# Analytical Writing: "Argument" Task Topics

This page contains the Argument topics for the analytical writing section of the GRE General Test. When you take the test, you will be presented with one Argument topic from this pool.

The wording of some topics in the test might vary slightly from what is presented here. Therefore, read your test topic carefully and respond to the wording as it appears in the actual test.

**Discuss how well reasoned you find this argument.**

A recent study shows that people living on the continent of North America suffer 9 times more chronic fatigue and 31 times more chronic depression than do people living on the continent of Asia. Interestingly, Asians, on average, eat 20 grams of soy per day, whereas North Americans eat virtually none. It turns out that soy contains phytochemicals called isoflavones, which have been found to possess disease–preventing properties. Thus, North Americans should consider eating soy on a regular basis as a way of preventing fatigue and depression.

———————————————

The following is taken from the editorial section of the local newspaper in Rockingham.

"In order to save a considerable amount of money, Rockingham's century-old town hall should be torn down and replaced by the larger and more energy-efficient building that some citizens have proposed. The old town hall is too small to comfortably accommodate the number of people who are employed by the town. In addition, it is very costly to heat the old hall in winter and cool it in summer. The new, larger building would be more energy efficient, costing less per square foot to heat and cool than the old hall. Furthermore, it would be possible to rent out some of the space in the new building, thereby generating income for the town of Rockingham."

———————————————

Claitown University needs both affordable housing for its students and a way to fund the building of such housing. The best solution to this problem is to commission a famous architect known for experimental and futuristic buildings. It is common knowledge that tourists are willing to pay money to tour some of the architect's buildings, so it can be expected that tourists will want to visit this new building. The income from the fees charged to tourists will soon cover the building costs. Furthermore, such a building will attract new students as well as donations from alumni. And even though such a building will be much larger than our current need for student housing, part of the building can be used as office space.

———————————————

The following appeared in a business magazine.

"As a result of numerous consumer complaints of dizziness and nausea, Promofoods requested that eight million cans of tuna be returned for testing last year. Promofoods concluded that the cans did not, after all, contain chemicals that posed a health risk. This conclusion is based on the fact that the chemists from Promofoods tested samples of the recalled cans and found that, of the eight chemicals most commonly blamed for causing symptoms of dizziness and nausea, five were not found in any of the tested cans. The chemists did find that the three remaining suspected chemicals are naturally found in all other kinds of canned foods."

———————————————

The following appeared in a local newspaper.

"People should not be misled by the advertising competition between Coldex and Cold-Away, both popular over-the-counter cold medications that anyone can purchase without a doctor's prescription. Each brand is accusing the other of causing some well-known, unwanted side effect: Coldex is known to contribute to existing high blood pressure and Cold-Away is known to cause drowsiness. But the choice should be clear for most health-conscious people: Cold-Away has been on the market for much longer and is used by more hospitals than is Coldex. Clearly, Cold-Away is more effective."

———————————————

A folk remedy* for insomnia, the scent in lavender flowers, has now been proved effective. In a recent study, 30 volunteers with chronic insomnia slept each night for three weeks on lavender-scented pillows in a controlled room where their sleep was monitored. During the first week, volunteers continued to take their usual sleeping medication. They slept soundly but wakened feeling tired. During the second week, the volunteers discontinued their medication. As a result, they slept less soundly than the previous week and felt even more tired. During the third week, the volunteers slept longer and more soundly than in the previous two weeks. This shows that over a short period of time lavender cures insomnia.

*A folk remedy is usually a plant-based form of treatment common to traditional forms of medicine, ones that developed before the advent of modern medical services and technology.

———————————————

Typically, as people age, their bone mass decreases, making them more vulnerable to bone fractures. A recent study concludes that the most effective way to reduce the risk of fractures in later life is to take twice the recommended dose of vitamin D and calcium daily. The three-year study followed a group of French women in their eighties who were nursing-home residents. The women were given daily supplements of twice the recommended dose of vitamin D and calcium. In addition, the women participated in a light weightlifting program. After three years, these women showed a much lower rate of hip fractures than is average for their age.

———————————————

The following appeared in a letter from a department chairperson to the president of Pierce University.

"Some studies conducted by Bronston College, which is also located in a small town, reveal that both male and female professors are happier living in small towns when their spouses are also employed in the same geographic area. Therefore, in the interest of attracting the most gifted teachers and researchers to our faculty and improving the morale of our entire staff, we at Pierce University should offer employment to the spouse of each new faculty member we hire. Although we cannot expect all offers to be accepted or to be viewed as an ideal job offer, the money invested in this effort will clearly be well spent because, if their spouses have a chance of employment, new professors will be more likely to accept our offers."

———————————————

For the past five years, consumers in California have been willing to pay twice as much for oysters from the northeastern Atlantic Coast as for Gulf Coast oysters. This trend began shortly after harmful bacteria were found in a few raw Gulf Coast oysters. But scientists have now devised a process for killing the bacteria. Once consumers are made aware of the increased safety of Gulf Coast oysters, they are likely to be willing to pay as much for Gulf Coast as for northeastern Atlantic Coast oysters, and greater profits for Gulf Coast oyster producers will follow.

———————————————

The following appeared in a memo from the marketing director of Bargain Brand Cereals.

"One year ago we introduced our first product, 'Bargain Brand' breakfast cereal. Our very low prices quickly drew many customers away from the top-selling cereal companies. Although the companies producing the top brands have since tried to compete with us by lowering their prices, and although several plan to introduce their own budget brands, not once have we needed to raise our prices to continue making a profit. Given our success selling cereal, Bargain Brand should now expand its business and begin marketing other low-priced food products as quickly as possible."

———————————————

The Mozart School of Music should obviously be the first choice of any music student aware of its reputation. First of all, the Mozart School stresses intensive practice and training, so that students typically begin their training at a very young age. Second, the school has ample facilities and up-to-date professional equipment, and its faculty includes some of the most distinguished music teachers in the world. Finally, many Mozart graduates have gone on to be the best known and most highly paid musicians in the nation.

———————————————

The following is a memorandum issued by the publisher of a newsmagazine, Newsbeat, in the country of Dinn.

"Our poorest-selling magazine issues over the past three years were those that featured international news stories on their front covers. Over the same period, competing news-magazines have significantly decreased the number of cover stories that they devote to international news. Moreover, the cost of maintaining our foreign bureaus to report on international news is increasing. Therefore, we should decrease our emphasis on international news and refrain from displaying such stories on our magazine covers."

———————————————

The following recommendation was made by the president and administrative staff of Grove College, a private institution, to the college's governing committee.

"We recommend that Grove College preserve its century-old tradition of all-female education rather than admit men into its programs. It is true that a majority of faculty members voted in favor of coeducation, arguing that it would encourage more students to apply to Grove. But eighty percent of the students responding to a survey conducted by the student government wanted the school to remain all female, and over half of the alumni who answered a separate survey also opposed coeducation. Keeping the college all-female, therefore, will improve morale among students and convince alumni to keep supporting the college financially."

———————————————

The following appeared in a letter to the school board in the town of Centerville.

"All students should be required to take the driver's education course at Centerville High School. In the past two years several accidents in and around Centerville have involved teenage drivers. Since a number of parents in Centerville have complained that they are too busy to teach their teenagers to drive, some other instruction is necessary to ensure that these teenagers are safe drivers. Although there are two driving schools in Centerville, parents on a tight budget cannot afford to pay for driving instruction. Therefore an effective and mandatory program sponsored by the high school is the only solution to this serious problem."

———————————————

The following is a memorandum from the sales director to the president of the Healthy-and-Good food company.

"A recent study indicates that Venadial, a new margarine currently produced only in the country of Alta, actually reduces cholesterol levels. Derived from the resin of pine trees, Venadial works by activating a metabolic response that is not yet well understood. However, cholesterol levels fell ten to fifteen percent among participants in the study who consumed Venadial daily, and the risk of heart attack by one-third. In addition, the new margarine is so popular that stores in Alta are unable to keep it on their shelves. Therefore, if our company obtains the exclusive right to sell Venadial internationally, our profits are sure to increase substantially within a very short time."

———————————————

The following is a letter that recently appeared in the Oak City Gazette, a local newspaper.

"Membership in Oak City's Civic Club — a club whose primary objective is to discuss local issues — should continue to be restricted to people who live in Oak City. People who work in Oak City but who live elsewhere cannot truly understand the business and politics of the city. It is important to restrict membership to city residents because only residents pay city taxes and therefore only residents understand how the money could best be used to improve the city. At any rate, restricting membership in this way is unlikely to disappoint many of the nonresidents employed in Oak City, since neighboring Elm City's Civic Club has always had an open membership policy, and only twenty-five nonresidents have joined Elm City's Club in the last ten years."

———————————————

The following appeared in the annual report from the president of the National Brush Company.

"In order to save money, we at the National Brush Company have decided to pay our employees for each brush they produce instead of for the time they spend producing brushes. We believe that this policy will lead to the production of more and better brushes, will allow us to reduce our staff size, and will enable the company factories to operate for fewer hours — resulting in savings on electricity and security costs. These changes will ensure that the best workers keep their jobs and that the company will earn a profit in the coming year."

———————————————

The following is a memorandum written by the director of personnel to the president of the Cedar Corporation.

"It would be a mistake to rehire the Good-Taste Company to supply the food in our employee cafeteria next year. It is the second most expensive caterer in the city. In addition, its prices have risen in each of the last three years, and it refuses to provide meals for people on special diets. Just last month three employees complained to me that they no longer eat in the cafeteria because they find the experience 'unbearable.' Our company should instead hire Discount Foods. Discount is a family-owned local company and it offers a varied menu of fish and poultry. I recently tasted a sample lunch at one of the many companies that Discount serves and it was delicious — an indication that hiring Discount will lead to improved employee satisfaction."

———————————————

The following is a recommendation from the personnel director to the president of Acme Publishing Company.

"Many other companies have recently stated that having their employees take the Easy Read Speed-Reading Course has greatly improved productivity. One graduate of the course was able to read a five-hundred-page report in only two hours; another graduate rose from an assistant manager to vice president of the company in under a year. Obviously, the faster you can read, the more information you can absorb in a single workday. Moreover, Easy Read costs only $500 per employee — a small price to pay when you consider the benefits to Acme. Included in this fee is a three-week seminar in Spruce City and a lifelong subscription to the Easy Read newsletter. Clearly, Acme would benefit greatly by requiring all of our employees to take the Easy Read course."

———————————————

From a letter to the editor of a city newspaper.

"One recent research study has indicated that many adolescents need more sleep than they are getting, and another study has shown that many high school students in our city are actually dissatisfied with their own academic performance. As a way of combating these problems, the high schools in our city should begin classes at 8:30 A.M. instead of 7:30 A.M., and end the school day an hour later. This arrangement will give students an extra hour of sleep in the morning, thereby making them more alert and more productive. Consequently, the students will perform better on tests and other assignments, and their academic skills will improve significantly."

———————————————

Butter has now been replaced by margarine in Happy Pancake House restaurants throughout the southwestern United States. Only about 2 percent of customers have complained, indicating that 98 people out of 100 are happy with the change. Furthermore, many servers have reported that a number of customers who still ask for butter do not complain when they are given margarine instead. Clearly, either these customers cannot distinguish margarine from butter, or they use the term 'butter' to refer to either butter or margarine. Thus, to avoid the expense of purchasing butter, the Happy Pancake House should extend this cost-saving change to its restaurants in the southeast and northeast as well.

———————————————

Many employees of major United States corporations are fearful that they will lose their jobs in the near future, but this fear is largely unfounded. According to a recent study, a majority of companies expected to make new hires in the coming year, while fewer companies expected to lay off employees. In addition, although it is very disturbing to be laid off, the proliferation of programs and of workshops designed to improve job-finding skills has made being laid off far less painful than it once was.

———————————————

In the Bayhead Public Library, books that are rarely borrowed continue to take up shelf space year after year, while people who want to read a recent novel frequently find that the library's only copy is checked out. Clearly, the library's plan to replace books that are borrowed no more than once a year with sufficient copies of more recent books will solve this problem. The protest we have heard since this plan was made public has come from a small, and thus unrepresentative, group of some thirty people and so should therefore be ignored.

———————————————

The following appeared in a letter from the owner of the Sunnyside Towers apartment building to its manager.

"One month ago, all the showerheads on the first five floors of SunnysideT owers were modified to restrict the water flow to approximately 1/3 of its original force. Although actual readings of water usage before and after the adjustment are not yet available, the change will obviously result in a considerable savings for Sunnyside Corporation, since the corporation must pay for water each month. Except for a few complaints about low water pressure, no problems with showers have been reported since the adjustment. Clearly, restricting water flow throughout all the 20 floors of Sunnyside Towers will increase our profits further."

———————————————

The following is a recommendation from the director of personnel to the president of Professional Printing Company.

"In a recent telephone survey of automobile factory workers, older employees were less likely to report that having a supervisor present increases their productivity. Among workers aged 18 to 29, 27 percent said that they are more productive in the presence of their immediate supervisor, compared to 12 percent for those aged 30 or over, and only 8 percent for those aged 50 or over. Clearly, if our printing company hires mainly older employees, we will increase productivity and save money because of the reduced need for supervisors. "

———————————————

The following appeared as part of an article in a health magazine.

"A new discovery warrants a drastic change in the diets of people living in the United States. Two scientists have recently suggested that omega -3 fatty acids (found in some fish and fish oils) play a key role in mental health. Our ancestors, who ate less saturated fat and more polyunsaturated fat, including omega -3 fatty acids, were much less likely to suffer from depression than we are today. Moreover, modern societies — such as those in Japan and Taiwan — that consume large quantities of fish report depression rates lower than that in the United States. Given this link between omega -3 fatty acids and depression, it is important for all people in the United States to increase their consumption of fish in order to prevent depression."

———————————————

A new report suggests that men and women experience pain very differently from one another, and that doctors should consider these differences when prescribing pain medications. When researchers administered the same dosage of kappa opioids — a painkiller — to 28 men and 20 women who were having their wisdom teeth extracted, the women reported feeling much less pain than the men, and the easing of pain lasted considerably longer in women. This research suggests that kappa opioids should be prescribed for women whenever pain medication is required, whereas men should be given other kinds of pain medication. In addition, researchers should reevaluate the effects of all medications on men versus women.

———————————————

The following is a recommendation from the dean at Foley College, a small liberal arts college, to the president of the college.

"Since college-bound students are increasingly concerned about job prospects after graduation, Foley College should attempt to increase enrollment by promising to find its students jobs after they graduate. Many administrators feel that this strategy is a way for Foley to compete against larger and more prestigious schools and to encourage students to begin preparing for careers as soon as they enter college. Furthermore, a student who must choose a career path within his or her first year of college and who is guaranteed a job after graduation is more likely to successfully complete the coursework that will prepare him or her for the future."

———————————————

The following is a letter to the editor of the Glenville Gazette, a local newspaper.

"Over the past few years, the number of people who have purchased advance tickets for the Glenville Summer Concert series has declined, indicating lack of community support. Although the weather has been unpredictable in the past few years, this cannot be the reason for the decline in advance ticket purchases, because many people attended the concerts even in bad weather. Clearly, then, the reason for the decline is the choice of music, so the organizers of the concert should feature more modern music in the future and should be sure to include music composed by Richerts, whose recordings Glenville residents purchase more often than any other contemporary recordings. This strategy will undoubtedly increase advance ticket purchases and will increase attendance at the concerts."

———————————————

The following is a letter from a professor at Xanadu College to the college's president.

"The development of an extensive computer-based long-distance learning program will enhance the reputation of Xanadu College. This program would allow more students to enroll in our courses, thereby increasing our income from student tuition. Traditional courses could easily be adapted for distance learners, as was shown by the adaptation of two traditional courses for our distance learning trial project last year. Also, by using computer programs and taped lectures, faculty will have fewer classroom obligations and more time to engage in extensive research, thereby enhancing the reputation of Xanadu."

———————————————

The following is a letter to the editor of the Roseville Gazette.

"Despite opposition from some residents of West Roseville, the arguments in favor of merging the townships of Roseville and West Roseville are overwhelming. First, residents in both townships are confused about which authority to contact when they need a service; for example, the police department in Roseville receives many calls from residents of West Roseville. This sort of confusion would be eliminated with the merger. Second, the savings in administrative costs would be enormous, since services would no longer be duplicated: we would have only one fire chief, one tax department, one mayor, and so on. And no jobs in city government would be lost — employees could simply be reassigned. Most importantly, the merger will undoubtedly attract business investments as it did when the townships of Hamden and North Hamden merged ten years ago."

———————————————

The Department of Education in the state of Attra recommends that high school students be assigned homework every day. Yet a recent statewide survey of high school math and science teachers calls the usefulness of daily homework into question. In the district of Sanlee, 86 percent of the teachers reported assigning homework three to five times a week, whereas in the district of Marlee, less than 25 percent of the teachers reported assigning homework three to five times a week. Yet the students in Marlee earn better grades overall and are less likely to be required to repeat a year of school than are the students in Sanlee. Therefore, all teachers in our high schools should assign homework no more than twice a week, if at all.

———————————————

A recent study suggests that people who are left-handed are more likely to succeed in business than are right-handed people. Researchers studied photographs of 1,000 prominent business executives and found that 21 percent of these executives wrote with their left hand. So the percentage of prominent business executives who are left-handed (21 percent) is almost twice the percentage of people in the general population who are left-handed (11 percent). Thus, people who are left-handed would be well advised to pursue a career in business, whereas people who are right-handed would be well advised to imitate the business practices exhibited by left-handers.

———————————————

The following is a letter from an editor at Liber Publishing Company to the company's president.

"In recent years, Liber has unfortunately moved away from its original mission: to publish the works of regional small-town authors instead of those of big-city authors. Just last year, 90 percent of the novels we published were written by authors who maintain a residence in a big city. Although this change must have been intended to increase profits, it has obviously backfired, because Liber is now in serious financial trouble. The only way to address this problem is to return to our original mission. If we return to publishing only the works of regional small-town authors, our financial troubles will soon be resolved."

———————————————

Sadly, widespread negative images of businesspeople have been created in large part by television. Consider the fact that, although they make up a mere 10 percent of the characters in dramatic roles on television, businesspeople are responsible for about one-fifth of all the crime on television shows. In fact, in a recent survey of television producers, only 35 percent of the television roles for businesspeople were viewed as positive ones.

———————————————

The following appeared as part of a recommendation made by a faculty member to the president of a large university.

"Never once in our 150-year history as a university have we clarified our objectives. How, then, can we hope to adapt as an institution to the new challenges facing higher education. As a first step in this evolutionary process, therefore, we should send out questionnaires asking faculty members why they teach, asking students what they want from this university, and asking former students what they gained from their own education here. When the replies come in, we can tabulate them and formulate an official statement of our educational mission. This will surely result in improved programs at our university."

———————————————

There is a general idea that a translation always fails to preserve some of the qualities that distinguish the original work — i.e., that 'something always gets lost in translation.' Writers, critics, and the general reading public unthinkingly accept this clichè. But this belief is unwarranted: translators are sometimes distinguished authors themselves, and some authors may even translate their own works. As the translator pointed out in the preface to an English version of Dante's works, the violin and the piano make different sounds, but they can play what is recognizably the same piece of music.

———————————————

There is a general idea that waiters and waitresses are more likely to receive larger gratuities from large groups of people. A recent research study suggests this is not true. The researchers examined the relationship between the size of tips in restaurants and the number of meals charged on the bill. They found that, while most tips were around 15 percent, the minimum percentage considered appropriate, people dining alone tipped consistently more (19 percent) and those dining in groups of four or more tipped considerably less (13 percent) than this 15 percent standard. These results strongly suggest that people dining in a group are less likely to feel personally responsible for leaving an adequate or generous tip.

———————————————

Statistics collected from dentists indicate that three times more men than women faint while visiting the dentist. This evidence suggests that men are more likely to be distressed about having dental work done than women are. Thus, dentists who advertise to attract patients should target the male consumer and emphasize both the effectiveness of their anesthetic techniques and the sensitivity of their staff to nervous or suffering patients.

———————————————

The citizens of Forsythe have adopted healthier lifestyles. Their responses to a recent survey show that in their eating habits they conform more closely to government nutritional recommendations than they did ten years ago. Furthermore, there has been a fourfold increase in sales of food products containing kiran, a substance that a scientific study has shown reduces cholesterol. This trend is also evident in reduced sales of sulia, a food that few of the healthiest citizens regularly eat.

———————————————

Humans arrived in the Kaliko Islands about 7,000 years ago, and within 3,000 years most of the large mammal species that had lived in the forests of the Kaliko Islands had become extinct. Yet humans cannot have been a factor in the species' extinctions, because there is no evidence that the humans had any significant contact with the mammals. Further, archaeologists have discovered numerous sites where the bones of fish had been discarded, but they found no such areas containing the bones of large mammals, so the humans cannot have hunted the mammals. Therefore, some climate change or other environmental factor must have caused the species' extinctions.

———————————————

The following appeared in a newspaper feature story.

"At the small, nonprofit hospital in the town of Saluda, the average length of a patient's stay is two days; at the large, for-profit hospital in the nearby city of Megaville, the average patient stay is six days. Also, the cure rate among patients in the Saluda hospital is about twice that of the Megaville hospital. The Saluda hospital has more employees per patient than the hospital in Megaville, and there are few complaints about service at the local hospital. Such data indicate that treatment in smaller, nonprofit hospitals is more economical and of better quality than treatment in larger, for-profit hospitals."

——————————————-

The following appeared as a letter to the editor of a farming publication.

"With continuing publicity about the need for healthful diets, and with new research about the harmful effects of eating too much sugar, nationwide demand for sugar will no doubt decline. Therefore, farmers in our state should use the land on which they currently grow sugar cane to grow peanuts, a food that is rich in protein and low in sugar. Farmers in the neighboring country of Palin greatly increased their production of peanuts last year, and their total revenues from that crop were quite high."

———————————————

The following appeared in a recommendation from the president of Amburg's Chamber of Commerce.

"Last October the city of Belleville installed high intensity lighting in its central business district, and vandalism there declined almost immediately. The city of Amburg has recently begun police patrols on bicycles in its business district but the rate of vandalism there remains constant. Since high intensity lighting is apparently the most effective way to combat crime, we should install such lighting throughout Amburg. By reducing crime in this way, we can revitalize the declining neighborhoods in our city."

———————————————

The following appeared in a letter to the editor of the Parkville Daily Newspaper.

"Throughout the country last year, as more and more children below the age of nine participated in youth-league softball and soccer, over 80,000 of these young players suffered injuries. When interviewed for a recent study, youth-league softball players in several major cities also reported psychological pressure from coaches and parents to win games. Furthermore, education experts say that long practice sessions for these sports take away time that could be used for academic activities. Since the disadvantages apparently outweigh any advantages, we in Parkville should discontinue organized athletic competition for children under nine."

———————————————

It is known that in recent years, industrial pollution has caused the Earth's ozone layer to thin, allowing an increase in the amount of ultraviolet radiation that reaches the Earth's surface. At the same time, scientists have discovered, the population of a species of salamander that lays its eggs in mountain lakes has declined. Since ultraviolet radiation is known to be damaging to delicate tissues and since salamander eggs have no protective shells, it must be the case that the increase in ultraviolet radiation has damaged many salamander eggs and prevented them from hatching. This process will no doubt cause population declines in other species, just as it has in the salamander species.

———————————————

The following appeared in a memorandum from the planning department of an electric power company.

"Several recent surveys indicate that homeowners are increasingly eager to conserve energy and manufacturers are now marketing many home appliances, such as refrigerators and air conditioners, that are almost twice as energy-efficient as those sold a decade ago. Also, new technologies for better home insulation and passive solar heating are readily available to reduce the energy needed for home heating. Therefore, we anticipate that the total demand for electricity in our area will not increase, and may decline slightly. Since our three electric generating plants in operation for the past 20 years have always met our needs, construction of new generating plants should not be necessary."

———————————————

The following recommendation was made by the Human Resources Manager to the board of directors of the Fancy Toy Company.

"In the last three quarters of this year, under the leadership of our president, Pat Salvo, our profits have fallen considerably. Thus, we should ask for her resignation in return for a generous severance package. In Pat's place, we should appoint Rosa Winnings. Rosa is currently president of Starlight Jewelry, a company whose profits have increased dramatically over the past several years. Although we will have to pay Rosa twice the salary that Pat has been receiving, it will be well worth it because we can soon expect our profits to increase considerably."

———————————————

The following is a letter to the editor of a news magazine.

"Clearly, the successful use of robots on missions to explore outer space in the past 20 years demonstrates that robots could be increasingly used to perform factory work more effectively, efficiently, and profitably than human factory workers. The use of robots in factories would offer several advantages. First, robots never get sick, so absenteeism would be reduced. Second, robots do not make mistakes, so factories would increase their output. Finally, the use of robots would also improve the morale of factory workers, since factory work can be so boring that many workers would be glad to shift to more interesting kinds of tasks."

———————————————

The following appeared in a memorandum to faculty from the academic vice president of Waymarsh University.

"So that we can better accomplish Waymarsh University's academic goals, we should adopt the job-opportunity (job-op) program offered at Plateau Technical College and strongly encourage all students at Waymarsh to participate in it. The success of the job-op program at Plateau is evident: Over the past two years, more than 75% of the freshmen at Plateau have enrolled in the optional job-op program. Moreover, at Plateau, the grades of job-op students are consistently higher than those of other students, 90% of the job-op students receive job offers within a month after their graduation, and most former job-op students report much success in their careers."

———————————————

The following appeared in a memorandum from the new president of the Patriot car manufacturing company.

"In the past, the body styles of Patriot cars have been old-fashioned, and our cars have not sold as well as have our competitors' cars. But now, since many regions in this country report rapid increases in the numbers of newly licensed drivers, we should be able to increase our share of the market by selling cars to this growing population. Thus, we should discontinue our oldest models and concentrate instead on manufacturing sporty cars. We can also improve the success of our marketing campaigns by switching our advertising to the Youth Advertising agency, which has successfully promoted the country's leading soft drink."

———————————————

The following appeared in a memorandum from the owner of Armchair Video, a chain of video rental stores.

"Because of declining profits, we must reduce operating expenses at Armchair Video's ten video rental stores. Raising prices is not a good option, since we are famous for our special bargains. Instead, we should reduce our operating hours. Last month our store in downtown Marston reduced its hours by closing at 6:00 P.M. rather than 9:00 P.M. and reduced its overall inventory by no longer stocking any film released more than two years ago. Since we have received very few customer complaints about these new policies, we should now adopt them at all other Armchair Video stores as our best strategies for improving profits."

———————————————

In each city in the region of Treehaven, the majority of the money spent on government-run public school education comes from taxes that each city government collects. The region's cities differ, however, in the value they place on public education. For example, Parson City typically budgets twice as much money per year as Blue City does for its public schools — even though both cities have about the same number of residents. It seems clear, therefore, that Parson City residents care more about public school education than do Blue City residents.

———————————————

The following appeared in a letter to the Grandview City Council from a local business leader.

"During last year's severe drought, when the water supply in the Grandview city reservoir fell to an extremely low level, the city council imposed much more rigid water-rationing rules. But just after these rules were imposed, industrial growth in the area declined. This clearly shows that the new rationing rules have hurt industry in Grandview. Therefore, to promote the health of the local economy, the city council should now stop water rationing."

———————————————

The following appeared in a magazine article about planning for retirement.

"Because of its spectacular natural beauty and consistent climate, Clearview should be a top choice for anyone seeking a place to retire. As a bonus, housing costs in Clearview have fallen significantly during the past year, and real estate taxes remain lower than those in neighboring towns. Nevertheless, Clearview's mayor promises many new programs to improve schools, streets, and public services. Retirees in Clearview can also expect excellent health care as they grow older, since the number of physicians in the area is far greater than the national average."

———————————————

The following appeared in a brochure promoting the purchase of local franchises for a national chain of gyms.

"Now is the time to invest in a Power-Lift Gym franchise so that you can profit from opening one of our gyms in your town. Consider the current trends: Power-Lift Gyms are already popular among customers in 500 locations, and national surveys indicate increasing concern with weight loss and physical fitness. Furthermore, last year's sales of books and magazines on personal health totaled more than $50 million, and purchases of home exercise equipment almost doubled. Investing now in a Power-Lift Gym franchise will guarantee a quick profit."

———————————————

The following appeared in a memorandum from the president of Hyper-Go Toy Company.

"Last year, sales of our Fierce Fighter toy airplane declined sharply, even though the toy had been a top seller for three years. Our customer surveys show that parents are now more worried about youthful violence and are concerned about better education for their children. Therefore, to maintain profits we should discontinue all our action toys and focus exclusively on a new line of educational toys. Several other toy companies have already begun marketing educational toys and report sales increases last year of 200 percent. And since the average family income is growing, sales of new Hyper-Go toys should also increase."

———————————————

The following appeared in a memorandum from a vice president of the Megamart department store chain.

"For the third year in a row, the average household income in our country has risen significantly. That prosperity means that families are likely to be spending more time and money on leisure activities. Megamart stores should therefore concentrate on enlarging and promoting its line of products typically used in leisure activities: athletic and outdoor equipment, televisions, gourmet cooking equipment, and luggage and travel accessories."

———————————————

The following appeared in an article in a magazine for writers.

"A recent study showed that in describing a typical day's conversation, people make an average of 23 references to watching television and only 1 reference to reading fiction. This result suggests that, compared with the television industry, the publishing and bookselling industries are likely to decline in profitability. Therefore, people who wish to have careers as writers should acquire training and experience in writing for television rather than for print media."

———————————————

The following appeared in the editorial section of a student newspaper.

"In a recent survey, most students who were studying beginning Russian gave higher course-evaluation ratings to classes taught by non-native Russian speakers than to classes taught by native Russian speakers. The reason that the non-native speakers were better teachers of Russian is easy to see: the non-native speakers learned Russian later in life themselves, and so they have a better understanding of how the language can be taught effectively. Therefore, in order to improve instruction for all languages and also save money, our university should hire non-native speakers as language instructors instead of trying to find and recruit native speakers."

———————————————

The following article appeared in a recent issue of a college newspaper.

"Among all students who graduated from Hooper University over the past five years, more physical science majors than social science majors found permanent jobs within a year of graduation. In a survey of recent Hooper University graduates, most physical science majors said they believed that the prestige of Hooper University's physical science programs helped them significantly in finding a job. In contrast, social science majors who found permanent employment attributed their success to their own personal initiative. Therefore, to ensure that social science majors find permanent jobs, Hooper University should offer additional social science courses and hire several new faculty members who already have national reputations in the social sciences."

———————————————

The following appeared as an editorial in one of Coleville's city newspapers.

"Even though a high percentage of Coleville City's businesses failed last year, we who live in Coleville City should keep in mind the fact that the Coleville region has attracted a great many new businesses over the last three years. It is well known that new businesses are, on average, much more likely to fail than are long-established ones, so the business failures should not be considered a sign of poor economic health. Indeed, many analysts regard the presence of a significant number of new companies among a region's businesses as a sign of economic health. Thus Coleville City appears to be in good, not poor, economic shape."

———————————————

The following appeared in a corporate planning memo at ABC Cereal Company, the makers of Better Bran cereal.

"Sales of Better Bran have declined in recent years, for reasons that management has now identified. First, Better Bran is a cereal with high sugar content, and recent research studies have found that most consumers say they are concerned about the amount of sugar added to their breakfast cereal. Second, the price of Better Bran has increased by 5 percent in each of the last three years. Therefore, to increase our company's profits we need to reduce the amount of sugar in Better Bran and lower Better Bran's price."

———————————————

The following appeared as part of a letter to the editor of a local newspaper.

"During her three years in office, Governor Riedeburg has shown herself to be a worthy leader. Since she took office, crime has decreased, the number of jobs created per year has doubled, and the number of people choosing to live in our state has increased. These trends are likely to continue if she is reelected. In addition, Ms. Riedeburg has promised to take steps to keep big companies here, thereby providing jobs for any new residents. Anyone who looks at Ms. Riedeburg's record can tell that she is the best-qualified candidate for governor."

———————————————

The following appeared as part of a memo from the manager of an automobile manufacturing company.

"Because the demand for our automobiles is expected to increase dramatically, we need to open a new manufacturing plant as soon as possible in order to continue to thrive. Our marketing projections indicate that 80 million people will want to buy our automobiles, yet our existing plant can only produce 40 million automobiles. The new plant can be opened on a part-time basis, with workers from our existing site rotating responsibilities, until an operational staff can be trained. A major airplane manufacturer was extremely successful using this part-time rotating strategy when it opened its new plant five years ago."

———————————————

The following appeared as an editorial in a local newspaper.

"In order to attract visitors to Central Plaza downtown and to return the plaza to its former glory, the city should prohibit skateboarding there and instead allow skateboarders to use an area in Monroe Park. At Central Plaza, skateboard users are about the only people one sees now, and litter and defaced property have made the plaza unattractive. In a recent survey of downtown merchants, the majority supported a prohibition on skateboarding in the plaza. Clearly, banning skateboarding in Central Plaza will make the area a place where people can congregate for fun or for relaxation."

———————————————

The following appeared in a newsletter from a political organization.

"In order to promote economic growth in the city, city residents should vote 'yes' on the state government's proposal to build a new expressway linking the outlying suburbs directly to the city center. A direct link to the city center will enable downtown businesses to receive deliveries more frequently, so that downtown retailers will no longer run out of stock and city manufacturers will not be affected by shortages of materials. Booming businesses will attract qualified workers from all over the state, workers who will be able to take advantage of the new expressway to commute to work in our city. In addition to these advantages, hundreds of workers will be employed to build the expressway, further stimulating the local economy!"

———————————————

The following appeared as part of a memo from the manager of a hazardous-waste disposal company.

"Our new plan will help us better protect our staff against exposure to toxic chemicals: We are fitting each new safety suit with an alarm that will sound in the main control booth when the suit is punctured. The control booth will notify the managers on duty, who will then take the necessary steps to ensure employees' safety. In addition to the obvious safety-related benefits, the fast reaction time will ensure minimal work stoppage and thus result in increased worker productivity and company profitability."

———————————————

The following appeared in a recommendation from the planning department of the city of Transopolis.

"Ten years ago, as part of a comprehensive urban renewal program, the city of Transopolis adapted for industrial use a large area of severely substandard housing near the freeway. Subsequently, several factories were constructed there, crime rates in the area declined, and property tax revenues for the entire city increased. To further revitalize the city, we should now take similar action in a declining residential area on the opposite side of the city. Since some houses and apartments in existing nearby neighborhoods are currently unoccupied, alternate housing for those displaced by this action will be readily available."

———————————————

The following appeared in a letter to the editor of a local newspaper.

"The members of the town school board should not be reelected because they are not concerned about promoting high-quality education in the arts in our local schools. For example, student participation in the high school drama club has been declining steadily, and this year the school board refused to renew the contract of the drama director, even though he had received many awards for his original plays. Meanwhile, over $300,000 of the high school budget goes to athletic programs, and the head football coach is now the highest-paid member of the teaching staff."

———————————————

The following appeared in a memo from the sales manager of Eco-Power, a company that manufactures tools and home appliances.

"Many popular radio and television commercials use memorable tunes and song lyrics to call attention to the products being advertised. Indeed, a recent study of high school students showed that 85 percent could easily recognize the tunes used to advertise leading soft drinks and fast-food restaurants. Despite our company's extensive advertising in magazines during the past year, sales of our home appliances declined. Therefore, to boost company profits, we should now switch to advertisements featuring a distinctive song."

———————————————

The following appeared in a memo from the vice president of a company that builds shopping malls throughout the country.

"The surface of a section of Route 101, paved two years ago by McAdam Road Builders, is now badly cracked and marred by dangerous potholes. In another part of the state, a section of Route 66, paved by Appian Roadways more than four years ago, is still in good condition. Appian Roadways has recently purchased state-of-the-art paving machinery, and it has hired a new quality-control manager. Because of its superior work and commitment to quality, we should contract with Appian Roadways rather than McAdam Road Builders to construct the access roads for all our new shopping malls."

———————————————

The following appeared in a newspaper feature story.

"There is now evidence that the relaxed manner of living in small towns promotes better health and greater longevity than does the hectic pace of life in big cities. Businesses in the small town of Leeville report fewer days of sick leave taken by individual workers than do businesses in the nearby large city of Mason City. Furthermore, Leeville has only one physician for its one thousand residents, but in Mason City the proportion of physicians to residents is five times as high. And the average age of Leeville residents is significantly higher than that of Mason City residents. These findings suggest that people seeking longer and healthier lives should consider moving to small communities."

———————————————

The following appeared in a memorandum from the general manager of KNOW radio station.

"Several factors indicate that radio station KNOW should shift its programming from rock-and-roll music to a continuous news format. Consider, for example, the number of older people in our listening area has increased dramatically, while the total number of our listeners has recently declined. Also, music stores in our area report decreased sales of recorded music. Finally, continuous news stations in neighboring cities have been very successful, and a survey taken just before the recent election shows that local citizens are interested in becoming better informed about politics."

———————————————

The following appeared as a letter to the editor of a local Solano newspaper.

"The Solano school district should do away with its music education programs. After all, music programs are not especially popular in our schools: Only 20 percent of our high school students participated in music programs last year. Furthermore, very few of the Solano district's college-bound students are interested in majoring in music at the university level. Also, when the school district of our neighboring town of Rutherford eliminated its music programs two years ago, the overall grade point average in the high school increased by 10 percent the next year. Surely the money spent on Solano music programs could be better used to improve the quality of traditional academic courses."

———————————————

The following appeared as part of an article in a local Beauville newspaper.

"According to a government report, last year the city of Dillton reduced its corporate tax rate by 15 percent; at the same time, it began offering relocation grants and favorable rates on city utilities to any company that would relocate to Dillton. Within 18 months, two manufacturing companies moved to Dillton, where they employ a total of 300 people. Therefore, the fastest way for Beauville to stimulate economic development and hence reduce unemployment is to provide tax incentives and other financial inducements that encourage private companies to relocate here."

———————————————

The following appeared in a memorandum from the president of Mira Vista College to the college's board of trustees.

"At nearby Green Mountain College, which has more business courses and more job counselors than does Mira Vista College, 90 percent of last year's graduating seniors had job offers from prospective employers. But at Mira Vista College last year, only 70 percent of the seniors who informed the placement office that they would be seeking employment had found full-time jobs within three months after graduation, and only half of these graduates were employed in their major field of study. To help Mira Vista's graduates find employment, we must offer more courses in business and computer technology and hire additional job counselors to help students with their resumès and interviewing skills."

———————————————

The following appeared as an editorial in the local newspaper of Dalton.

"When the neighboring town of Williamsville adopted a curfew four months ago that made it illegal for persons under the age of 18 to loiter or idle in public places after 10 p.m., youth crime in Williamsville dropped by 27 percent during curfew hours. In Williamsville's town square, the area where its citizens were once most outraged at the high crime rate, not a single crime has been reported since the curfew was introduced. Therefore, to help reduce its own rising crime rate, the town of Dalton should adopt the same kind of curfew. A curfew that keeps young people at home late at night will surely control juvenile delinquency and protect minors from becoming victims of crime."

———————————————

The following appeared in a memo written by a dean at Buckingham College.

"To serve the housing needs of our students, Buckingham College should build a new dormitory. Buckingham's enrollment is growing and, based on current trends, should double over the next fifty years, thus making existing dormitories inadequate. Moreover, the average rent for an apartment in our town has increased in recent years. Consequently, students will find it increasingly difficult to afford off-campus housing. Finally, an attractive new dormitory would make prospective students more likely to enroll at Buckingham."

———————————————

The following appeared in a memo at the XYZ company.

"When XYZ lays off employees, it pays Delany Personnel Firm to offer those employees assistance in creating resumès and developing interviewing skills, if they so desire. Laid-off employees have benefited greatly from Delany's services: last year those who used Delany found jobs much more quickly than did those who did not. Recently, it has been proposed that we use the less-expensive Walsh Personnel Firm in place of Delany. This would be a mistake because eight years ago, when XYZ was using Walsh, only half of the workers we laid off at that time found jobs within a year. Moreover, Delany is clearly superior, as evidenced by its bigger staff and larger number of branch offices. After all, last year Delany's clients took an average of six months to find jobs, whereas Walsh's clients took nine."

———————————————

The following appeared as an editorial in the student newspaper of Groveton College.

"To combat the recently reported dramatic rise in cheating among college and university students, these institutions should adopt honor codes similar to Groveton's, which calls for students to agree not to cheat in their academic endeavors and to notify a faculty member if they suspect that others have cheated. Groveton's honor code replaced an old-fashioned system in which students were closely monitored by teachers and an average of thirty cases of cheating per year were reported. The honor code has proven far more successful: in the first year it was in place, students reported twenty-one cases of cheating; five years later, this figure had dropped to fourteen. Moreover, in a recent survey conducted by the Groveton honor council, a majority of students said that they would be less likely to cheat with an honor code in place than without."

———————————————

The following appeared in a memorandum written by the vice president of Nature's Way, a chain of stores selling health food and other health-related products.

"Previous experience has shown that our stores are most profitable in areas where residents are highly concerned with leading healthy lives. We should therefore build our next new store in Plainsville, which has many such residents. Plainsville merchants report that sales of running shoes and exercise clothing are at all-time highs. The local health club, which nearly closed five years ago due to lack of business, has more members than ever, and the weight training and aerobics classes are always full. We can even anticipate a new generation of customers: Plainsville's schoolchildren are required to participate in a 'fitness for life' program, which emphasizes the benefits of regular exercise at an early age."

———————————————

The following appeared in a letter sent by a committee of homeowners from the Deerhaven Acres to all homeowners in Deerhaven Acres.

"Seven years ago, homeowners in nearby Brookville community adopted a set of restrictions on how the community's yards should be landscaped and what colors the exteriors of homes should be painted. Since then, average property values have tripled in Brookville. In order to raise property values in Deerhaven Acres, we should adopt our own set of restrictions on landscaping and housepainting."

———————————————

The following appeared in a newspaper article about law firms in the city of Megalopolis.

"In Megalopolis, the number of law school graduates who went to work for large, corporate firms declined by 15 percent over the last three years, whereas an increasing number of graduates took jobs at small, general practice firms. Even though large firms usually offer much higher salaries, law school graduates are choosing to work for the smaller firms most likely because they experience greater job satisfaction at smaller firms. In a survey of first-year students at a leading law school, most agreed with the statement that earning a high salary was less important to them than job satisfaction. This finding suggests that the large, corporate firms of Megalopolis will need to offer graduates more benefits and incentives and reduce the number of hours they must work."

———————————————

The following was posted on an Internet real estate discussion site.

"Of the two leading real estate firms in our town — Adams Realty and Fitch Realty — Adams is clearly superior. Adams has 40 real estate agents. In contrast, Fitch has 25, many of whom work only part-time. Moreover, Adams' revenue last year was twice as high as that of Fitch, and included home sales that averaged $168,000, compared to Fitch's $144,000. Homes listed with Adams sell faster as well: Ten years ago, I listed my home with Fitch and it took more than four months to sell; last year, when I sold another home, I listed it with Adams, and it took only one month. Thus, if you want to sell your home quickly and at a good price, you should use Adams."

———————————————

The following appeared in the business section of a newspaper.

"Given that the number of people in our country with some form of arthritis is expected to rise from 40 million to 60 million over the next twenty years, pharmaceutical companies that produce drugs for the treatment of arthritis should be very profitable. Many analysts believe that in ten years Becton Pharmaceuticals, which makes Xenon, the best-selling drug treatment for arthritis, will be the most profitable pharmaceutical company. But the patent on Xenon expires in three years, and other companies will then be able to produce a cheaper version of the drug. Thus, it is more likely that in ten years the most profitable pharmaceutical company will be Perkins Pharmaceuticals, maker of a new drug called Xylan, which clinical studies show is preferred over Xenon by seven out of ten patients suffering from the most extreme cases of arthritis."

———————————————

The following was written as a part of an application for a small business loan by a group of developers in the city of Monroe.

"A jazz music club in Monroe would be a tremendously profitable enterprise. Currently, the nearest jazz club is 65 miles away; thus, our proposed club, the C Note, would have the local market all to itself. Plus, jazz is extremely popular in Monroe: over 100,000 people attended Monroe's jazz festival last summer, several well-known jazz musicians live in Monroe, and the highest-rated radio program in Monroe is 'Jazz Nightly,' which airs every weeknight. Finally, a nationwide study indicates that the typical jazz fan spends close to $1,000 per year on jazz entertainment. It is clear that the C Note cannot help but make money."

———————————————

The following appeared in a letter to the editor of the Clearview newspaper.

"In the next mayoral election, residents of Clearview should vote for Ann Green, who is a member of the Good Earth Coalition, rather than for Frank Braun, a member of the Clearview town council, because the current members are not protecting our environment. For example, during the past year the number of factories in Clearview has doubled, air pollution levels have increased, and the local hospital has treated 25 percent more patients with respiratory illnesses. If we elect Ann Green, the environmental problems in Clearview will certainly be solved."

———————————————

The following appeared in a memorandum issued by the strategic planning department at Omni Inc.

"Mesa Foods, a manufacturer of snack foods that currently markets its products within a relatively small region of the country, has strong growth potential. Mesa enjoyed a 20 percent increase in profits last year, and its best-selling product, Diabolique Salsa, has had increased sales over each of the past three years. Since Omni Inc. is interested in reaching 14-to-25 year olds, the age group that consumes the most snack food, we should buy Mesa Foods, and concentrate in particular on marketing Diabolique Salsa throughout the country."

———————————————

The following appeared in a memorandum from a dean at Omega University.

"Fifteen years ago, Omega University implemented a new procedure that encouraged students to evaluate the teaching effectiveness of all their professors. Since that time, Omega professors have begun to assign higher grades in their classes, and overall student grade averages at Omega have risen by thirty percent. Potential employers apparently believe the grades at Omega are inflated; this would explain why Omega graduates have not been as successful at getting jobs as have graduates from nearby Alpha University. To enable its graduates to secure better jobs, Omega University should now terminate student evaluation of professors."

———————————————

The following appeared in a letter to the editor of a Batavia newspaper.

"The department of agriculture in Batavia reports that the number of dairy farms throughout the country is now 25 percent greater than it was 10 years ago. During this same time period, however, the price of milk at the local Excello Food Market has increased from $1.50 to over $3.00 per gallon. To prevent farmers from continuing to receive excessive profits on an apparently increased supply of milk, the Batavia government should begin to regulate retail milk prices. Such regulation is necessary to ensure both lower prices and an adequate supply of milk for consumers."

———————————————

The following appeared in a memo from the mayor of the town of West Egg.

"Two years ago, our consultants predicted that West Egg's landfill, which is used for garbage disposal, would be completely filled within five years. During the past two years, however, town residents have been recycling twice as much aluminum and paper as they did in previous years. Next month the amount of material recycled should further increase, since charges for garbage pickup will double. Furthermore, over ninety percent of the respondents to a recent survey said that they would do more recycling in the future. Because of our residents' strong commitment to recycling, the available space in our landfill should last for considerably longer than predicted."

———————————————

The following appeared in a memo from a vice president of Alta Manufacturing.

"During the past year, Alta Manufacturing had thirty percent more on-the-job accidents than nearby Panoply Industries, where the work shifts are one hour shorter than ours. Experts believe that a significant contributing factor in many on-the-job accidents is fatigue and sleep deprivation among workers. Therefore, to reduce the number of on-the-job accidents at Alta and thereby increase productivity, we should shorten each of our three work shifts by one hour so that our employees will get adequate amounts of sleep."

———————————————

The following appeared in a memo from the chief executive of a video game company.

"We have recently been offered the opportunity to buy the rights to produce a video game based on the soon-to-be-published children's book 'Squirrel Power,' by Peter Wood. While the cost of the rights is substantial and will place economic constraints on our company in the short-term, there are two reasons that the purchase of these rights will undoubtedly be a wise investment. First, Wood's last three books have been best sellers and the movie based on his first book was highly profitable. Second, the popular characters and story line in 'Squirrel Power' will save us time in developing our video game, thereby reducing our costs."

———————————————

The following appeared in a memo from the owner of Green Thumb Gardening Center, a small business serving a suburban town.

"There is evidence that consumers are becoming more and more interested in growing their own vegetables. A national survey conducted last month indicated that many consumers were dissatisfied with the quality of fresh vegetables available in supermarkets. And locally, the gardening magazine GreatGardens has sold out at the Village News stand three months in a row. Thus, we at Green Thumb Gardening Center can increase our profits by greatly expanding the variety of vegetable seeds we stock for gardeners this coming spring."

———————————————

The following appeared in a newsletter offering advice to investors.

"Over 80 percent of the respondents to a recent survey indicated a desire to reduce their intake of foods containing fats and cholesterol, and today low-fat products abound in many food stores. Since many of the food products currently marketed by Old Dairy Industries are high in fat and cholesterol, the company's sales are likely to diminish greatly and their profits will no doubt decrease. We therefore advise Old Dairy stockholders to sell their shares and other investors not to purchase stock in this company."

———————————————

The following appeared in a letter to the editor of a local newspaper from a citizen of the state of Impecunia.

"Two years ago our neighboring state, Lucria, began a state lottery to supplement tax revenues for education and public health. Today, Lucria spends more per pupil than we do, and Lucria's public health program treats far more people than our state's program does. If we were to establish a state lottery like the one in Lucria, the profits could be used to improve our educational system and public health program. The new lottery would doubtless be successful, because a survey conducted in our capital city concludes that citizens of Impecunia already spend an average of $50 per person per year on gambling."

———————————————

The following appeared in a letter to the editor of the Walnut Grove town newspaper.

"Walnut Grove's town council has advocated switching from EZ Disposal (which has had the contract for trash collection services in Walnut Grove for the past ten years) to ABC Waste, because EZ recently raised its monthly fee from $2,000 to $2,500 a month, whereas ABC's fee is still $2,000. But the town council is mistaken; we should continue using EZ. EZ collects trash twice a week, while ABC collects only once. Moreover, EZ — which, like ABC, currently has a fleet of 20 trucks — has ordered additional trucks. Finally, EZ provides exceptional service: 80 percent of respondents to last year's town survey agreed that they were 'satisfied' with EZ's performance."

———————————————

The following appeared in an editorial in a Prunty County newspaper.

"In an attempt to improve highway safety, Prunty County recently lowered its speed limit from 55 miles per hour to 45 on all major county roads. But the 55 mph limit should be restored, because this safety effort has failed. Most drivers are exceeding the new speed limit and the accident rate throughout Prunty County has decreased only slightly. If we want to improve the safety of our roads, we should instead undertake the same kind of road improvement project that Butler County completed five years ago: increasing lane widths and resurfacing rough roads. Today, major Butler County roads still have a 55 mph speed limit, yet there were 25 percent fewer reported accidents in Butler County this past year than there were five years ago."

———————————————

The following appeared in a letter from the manager of a rock band named Double Rice.

"One year ago, tickets for Double Rice's concerts in stadiums around the country took, on average, at least 24 hours to sell out, if they sold out at all. But the band has been enjoying a surge in nationwide popularity among 14 to 25 year olds, and the 30,000 tickets for a recent concert in Megalopolis sold out in 12 minutes. Clearly the ticket sales in Megalopolis are a result both of the band's increased popularity and of the advertising campaign run in Megalopolis by the Ad Lib advertising agency. Thus, in order to ensure that the band's success in Megalopolis is repeated across the country, the band should hire Ad Lib to duplicate the Megalopolis ad campaign on a nationwide scale."

———————————————

The following appeared in a letter to the editor of the Balmer Island Gazette.

"The population of Balmer Island increases to 100,000 duing the summer months. To reduce the number of accidents involving mopeds and pedestrians, the town council of Balmer Island should limit the number of mopeds rented by each of the island's six moped and bicycle rental companies from 50 per day to 30 per day during the summer season. By limiting the number of rentals, the town council is sure to attain the 50 percent reduction in moped accidents that was achieved last year in the neighboring island of Torseau, when Torseau's town council enforced similar limits on moped rentals."

———————————————

The following appeared in a memo from the new vice president of Sartorian, a company that manufactures men's clothing.

"Five years ago, at a time when we had difficulties in obtaining reliable supplies of high-quality wool fabric, we discontinued production of our deluxe alpaca overcoats. Now that we have a new fabric supplier, we should resume production. This coat should sell very well: since we have not offered an alpaca overcoat for five years and since our major competitor no longer makes an alpaca overcoat, there will be pent-up customer demand. Also, since the price of most types of clothing has risen in each of the past five years, customers should be willing to pay significantly higher prices for alpaca overcoats than they did five years ago, and our company profits will increase."

———————————————

The following appeared in a memo from the president of a company that builds and sells new homes in Steel City.

"Over the past five years, the population of Steel City has increased by more than 20 percent, and family incomes in Steel City have risen much faster than the national average. Nationwide, sales of houses priced above $150,000 have increased more than have sales of lower-priced houses. Such data indicate that we should make changes in our business to increase company profits. First, we should build fewer low-priced houses than we did last year and focus instead on building houses designed to sell at above $150,000. Second, we should hire additional workers so that we can build a larger total number of houses than we did last year."

———————————————

A recent sales study indicated that consumption of seafood dishes in Bay City restaurants has increased by 30 percent over the past five years. Yet there are no currently operating city restaurants that specialize in seafood. Moreover, the majority of families in Bay City are two-income families, and a nationwide study has shown that such families eat significantly fewer home-cooked meals than they did a decade ago but at the same time express more concern about eating healthily. Therefore, a new Bay City restaurant specializing in seafood will be quite popular and profitable.

———————————————

The following appeared in a memo from the president of Viva-Tech, a manufacturer of high-tech medical equipment.

"In order to reduce costs, we should close some of our existing small assembly plants and build a large central plant. Grandview would be an ideal location for this new plant. First, of the locations that we have considered, Grandview has the largest adult population, so that we will be able to staff our plant quickly and easily. Second, since the average wage earned by workers in Grandview is less than that in the other locations, we should be able to keep production costs low. Last, as an inducement for us to build there, Grandview's town council has offered to allow us to operate for the first three years without paying city taxes."

———————————————

The following appeared in a memo from the mayor of the town of Hopewell.

"Two years ago, the town of Ocean View built a new municipal golf course and resort hotel. During the past two years, tourism in Ocean View has increased, new businesses have opened there, and Ocean View's tax revenues have risen by 30 percent. The best way to improve Hopewell's economy, and generate additional tax revenues, is to build a golf course and resort hotel similar to those in Ocean View."

———————————————

The following appeared in a memo from the chairperson of the school board in the town of Saluda.

"For the past five years, Mr. Charles Schade has been the music director at Steel City High School, and during that time the school band from Steel City High has won three regional band competitions. In addition, the quality of the music rehearsal facilities and musical instruments at Steel City High has improved markedly over the past five years. Because of such successes at Steel City High, the Saluda school board should hire Mr. Schade to plan and direct the general music education programs for the entire Saluda school system."

———————————————

The following appeared as part of a memo from the president of Automate, a company that manufactures automobiles.

"It has come to my attention that Sparks, Inc., the manufacturing company that just moved into our state, is advertising job openings at salaries that are twice as high as those paid to our experienced assembly-line workers. Some of our employees have already left to work for Sparks. In order to keep our best staff, we must pay them salaries equal to those Sparks pays its employees. Otherwise we will continue to lose employees in the future, because Sparks must staff the additional new plants that it plans to build in the state."

———————————————

The following is a memo from the superintendent of the Mylar school district.

"A recent six-month study, in which breakfast was made available at school for 100 schoolchildren ages five to twelve, found that children on the breakfast plan were less likely than other children to be absent from or late for school. Clearly, eating breakfast before school plays a role in reducing student absenteeism and tardiness. It is also well known that children who regularly eat a healthful breakfast tend to perform better in school. Therefore, in order to reduce absenteeism and tardiness and to improve academic performance in all of Mylar's elementary and secondary schools, we should provide breakfasts for all students before each school day."

———————————————

When Ida McAllister ran for mayor of Lake City four years ago, she failed to win even 30 percent of the vote. But since then, McAllister has made public her commitment to environmental causes. She would be wise, therefore, to announce her intention to close all Lake City parks to automobile traffic, thus following the example of the former mayor of Plainsville, Alecia Yu . On the recommendation of a small group of concerned citizens, Mayor Yu prohibited automobile traffic in all Plainsville parks, and therefore was credited with solving the pollution problem and improving the quality of life in Plainsville. This action would have great appeal to the citizens of Lake City, most of whom participate in the community's recycling program, and would guarantee McAllister's success in her current quest to be Lake City's new mayor.

———————————————

According to information recently reported in the Eliottown Gazette, the number of people who travel to Eliottown has increased significantly over the past several years. So far this year over 100,000 people have arrived on flights to Eliottown's airport, compared with only 80,000 last year and 40,000 the year before. Eliottown's train station has received more than 50,000 passengers this year, compared with less than 40,000 last year and 20,000 the year before. Clearly tourism in Eliottown has been increasing, thanks to the new Central Park and Museum of Modern Art that opened last year. Therefore, the funding for the park and museum should be increased significantly.

———————————————

The following appeared in the editorial section of a newsmagazine.

"Some states are creating new laws that restrict the use of handheld cell phones by drivers of automobiles. Such legislation, however, is sheer folly. Although some people with cell phones undoubtedly cause problems on the road, including serious accidents, the majority do not. Besides, problems are also caused by drivers who are distracted by any number of other activities, from listening to the radio to disciplining children. Since there is no need to pass legislation restricting these and other such activities, it follows that there is no need to restrict people's freedom to use a device that they find convenient — or helpful in emergencies."

———————————————

Until recently, people in Hiparia did most of their shopping by driving to shopping malls. They are beginning, however, to do more of their shopping by ordering merchandise from mail-order catalogs and the Internet. These purchases are delivered to them by mail or by a delivery service. For many purchases, Hiparians no longer need to drive to and from shopping malls; there will therefore be a resulting reduction in the consumption of vehicle fuel in Hiparia.

———————————————

The following report appeared in an archaeology journal.

"The discovery of distinctively shaped ceramic pots at various prehistoric sites scattered over a wide area has led archaeologists to ask how the pots were spread. Some believe the pot makers migrated to the various sites and carried the pots along with them; others believe the pots were spread by trade and their makers remained in one place. Now, analysis of the bones of prehistoric human skeletons can settle the debate: high levels of a certain metallic element contained in various foods are strongly associated with people who migrated to a new place after childhood. Many of the bones found near the pots at a few sites showed high levels of the metallic element. Therefore, it must be that the pots were spread by migration, not trade."

———————————————

Milk and dairy products are rich in vitamin D and calcium, substances essential for building and maintaining bones. Many people therefore believe that a diet rich in dairy products can help prevent osteoporosis, a disease in which the bones weaken significantly with age and that is linked to both environmental and genetic factors. But a long-term study of a large number of people has found that those who have consistently consumed dairy products throughout the years of the study have a higher rate of bone fractures than any other participants in the study. Since bone fractures are a symptom of osteoporosis, this study result shows that a diet rich in dairy products may actually increase, rather than decrease, the risk of osteoporosis.

———————————————

The following appeared in the summary of a study on headaches suffered by the residents of Mentia.

"Salicylates are members of the same chemical family as aspirin, a medicine used to treat headaches. Although many foods are naturally rich in salicylates, for the past several decades food-processing companies have also been adding salicylates to foods as preservatives. This rise in the commercial use of salicylates has been found to correlate with a steady decline in the average number of headaches reported by participants in our twenty-year study. Recently, food-processing companies have found that salicylates can also be used as flavor additives for foods. With this new use for salicylates, we can expect a continued steady decline in the number of headaches suffered by the average citizen of Mentia."

———————————————

The following appeared in an article written by Dr. Karp, an anthropologist.

"Twenty years ago Dr. Field, a noted anthropologist, visited the island of Tertia and concluded from his observations that children in Tertia were reared by an entire village rather than by their own biological parents. However, my recent interviews with children living in the group of islands that includes Tertia show that these children spend much more time talking about their biological parents than about other adults in the village. This research proves that Dr. Field's conclusion about Tertian village culture is false, and thus that the observation-centered approach to studying cultures is invalid. Because they are using the interview-centered method, my team of graduate students working in Tertia will establish a much more accurate understanding of child-rearing traditions there and in other island cultures."

———————————————

Woven baskets characterized by a particular distinctive pattern have previously been found only in the immediate vicinity of the prehistoric village of Palea and therefore were believed to have been unique to the Palean people. Recently, however, archaeologists discovered such a 'Palean' basket in Lithos, an ancient village across the BrimRiver from Palea. The BrimRiver is very deep and broad, and so the ancient Paleans could only have crossed it by boat, but there is no evidence that the Paleans had boats. And boats capable of carrying groups of people and cargo were not developed until thousands of years after the Palean people disappeared. Moreover, Paleans would have had no need to cross the river — the woods around Palea are full of nuts, berries, and small game. It follows that the so-called Palean baskets were not unique to Palea.

———————————————

The following memo appeared in the newsletter of the West Meria Public Health Council.

"An innovative treatment has come to our attention that promises to significantly reduce absenteeism in our schools and workplaces. A study reports that in nearby East Meria, where fish consumption is very high, people visit the doctor only once or twice per year for the treatment of colds. Clearly, eating a substantial amount of fish can prevent colds. Since colds are the reason most frequently given for absences from school and work, we recommend the daily use of Ichthaid, a nutritional supplement derived from fish oil, as a good way to prevent colds and lower absenteeism."

———————————————

The following appeared in a memorandum from the president of Humana College.

"Last year the number of students who enrolled in long-distance degree programs at OmniU niversity increased by 50%. During the same year, Omni showed a significant decrease from prior years in expenditures for dormitory and classroom space, most likely because instruction in the long-distance programs takes place via interactive video computer connections. In contrast, over the past three years, enrollment at Humana College has diminished and costs of maintaining buildings have risen. Thus, to increase enrollment and solve the problem of budget deficits at Humana College, we should initiate and actively promote long-distance degree programs like those at Omni."

———————————————

The following appeared in a memorandum from the president of Excello Food Markets.

"In 90 towns where Excello has food markets, natural-food stores specializing in organic food products — products containing no chemical preservatives and made with foods grown without pesticides — have opened nearby as competitors. Surveys of our own customers reveal a growing concern about foods grown using pesticides or preserved with chemicals. Recently our market in Sun City participated in a local food tasting fair, and 75 percent of the fair goers who visited the Excello booth requested free samples of organic fruit. Such evidence indicates that to increase our profits, we should begin to stock a full line of organic food products in all our markets."

———————————————

The following appeared in a memo from the vice president of a food-distribution company with food-storage warehouses in several cities.

"Recently we signed a contract with The Fly-Away Pest-Control Company to provide pest-control services at our fast-food warehouse in Palm City, but last month we discovered that over $20,000 worth of food there had been destroyed by pest damage. Meanwhile, the Buzzoff Pest-Control Company, which we have used for many years, continued to service our warehouse in Wintervale, and last month only $10,000 worth of the food stored there had been destroyed by pest damage. Even though the price charged by Fly-Away is considerably lower, our best means of saving money is to return to Buzzoff Company for all our pest-control services."

———————————————

The following appeared in a proposal from the economic minister of the country of Paraterra.

"In order to strengthen its lagging economy, last year the government of the nearby country of Bellegea began an advertising campaign to promote ecologically sound tourism (ecotourism). This year, the number of foreign visitors arriving at Bellegea's main airport doubled, and per capita income in Bellegea increased by ten percent. To provide more income for the population of Paraterra and also preserve the natural environment of our tiny country, we too should begin to promote ecotourism. To ensure that our advertising campaign is successful, we should hire the current director of Bellegea's National Tourism Office as a consultant for the campaign."

———————————————

The following appeared as part of a business plan developed by the manager of the Rialto Theater.

"Despite its downtown location, the Rialto Movie Theater, a local institution for five decades, must make big changes or close its doors forever. It should follow the example of the new Apex Theater in the mall outside of town. When the Apex opened last year, it featured a video arcade, plush carpeting and seats, and a state-of-the-art sound system. Furthermore, in a recent survey, over 85 percent of respondents reported that the high price of newly released movies prevents them from going to the movies more than five times per year. Thus, if the Rialto intends to hold on to its share of a decreasing pool of moviegoers, it must offer the same features as Apex."

———————————————

The following is a recommendation from the business manager of Monarch Books.

"Monarch Books should open a cafè in its store to attract more customers and better compete with Regal Books, which recently opened a cafè. Monarch, which has been in business at the same location for more than twenty years, has a large customer following because it is known for its wide selection of books on all subjects. Opening the cafè would clearly attract more customers. The cafè would require relatively little space. Space could be made for the cafè by discontinuing the children's book section, which will likely become less popular given that the last national census indicated a significant decline in the percent of the population who are under age ten."

———————————————

The following appeared as an editorial in a wildlife journal.

"Arctic deer live on islands in Canada's arctic region. They search for food by moving over ice from island to island during the course of a year. Their habitat is limited to areas warm enough to sustain the plants on which they feed, and cold enough, at least some of the year, for the ice to cover the sea separating the islands, allowing the deer to travel over it. Unfortunately, according to reports from local hunters, the deer populations are declining. Since these reports coincide with recent global warming trends that have caused the sea ice to melt, we can conclude that the decline in arctic deer populations is the result of deer being unable to follow their age-old migration patterns across the frozen sea."

———————————————

Although black bears are common in the eastern Canadian province of Labrador, grizzly bears — often similar in color, but much larger — were believed to exist only in the western provinces. Despite a nineteenth-century explorer's account of having startled and narrowly escaped from a grizzly bear deep in the woods in Labrador, modern scientists find no physical evidence that grizzly bears have ever lived in Labrador. But recent research into the language and legends of the Innu, a people who have lived in Labrador for thousands of years, reveals that their language has words for two different kinds of bears, and their ancient legends attribute different characteristics to the two kinds of bears. Therefore, there probably were grizzly bears in Labrador, and the explorer's account probably accurately identified the bear.

———————————————

Scientists studying historical weather patterns have discovered that in the mid-sixth century, Earth suddenly became significantly cooler. Although few historical records survive from that time, some accounts found both in Asia and Europe mention a dimming of the sun and extremely cold temperatures. Either a huge volcanic eruption or a large meteorite colliding with Earth could have created a large dust cloud throughout Earth's atmosphere that would have been capable of blocking enough sunlight to lower global temperatures significantly. A large meteorite collision, however, would probably create a sudden bright flash of light, and no extant historical records of the time mention such a flash. Some surviving Asian historical records of the time, however, mention a loud boom that would be consistent with a volcanic eruption. Therefore, the cooling was probably caused by a volcanic eruption.

———————————————

The following appeared in a newspaper article published in the country of Corpora.

"Twenty years ago, one half of all citizens in Corpora met the standards for adequate physical fitness as then defined by the national advisory board on physical fitness. Today, the board says that only one quarter of all citizens are adequately fit and suggests that spending too much time using computers may be the reason. But since overall fitness levels are highest in regions of Corpora where levels of computer ownership are also highest, it is clear that using computers has not made citizens less physically fit. Instead, as shown by this year's unusually low expenditures on fitness-related products and services, the recent decline in the economy is most likely the cause, and fitness levels will improve when the economy does."

———————————————

The following appeared in a letter to the editor of a newsletter on health issues.

"For the past decade, most health experts have advised teenagers to avoid eating greasy foods in order to prevent acne and related skin conditions, but the number of teenagers who sought medical help for these skin problems has actually risen over the same period. In a recent study, teenagers who avoided greasy foods for a month reported approximately as many outbreaks of acne and related skin conditions as did those who ate an average of two servings of greasy food per day. Such data indicate that eating greasy foods is unlikely to be a cause of acne and related skin conditions. Therefore, health experts should no longer recommend that people avoid such foods."

———————————————

From a draft textbook manuscript submitted to a publisher.

"As Earth was being formed out of the collision of space rocks, the heat from those collisions and from the increasing gravitational energy of the planet made the entire planet molten, even the surface. Any water present would have evaporated and gone off into space. As the planet approached its current size, however, its gravitation became strong enough to hold gases and water vapor around it as an atmosphere. Because comets are largely ice made up of frozen water and gases, a comet striking Earth then would have vaporized. The resulting water vapor would have been retained in the atmosphere, eventually falling as rain on the cooled and solidified surface of Earth. Therefore, the water in Earth's oceans must have originated from comets."

———————————————

The following appeared in a medical newsletter.

"Doctors have long suspected that secondary infections may keep some patients from healing quickly after severe muscle strain. This hypothesis has now been proved by preliminary results of a study of two groups of patients. The first group of patients, all being treated for muscle injuries by Dr. Newland, a doctor who specializes in sports medicine, took antibiotics regularly throughout their treatment. Their recuperation time was, on average, 40 percent quicker than typically expected. Patients in the second group, all being treated by Dr. Alton, a general physician, were given sugar pills, although the patients believed they were taking antibiotics. Their average recuperation time was not significantly reduced. Therefore, all patients who are diagnosed with muscle strain would be well advised to take antibiotics as part of their treatment. "

———————————————

The following appeared in a memo to the human resources manager at Baobob Inc., a large architectural firm.

"Several well-known, retired architects were interviewed in Architecture Today about changes in the field. Only one had earned a college degree in architecture. All others had come into the field at an early age by serving apprenticeships that required them to work under the direct supervision of an experienced architect. Several of the colleges that we recruit from report that many promising architecture students leave school early in their undergraduate career. Therefore, because finding talented architecture graduates is becoming more difficult, Baobob Inc. should start an aggressive apprenticeship program and hire students who express an interest in architecture directly out of high school rather than wait for them to get out of college."

———————————————

Thirteen years ago, researchers studied a group of 25 infants who showed signs of mild distress when exposed to unfamiliar stimuli such as an unusual odor or a tape recording of an unknown voice. They discovered that these infants were more likely than other infants to have been conceived in early autumn, a time when their mothers' production of melatonin — a hormone known to affect some brain functions — would naturally increase in response to decreased daylight. In a follow-up study conducted earlier this year, more than half of these children — now teenagers — who had shown signs of distress identified themselves as shy. Clearly, increased levels of melatonin before birth cause shyness during infancy and this shyness continues into later life.

———————————————

The following appeared in a newsletter on dental health.

"A recent research study reported the experience of dentists whose patients had, over a period of five years, regularly used Flux Dental Floss as part of their dental hygiene routine. The report indicates that these dentists had 50 percent fewer cases of gum disease than did dentists whose patients did not use Flux regularly. In addition, most of the Flux users who were surveyed by their dentists agreed that Flux's mint flavor would encourage people to floss more often. Thus, even though Flux may cost more than other brands of floss, it is clearly a worthwhile investment for those who want to be assured of healthy teeth and gums."

———————————————

The following appeared in a Letter to the Editor of the Shady Village newspaper.

"Commuters are complaining that the rush hour traffic on Blue Highway between Shady Village and Bright City has doubled their commuting time. Some commuters have asked that an additional traffic lane be built, but the recent creation of such a lane on nearby Green Highway apparently attracted more commuters, judging from the fact that rush-hour traffic jams actually increased there this past winter. To reduce rush-hour traffic on Blue Highway, a bicycle lane should be added instead of a traffic lane. This approach will succeed because many citizens of Shady Village are avid bicyclists; 75 percent of respondents to a recent questionnaire distributed there said they would like to bicycle more hours per week than they currently do."

———————————————

Collectors prize the ancient life-size clay statues of human figures made on Kali Island but have long wondered how the Kalinese artists were able to depict bodies with such realistic precision. Since archeologists have recently discovered molds of human heads and hands on Kali, we can now conclude that the ancient Kalinese artists used molds of actual bodies, not sculpting tools and techniques, to create these statues. This discovery explains why Kalinese miniature statues were abstract and entirely different in style: molds could only be used for life-size sculptures. It also explains why few ancient Kalinese sculpting tools have been found. In light of this development, collectors should expect the life-size sculptures to decrease in value and the miniatures to increase in value.

———————————————

The following appeared in a newsletter on nutrition and health.

"Although the multimineral Zorba pill was designed as a simple dietary supplement, a study of first-time ulcer patients who took Zorba suggests that Zorba actually helps prevent ulcers. The study showed that only 25 percent of those ulcer patients who took Zorba under a doctor's direction developed new ulcers, compared to a 75 percent recurrence rate among ulcer patients who did not take Zorba. Clearly, then, Zorba will be highly effective in preventing recurrent ulcers and if health experts inform the general public of this fact, many first-time ulcers can be prevented as well."

———————————————

The following appeared in an article from a popular newsmagazine.

"In 1888 a stone was unearthed in northern Wisconsin with an inscription in an old Scandinavian alphabet and bearing the date 1362. Scandinavians were not, however, exploring or emigrating to northern Wisconsin in the fourteenth century. Recent analysis proves, in fact, that the stone had been buried in the spot where it was found for no more than 100 years. Moreover, the community near the discovery site was home to a group of people who had formed a club to study medieval Scandinavian culture — a period that includes the fourteenth century. The stone, therefore, is not a genuine artifact of medieval Scandinavian culture inscribed in the fourteenth century but most likely a hoax perpetrated by the group."

———————————————

The following appeared in an article in the health section of a newspaper.

"According to the available medical records, the six worst worldwide flu epidemics during the past 300 years occurred in 1729, 1830, 1918, 1957, 1968, and 1977. These were all years with heavy sunspot activity — that is, years when the Earth received significantly more solar energy than in normal years. People at particular risk for the flu should therefore avoid prolonged exposure to the Sun."

———————————————

The following appeared in the health section of Glenntown's local newspaper.

"Several national medical studies suggest that older people who have pets tend to enjoy better health than those who do not have pets: those who have pets have lower rates of high blood pressure and arthritis. It seems clear that having to care for an animal promotes good health for the older person. Therefore, Glenntown should establish a program to give a small pet such as a dog or cat to all of its citizens who are over the age of 65. This will help to insure that our senior citizens enjoy good health and have fewer medical bills."

——————————————-

The following appeared in a report by the School District of Eyleria.

"Nationally, the average ratio of computers to students in kindergarten through grade 12 (K-12) is 1:5. Educators indicate that this is very good ratio. This means that across the country, all students have access to and can use computers daily in their classrooms. In Eyleria's K-12 schools, the ratio of computers to students is 1:7. This number is sufficient to ensure that all of Eyleria's students, by the time they graduate from high school, will be fully proficient in the use of computer technology. Thus, there is no reason to spend any of the schools' budget on computers or other technology in the next few years."

——————————————-

The Treasury has once again introduced a dollar coin, the Pine Tree dollar. Neither the Presidential dollar coin, introduced 11 years ago, nor the Eagle dollar coin, introduced 3 years ago, remained in circulation long: people simply preferred spending paper dollars. However, a survey conducted soon after its release indicates that the Pine Tree dollar is far more appealing than other dollar coins: 76 percent of respondents own the coin; 62 percent of those owning multiple coins consider it so attractive that they are still saving rather than spending the most recent coin to come into their possession. Since the Pine Tree coin promises to become the dollar currency of choice, the Treasury is correct to begin saving money by dramatically reducing the costly printing of paper dollars.

———————————————

When Stanley Park first opened, it was the largest, most heavily used park in town. It is still the largest park, but it is no longer heavily used. Video cameras mounted in the park's parking lots last month revealed the park's drop in popularity: the recordings showed an average of only 50 cars per day. In contrast, tiny Carlton Park in the heart of the business district is visited by more than 150 people on a typical weekday. An obvious difference is that Carlton Park, unlike Stanley Park, provides ample seating. Thus, if Stanley Park is ever to be as popular with our citizens as is Carlton Park, the town will obviously need to provide more benches, thereby converting some of the unused open areas into spaces suitable for socializing.

———————————————

The following appeared in a memo from the Dean of the College of Education at Omni State University.

"Only seven of our state's high schools offer even one course in Latin, but over 80 percent of the graduates who study Latin at those seven schools enroll in college. Furthermore, a recent study shows that students who have mastered Latin perform much better in logic and critical thinking. Thus, in order to increase the percentage of our high school students who graduate from college as well as to ensure that they receive a better education in critical thinking, Omni State University should begin an intensive program to prepare our future teachers to teach high school Latin."

———————————————

The following appeared in a memo from the president of a chain of cheese stores located throughout the United States.

"For many years all the stores in our chain have stocked a wide variety of both domestic and imported cheeses. Last year, however, the five best-selling cheeses at our newest store were all domestic cheddar cheeses from Wisconsin. Furthermore, a recent survey by Cheeses of the World magazine indicates an increasing preference for domestic cheeses among its subscribers. Since our company can reduce expenses by limiting inventory, the best way to improve profits in all of our stores is to discontinue stocking many of our varieties of imported cheese and concentrate primarily on domestic cheeses."

———————————————

The following appeared in a letter from a firm providing investment advice to a client.

"Homes in the northeastern United States, where winters are typically cold, have traditionally used oil as their major fuel for heating. Last year that region experienced 90 days with below-average temperatures, and climate forecasters at Waymarsh University predict that this weather pattern will continue for several more years. Furthermore, many new homes have been built in this region during the past year. Because of these developments, we predict an increased demand for heating oil and recommend investment in Consolidated Industries, one of whose major business operations is the retail sale of home heating oil."

———————————————

The following appeared in a letter to the editor of a newspaper serving the villages of Castorville and Polluxton.

"Both the villages of Castorville and Polluxton have experienced sharp declines in the numbers of residents who pay property taxes. To save money and improve service, the two villages recently merged their once separate garbage collection departments into a single department located in Castorville, and the new department has reported few complaints about its service. Last year the library in Polluxton had 20 percent fewer users than during the previous year. It follows that we should now further economize and improve service, as we did with garbage collection, by closing the library in Polluxton and using the library in Castorville to serve both villages."

———————————————

The following appeared in a memo from a budget planner for the City of Grandview.

"To avoid a budget deficit next year, the City of Grandview must eliminate its funding for the Grandview Symphony. Our citizens are well aware of the fact that while the Grandview Symphony Orchestra was struggling to succeed, our city government promised annual funding to help support its programs. Last year, however, private contributions to the Symphony increased by 200 percent, and attendance at the Symphony's concerts-in-the-park series doubled. The Symphony has also announced an increase in ticket prices for next year. Such developments indicate that the Symphony can now succeed without funding from city government and we can eliminate that expense from next year's budget. This action will surely prevent a budget deficit."

———————————————

Yellow-legged frogs were once common in high-altitude lakes in the Sierra Nevada mountains, but they have become increasingly rare. Trout feed on tadpoles and young frogs. Few lakes in the Sierra Nevada had any trout in them until a hundred years ago. At that time, many lakes were stocked with trout for recreational fishing, and now trout are common in virtually all bodies of water in the Sierra Nevada. Researchers removed the trout from one lake, and the frog population soon quadrupled. Since frogs are capable of moving several miles over land, removing trout from just a few lakes is clearly the way to restore the frog population to its former levels.

———————————————

Studies show that in 70 percent of traffic accidents, at least one driver involved is less than 10 miles from home when the accident occurs. This statistic indicates that drivers have a tendency to drive incautiously when they are close to home, probably because familiar surroundings give them a false sense of security. Thus, the places where people feel safest are the places where they are in fact at greatest risk of serious injury.

———————————————

Copper occurs in nature mixed with other minerals and valuable metals in ore, and the proportion of copper in the ore can vary considerably. Until fairly recently, the only way to extract pure copper from ore was by using a process that requires large amounts of electric energy, especially if the proportion of copper in the ore is low. New copper-extracting technologies can use up to 40 percent less electricity than the older method to process the same amount of raw ore, especially when the proportion of copper in the ore is high. Therefore, we can expect the amount of electricity used by the copper-extraction industry to decline significantly.

———————————————

In measuring electrical activity in different parts of the brain, researchers found that people who describe themselves as generally happy have more activity in the left prefrontal lobe of their brains than do other people. Therefore, a medication for stimulating the left prefrontal lobe of the brain would be an effective treatment for clinical depression.

———————————————

The following appeared in a memo from a manager of a car dealership.

"Ten years ago, long-term car leasing became available in our country of Mohilia as an alternative to outright car ownership, and leasing has steadily risen in popularity. For each of the last five years, the number of people leasing new cars has surpassed the number buying new cars. The average age of cars driven in Mohilia is six years; hence, if new car leases again outnumber purchases this year, it is likely that the majority of drivers will be driving leased, not individually owned, cars. Therefore, we should change the focus of our business from selling cars to leasing them."

———————————————

The following appeared in a newsletter about education policy.

'The average annual earnings of high school dropouts are significantly less than the average annual earnings of high school graduates. To address this problem, the state governor has proposed that the state should establish free vocational training programs for high school dropouts. But the availability of such programs would probably encourage some students who would otherwise have graduated to drop out in order to pursue vocational training. Hence the proposed programs would lower, not raise, the average earning potential of young people. Therefore, the state should not establish the vocational training programs but should instead focus on improving academic programs in our high schools.'

———————————————

The following appeared in a newsletter about health.

"The proportion of children in the United States who are overweight is greater now than ever before. Obesity rates among children have been increasing since the 1970's and, during that same time period, the proportion of children living in suburbs has increased. Whereas children in rural areas tend to have outdoor active chores and children in cities often walk to school or other places they need to go, children in suburbs are typically driven everywhere. Thus the increase in childhood obesity is probably due mainly to the suburbanization of America and the associated decrease in the opportunities children have for exercise."

———————————————

The following appeared as part of an article in a health and beauty magazine.

"A group of volunteers participated in a study of consumer responses to the new Luxess face cream. Every morning for a month, they washed their faces with mild soap and then applied Luxess. At the end of that month, most volunteers reported a marked improvement in the way their skin looked and felt. Thus it appears that Luxess is truly effective in improving the condition of facial skin."

———————————————

The cities of East Sacunda and West Sacunda are in an earthquake-prone area. Since 1985 both cities have had stringent building codes requiring all new buildings to have specific features designed to prevent damage in an earthquake. Buildings built before 1985 are exempt from the codes, but many building owners have modified their buildings to make them conform to the 1985 codes. Last year a major earthquake hit the area, and many people lost their homes. The number of people who were left homeless was much higher in East Sacunda than in West Sacunda, however, so we can conclude that building owners in East Sacunda were less likely to modify their buildings so as to bring them up to the 1985 code standards.

———————————————

The following appeared in a letter to the editor of an archaeological magazine.

"Archaeologists excavated a cave that had been inhabited by prehistoric people for thousands of years. These people hunted wild animals, many of whose bones were found at levels corresponding to different times of habitation. Most of the bones at the oldest levels, over 40,000 years old, were from a deer species whose modern-day descendants are known to prefer woodland habitats, whereas most of the bones at more recent levels, dating from 30,000 to 10,000 years ago, were from a gazelle species whose modern-day descendants are known to prefer grasslands. We can thus conclude that the climate of the area changed dramatically between 40,000 and 30,000 years ago, causing the terrain to change from woodland to grassland."

———————————————

The following appeared in a magazine for the trucking industry.

"The Longhaul trucking company was concerned that its annual accident rate (the number of accidents per mile driven) was too high. It granted a significant pay increase to its drivers and increased its training standards. It also put strict limits on the number of hours per week each driver could drive. The following year, its trucks were involved in half the number of accidents as before the changes were implemented. A survey of other trucking companies found that the highest-paid drivers were the least likely to have had an accident. Therefore, trucking companies wishing to reduce their accident rate can do so simply by raising their drivers' pay and limiting the overall number of hours they drive."

———————————————

The following appeared as an editorial in a health magazine.

"Clormium 5 is an odorless, tasteless, and generally harmless industrial by-product that can enter the water supply. A preliminary study has linked cooking with water containing clormium 5 to an increased incidence of allergies and skin rashes. Tests of the drinking water in several areas have revealed the presence of clormium 5. Although it is possible to remove clormium 5 from water, the costs of routine testing and purification are higher than many communities can afford. Therefore, in order to prevent allergies and skin rashes, communities that cannot afford to rid their drinking water of clormium 5 should replace drinking fountains in public buildings, such as schools and libraries, with bottled-water coolers."

———————————————

Allergies are an overreaction of the immune system to certain stimuli. One view is that allergies can develop as the result of childhood exposure to certain irritants, such as dust or animal dander, while the immune system is not yet mature. Another view is that exposure to particular bacteria early in childhood actually triggers the proper development of the immune system, and that limiting exposure to these bacteria through excessive hygiene can cause children's immune systems to overreact to certain irritants later on. A new study supports the second view: children who are washed especially frequently and whose parents clean their homes especially frequently are more likely to develop allergies than are other children. So in order to reduce the incidence of allergies in children and adults, parents should not limit children's exposure to irritants or bacteria.

———————————————

The following appeared in a letter to an editor.

"In many countries, wood is the primary fuel used for heating and cooking, but wood smoke can cause respiratory and eye problems, and extensive use of wood causes deforestation, a major environmental problem. In contrast, charcoal, made by partially burning wood in a controlled process, is a fuel that creates less smoke than wood does. Moreover, although charcoal costs slightly more than wood, less charcoal is needed to produce the same amount of heat. Therefore, people who use wood as their primary fuel can, without experiencing economic hardship, switch to charcoal and can thereby improve their health and preserve the environment."

———————————————

The following appeared in a memo from the business manager of Medicine, Inc., a local drugstore.

"Most business analysts for the drugstore industry have stated that even when a nation's economy is weak, drugstores' profits are unlikely to decline appreciably. While consumers might put off some kinds of purchases when the economy is slow, prescription and over-the-counter drug purchases are dictated by consumers' health needs, which are independent of the economy. Therefore, Medicine Inc. is likely to continue to have increasing profits and should plan to open an additional drugstore next year."

———————————————

The following appeared in a memo written by the head of the Gorham School.

"Our school cafeteria should make changes in the lunches that it serves in order to improve the health of our students. Several teachers and I have observed that students who eat these meals tend to eat the main course and the dessert, but seldom finish the vegetable portion. This pattern means that students are missing the vital nutritional benefits of fruits and vegetables, which are typically rich in vitamins and minerals. Therefore, the school cafeteria should serve larger fruit and vegetable portions along with smaller main course and dessert portions. This change will be effective because, according to research conducted at the Rose Children's Hospital, children eat the same amount of food served to them — about 55 percent, on average — no matter what the main course is."

———————————————

The following appeared in the letter to an editor of a Myrian newspaper.

"Under Governor Winslow's leadership over the past four years, Myria has enjoyed unprecedented prosperity. Average wage increases this year are higher than they have been at any time since the 1970's, the number of people who report being unemployed has decreased by 10 percent, and construction of new homes is up by one third. In contrast, over the past four years Governor Winslow's opponent, Mr. Homer, has been mayor of a city in which only a small number of new businesses have opened. If Myrians want another four years like the past four years, they should reelect Governor Winslow."

———————————————

The following appeared in a memo from a member of the Clark City School Board.

"Mason Elementary School is faced with a shortage of classroom space. At the same time, parents in our district are increasingly expressing the desire to see improvements in their children's reading abilities. Therefore, we should reduce the number of physical education classes at Mason Elementary and convert part of the gymnasium to class-room space. The school will gain the additional space for classrooms without the cost of extending the building and can use the time that students would have spent in physical education classes to provide more reading instruction. This plan will lead to improvements in students' reading skills."

———————————————

The following appeared in a memo to managers of Christine's, a chain of craft stores.

"Several major newspapers have recently run articles noting an increased interest in pottery. The number of potters in this country has risen by eighteen percent in the past five years, and pottery is particularly gaining popularity on college campuses. In order to take advantage of these trends, Christine's should immediately begin carrying a larger volume of pottery supplies. Since several of our stores have recently experienced a decrease in sales of painting supplies, all store managers should reallocate shelf space from the painting area for the display of pottery. Stores should display posters showing pottery that is designed to appeal to college-age individuals. These actions will undoubtedly increase our profits dramatically."

———————————————

The following appeared in a newsletter about health published in the country of Sauria.

"According to Sauria's leading nutritional experts, a diet high in complex carbohydrates, and low in fat is optimal for good health and longevity. Because this was the diet of the people who lived in ancient Sauria, one would expect them to have had long and healthy lives. Yet the mummified remains of Sauria's ruling classes from two to three thousand years ago show the existence of many medical problems among the ancient Saurians, including dental problems, elevated blood pressure, obesity, heart disease, and early mortality. Clearly, the diet of the ancient Saurians was responsible for these problems. The high incidence of high blood pressure, obesity, and heart disease in Sauria today even among those who have tried low-fat, high-carbohydrate diets further proves that Sauria's leading nutritional experts are wrong."

———————————————

The following appeared in a newspaper published in the state of Celera.

"Speed limits on our state's highways should be eliminated in order to increase our state's prosperity. Because greater speed means more efficient travel, commercial deliveries will be faster, increasing business profits. Elimination of speed limits will also make driving more attractive to motorists, so that more people will use the highways, providing more highway toll revenues for the state. At the same time, safety on our highways will not be affected: daytime speed limits were eliminated last year in the western states of our country, and no significant increase in the number of accidents in these states has been reported."

———————————————

The following appeared in an editorial on health problems in the country of Corpora.

"Some pharmacies now feature ultrasound machines that screen for an elevated risk of stroke. For a fee, a technician presses a probe against the neck to determine whether any plaque has thickened the walls of the main artery leading to the brain. Researchers have shown that a thickening of artery walls is associated with elevated stroke risk, and such scans typically find that anywhere from 5 to 20 percent of clients have detectable plaque. All pharmacies should offer this service, because early detection of increased risk for stroke will encourage clients to consult with their doctors and make important life-style changes to reduce their risk of having a stroke. This in turn will cause a decrease in overall medical costs in Corpora."

———————————————

The following appeared in an article in Supplements Today.

"Dieticians have long known that professional athletes who eat a lot of nuts have higher levels of endurance than those who do not. Researchers have recently discovered that the particular combination of vitamin N and fiber found in some nuts provides a boost for those who participate in strenuous physical activities daily. Both vitamin N and fiber supplements are easily synthesized and widely available. As a result, all those who participate in athletic activities will be able to increase their endurance and win more games by taking vitamin N along with a fiber supplement."

———————————————

The following is a recommendation from the human resources department at Techforce Computer Company.

"Many working parents report that problems related to their childcare arrangements are a major reason for absenteeism from their jobs. Bridgewell Corporation, a tele-communications company, implemented an on-site childcare program and after one year, the company reported that unscheduled absences had declined by 25 percent. Since Techforce has had an increase in unscheduled employee absences over the past year, we should therefore implement our own on-site childcare program. The program will undoubtedly reduce our unscheduled employee absences, resulting in significantly increased productivity."

———————————————

The following appeared in a memo from a vice president of a large, highly diversified company.

"Ten years ago our company had two new regional office buildings built in two different regions. The buildings were erected by two different construction companies — Alpha and Zeta. Even though the two buildings had virtually identical floor plans, the building constructed by Zeta cost 30 percent more to build, and its expenses for maintenance last year were twice those of the building constructed by Alpha. Furthermore, the energy consumption of the Zeta building has been higher than that of the Alpha building every year since its construction. Such data, plus the fact that Alpha has a stable workforce with little employee turnover, indicate that we should use Alpha Construction Company, rather than Zeta, for all future building projects."

———————————————

The following appeared in a memo from the president of Bower Builders, a company that constructs new homes.

"A nationwide survey reveals that the two most desired home features are a bathroom with a whirlpool tub and a large kitchen. Homes in a nearby development built by our competitor, Domus Construction, have whirlpool tubs and have sold much faster and at significantly higher prices than the average. To increase our sales and profits, we should include whirlpool tubs and larger kitchens as standard features in all our new homes. Since our recent buyers have voiced no complaints about small yards, we can also increase profits by decreasing the size of our yards."

———————————————

The following appeared in a memo from a budget planner in Sophia County.

"Census data indicate that the number of retired couples without children who are moving into Sophia County is steadily rising; private schools in our county report substantial increases in enrollment; and a statewide survey of parents shows that over 10 percent now support the idea of home schooling instead of public schooling funded by the county government. Such demographic trends suggest that our county will not have to construct new school buildings and that we can therefore decrease the budget for county-funded public schools."

———————————————

The following appeared in a magazine focusing on health and fitness.

"A recent study of several nutritional supplements showed that subjects who took a daily pill containing luceen had significantly better vision of distant objects than subjects in the study who took other nutritional supplements. Luceen appears naturally in a tasty fruit that grows on the island of Bonopia, and very few inhabitants of that island wear eyeglasses or other corrective lenses. Such evidence suggests that people who develop vision problems should take regular luceen supplements."

———————————————

The following appeared in a memo from the manager of television station KICK.

"A nationwide survey reveals that a sizeable majority of men would like to see additional sports programs on television. After television station WACK increased its sports broadcasts, its share of the television audience in its viewing area almost doubled. To gain a larger audience share in our area, and thus increase company profits, KICK should also revise its broadcast schedule to include more sports coverage."

———————————————

The following appeared in a memo from the director of a large group of hospitals.

"In a laboratory study of liquid antibacterial hand soaps, a concentrated solution of Nadasept killed 40 percent more bacteria than the liquid hand soaps currently used in our hospitals. During a subsequent test of Nadasept at our hospital in Saluda, that hospital reported significantly fewer cases of patient infection than did any of the other hospitals in our group. Therefore, to prevent serious patient infections, we should supply Nadasept at all hand washing stations throughout our hospital system."

———————————————

The following appeared in a memo from the economic minister of the small country Paucia.

"Using a newly developed variety of seed, farmers in our neighboring country Abundia produced 80 percent more rice last year than in any previous year. To increase the income of farmers in our own country, we should encourage them to cultivate this new variety of rice rather than some of their traditional crops. Such high yields of rice will also improve our country's balance of trade by enabling us to begin exporting it."

———————————————

The following appeared in a memo from the chief operating officer of the Presto Manufacturing Company.

"Since orders for our major product increased by over 200 percent last quarter, we should promptly expand production by building a new manufacturing plant in Summit City. Summit City is the ideal location for the new plant because it has low property taxes, extensive blocks of land available for immediate purchase, and a large number of residents who are not currently employed."

———————————————

The following appeared in a memo from the president of a company that makes breakfast cereals.

"In a recent study, subjects who ate soybeans at least five times per week had significantly lower cholesterol levels than subjects who ate no soy products. By fortifying our Wheat-O cereal with soy protein, we can increase sales by appealing to additional consumers who are concerned about their health. This new version of Wheat-O should increase company profits and, at the same time, improve the health of our customers."

———————————————

The following appeared in a letter from the mayor of Tudor City.

"After a major airline chose Yorkville as its regional flight hub, the number of businesses in that city almost doubled and local tax revenue increased by 50 percent. In addition, as travel to Yorkville became easier, most respondents to a survey of the country's top executives identified Yorkville as a desirable place to transact business. To secure efficient transportation for Tudor City and stimulate our local economy, we should build a new airport, like the one in Yorkville, that is suitable for a regional flight hub."

———————————————

Blue City Highway had always been notorious for its tight curves and poor roadway visibility, and the accident rate there was generally very high. Last year the highway was redesigned to broaden the curves and improve roadway visibility. Drivers report that they now feel much safer driving on the highway and that the redesign has been a big improvement. But the number of accidents on the highway has not been significantly lower in the six months since the redesign than it was in the six months before the redesign. Therefore, the redesign clearly did not improve the curves and roadway visibility enough to make a difference.

———————————————

One kind of brain-scanning device is used by doctors to monitor normal as well as abnormal activity in a patient's brain. The device provides precise measurements of blood flow in the brain, a known indicator of how the brain is working. Unfortunately, the device requires patients to remain completely still with their heads in the scanning machine, which makes a very loud noise. Under these uncomfortable conditions, it is doubtful that doctors can get accurate measurements. A new head-mounted device that measures eye movements rather than blood flow and allows patients to move around will undoubtedly provide better brain measurements. Thus, the new head-mounted device should replace the older device at all hospitals and research institutions.

———————————————

The following appeared in a health newsletter.

"According to a recent study, people with many social ties report catching colds less often than do people with few social ties. Consequently, researchers conclude that having an active social life probably helps strengthen the immune system. The researchers note that catching a cold — one of a family of highly contagious viruses — gives the cold-sufferer temporary immunity to that virus in the future, but not to the many other related viruses. Merely being exposed to a new cold virus, however, is not enough for a person to catch a cold, since a strong immune system can successfully fight off some new viruses. Thus, in order to prevent catching a cold, people should strengthen their immune systems by becoming more active socially."

———————————————

The following editorial appeared in a newspaper in the country of Solaria.

"The Eliot Valley region was primarily agricultural twenty years ago. In the past twenty years, however, many computer-chip manufacturers have opened factories there. A recent study found that water pollution in the region was worse than in any other region in the country. Moreover, the computer-chip factories, which use large quantities of water to manufacture the chips, are probably responsible for the low levels of water in the region's lakes and reservoirs. Therefore, if the region's computer-chip makers had limits placed on the amount of water they could use, water quality would improve."

———————————————

The following appeared in an editorial in the Seatown newspaper.

"Seatown has a large port exclusively for fishing boats, whose owners pay fees for the upkeep of the docks and for facilities for cleaning engines and repairing nets. In recent years, declining fish populations have decreased fishing revenue and forced many owners to stop fishing altogether. As a result, the port has a high vacancy rate and port managers are considering allowing pleasure boats, including cruise ships and other large vessels, to use the port in order to increase revenue. But allowing pleasure boats into the port would be a mistake, because the fishing boats would be forced out of the port. We should preserve the port for the fishing fleet, which, unlike pleasure boats, contributes to the prosperity of Seatown."

———————————————

The following appeared in a Brenton newspaper.

"The Brenton power plant draws water from Scott's River for its cooling system and releases the warmed water back into the river. The town council recommends that the plant install a more efficient cooling system that uses less water, claiming it will be more environmentally sound. However, in Uptown, where the new system is used, a study found that the complex network of pipes in the new system tends to accumulate algae. The build up of algae can be avoided by scrubbing the pipes, which is costly, or by adding an herbicide to the water in the pipes to prevent algae accumulation. But water containing the herbicide cannot be released back into the river and it is known that low water levels can harm river ecosystems accustomed to higher levels. Therefore, Brenton power plant should continue to use the old cooling system exclusively."

———————————————

The following appeared in a letter to the editor of the Maple City newspaper.

"Twenty years ago Pine City established strict laws designed to limit the number of new buildings that could be constructed in the city. Since that time the average housing prices in Pine City have increased considerably. Chestnut City, which is about the same size as Pine City, has over the past twenty years experienced an increase in average housing prices similar to Pine City, but Chestnut City never established any laws that limit new building construction. So it is clear that laws limiting new construction have no effect on average housing prices. So if Maple City were to establish strict laws that limit new building construction, these laws will have no effect on average housing prices."

———————————————

The following appeared in a memo from the Principal of Sherwood Junior High School.

"It appears that the lighting in Sherwood High's classrooms, which have large windows but minimal overhead light sources, is impairing student academic performance and teacher morale. Records show that during December and January, the two months with the fewest hours of daylight, attendance rates fall, average daily class participation drops, and grades decline. Teacher resignations are also highest during these months. According to a study of Tundra Vocational School, which experiences entire seasons with little daylight, students' grade point averages increased when Day Glow light bulbs, which mimic sunlight, were installed in classrooms. This study suggests that Sherwood can improve students' academic performance and teachers' morale by using Day Glow light bulbs in winter."

———————————————

The following appeared in a memo from the vice president of marketing at Dura-Sock, Inc.

"A recent study of Dura-Sock wearers suggests that our company is wasting the money it spends on its patented 'Endure' manufacturing process, which ensures that our socks are strong enough to last for two years. Dura-Sock has always advertised its use of the 'Endure' process, but the new study shows that the average Dura-Sock customer actually purchases new Dura-Socks every three months. Furthermore, Dura-Sock customers surveyed in our largest market, northeastern United States cities, say that they most value Dura-Sock's stylish appearance and availability in many colors. These findings suggest that Dura-Sock can increase its profits by discontinuing its use of the 'Endure' manufacturing process."

———————————————

The following proposal was raised at a meeting of the Franklin City Council.

"Franklin Airport, which is on a bay, is notorious for flight delays. The airport management wants to build new runways to increase capacity but can only do so by filling in 900 acres of the bay. The Bay Coalition organization objects that filling in the bay will disrupt tidal patterns and harm wildlife. But the airport says that if it is permitted to build its new runways, it will fund the restoration of 1,000 acres of wetlands in areas of the bay that have previously been damaged by industrialization. This plan should be adopted, for it is necessary to reduce the flight delays, and the wetlands restoration part of the plan ensures that the bay's environment will actually be helped rather than hurt."

———————————————

The following was published by a consumer protection agency.

"Three years ago, So-Low launched a nationwide ad campaign, focusing heavily on sunny regions and distributing free sunglasses there. But although So-Low sunglasses cost less than higher-priced brands, they block a smaller proportion of the Sun's rays, including the type of rays known to damage the eyes even when the person wearing the sunglasses feels no discomfort. A recent study suggests that So-Low sunglasses can actually increase the risk of damage to people's eyes by creating a false sense of security. The study shows a sharp increase in the incidence of vision problems in the sunny regions over the past three years. These findings suggest that anyone concerned about eye damage from the Sun should avoid So-Low brand and instead either pay for higher-priced brands or wear no sunglasses at all."

———————————————

A recently completed study shows that people dwelling in stairs-only apartment buildings (that is, buildings without elevators) live an average of three years longer than do people who live in buildings with both elevators and stairs. A second study shows that elderly residents of buildings with elevators make, on average, twice as many visits to doctors each year as do elderly residents of buildings without elevators. These findings suggest that even a very moderate amount of daily exercise, such as that required to use the stairs leading to and from one's apartment, can increase people's health and longevity. The findings also suggest that new apartment buildings should be constructed with as few elevators as possible.

———————————————

The following appeared in a clothing industry trade journal in the country of Sartoria.

"A popular fashion magazine recently conducted a survey of consumers' opinions about clothing prices, using prepaid mailing envelopes. Eighty-nine percent of the approximately 20,000 respondents reported that they were either 'dissatisfied' or 'very dissatisfied' with current clothing prices. The large number of responses indicates that the Sartorian clothing industry is at risk. Given the survey results, clothing manufacturers must find a way to reduce prices in order to keep their existing customers and maintain their businesses."

———————————————

The following appeared in a memo from Grocery Town's regional manager.

"The new Grocery Town store in Elm City, located near a new residential development, has a 'high-low' pricing policy where average prices are relatively high, but deep discounts are offered on some items in weekly specials. This store has been showing increased profits every month as the nearby residential development gets closer to full capacity. It follows that people prefer a pricing policy where they can find bargains on specific items. Since there is a new residential development planned in Oak City, we should change the pricing policy at all of our Oak City stores from our current 'everyday low prices' policy to a 'high-low' policy. This will increase the profits at all of our stores in Oak City."

———————————————

The following is a memo from the business manager of Valu-Mart stores.

"Over 70 percent of the respondents to a recent survey reported that they are required to take more work home with them from the workplace than they were in the past. Since Valu-Mart has not seen impressive sales in its office-supply departments in the past, we should take advantage of this work-at-home trend by increasing at all Valu-Mart stores the stock of home office machines such as printers, small copy machines, paper shredders, and fax machines. We will also increase stock of office supplies such as paper, pens, and staplers. With these changes, our office-supply departments will become the most profitable component of our stores."

———————————————

The following appeared in a newsletter from a national astronomy association.

"Various sources are predicting higher-than-average temperatures across the country next winter, including in Sun City, the traditional location of our yearly winter conference. Higher winter temperatures are sure to result in higher-than-usual tourism in Sun City, a location already known for its attractive beaches and good weather. Hotels will have fewer rooms available, transportation will be more difficult to reserve, and public places such as parks and restaurants will be more crowded. These conditions are likely to significantly reduce attendance at the conference. We should therefore move our conference to a city less popular with winter tourists."

———————————————

The following is a letter to the editor of the Waymarsh Times.

"Traffic problems here in Waymarsh are obviously reaching record levels. While just three months ago it would take me 15 minutes to get to work, it now takes closer to 25. Waymarsh should follow the example of our neighboring city Gearsville. Last year, Gearsville implemented a policy that rewards people who share rides to work with coupons for free gas. Pollution levels in Gearsville have dropped since the policy was implemented, and several friends who live in Gearsville tell me that their trip to work is quicker than it used to be. With the terrible traffic and high pollution in Waymarsh, we must implement a policy similar to Gearsville's."

———————————————

The following appeared in a health newsletter.

"A ten-year nationwide study of the effectiveness of wearing a helmet while bicycling indicates that ten years ago, approximately 35 percent of all bicyclists reported wearing helmets, whereas today that number is nearly 80 percent. Another study, however, suggests that during the same ten-year period, the number of accidents caused by bicycling has increased 200 percent. These results demonstrate that bicyclists feel safer because they are wearing helmets and they take more risks as a result. Thus, to reduce the number of serious injuries from bicycle accidents, the government should concentrate more on educating people about bicycle safety and less on encouraging or requiring bicyclists to wear helmets."

———————————————

The following is a memo from the president of Cyberell Computer Company.

"All of our customer-service employees recently attended a two-day retreat during which they received retraining in effective customer service. Subsequently, Cyberell's employee-performance study showed that the retreat benefited new employees — those who have worked with Cyberell for less than two years — far more than it did experienced employees. According to the study, after the retreat new employees were able to handle an average of ten percent more calls per hour, and the total number of customer complaints about new employees decreased, but experienced employees showed little improvement in these areas. Therefore, Cyberell should send only new employees to future retreats and should use the resulting savings to double the length of the retreats so that the retreats will be more likely to yield optimum employee performance."

———————————————

The following appeared in the Pine City Gazette.

"Fifteen years ago, Pine City launched an electricity-conservation program that reimbursed residents some of the cost for replacing energy-wasteful motors, home office equipment, and home appliances with energy-efficient ones. For ten years, spending on this program increased annually, and annual total energy consumption declined. But spending on the program began to decline five years ago, and since then Pine City's total electricity consumption has increased sharply. If this increased usage continues, the city will have to build a costly new power plant. Obviously the best way to avoid this expense is to increase reimbursement to residents for replacing energy-wasteful equipment. This will reduce energy usage to the levels of five years ago."

———————————————

The following appeared in a health newsletter.

"Eating a heavy meal may increase the risk of heart attack. A recent survey of 2,000 people who had had a heart attack revealed that 158 of them said they had eaten a heavy meal within 24 hours before their heart attack, and 25 of them said they had eaten a heavy meal within 2 hours before their heart attack. Eating and digesting food releases hormones into the bloodstream and temporarily increases heart rate and blood pressure slightly. Both of these things put stress on the heart. Therefore, people who are at risk of having a heart attack can lower that risk by not overeating."

———————————————

The following is a memo from the business manager of National Daily News.

"To expand the home delivery service of our national newspaper, we should concentrate on the state of Urba rather than on the state of Sylva. First, the population of Sylva is more widely dispersed, which would require us to spend more money to deliver our papers in that area, resulting in less profit per customer. Second, a long-term study of television viewing habits suggests that Sylvans prefer local to national news, since they spend twice as much time viewing local news programs as they do viewing national programs. Finally, because events in Urba receive more coverage in our newspaper than do events in Sylva, we can expect Urbans to be more interested in reading our newspaper."

———————————————

The following is a recommendation from the president of Appleby College.

"Whereas Appleby College holds class reunions every five years, Edelston College holds annual reunions for all classes, during which Edelston's alumni are treated to banquets, lectures, and student performances, enhancing their loyalty to the college and their willingness to donate money. Edelston College receives most of its alumni donations during or shortly after these reunions. Therefore, the best way for Appleby to increase its alumni donations is to offer similar reunion activities and to have each graduating class hold annual reunions."

———————————————

The following appeared in a health magazine.

"It has long been believed that getting at least eight hours of sleep a night is good for health. But a recent six-year study of adult sleeping habits found that people who reported sleeping eight or more hours a night had a higher rate of certain health problems than did those who reported sleeping seven hours a night. People who reported sleeping five hours a night also had an increased rate of the health problems, but this increase was slight compared to that for people who reported sleeping eight or more hours a night. Clearly, people should try to get seven hours of sleep, and they should worry more about getting too much sleep than too little."

———————————————

The vice president for human resources at Climpson Industries sent the following recommendation to the company's president.

"In an effort to improve our employees' productivity, we should implement electronic monitoring of employees' Internet use from their workstations. Employees who use the Internet from their workstations need to be identified and punished if we are to reduce the number of work hours spent on personal or recreational activities, such as shopping or playing games. By installing software to detect employees' Internet use on company computers, we can prevent employees from wasting time, foster a better work ethic at Climpson, and improve our overall profits."

———————————————

The following appeared in an editorial in the Garden City Gazette.

"To address the parking problems in our downtown business district, it has been proposed that the city increase parking capacity by building a four-story parking garage. However, this project would cost more than it would to improve the downtown pedestrian plaza. Because the pedestrian plaza is an important attraction that draws people to the downtown area, improvements to it will increase business for downtown merchants. The merchants' higher profits will ultimately produce increased tax revenues for the city. Therefore, we should invest in the plaza improvements first and then use the revenues thus generated to pay for the construction of the parking garage."

———————————————

The following appeared in the Sherwood Times newspaper.

"A recent study reported that pet owners have longer, healthier lives on average than do people who own no pets. Specifically, dog owners tend to have a lower incidence of heart disease. In light of these findings, Sherwood Hospital should form a partnership with Sherwood Animal Shelter to institute an 'adopt-a-dog' program. The program would encourage dog ownership for patients recovering from heart disease, which will help reduce medical costs by reducing the number of these patients needing ongoing treatment. In addition, the publicity about the program will encourage more people to adopt pets from the shelter, which will reduce the risk of heart disease in the general population."

———————————————

The following appeared in the annual report of a chain of stores that sell supplies for do-it-yourself home improvements.

"Current reports indicate that sales of new homes nationwide declined by 9 percent during the past year, while sales of existing homes increased by 16 percent. Thus we can expect that the percentage of homeowners who will be making repairs or improvements to their homes will also increase. In addition, people who buy existing homes will have more money left over after the purchase to spend on home improvements. Finally, people who buy existing homes are more likely to make improvements themselves, as opposed to paying someone else. These factors combined indicate we can expect an increasing demand for products in all our stores nationwide, thus increasing our profits in the coming year."

———————————————

The following appeared in an environmental newsletter published in Tria Island.

"The marine sanctuary on Tria Island was established to protect certain marine mammals. Its regulations ban dumping and offshore oil drilling within 20 miles of Tria, but fishing is not banned. Currently many fish populations in Tria's waters are declining, a situation blamed on pollution. In contrast, the marine sanctuary on Omni Island has regulations that ban dumping, offshore oil drilling, and fishing within 10 miles of Omni and Omni reports no significant decline in its fish populations. Clearly, the decline in fish populations in Tria's waters is the result of overfishing, not pollution. Therefore, the best way to restore Tria's fish populations and to protect all of Tria's marine wildlife is to abandon our regulations and adopt those of Omni."

———————————————

The following appeared in an editorial in the local newspaper of Workville.

"Workers should be allowed to reduce their workload from 40 to 25 or even 20 hours per week because it is clear that people who work part-time instead of full-time have better health and improved morale. One store in Workville, which began allowing its employees to work part-time last year, reports that fewer days of sick leave were taken last year than in previous years. In contrast, the factory in Workville, which does not allow any of its employees to work part-time, had a slight increase in the number of days of sick leave taken last year. In addition, a recent survey reports that most of the store employees stated that they are satisfied with their jobs, while many of the factory employees stated that they are dissatisfied with their jobs."

———————————————

The following is a memo from the principal of Academia High School.

"Academia High School should abolish its after-school performing-arts programs and replace them with computer-technology programs. When nearby Techno High School did so last year, total enrollment in all of its after-school activities remained about the same. Moreover, on entering college, many Techno students chose a major directly related to their after-school activities. On the other hand, last year only 10 percent of Academia's graduating seniors chose performing arts as their major field of study in their first year of college, clearly indicating that most students do not have a strong interest in the performing arts."

———————————————

The following was taken from a guide for aspiring writers.

"New writers usually cannot convince large, prestigious publishers that their work is marketable, so they must first publish with smaller, less well-known presses to establish a sales record. But the editors of Mystery Writers Magazine have good news for aspiring writers: the number of mystery novels published in the last two years has grown significantly, and more people read mysteries than any other type of novel. In addition, almost half of the mystery novels published last year were written by first-time novel writers. Since there is apparently an expanding market for mystery novels, all publishers will want to increase the number of mystery novels they publish. Therefore, new writers should write mystery novels to increase their chances for first-time publication with a larger, prestigious company."

———————————————

The following is a memorandum from the business manager of WLSS television station.

"Over the past year, our late-night news program has devoted increasingly more time to covering national news and less time to covering weather and local news. During the same time period, most of the complaints we received from viewers were concerned with the station's coverage of weather and local news. In addition, several local businesses that used to run advertisements during our late-night news program have just cancelled their advertising contracts with us. Therefore, in order to attract more viewers to our news programs and to avoid losing any further advertising revenues, we should expand the coverage of weather and local news on all our news programs."

———————————————

The following is part of a letter from the Brookfree School Board.

"As part of our new educational reform program, we identified ten schools most in need of immediate improvement. An advisory committee is now recommending that we hire consultants to study further the schools' problems and to propose a plan of action. Only two years ago, however, another group of consultants determined that several schools in our district had problems because their principals were inexperienced. Thus, if we want to see immediate improvement in our schools and save the district the money it would spend on hiring more consultants, we should replace all the principals in the ten worst schools with ten of our most experienced principals in the district."

———————————————

The following appeared in an editorial in the Mason City newspaper.

"At present, Mason City residents seldom use the nearby Mason River for any kind of recreational activity, even though surveys of the region's residents consistently rank water sports (swimming, fishing, and boating) as a favorite form of recreation. Since there have been complaints about the quality of the water in the river, residents must be avoiding the river because they think that it is not clean enough. But that situation is about to change: the agency responsible for rivers in our region has announced plans to clean up Mason River. Therefore, recreational use of the river is likely to increase, so the Mason City council will need to increase its budget for improvements to the publicly owned lands along the Mason River."

———————————————

The following report appeared in a memo from the vice president of the Southside Transportation Authority.

"We should abandon our current five-year plan to purchase additional buses to serve the campus of Southside University, because students there are unlikely to use them. Consider the results of the recent campaign sponsored by the Environmental Club at Southside University: in a program on the campus radio station, the club asked students to call in and pledge that they would commute to school by bus instead of by automobile at least one day per week. Only ten percent of the students called in and pledged. In view of the campaign's lack of success, we can assume that the bus service we currently offer will continue to be sufficient to serve the university."

———————————————

The following appeared in the editorial section of an educational publication.

"One study at Lee University found that first-semester grades of teenage students who had always attended public, tax-supported schools were slightly lower than the grades of students who had received some home schooling instruction by parents at home, although the grade differences disappeared in the second semester. These results suggest that home schooling is the best way to educate teenage children. Therefore, instead of spending more money on public education, the government should provide financial incentives so that home schooling is an option for more parents. After all, children schooled at home receive more attention, since they are taught by the best possible teacher: a parent who has a high stake in educating them well."

———————————————

The following appeared in a report of the Committee on Faculty Promotions and Salaries at Elm City University.

"During her 17 years as a professor of botany, Professor Thomas has proved herself to be well worth her annual salary of $50,000. Her classes are among the largest at the university, demonstrating her popularity among students. Moreover, the money she has brought to the university in research grants has exceeded her salary in each of the last two years. Therefore, in consideration of Professor Thomas' demonstrated teaching and research abilities, we recommend that she receive a $10,000 raise and a promotion to Department Chairperson; without such a raise and promotion, we fear that Professor Thomas will leave Elm City University for another college."

———————————————

The following appeared in a newsletter distributed at a recent political rally.

"Over the past year, the Consolidated Copper Company (CCC) has purchased over one million square miles of land in the tropical nation of West Fredonia. Mining copper on this land will inevitably result in pollution and environmental disaster, since West Fredonia is home to several endangered animal species. But such disaster can be prevented if consumers simply refuse to purchase products that are made with CCC's copper until the company abandons its mining plans."

———————————————

The article entitled "Eating Iron" in last month's issue of Eating for Health reported that a recent study found a correlation between high levels of iron in the diet and an increased risk of heart disease. Further, it is well established that there is a link between large amounts of red meat in the diet and heart disease, and red meat is high in iron. On the basis of the study and the well-established link between red meat and heart disease, we can conclude that the correlation between high iron levels and heart disease, then, is most probably a function of the correlation between red meat and heart disease.

———————————————

The following appeared as a letter to the editor of a national newspaper.

"Your recent article on corporate downsizing* in the United States is misleading. The article gives the mistaken impression that many competent workers who lost jobs as a result of downsizing face serious economic hardship, often for years, before finding other suitable employment. But this impression is contradicted by a recent report on the United States economy, which found that since 1992 far more jobs have been created than have been eliminated. The report also demonstrates that many of those who lost their jobs have found new employment. Two-thirds of the newly created jobs have been in industries that tend to pay above-average wages, and the vast majority of these jobs are full-time."

*Downsizing is the process in which corporations deliberately reduce the number of their employees.

———————————————

According to a poll of 200 charitable organizations, donations of money to nonprofit groups increased by nearly 25 percent last year, though not all charities gained equally. Religious groups gained the most (30 percent), followed by environmental groups (23 percent), whereas educational institutions experienced only a very small increase in donations (3 percent). This poll indicates that more people are willing and able to give money to charities but that funding for education is not a priority for most people. These differences in donation rates must result from the perception that educational institutions are less in need of donations than are other kinds of institutions.

———————————————

A new study collected data that shows that people who snore are more likely to gain weight than are people who do not snore. It is well known that many people who snore also stop breathing frequently during the night for a few seconds, a condition called sleep apnea. The interruption of breathing wakes the person — often so briefly that the waking goes unnoticed — and can leave the person too tired during the day to exercise. Anyone who snores, therefore, should try to eat less than the average person and to exercise more.

———————————————

The following appeared in the editorial section of a local newspaper.

"The librarians in our town's school system have reported that the number of trips that our students make to their school library on a voluntary basis has decreased significantly in recent years. For example, the average seventh-grade student visited the school library five times last year, but four of those visits were part of required classroom activities. This shows that our students are reading less than in the past. To address this problem, our town needs to improve the atmosphere of the libraries so that they will be comfortable places in which to work. If students view the libraries as uncomfortable, then they are unlikely to want to spend much time there."

———————————————

The following appeared in an editorial in a business magazine.

"Although the sales of Whirlwind video games have declined over the past two years, a recent survey of video-game players suggests that this sales trend is about to be reversed. The survey asked video-game players what features they thought were most important in a video game. According to the survey, players prefer games that provide lifelike graphics, which require the most up-to-date computers. Whirlwind has just introduced several such games with an extensive advertising campaign directed at people 10 to 25 years old, the age-group most likely to play video games. It follows, then, that the sales of Whirlwind video games are likely to increase dramatically in the next few months."

———————————————

The following appeared in the editorial section of Monroetown's local newspaper.

"Mayor Brown was recently re-elected by a clear majority of 52 percent of Monroetown's voters. Her re-election, however, does not show that most people in our town favored Mayor Brown's proposal for tax reduction over that of her opponent, Mr. Greene, who proposed raising taxes to improve education. It has been shown that voters nationwide tend to re-elect people already in office, regardless of candidates' proposals. In fact, a local survey after the election showed most people in Monroetown disagreed with Mayor Brown's proposal. Clearly most people in Monroetown favor improving education and therefore approve of Mr. Greene's proposal despite the fact that they did not vote for him."

———————————————

The following is a memorandum from the director of personnel to the president of Get-Away Airlines.

"Since our mechanics are responsible for inspecting and maintaining our aircraft, Get-Away Airlines should pay to send them to the Quality-Care Seminar, a two-week seminar on proper maintenance procedures. I recommend this seminar because it is likely to be a wise investment, given that the automobile racing industry recently reported that the performance of its maintenance crews improved markedly after their crews had attended the seminar. These maintenance crews perform many of the same functions as do our mechanics, including refueling and repairing engines. The money we spend on sending our staff to the seminar will inevitably lead to improved maintenance and thus to greater customer satisfaction along with greater profits for our airline."

———————————————

The following is a letter to the editor of an environmental magazine.

"The decline in the numbers of amphibians worldwide clearly indicates the global pollution of water and air. Two studies of amphibians in YosemiteNational Park in California confirm my conclusion. In 1915 there were seven species of amphibians in the park, and there were abundant numbers of each species. However, in 1992 there were only four species of amphibians observed in the park, and the numbers of each species were drastically reduced. The decline in Yosemite has been blamed on the introduction of trout into the park's waters, which began in 1920 (trout are known to eat amphibian eggs). But the introduction of trout cannot be the real reason for the Yosemite decline because it does not explain the worldwide decline."

———————————————

The following is a letter to the editor of the Atticus City newspaper.

"Former Mayor Durant owes an apology to the city of Atticus. Both the damage to the River Bridge, which connects Atticus to Hartley, and the traffic problems we have long experienced on the bridge were actually caused 20 years ago by Durant. After all, he is the one who approved the construction of the bridge. If he had approved a wider and better-designed bridge, on which approximately the same amount of public money would have been spent, none of the damage or problems would have occurred. Instead, the River Bridge has deteriorated far more rapidly over the past 20 years than has the much longer DerbyBridge up the river. Even though the winters have been severe in the past several years, this is no excuse for the negligence and wastefulness of Durant."

———————————————

The following is a letter to the head of the tourism bureau on the island of Tria.

"Erosion of beach sand along the shores of Tria Island is a serious threat to our island and our tourist industry. In order to stop the erosion, we should charge people for using the beaches. Although this solution may annoy a few tourists in the short term, it will reduce the number of people using the beaches and will raise money for replenishing the sand. Replenishing the sand, as was done to protect buildings on the nearby island of Batia, will help protect buildings along our shores, thereby reducing these buildings' risk of additional damage from severe storms. And since the areas along the shore will be more attractive as a result, the beaches will be preserved and the area's tourist industry will improve over the long term."

———————————————

The following is from an editorial in the Midvale Observer, a local newspaper.

"Ever since the 1950's when television sets began to appear in the average home, the rate of crimes committed by teenagers in the country of Alta has steadily increased. This increase in teenage crime parallels the increase in violence shown on television. According to several national studies, even very young children who watch a great number of television shows featuring violent scenes display more violent behavior within their home environment than do children who do not watch violent shows. Furthermore, in a survey conducted by the Observer, over 90 percent of the respondents were parents who indicated that prime-time television — programs that are shown between 7 p.m. and 9 p.m. — should show less violence. Therefore, in order to lower the rate of teenage crime in Alta, television viewers should demand that television programmers reduce the amount of violence shown during prime time."

———————————————

The following appeared in the editorial section of a health and fitness magazine.

"In a study of the effects of exercise on longevity, medical researchers tracked 500 middle-aged men over a 20-year period. The subjects represented a variety of occupations in several different parts of the country and responded to an annual survey in which they were asked: How often and how strenuously do you exercise? Of those who responded, the men who reported that they engaged in vigorous outdoor exercise nearly every day lived longer than the men who reported that they exercised mildly only once or twice a week. Given the clear link that this study establishes between longevity and exercise, doctors should not recommend moderate exercise to their patients but should instead encourage vigorous outdoor exercise on a daily basis."

———————————————

The following appeared in a letter to the editor of a local newspaper.

"Too much emphasis is placed on the development of reading skills in elementary school. Many students who are discouraged by the lonely activity of reading turn away from schoolwork merely because they are poor readers. But books recorded on audiocassette tape provide an important alternative for students at this crucial stage in their education, one the school board should not reject merely because of the expense involved. After all, many studies attest to the value of allowing students to hear books read aloud; there is even evidence that students whose parents read to them are even more likely to become able readers. Thus, hearing books on tape can only make students more eager to read and to learn. Therefore, the school board should encourage schools to buy books on tape and to use them in elementary education."

———————————————

The following is taken from an advertisement placed in a weekly business magazine by the DickensAcademy.

"We distributed a survey to senior management at International Mega-Publishing, Inc. The result of the survey clearly indicates that many employees were well prepared in business knowledge and computer skills, but lacked interpersonal skills to interact gracefully with customers. International Mega-Publishing decided to improve customer satisfaction by sending their newly hired employees to our one-day seminars. Since taking advantage of our program, International Mega-Publishing has seen a sharp increase in sales, an indication that the number of their disgruntled customers has declined significantly. Your company should hire Dickens and let us turn every employee into an ambassador for your company."

———————————————

The following is a letter to the editor of a local newspaper.

"As a local merchant, I wish to support the development of a ski resort in the state park north of our township. Along with many other merchants who favor the proposal by Ski the Slopes, Incorporated, I would, of course, experience a growth in my business. But I also know how much more prosperous, not to mention lively and interesting, our community would be if tourism increased. Since the main opposition comes from a few environmentalists* who do not even live in this community, I see no reason to give in to their views. The First National Bank has finally researched the project and agreed to fund it. As a result, I see no reason to delay development of the resort."

Environmentalists are people who advocate the preservation of the natural environment.

———————————————

The Trash-Site Safety Council has recently conducted a statewide study of possible harmful effects of garbage sites on the health of people living near the sites. A total of five sites and 300 people were examined. The study revealed, on average, only a small statistical correlation between the proximity of homes to garbage sites and the incidence of unexplained rashes among people living in these homes. Furthermore, although it is true that people living near the largest trash sites had a slightly higher incidence of the rashes, there was otherwise no correlation between the size of the garbage sites and people's health. Therefore, the council is pleased to announce that the current system of garbage sites does not pose a significant health hazard. We see no need to restrict the size of such sites in our state or to place any restrictions on the number of homes built near the sites.

———————————————

The nation of Claria covers a vast physical area. But despite wide geographic differences, many citizens are experiencing rising costs of electricity. A recent study of household electric costs in Claria found that families who cooled their houses with fans alone spent more on electricity than did families using air conditioners alone for cooling. However, those households that reported using both fans and air conditioners spent less on electricity than those households that used either fans or air conditioners alone. Thus, the citizens of Claria should follow the study's recommendation and use both air conditioners and fans in order to save money on electricity.

———————————————

As people grow older, an enzyme known as PEP increasingly breaks down the neuropeptide chemicals involved in learning and memory. But now, researchers have found compounds that prevent PEP from breaking neuropeptides apart. In tests, these compounds almost completely restored lost memory in rats. The use of these compounds should be extended to students who have poor memory and difficulty in concentrating — and therefore serious problems in school performance. Science finally has a solution for problems neither parents nor teachers could solve.

———————————————

In a study of reading habits of Leeville citizens conducted by the University of Leeville, most respondents said they preferred literary classics as reading material. However, a follow-up study conducted by the same researchers found that the type of book most frequently checked out of each of the public libraries in Leeville was the mystery novel. Therefore, it can be concluded that the respondents in the first study had misrepresented their reading habits.