# 第四章 朗读

## 1. 最古老最有效的训练方式

拥有文字之前，人类就已经能够说话，只不过能说的没那么复杂、要说的也非常简单而已。有了文字，后来甚至发展并掌握了逻辑之后，人们能够想到的、需要表达的开始变得越来越复杂起来。某种意义上，最终拥有了文字是人类与其它近亲物种最深刻的本质区别。一旦人类拥有了文字，有意识、有目的的教育就成了必须。

而所有文化在这一点上都一模一样：**朗读是语文教育的最古老、最普及、成本最低、效果最好的训练方式**。只可惜这种最好的训练方法即便在我们的母语语文教育中被重视的程度都远远不够。并且，每代人都以为自己可以找得到更好的方法而忽略这个其实无法超越的手段。

许多年来，我一直在进步，但从来没觉得自己英语学得好（至少不是人们普遍认为的那种 “好”），但在习得过程中确确实实没有觉得那么费劲。这要归功于我的父亲。我的父亲是个精通多种语言的人。毕业于黑龙江大学俄语系，文革没多久就被下放到海林县一中任英语教员，后被 “落实政策” 而调任延边医学院外语系主任直至退休。由于我的父亲是位英语教授，我一上初中就被老师任命为 “英语课代表”。我的班主任误以为我爸爸是英语教授，我的英语就自然会不错 —— 大错特错。

有句话说，“医不治己”。同样的道理，我老爸是个对学生无比耐心的好老师，可是回家教自己儿子，两句话之后就受不了了，不由得骂起来：“小崽子，是我儿子么？这么笨！” 当然，我也不示弱：“你不说我是你捡来的么！” 于是爷俩就不欢而散。那时，我觉得他英语好是他的事儿，我英语不好还是他的事儿。

可我已经成了 “英语课代表”。每天早上要站在全班同学面前领读课文，要是磕磕巴巴就很丢人。于是只好硬着头皮向老爸求助。那个年代（大约是 1984 年前后）的英语课本是没有配套磁带的（当然更没有现在这么方便的 mp3）。老爸是外语系主任，于是家里很早就有录音机，他又假公济私弄来两盘空白进口牌子 TDK 磁带，为我把所有课文朗读了一遍录了下来。此后，我事先在家里花几十分钟把课文跟着磁带读熟，然后再到学校领读，总算是不再丢脸。

初中课本很简单，从 “This is a book. That is a table. ” 开始。一册书总共也没有多少单元，而一个单元要一个星期（甚至更久）老师才能讲完。于是，课本上的每句话，我都不知道要带着全班同学读上多少次。很快我就发现领读三五遍之后，我就基本上能把课文背下来。我读完一句，等同学们跟读的时候，自然而然地就能想起来下一句是什么 —— 我甚至不用带书就可以站到前面领读。

此后的许多年里，英语课上我从来都没有认真听讲过，考试成绩却也从来没有差过。做选择题的时候，只是觉得哪一个选项填进去 “顺嘴” 就选哪个，正确率奇高无比,几乎从不出错。没多久，我就发现同学们问我哪一道题为什么只能选那一个选项的时候我要是如实回答往往招来怀疑的目光，于是就开始用从老师那里学来的行话胡说八道：“唉，语感呗……” 说来也怪，得到这种莫名其妙的答案的时候，提问者往往表情凝重，显得若有所思，然后缓缓点头，默默走开。

许多年后，我自己莫名其妙成了英语老师，认真回顾才发现我捡了个大便宜：不知不觉用了成本最低、效果最好的训练方式躲过了无数劫难。

## 2. 朗读有助于提高文字理解能力

说来可惜，但大多数人确实并不重视朗读训练 —— 无论是母语还是外语的习得过程中都是如此。朗读训练既简单又有效，并且可以解决很多许多人花很多钱去各种各样的培训班解决不了的问题。

朗读训练是提高文字理解能力的最有效方式。想象一下，现在你要流畅地朗读一个由二十个单词构成的句子。

首先，每看到一个单词，你都要有能力识别。有些单词长得很像的，比如，“principle” 和 “principal”，“quite” 和 “quiet” —— 甚至有没有空格都是需要考虑的因素，比如 “some time” 和 “sometimes”，或者 “everyone” 和 “every one”……

其次，大多数单词有很多个意思，至于它究竟在当前这句话里是哪一个意思，要根据与它相邻的单词究竟是什么意思来决定。比如，“scale” 这个单词，就有很多个意思，如果后面跟着 “~ of the economy”，那它就是 “规模” 的意思；如果后面跟着 “~ of fish”，那么它应该是 “鱼鳞” 的意思……

再次，有些单词组合在一起之后表达的意思几乎完全不是字面的含义，比如 “strike home”、“even Steven”、“paint the town red” 等等。完全不明白倒也罢了，有时真实的意思与直观的感觉恰恰相反就很难办，比如，“birds of prey”，只认识 “prey” 这个单词的学生没有专门查过词典的话，很可能把这个词组理解为 “被捕食的鸟”，而正确的含义却是 “食肉鸟、猛禽”。（别惊讶，相信我，你并不孤独。）

另外，但凡一个句子超过十个词的长度，大抵上它更可能是个复杂句，有词组、有从句，有可能是倒装句或者强调句，也有可能存在被省略的语法成分。这些语法现象并不总是那么容易处理，偶尔需要破费一些心思才能正确完成。
之所以朗读是提高 “理解能力” 的最基本方法，是因为当一个人可以流利地朗读一个句子的时候，即意味着说他正在完成对这个句子的 “拆解” 与 “重组” 的过程 —— 这是个复杂的系统工程：

> 信息通过眼睛输入，经过大脑识别、理解、处理之后又运用口腔的种种器官形成正确的声音，而后又通过耳朵反馈回大脑；而与此同时，大脑在一刻不停闲进行各种处理过程：句子成分都有哪些、哪几个字词构成什么样的成分、这些成分各自是什么意思、成分之间的关系究竟是什么、这些成分组合起来又构成怎样的含义，等等。

> 反过来也一样，如果阅读者面对一个语法正确、逻辑严谨的句子竟然不能够把它流利地朗读出来，就说明阅读者“拆解”有误或者“重组”有误。重新把句子结构与成分意义以及它们之间的关系都搞清楚之后，句意也就自然明朗了，读起来自然就“顺”了；而后再把句子多读几遍——其实就是“通过重复练习理解过程、巩固理解能力”了。

事实上，大多数人很难做到用母语流畅朗读任何句子 —— 尽管大多数人都认为自己可以做到。举例来说，也许大多数人能够在不作任何准备的情况下，能够比较流畅地朗读《读者》杂志中的任意句子 —— 因为那只不过是个扫盲类的杂志；但是，只有少数人（应该是极少数）能够做到在不作任何准备的情况下流畅地朗读《读书》杂志里的任意句子 —— 因为这种杂志所传递的才是真正需要智力才能理解的知识。即便是专业播音员，朗读任何材料之前也要首先花点时间熟悉一下内容，才能做到基本不出错地朗读出来。

> 关于《读者》与《读书》的评论，只是我个人看法。另外，《读书》好像已经停办了？

“朗读” 甚至是一种能力，也就当然需要通过锻炼才能掌握。尽管不是每个人都需要做到极致（最终成为播音员或者演员的人除外），但是如果连这都不及格，那么很可能因此导致 “理解能力” 低下，乃至于各个科目都可能受到影响。读者不妨回想一下自己的成长过程，每个班级里都至少有那么一两个因朗读糟糕而被老师或者同学耻笑的学生，大抵上他们其他科目的成绩不大可能理想的 —— 因为学习任何学科都需要阅读文本，需要理解能力，但这些孩子连流利朗读都掌握不了，理解能力自然就差出许多，于是在各个科目都可能因此落后于他人。，这几乎是铁律：儿时的文字训练影响一个人一生的思考能力，进而影响一生的生活质量。

## 3. 朗读训练会潜移默化地提高阅读理解速度

平时，我们并不在意自己的阅读速度，尤其在读闲书的时候，“速度” 几乎是不被考虑的因素 —— 快与慢全凭个人喜好。有的人喜欢咬文嚼字，有的人就是喜欢囫囵吞枣 —— 当然更多的人干脆懒得读书，只看画报与影视。人们真正在意自己的阅读速度的时候，基本上都是在考试的时候，比如，在参加外语考试诸如国内的四六级考试或者国外的留学考试 TOEFL、SAT、GRE、GMAT、LSAT 的时候 —— 大多数人的直接感受是阅读速度太慢，乃至于时间不够用。而尽管考试从来都不是招人喜欢的东西，但优异的考试成绩，往往是一个人发展的通行证，不得不为之努力。当然，在工作中，输入至关重要，因此一个人的阅读理解速度不足够快，会在很大程度上限制一个人的能力 —— 因为他获取、过滤、筛选信息的速度，以及获取的信息量和质量都在不同程度上受到些限制。

为了解决阅读速度的限制，人们（包括老师与学生）给出了各种各样的解决方案和建议，同时也定义了很多所谓的 “恶习”，比如，“唇读”、“指读”、“回读”、“译读” 等等。很多学生在面临问题的时候也难免 “病急乱投医”，相信 “唇读”、“指读” 等等方式真的是所谓的恶习。事实上，无论多么荒谬的事情只要有人肯斩钉截铁地说出来就会有人（很多人）不假思索地相信。每天遇到的这种例子还少吗？

而这些 “快速阅读” 建议基本上都是治标不治本的，因为它们解决的都是输入速度问题而已，而不是输入之后的理解速度问题。输入的速度再快，理解速度跟不上，又于事何补？有的时候有点想不明白为什么那么多人脑子里明明想着要提高 “阅读理解速度”，而实际 “阅读” 中却只关心 “速度” 而干脆忽略 “理解” 的重要呢？（也许是 “跳读、略读” 的习惯造成的？一不小心就把 “理解” 两个字给跳过去了，干脆没看着 …… 这就是很好的一个出于好意的不严谨建议最终带来恶果的例子。）

只看到表象，从未深入实质，是一切问题得不到解决的根源。阅读理解速度的瓶颈在于理解速度，而绝非输入速度。

“输入” 的方式至少有以下常见的四种：

* 扫读：只用眼睛快速浏览文字（本质上来看是必然以遗漏一些信息为代价
* 默读：在用眼睛浏览文字的同时脑子里有一个声音在 “说” 这些文字，并不实际发声
* 唇读：在用眼睛浏览文字的同时嘴唇翕动 “说” 出这些文字
* 朗读：大声把自己读到的文字说出来

现实生活中，没有人永远只用以上四种输入方式中的某一种 —— 无论是在读母语的时候，还是在读外语的时候；相反，大家都是在不自觉地根据需要选择输入方式。阅读内容对阅读者来说相对简单（即，阅读者的理解能力在这方面相对很强）的时候，更多的情况下都是采取 “扫读” 的方式；而内容难度高一点的时候，就会采用 “默读” 的方式；如果内容难度相对较高，那么就会自然地采取 “唇读” 的方式 —— 因为这样可以把速度放慢，以便有更多时间思考消化。所以说，“扫读” 也好， “默读”、“唇读” 也罢，都只是输入方式，且是各有用处的输入方式，根本不是什么恶习。如果学生相信 “唇读” 和 “默读” 都是恶习的话，他们实际上已经相当于 “三脚猫被砍掉了两条腿” —— 换句话讲，“雪上加霜”。

对于任何人都一样：阅读内容难度与阅读理解速度成反比，即，正在阅读的内容难度越高，阅读者的理解速度越低。而我们正在使用的输入手段（“扫读”、“默读”、与 “唇读”）必然会配合理解速度；于是，一旦阅读者开始使用 “唇读” 的时候，就说明此时正在阅读的内容难度已经达到一定程度，而在这样的难度之下，阅读者的 “理解速度” 已经小于等于 “唇读” 速度 —— 如果理解速度再差一些的话，阅读者还可能需要 “反复阅读” 若干次，甚至要返回之前的某一点（前一句、前一段、甚至前一页）才可能找到能让他迷途知返的线索。

而文字本身就是有声音的，只因为大多数人既不是聋子也不是哑巴。于是在理解文字的时候是不可能回避声音的。不妨自我审视一下自己的所谓 “扫读” 过程，就会发现脑子里的那个声音其实一直存在。本质上来看，“扫读” 的时候那个声音之所以有时 “断断续续”，其实只不过是因为在阅读的过程中 “跳” 过了一些 “即便不全读也能正确推测到的内容”；而那个声音只在 “读” 那些 “必须读到才不至于影响理解” 的内容 —— 也可能是句子、也可能是只言片语。再进一步，一个人但凡正常，那么他顶多可以刻意回避 “唇读”，但根本无法回避 “默读”。

大多数英语初学者在阅读一定难度的文本之时，他们的 “理解速度” 甚至赶不上 “朗读速度”。其实，类似 TOEFL 这种语言能力测试，应试者只需要做到 “理解速度” 与 “朗读速度” 相当，那么在考场上的时间就相当富裕了（而 SAT、GRE、GMAT 这几种考试对理解速度的要求相对来看就高出许多）。既然朗读训练能够提高文字理解能力，那么，朗读是提高阅读理解速度的有效训练手段 —— 尽管从感觉上来看并不那么直观。

## 4. 不必专门练习听力，朗读就够了

大量的朗读训练，可以使学生不必专门练习 “听力”。某种意义上，很多学生花费时间去专门练习听力其实非常荒谬。不聋不哑的正常人是没必要专门训练什么听力的，事实上也没办法专门练 —— 大家的耳朵构造是相同的，怎么练耳廓也不会增大，耳膜也不会变得更薄……

其实道理很简单，只要说得出，就能听得懂 —— 不管是哪一种语言。所以，只需要练说，而没必要专门练听。很多人所谓的 “听力不好” 其实是说得不好造成的，然而，他们舌本求末，就是不说，而后专门练听，这不是荒唐是什么？事实上，哪怕说得不好，也一样能够听懂。举例来说，我国有很多地区的人普通话说得并不标准，讲话掺杂着浓重的本地口音，甚至使用大量的本地特有词汇，但是，你遇到过他们之中的哪一个向你抱怨说中央电视台的新闻联播听不懂么？

这一点上体系外的培训机构显得更加荒唐，它们往往为学生配备专门的 “听力” 老师。作为商业机构，这种做法一点都不奇怪，很容易理解 —— 投其所好就有钱赚。可事实上那完全是在浪费学生时间，当然，浪费掉的还有学生的金钱 —— 可从另外一个角度上来看同样也是学生自愿浪费时间和金钱，完全是周瑜打黄盖。在这些培训机构里，我们从来看不到哪一个听力老师主张学生通过练习说而提高所谓的 “听力” —— 因为如果那么做的话，岂不是在抢口语老师的饭碗么？

很多 “听力” 老师鼓吹甚至神化 “听写” 训练的好处 —— 尽管他们并非有意欺骗，事实上他们可能真的很相信自己的方法是最有效的。但是，听写训练几乎是最浪费时间最无效果的所谓方法了。经常遇到学生这样的提问：“老师，我已经听写三个月了，怎么没有提高呢？” 这样的时候我就很迷惑，心里想：“你都已经用三个月时间完美地证明这个方法无效了，怎么还来问我它为什么无效？”

英语教学领域中，荒唐的 “方法” 要比医学领域中被吹得神乎其神的 “灵丹妙药” 多得多。因为现代医学领域中起码还有个双盲测试的方法来判定一种药物是否真的有效，可是英语教学领域中，很难运用双盲测试（或者类似的其它什么方法）来做有效性判断。然而，关于 “听写” 训练为什么无效，其实只需要用两句话（尽管可能不雅）就可以解释清楚：1) 听不懂写个屁嘛！2) 听得懂写个屁嘛！这么简单的事实，根本不用 “争议”。

事实上，Listening Comprehension 和 Reading Comprehension 一样，重点更在于 Comprehension，而非仅仅在于 Listening 或者 Reading。用耳朵听进来的东西，最终要理解了才可以，否则就没有意义。而所谓的 “练听力” 本质上来看是治标不治本的手段。

## 5. 朗读训练可以提高语言文字记忆能力

朗读训练会不知不觉地提高我们的语言文字记忆力。我们记忆人脸、记忆歌曲曲调、或者记忆文章段落的时候所使用的方法模式都是各不相同的。因为我们不可能一辈子只反复朗读同一个句子，或者同一篇文章，也因此我们必将遇到各种各样的行文模式、韵律和组合。而一定量的重复必然产生深刻记忆，于是，在大量的朗读训练过程中，会自然而然地调用我们各种可能用得到的记忆手段，比如模式的、声音的、文字的等等。

学习任何一门外语，我们最终都要能够做到用那一门语言自如地记忆篇章、转述大意。而这些都需要一个基本的能力，记忆力。学英语的时候，那就是英文记忆力。我在面试英文教师的时候，基本上只要求他们做一件事：随便背诵一段曾经熟读的篇章。换你是我，很快就会发现这么简单的一个要求会迅速地过滤掉大多数应聘者 ——大多数人竟然背不出任何 100 词以上的篇章。这一点基本的英文记忆能力都没有，怎么可能自如地运用英文呢？

多年的特殊工作经验，使我变成了 “考试机器”。很多人惊讶于我做阅读题的速度。过去参加 TOEFL 考试的时候，要求 55 分钟之内做完的题目我们可以在大约 25 分钟内做完。为什么呢？事实上，我们的阅读速度并不快，只不过，看一遍就能看懂，并且大致都记得住。于是做题的时候就会很快。一道题拿过来，看到 A 选项，就知道这个肯定不对，因为明显跟刚才看到的恰恰相反；再看 B 选项，马上就知道不能选，因为刚才读过的文章中没提到这个；再看 C 选项，就是它了，看起来只不过是原文的一句同意改写而已；这时候 D 选项甚至不用看了，因为这是四选一题目，已经有个正确答案，那剩下的必然是错的……

让我来描述一下为什么很多考生会觉得时间怎么都不够。事实上他们读得并不慢，只不过，读完了并不全懂，更谈不上记得住。等做题的时候，看到 A 选项，心想，刚才我好像看到过这个的，可是在哪儿呢？于是回到文章中去找，找啊找，文章又扫了一遍，可是竟然没有找到！于是就慌了 …… 事实上，他们的阅读速度很快，但就是无法做到完全理解，更谈不上有所记忆，于是，文章反复读了很多遍，竟然根本无从判断正确答案是哪一个。

TOEFL 考试是目前最权威的英语水平测试之一。现在的托福考试包括听说读写四个部分，无论是哪一个部分，都需要考试者拥有足够的英语记忆能力才能够获得高分。很多人托福听力考试成绩差的原因并不是因为他们 “没有听懂”，而是因为他们 “其实听懂了，但等听到题目的时候，已经想不起来刚才听懂的内容了”。记忆力对阅读成绩的影响刚才已经说过，那我们再来看看记忆力对说和写两个部分的影响。无论是说，还是写，这两个部分的考题中都有所谓的 “综合测试部分”，即，在听或读（或先听后读，或先读后听）之后根据刚刚输入的内容再输出，即，说或写。所谓的 “综合测试” 考核的一项重要能力是 “准确、全面的细节复述能力”，没有基本的记忆力，复述从何谈起？

如果参加的是 GMAT 之类的考试（这些考试本质上来看不是英语考试，而是逻辑考试，只不过用英语考而已），记忆力差的考生就更惨了。那些题目都有五个选项（而不是四个），每个选项都可能是长达三四行的复杂句，然后题目可能是这么问的：“请问以下 A、B、C、D、E 五个选项中，哪一个选项的陈述如果成立的话，那么文章中的观点会遭到严重削弱？” 没有起码的记忆力，这种题目如何才能做对呢？——想都别想。

我们很难记忆无意义、无关联的信息。比如，背下圆周率小数点后面的 100 位以上很难，相对来看很可能要比背一篇 200 字的文章难多了。一个人的文字记忆能力，很大程度上依赖他的文字理解能力。朗读的过程中，除了文字理解能力会潜移默化地提高之外，文字记忆能力也会大幅度提高。我们都有这样的经历，同一文章反复朗读很多遍，我们就会自然而然地把它背下来。这是因为 “读书千遍其义自现” —— 理解了之后就很容易记忆。而大量朗读不同的文章，实际上会有很多类似的 “模式” 在反复重复，于是，我们也相当于在不停地往我们的记忆库里潜移默化地保存信息。

反过来，一个人的记忆力同样也会影响他的理解能力。之前读过的信息如果记不住的话，就无法与后继输入的信息联系起来。信息之间无法建立足够的联系，那么就很难被理解。所以，记忆力的提高促进理解力的加强，同时，理解力的发展也会促进记忆力的发展。记忆力就是这样：记住的东西越多，记得住的东西就越多。一个人记忆力的发展空间取决于他现有的记忆力。而理解力也是如此，已经理解的东西越多，能够进一步理解的东西就越多，一个人的理解力的发展空间同样取决于他现有的理解力。

## 6. 朗读训练能够提高表达能力

朗读训练会提高一个人的表达能力，无论是说还是写。大量的朗读会使你不知不觉记住大量的表达法。越是常用的、越是必要的表达法，在各种文章中重复出现的频率越高，而通过大量地重复，这些表达法会慢慢刻在脑海中。按照心理学家的说法就是这些信息会慢慢从短期记忆区域移动到长期记忆区域，即，这些表达法会渐渐成为你的 “内嵌”(built-in)表达手段。

学习外语的时候，语法总是最大难点之一。英语中，有些名词单复数形式相同，而另外一些名词有特殊的复数形式；有些动词可能是及物动词也可能是非及物动词，如若它被当作非及物动词使用的时候，那么就要搭配一个恰当的介词；有些动词后面只能接 “ing” 形式，而另外一些动词后面只能接 “to do” 形式 …… 这些规则尽管在语法书中都被整理的一清二楚，但想通过阅读语法书记住这些实在是太难 —— 要不然怎么会有那么多人反复参加英语考试之后依然得不了满分，依然反复出错？而如若朗读过那些语法考点的类似例句，那么做题的时候就会感觉 “正确答案顺嘴”，“错误答案拗口”…… 而在平时说或者写的时候，就会自然而然地使用正确的方式，而非在自己都并不知晓的情况下 “发明了一种新的英语”。

朗读训练还会在不知不觉中培养练习者的语言文字韵律感。这方面，即便在我们母语的正规语文教育体系中，都强调得太少。我们所拥有的对母语文字韵律的了解，几乎全部不是从学校里刻意学来的（因为学校里很少刻意去教），而是在朗读中不知不觉习得的。我们在成长过程中，或主动或被动地朗读过许多的课文（通常文字确实比较隽永），许多的诗歌（现代诗、唐诗、宋词等等），很多人就算没有朗读过太多的文章、诗歌，但起码会唱许多流行歌曲（某种意义上，大多数流行歌曲的歌词为了能够朗朗上口，也相当追求韵律），所以，人们在使用母语的时候，好像 “不用教、不用学、不用练” 就 “自然地” 拥有一定的语言文字韵律感。

如果你在出版社做过哪怕一两天文字编辑就知道有很多人写出来的文字根本没法读，全然缺乏文字的哪怕最基本的韵律感，而作者显然并不知道自己的文字究竟有多么地拗口 —— 能给出版社投稿的作者往往都自认为自己的文字写得相当不错 …… 这就是母语朗读训练太少而造成的恶果。而朗读训练会使一个人不知不觉避免这种尴尬，俗话说，“熟读唐诗三百首，不会作诗也会吟”，某种意义上说的也是这个道理。

## 7. 朗读训练可以提高语言文字模式识别能力

朗读训练会提高一个人的语言文字模式识别能力。正常人在各方面都有很强的模式识别（pattern recognition）能力。比如，能在几十张脸中迅速识别出哪些是陌生的哪些是熟悉的 —— 哪怕看到的并不是百分之百清楚、甚至可能是多少有点扭曲的图像。心理学家们早就注意到英语使用者可以瞬间分辨出 “indicate” 和 “intricate” 这两个词，尽管这两个词只有一两个字母不相同（第一个单词由八个字母组成，第二个单词由九个字母组成）—— 能够做到这一点就是因为他们在不由自主地运用他们的模式识别能力。

当我们使用语言的时候，无论是听说读写，都不是一个字一个字单个输入而后再组合而后再进行处理的；实际上，我们往往是 “整块处理”，即，只要能用模式识别就用模式识别。

为什么我们听到 [le – m – gəu] 能明白那是在说 [let him gəu]？那不是我们一个词一个词识别（let + him + go）之后才进行理解而后得到结论的。那是日常生活中我们自己就说过很多遍，也听过很多遍，所以 “Let him go” 早成为一整个 “模块”，并且，在听到这个音流的过程中，还有可供辅助理解的场景存在，所以才显得我们瞬间已经领会。

再比如，当我们说 “I've lost my key!”(“我把钥匙弄丢了！”)的时候，我们不是用这种这样处理的：

* I（我……）
* 've（“have” 要和 “I” 连起来，于是 have 就要缩略为 ‘'ve’…… 钥匙是刚刚丢的，所以应该用现在完成时……）
* lost（“lose” 是个不规则动词…… “lose” 的过去式和过去分词都是 “lost”……
* my（那个钥匙是我的，而不是别人的……）
* key（我丢的是钥匙，不是别的……）

我们更可能是这样处理的：

> *I've lost my*（刚发现钥匙不见了；之所以这里可能有停顿，是因为正在找钥匙……）**key**!

也就是说，“I've lost my” 被当作一个单元，而 “key” 是另外一个单元。日常生活中，“I've lost my...” 其实不知道已经说过多少遍，比如：

* I've lost my **key**.
* I've lost my **money**.
* I've lost my **wallet**.
* I've lost my **ticket**.
* I've lost my **job**.
* ...

而我们其实也不知道听别人说过多少次类似的话：“I've lost my...”。所以，当我们听到别人说 “I've lost my...” 的时候，脑子里的反应是 “What did you lose?”，而不是：

* 听到 “I” 而后想，“你 …… 怎么了？”
* 听到 “'ve” 而后想，“哦，你说的现在完成时的什么动作呢？还是你 ‘有’ 什么？”
* 听到 “lost” 之后想，“哦，原来是丢东西了啊，这个不规则动词你居然用对了……”
* 听到 “my” 之后想，“知道，你丢了你的什么东西啊，我还以为是把我的什么东西弄丢了呢……”
* 而听到 “key” 之后想，“哦，原来是你刚刚把钥匙弄丢了啊！”

(就算真的如此想，那想的速度也应该快到我们都不知道在这么想的地步。)

以下的两个例子可以用来演示模式识别在语言应用中的重要性。

绝大多数中国人其实无法详细地解释出 “编” 和 “织” 这两个汉字的异同之处。某一个层面上，这两个字的意思是如此相同，乃至于拼起来 “编织” 还是那个意思。可是这两个字的用法上并不完全相同。我们可以说某个女孩子 “她编毛衣”，也可以说 “她织毛衣”；我们可能说某个男孩子 “他编故事”，但是我们却绝对不会说 “ 他织故事”！——换言之，哪怕做不到详细地解释出 “编” 和 “织” 这两个字的异同之处，但是却绝对不会用错。合理的解释是，母语使用者在过去曾经遇到过大量的 “编毛衣”、“织毛衣”、“编故事” 之类的组合，但是却从未遇到过 “织故事” 的组合，于是潜意识里就不存在这个 “模式”。

以英语为母语的人也是如此 —— 事实上所有人使用语言的时候都应该如此。大多数人（少数语言学教授除外）只能清楚地说出 “important” 与 “essential” 之间的区别是程度上的差异，即，“essential” 相当于 “very important”。“essential” 这个单词有个特征 —— 它所修饰的通常不是人 —— 就是大多数人说不出来的了。但是，以英语为母语的人可能会说 “He is an important teacher in my life.”，但轻易不会说 “He is an essential teacher in my life.” 以英语为第二语言的人却常常犯这样的 “错误”。

母语使用者知道关于自己母语的很多自己并不知道自己知道的知识 —— 往往被不知所以然的人称之为 “母语直觉”。而这样的知识的获得某种意义上只能靠 “大量应用” 以及 “日积月累”。而朗读对第二语言习得者来说，更可能只能在缺乏环境的情况下训练自己的语言模式识别能力。于是，朗读就几乎成了唯一可依赖的手段。反复朗读的过程中，很多 “模式” 就会不由自主地刻在脑子里，慢慢转化为自己都不知道自己知道的知识 —— 那种我们的英语老师常常闪烁其词的 “语感” 就自然而然地养成了。

| [< 第三章: 语音](./chapter3.md) | [第五章: 词典 >](./chapter5.md) |
| ------------------------------- | ------------------------------- |
