# 第二章 口语

## 1. 我是如何摆脱哑巴英语的？

我不是科班出身，所以，别说口语差，连单词发音都差得一塌糊涂。再往前倒推许多年，我刚开始讲托福课的时候，甚至连 “发音差” 都不是，而是 “干脆读错”（之前提到过我把 specific 读成 “spesifik”，把 facade 读成 “fakeid”）。更不用提什么口语了──事实上，几乎没怎么开口与人讲过英文。（但这并不影响我当时 TOEFL 考出高分，也不影响我在讲阅读课──事实上，我的发音还真不是所有老师里最差的……）

开始讲课没多久，我就被要求去讲作文课──后来，TOEFL 作文、SAT 作文、GRE 作文、GMAT 作文 …… 各式各样的留学考试的作文我都讲过。当年为了自己考出高分，我把所有的作文题目都分类写了一遍，TOEFL 有 185 道题，GRE 分别有两百多道 ISSUE 和 ARGUMENT 题目……

自己写好其实相对简单，一旦开始要给大量的学生讲课，我马上又发现了困境：作为老师，我不能把我的思路强加到学生身上，也不应该用某一种特定的思路限制学生的思维。所以，在接手作文课授课任务之后，我又动手把其中相当数量的题目写了若干个版本（比如，对某个特定的立场，写出同意的、反对的、中立的三个版本）……

所以，在开始讲作文课之后的一两年里，我每天都在写作文，改作文（自己的和学生的），不知不觉，脑子里装了无数的素材。

到此为止，我依然没有太多的口语实战经验。我个人也不太喜欢去英语角，可能是我的偏见，总觉得那儿效率太低。

终于有一天，意外发生了。那是从广州回北京的路上。当天起大雾，所以飞机延误，刚开始还以为多等一会儿就可以了，可是一个多小时过去，我依然在候机厅。百无聊赖之中，我打开笔记本，开始修改作文……

突然有个声音跟我说话，“Hi……”

我这才发现身边坐着一位金发碧眼的美女。瞬间我就反应了过来，她肯定是看到我在大段写英文，所以认为我一定能讲英文 …… 可是我自己知道自己什么德行啊！发音极差，一开口就出错……

那女生倒是不认生，自顾自就说了一大堆。我脑子里一片空白，不知道该说什么，只是硬着头皮用微笑（估计是红着脸）和点头应对。

可是，总不说话也不是事儿啊！

突然，我眉头一皱，计上心来。我终于开口说话了：“Many believe that parents are the best teachers, do you agree or disagree?”──这是 TOEFL 作文题第一道……

也许是这个话题太突兀了，那女生愣了一下，说话居然开始支吾起来。两三个短句之后，她把球踢了回来：“Wow, I really didn't think it through, huh, what do you say about it?”

我突然放松了下来──她怎么可能知道，这道题我写过四五个版本！我开始跟她说我的看法。我知道我的发音很差，所以，有意放慢了语速 …… 她不由地认真听了起来，因为她发现身边这个其貌不扬的男人，不开口倒也罢了，一开口竟然常常有并列复杂句 …… 更为关键的是，例证丰富，逻辑严谨……

她以为她与我之间的是 discussion，哪里知道对我来说，这根本就是 presentation!

不知不觉我说完了，她若有所思地说，“Wow, you’re so considerate!” 后来上了飞机，她还专门换了个座位，我们一路上聊了很多东西，比如，“小城市其实比大城市生活更舒服”、“人们为什么喜欢从事危险的活动”（TOEFL 题目）…… “每个社会都常常忽略那些真正的思想家”（GRE 题目）…… 到了北京，临分手我才知道她叫 Susan。后来我写《TOEFL 高分作文》的时候，由七人构成的外教团队就是她组织的。

这次经历，彻底改变了我对口语教学的看法：我以前总以为学生的问题是 “不知道怎么说”（HOW）──我曾以为我自己的问题也是如此；现在我认为学生所面临的问题不仅仅是这个，更重要的是他们 “没什么话可说”（WHAT）。

后来我就养成了习惯，不再指望自己能够脱口而出，而是希望自己有备无患。每当我遇到一些要讲英文的正式场合，我一定会提前花时间先写 “逐字稿”，不会写的就去查查词典，查词典查不到的，就用 Google 搜索，连 Google 都搜不到，那就想想看有没有可替代的说法 …… 而后再花时间修订，熟悉，复述。如此这般之后，到了现场，基本上能够做到 “自如” 应对。

如此这般之后，我才反应过来，其实我自己讲中文也是如此的。平时跟朋友闲聊，倒不见得一定要准备，但是哪次上台演讲不需要提前准备呢？有时即便提前准备了，也可能因为不够充分而出现 “演砸了” 的情况。而事实上，即便是与朋友闲聊的时候，有些重要内容还是需要准备一下的（只不过那准备很多的时候并不 “正式”）。谁都一样，有多少次你我在给朋友讲故事的时候由于不熟练而最终把好故事讲臭了？

* [TOEFL作文题目](files/TOEFL-writing-topics.pdf)
* [GRE的Issue题目](files/GRE-Analytical-Writing-Argument-Task-Topics.md)
* [GRE的Argument题目](files/GRE-Analytical-Writing-Issue-Task-Topics)

在相当长一段时间里，我以为自己 “发现” 了一条真正的捷径，后来才发现 “我并不孤独”。在国内，卖得最好的口语教材，实际上是北京外国语大学的专业教材，作者是北外教授吴祯福老师：一共三本，《英语初级口语》、《英语中级口语》、《英语高级口语》，多年来多次再版，印数均超过 100 万本。如果读者有机会，不妨去书店翻翻这套教材──你会发现其中的大多数课文话题，实际上也许都是从 TOEFL 作文题脱胎而来的。

请允许我重复一遍：**你的问题也许不在于你不会说，而在于你没什么话可说。**

## 2. 为什么买不到适合你的口语书？

这是个非常诡异的现象：市面上关于英语口语的书籍多如牛毛，但作为读者，总是觉得无论哪一本买回来之后都并不能真正解决自己的具体问题。

为什么会这样呢？

因为没有任何一本口语书籍是针对你写的 —— 它们都是针对大众写的，否则，书就只能卖给你一个人；如若真的如此，那书根本就印不出来，没有哪一个出版社愿意出版。

随着年龄的增加，每个人的内涵会慢慢积累出巨大的差异，于是，人们之间各自 “想要说的话” 都大不相同。另外还有一个原因，在真实的对话场景里，除非必要，人们往往回避 “重复别人的话”。既然别人已经说过，自己又何必再啰嗦？与此同时，随着时间的推移，每个人的思考方式也会衍生出独特之处，乃至于即便用同样的开场白，几句话过后，就会蔓延到与其他人完全不一样的方向。

As people getting older, their knowledge is also increasing (hopefully). Therefore, what people want to say varies drastically from individual to individual. Furthermore, in real conversations, people always avoid repeating others whenever necessary. Why waste time and energy to produce nothing?

Meanwhile, everyone is becoming even more distinctive, especially in terms of thinking. Therefore, a talk might well begin with mundane greetings, but is bound to crawl into a unique and unexpected direction after several exchanges.

上面两个段落，是典型的我自己的风格的书面表达方式 —— 至于是否 “地道” 先放在一旁。想想看，这是你想说的话么？这是你会使用的表达方式么？就算你我想得一样，但最终你会像我这么表达么？──无论是用中文，还是英文……

其实使用任何一种语言的人都一样，别看他们用相同的语言、文字、词汇，但最终他们所表达出来的都千差万别，各不相同，并且，不相同的部分居多。而且越是勤于思考的人越是有更多的不同。这就是个人风格，不论在文笔还是说话上，都会烙上显著的个人特色。英语也是如此，所以口语书不可能满足你的所需也实为正常

某种意义上，这可能更能解释为什么小孩子学外语显得比成年人容易。因为小孩子要说的话相对成年人少，并且相对成年人更少差异，也就是说，在少儿英语口语教材中所涉及的对话，可能更大程度上能够做到覆盖小孩子在真实世界里想说的话、要说的话，以及可能说出来的话。而成年人所需要表达的内容更为复杂，因此表达难度更高。成年人不像小孩子要说的话那样相对简单一些，他们无法做到 “不假思索” 地表达他们的感受尤其是那些 “深思熟虑” 的内容。

著名的《英语 900 句》曾经风靡全中国，被认为是最经典的口语教材。某种意义上它确实是；但从另外一个角度来看的话，又恰恰因为 “它挑选了所有的人（共同）最常用的句子”，所以，那些句子实际上是人们最少说，甚至根本不说的句子。不妨来看看以下的内容：

1. Hello.
2. Good morning.
3. I am Kate Green.
4. Are you Tom Brown?
5. Yes, I am.
6. How do you do?
7. How are you? Fine, thanks.
8. How is your mother?
9. She is very well, thank you.
10. Good afternoon.
11. Good evening.
12. Good night.
13. Good-bye.
14. See you in the evening.
15. So long.

这些句子全都学完了，对于真实的口语交际其实是没多大用处的。正常人怎么可能见面打招呼之后直接就告别呢？真正的场景可能是这样的：遇见与离开之时根本就没有寒暄 —— 因为大家彼此不是陌生人（你平日里跟陌生人说话的可能性有多大呢？），而聊天的内容每一次都有巨大的不同……

这些口语书选择了那些 “最经常重复出现的内容”，但这些内容并不像那些作者所想象的那样 “因为它们是最经常重复出现的，所以它们是最重要的”，恰恰相反，这些重复频率最高的内容实际上只不过覆盖总体语言使用的 1%而已。所以，注定用处十分有限。

## 3.口语差很可能另有原因……

很多人因为自己的口语差而苦恼，更多的，甚至是自卑。然而，口语差可能有更深层次的原因，也许不是因为你笨，恰恰相反，可能是因为你太聪明！
从某种角度来看，头脑简单的人更容易习得外语口语。因为他们的表达需求简单。他们头脑简单，所以，见人只想（也只能）讨论简单的问题，比如，今儿天气不错啊（Nice day, huh?），你最近怎么样啊（How are you doing?）等等……

头脑简单的人，见到陌生人问 “What’s your name?” 一点都不觉得自己说的有什么不妥。可事实上，请你认真回忆一下自己在真实的世界里有多少时候需要问 “你叫什么？”

真实的世界里，更可能的情况是这样的：

1. 首先愿意告诉你他名字的人会主动告诉你，不愿意告诉你名字的人你问他也不会说；
2. 对方告诉你他的名字之后，你所面临的问题很可能是不知道名字中具体的字怎么写（英文中就是怎么拼）……

所以，真实的对话可能是这样的：

* 你说：你是……？（You are …?）
* 对方接过来：李雷。（Michael Johnson.）
* 你可能需要把名字记下来，所以接着说：雷电的雷？（Michael as Michael Jordon?)
* 对方说：是啊。（Correct.）
* 你说：哦。（OK.）

事实上，在真实的世界里，也许只有警察才常常用这句话： “What’s your name?”

相对于那些头脑简单的人，那些头脑不简单的人在开口讲外语的时候会面临更多困难，因为他们的表达需求更为复杂，甚至可能过于复杂。他们没多大兴趣与对方讨论天气问题，或者对方来自于哪里，他们想跟对方探讨一下 “当前人们所关注的全球变暖问题之中，有哪些问题是被大多数人所误解的”，或者 “现在人民币汇率节节攀升对普通市民来说有哪些可能的风险”……

简言之：聪明的人往往思维复杂，而复杂的思维需要借助复杂的表达才能得以传递。

于是，头脑不简单的人，注定将面临更多隐含的问题。

比如，因为表达需求太过复杂，所以导致同样的训练在他们身上根本无法发挥同样的作用──他们事实上需要更多更强的训练。再比如，他们很难遇到有能力与他们探讨有深度的问题的人，所以，他们很少有机会去在实践中锻炼自己的口语能力──相对来看，那些头脑简单的人就幸福得多：随便抓来一个人就可以开始练了……

有些人口语不好不是因为笨，而是恰恰因为他不笨。然而，这结论反过来并不成立。口语流利者之中，除了少数头脑简单之外，更多的人是聪明的。因为说话本身是一种高度协调的系统工程：要持续输入（捕获对方一切反馈），要高速处理（所谓见机行事可不是那么容易的事情），还要有效输出（说准说对说得精彩更不容易）…… 这一切，都要有长期的锻炼和积累才行。

即便在说母语的时候，人与人之间的差异也是巨大的。有的人口齿伶俐，思维缜密。而更多的人，甚至吐字不清，逻辑混乱，语无伦次 …… 然而，这只不过是积累的最终表现而已，事实上，每个人的起点没有太大的区别。

以上文字的重点在鼓励那些口语差的人。在第二语言习得方面，无论是谁，都是从零开始，无论是谁，都不可能一朝一夕就登峰造极。而且，口语差一点，根本没必要自卑，因为那并不见得就是你笨，或者你没有天分，更可能只不过是因为你不笨，你头脑不简单。

## 4. 如何创作自己的口语书？

所以，“一切都只能靠自己” 这句话从古至今在任何领域都绝无半点夸张。既然你跟别人就是不一样的，那么，那些不一样的内容──对你来说也是最重要的内容──只能靠你自己去整理。

### (1) 一定要用本子记录
准备一个笔记本，随身携带。每天花十分钟到半个小时，把自己想要表达的内容用中文记录下来。坚持一段时间之后，每天再多花点时间把那些你要说的话用英文表达出来，并记录下来。

没多久你就会发现：
1. 实际上你必须表达的话并不多……
2. 这些内容中的绝大多数其实你完全有能力用英文表达（最多查查词典就可以了）。
在这个过程中，对你来说可能更重要的发现是你的中文，即，你的母语，并不像你自己原本以为的那么好。有时，你想说的话其实并不通顺。

比如，某论坛上曾有一位用户提问：“请问，‘盲目地做出的决定通常是不理智的’，这句话用英文怎么写，请大家帮忙，谢谢！”

很快就有人回答到：“感觉这句话有点别扭啊。就好像说 ‘空腹时不吃饭是会饿的’ 一样 —— 既然是盲目的决定，那当然是不理智的了！”

这位提问者所面临的问题，不仅是英语表达困难，更深的层面上来看，干脆是逻辑问题，即，思维层面的问题。由于逻辑的不严谨，他所要表达的内容，即便是用他的母语表达出来，也都是不通的……（就算是翻译成英文，依然是莫名其妙的句子：A blindly made decision is usually irrational.）

其实，这不是哪一个人特有的问题，事实上，这种隐含的问题非常普遍。这也是为什么很多人在第二语言习得过程中感觉非常吃力的重要原因──因为问题的症结根本不在外语上，而是在更为基础的层面上：逻辑训练欠佳。然而，在不自知的情况下，就可能误以为困难来自于外语本身；可既然瞄错了方向，又如何有的放矢呢？

所以，找个本子把自己要说的话记录下来，不仅仅是为了将来翻译成英文。记录下来有很多好处，起码，可以让自己重新审视一下自己所说过的话，避免自己的表达实际上是思维混乱的产物。

### (2) 根本不知道该如何用英文说怎么办？

少数情况下，我们会发现自己要表达的东西，完全不知道应该用英文如何表达。尽管这种情况属于少数，但它们却往往是最为关键的内容。

在我自己的积累过程中，遇到过很多当时完全不知道该怎么说的情况。比如，有一次，我在北京的一个酒吧里听歌。身边的朋友起身去洗手间的功夫，过来一个老外，想做在那个空座位上，我马上想表达的是 “这儿有人的！”

可是，我差一点卡住。在脱口而出 “There is a person here!” 的同时，我清楚地意识到我说的干脆就是一句 “鬼片台词”──座位上明明没有人么！那个老外听到之后愣了一下，随即反应过来，说，“OK, I’ll try another one.” 然后找其它的位子去了……

我掏出本子，写下这句中文 “这儿有人！”，然后，在这句中文之后，也写下了那句 “鬼片台词”──“There’s a person here!”，然后继续听歌。

过了几天，我在另外一个完全不相干的场合，见到一位老外遭遇与我一样的场景，然后她说的是：“Sorry, it’s taken.” 我愣了一下，反应过来，然后就掏出本子，找到前些天记录的位置，划掉 “There’s a person here!”，补上 “It’s (the seat is) taken.”

这就是解决方案：

管它对不对，地道不地道，先想办法表达出来。

老外也是人，也是相当有智商的，他们会动用一切可能的智慧去理解你的话。很多的时候，就算你表达得不地道，不正确，根据当时的场景，他们也能够猜出你想表达的究竟是什么（但即便你的表达有误，他们一般也不会指出来，这样会误使你认为自己口语还不错）…… 相信他人有一定的智商，是具有正常情商的表现。

一定要及时记录下来。记录的习惯无比重要，《把时间当作朋友》里我曾花费很大的篇幅论述。不过，遗憾的是，还是有一些读者认为 “不至于吧？” 所谓的 “执迷不悟”，如是罢了。

因为有记录，所以，将来 “偶然” 获得答案的时候，知道应该补在哪里。从我和无数学生的实践经验来看，如果之前有所记录，那么将来获得答案是 “必然”，如果之前没有记录，很多会 “必然” 到来的答案，最终连 “偶然” 都无法形成，因为你过去并未记录，所以当答案来临的时候，你根本就未曾意识到，于是，擦肩而过的就是你。

### (3) 学会 “换一种说法”

有很多时候，你要表达的东西在英语中根本就没有对应概念。这样的时候，就必须通过 “换一种说法” 去搞定。

我遇到过很多次类似情况。TOEFL 作文题中有一道题，问 “Do you agree or disagree with the following statement? Boys and girls should attend separate schools.” 我要给学生分析这道题目。在众多父母可能选择 separate school 的原因中有一个：他们害怕自己的孩子早恋。

可是，“早恋” 用英文怎么说呢？我不知道。也查不到。我甚至没办法问老外，“早恋” 怎么说，因为我没办法用英语问他我想问的东西究竟是什么……

我向他们描述：“In our culture, it is deemed as a wrongdoing if teenage girls and boys fall in love…” 我本来想接着问他 “… and we have a specific word to describe the relationship or the circumstance, called ‘早恋’，‘早’means too early, or premature, and ‘恋’means love… is there any counterpart in English vocabulary for this?” 可后面这话还没说出来，老外已经瞪大了眼睛喊道，“Why?”

老外不会理解的，在他们眼里，十几岁的孩子开始对异性感兴趣（事实上，孩子从几岁开始就对异性感兴趣了）根本就是正常的，甚至是必然的。歌德说，“哪个少女不怀春，哪个少男不钟情”。

> 原文是德文，英文译文是：“Whoever is a girl does not want to be loved, and whoever is a boy does not want to be royal to his lover.”

在西方世界里，不存在中文意义上的 “早恋”。而在中文中，“早恋” 这两个字是一个血淋淋的词汇──在中国境内每年因所谓的早恋问题而自杀的少年难以计算……

所以，“父母们之所以选择男女分校，很可能的原因之一是因为他们害怕自己的孩子早恋。” 这句话，我愣是用英文说不出来。但，我还是先把这句话中能说明白的部分记在本子上：

> One of the reasons why many parents want to send their children to separate school is that they are worried about 早恋.

很长时间里，我没有找到答案。

大概几个星期之后，有一天我在读一篇文章，读到一个词，“undernutrition”（营养不良），脑子里闪过的念头是这个词头 “under” 究竟都有哪些意思呢？于是动手去查词典。哦，它基本上有两个意思：

1. 在 …… 之下，比如 underground；
2. ……不足、不良，比如，undernutrition，比如 underage drinking……
读到 “underage drinking”（未成年人饮酒）的那一瞬间，我突然想到，实际上，我可以不用 “早恋” 这个词就能把我要说的说明白。其实，中国的父母害怕的并不是所谓的 “早恋”，如若一切发生在思维之中，他们很可能其实是并不关心的，就算因 “早恋” 发生了行动，拉拉手、亲亲嘴，他们也很可能不会太过紧张；然而，他们真的害怕自己的孩子发生 “underage sexual behaviors”……
One of the reasons why many parents want to send their children to separate school is that they are worried about possible underage sexual behaviors.

这里的关键还是在于，过去遇到的问题我记录了下来，所以当某个可能的解决方案出现之时──无论那方案来自多么不可想象的方向──我能够想起那曾经的问题，于是，问题有可能被解决。

### (4) 使用平实的、朴素的、没有修辞的中文

这是最重要的建议：在记录自己所要表达的内容之时，要尽量避免任何修辞。因为大多数情况下，修辞是几乎无法翻译的。

每种语言，都有自己特定的修辞方式。比如，在中文中，我们可以说 “他蠢得跟猪似的……” 可是，如果你用英文说 “He is as stupid as a pig…” 对方很可能完全不明白你在说什么。

因为，猪，在他们的文化里，很可能象征着下流、龌龊、但并不一定象征着愚蠢。甚至可能恰恰相反，他们知道猪是智商相对较高的动物──即便在寓言故事中，也常常有这样的描述：Animal Farm 里，就是因为猪是最聪明的，所以是它们领导了起义。我们的文化之所以常常认为猪愚蠢，大抵上是因为《西游记》这部经典小说罢，八戒毁了猪的 “世代英明”。

成语、俗语也常常是难以翻译，甚至无法翻译的。过去我在一位学生的本子上看到这样一句话：

> 即便一个人西装革履，也不见得他一定行为端正。

这里的成语 “西装革履”，是根本没办法用英文说出来的。“革履” 倒也好办，其实就是 “皮鞋”，大不了就是 “鞋”──shoes。可是， 在英文中是没有 “西装” 这个词的──这是中国人的词汇：我们看到西方人穿的衣服跟我们的不一样，于是把他们穿的那种衣服成为 “西装”。在英语中，也许还真的有一个 vocabulary counterpart（对应词汇）──“唐装”（tang suit 或者 han suit）。

用平实的朴素的中文表达大抵上是这样的：

> 即便一个人穿得再好，也不见得他一定行为端正。

既然这句话已经如此朴素，用另外一种语言表达，其实是非常容易的：

> Even if one is well suited, that doesn’t necessarily mean he is decent.

比如，“孔子曰……” 里面的这个 “曰” 字，很难在英文中找到完全的对应，“曰” 和 “say” 是很不一样的。“曰” 的意思是，这话是古人说的，并且，常常还是著名的古人说的，如果是古人说的，却不指明是哪一个古人说的，我们往往不用 “曰” 这个字，而是用 “云”，例如，“古人有云……”

所以，平实的、朴素的、没有修辞的说法不是 “孔子曰” 或者 “孔子云”，而是 “孔子曾经说过……” 这里面的 “过” 字，还在清楚地提醒你应该用 say 的过去式 said……

再比如，“北京的三月，乍暖还寒……” 这种依赖中文本身的韵律（仄仄平平）的诗意表达，无论如何都不可能在翻译成英文过后还保留原来的意味。

其实，这个简单的原则──使用平实的、朴素的、没有修辞的中文记录思想──在写作中也特别实用。很多人觉得英文写作困难，可实际上，那困难是自己给自己设置的，因为他们在表达思想的时候，不小心依赖了太多母语的修辞，乃至于，几乎不大可能用另外一种语言表达那些充满了修辞的思维。

很小的时候，语文课本里有一篇文章，是阿尔封斯・都德先生的《最后一课》。其中提到 “当一个民族沦为奴隶时，只要它好好地保存着自己的语言，就好像掌握了打开监狱的钥匙”──这是没办法不同意的；然而，当他提到 “法语是世界上最美丽、最清晰、最严谨的语言” 的时候，我问老师，“那中文呢？” 结果被老师一顿批评，说我上课捣乱……

事实上，每种语言都有其独特、美丽、严谨之处，在那些特定的点上，甚至可能是任何其他语言都无法替代的。然而，这并不意味着仅仅因为在那些方面无可替代，那种语言就高于其他一切语言。这是简单明了的道理，却被很多人有意忽视。观察一下身边，总是有无数的人以 “中文是无可替代的” 来作为 “懒得用英文” 的借口，乍一眼望过去，好像有点道理，甚至难以反驳，可事实真的如此吗？

### (5) 不是应该用英语思维吗？

有些学生刚开始 “打造自己的口语书” 的时候很兴奋，没多久就会产生一个疑问，“我天天这样翻译，这是不对的吧？难道我以后一直得靠这种翻译吗？不是说应该做到能用英语思维么？”

其实，谁也不需要这样翻译一辈子。事实上，在实际操作过程中，读者会发现，大多数句子基本上 “一一对应即可表达完毕的”，比如 “咖啡，想要温的还是凉的？” 这种句子，对大多数人来讲，并不需要额外的辛苦，直接说就是了：“Coffee, warm or cold?” 而剩下少数需要通过积累获得的，实际上也不可能在三五年之后依然处于不够用的状态。

倒是那个 “要用英语思维” 的说法值得着重批判一下。

一直以来，有很多英语教师向学生灌输 “最好/一定要用英语思维” 的观念。姑且不论宣扬这么做的老师究竟有没有做到，显而易见，这是学生不可能做到的事情。如果 “用英语思维” 果真像这些英语教师所宣扬的那样，这倒无可厚非；可是，如果 “用英语思维” 干脆就是个虚无的概念，或者就算存在也完全可以用其他更合理的方式去解释或达成的话，那么，这些教师的做法除非是出于无知尚可原谅，若是仅仅为了唬住学生，那就罪大恶极了。

> 历史上有很多已经被证明为虚无而最终消亡的概念。比如，17世纪前后，有个概念叫“燃素”（Phlogiston）。那时候，人们认为某种物体能够燃烧，一定是因为它含有一种叫做“燃素”的东西──因为那时候人们还不理解氧气的作用。后来科学证明“燃素”根本不存在，于是，这个概念就基本上消失了，现在，除了讲述科学史的文章之外，基本上不大可能提到这个概念。更有趣的是，心理学家迄今为止还做不到清楚地解释为什么人类那么需要一些干脆就是凭空捏造且无实际必要的概念——比如，上帝、魔鬼、处女膜，以及各种各样的主义……诸如此类。

某种意义上来看，英语教师口中的所谓 “英语思维”（抑或什么 “英式思维”、“美式思维” 之类的说法），就好像是英语老师手里的金箍棒 —— 可大、可小、可长、可短，大可以砸人，小可以遮羞；而它又好像是只有唐僧会念的紧箍咒 —— 没有人能搞懂那究竟是什么东西，反正只有他会念，并且只要他一念听到的人头晕脑胀疼得恨不能满地打滚。

姑且先不说 “一定要用英语思维” 这样的建议是否真的对学生有益，只提一个疑问：“人类真的必须使用语言才能思考么？”

这个问题的答案很重要。因为，诸如 “英语思维” 之类的所有概念（包括 “英式思维”、“美式思维”、“中式思维”、“母语思维”、“外语思维” 等）都建立在一个重要的前提之上，即，语言是人类思考的必须。

而如若人类思考之时并非一定要依赖语言的话，那么，所有这些概念都是凭空捏造的没有实际意义的概念。而我们很容易证明这个重要的前提显然非真：
人类思考从来就不仅仅依赖语言。没有语言文字的时候，人类已经存活（至少）几百万年。人类有了语言之后的很长一个时期里（比人类进入文明之后迄今为止的时间段长不知道多少倍）是没有文字存在的，即便如此，人类依然无时不刻在思考、在判断。即便在连语言都没有的时期里，人类就已经凭借他们的思考能力做出了使得本身可以生存发展的许多判断，与此同时，他们运用同样的思考能力获得了更多的技能，比如运用火，等等。

既然那个重要的前提非真，那么 “英语思维” 之类的概念就是虚无的，至少是 “靠不住的”，因为我们大多数情况下并不使用语言进行思维。更多的时候，我们是在思考有某种特定的语言如何表达思维结果，而非依赖语言去得到思维结果。

有一篇重要的论文请读者参考阅读：[Absurdity of ‘Thinking in Language’](http://www.dwillard.org/articles/artview.asp?artID=11) (1972)

作为老师，给学生一个 “凭空捏造且无实际意义的概念” 是不厚道的。尤其当很多学生不由自主地把老师给出的这个概念作为自己的追求的时候。这样的学生注定要以失败作为结局 —— 因为根本不存在，所以肯定追求不到。要知道那些凭空捏造且无实际意义的概念在真实世界里依然可以发挥巨大作用 —— 当然通常是负面作用，最终只能归结为 “幻觉”、“扭曲”，抑或 “自我催眠”，反正没一个是能有好下场的。

其实，用通俗易懂，且又合情合理的方式说的话，第二语言使用者真正能做到的是通过大量练习之前提到过的 “换一种表达方式”──注意，不是所谓的 “把中文思维换成英文思维”，而只不过是 “换一种方式表达同样的内容” 而已。这其中的差异，多半是语法习惯上的，并不细微，却总是被有意忽视。所幸的是，总是有一些人能够明白过来，悄悄地绕过了所谓 “不可逾越的鸿沟”。

### (6) 理解、表达与翻译之间的微妙差异

很多人读不懂一个句子的时候，提问的方法是：“这句话（应该）怎么翻译啊？”

之前的文章里，我反复提到一个现象：

> 我们所使用的语言限制我们的思维。

这个错误的提问，无形之间给很多英语学习者造成了非常严重而又看不见摸不着的障碍（读者现在应该已经理解：每个人都不仅仅应该是 “学习者”，而是一上来就应该是 “使用者” ）。

首先，翻译并不是大多数人学习外语的目的。大多数人学习外语的目的是使用外语，而 “翻译”，只不过是外语的众多用处之一而已。但是，“这句话怎么翻译？” 这个问法，却无形之中把这只不过是 “之一” 的用处变成了全部，正是所谓的本末倒置。

其次，翻译起码可以分为两种，直译和意译。其实大多数情况下，这样提问的人并没有意识到自己问的实际上是 “这句话怎么直译？” 可事实上，很多时候，哪怕很多看起来非常简单的句子都很难直译，甚至没办法直译。于是，这种提问很可能遇到的答案是 “我也不知道……” 问的人并没清醒地意识到自己其实问错了，或者起码问得不够准确，回答的人根本不知道自己给的并不是恰当的答案 —— 尽管是大实话一句。

比如这句话，就挺难直译的：

> We noticed that sometimes we were tempted to **locate** the morality of an act **in** the consequences, in the results, in the state of the world that it brought about.

学生的提问是这样的：
> 这句里*locate the morality of an act in the consequences*, 怎么翻译比较好? 谢谢.

其实，对英语学习者（将来的英语使用者）更为重要的是 “理解”，而非 “翻译”。就算是有时需要翻译才能理解，那么需要的往往更多是 “意译”，而非 “直译”。“locate the morality of an act in the consequences”，意译的话，相当于 “以结果判断一个行为的道德”。

任意两种语言之间（并不仅限于英文和中文之间），不大可能处处都存在着一一对应关系。我们经常会遇到找不到对应中文的英文概念（比如，*serendipity*），或者中文的某个概念在英文中很难找到对应（比如，大队长）。这时，我们甚至无法借助 “意译”，只能借助更为繁杂的诸如详细解释、重新定义，或者创造新词等手段……

所以，当遇到一个不能理解的句子之时，最正确的提问方法可能是这样：“这句话应该怎么理解呢？” 或者 “这句话到底是什么意思？”

尽管表面上来看这样提问和 “这句话怎么翻译？” 区别不大，但实际上却有着天壤之别。首先自己清楚地知道发问的目的究竟是什么（理解句子），其次，被问的人也清楚地知道自己该如何答才能让提问者弄明白。只有这样，才是有效的沟通。

同样的道理，当我们需要表达之时，我们要判断一个可能性：我们要说的这个内容，能否被 “直译” 成英文──或 “能否用英语直接表达”。如若不能，需要做的事情不是问别人 “这句话怎么翻译成英文啊？”，而是 “要靠自己换一种方式把同样的思想表达出来”，正如之前所讲解的那样。

所以，我建议，向别人提问的时候，为了能够得到有效的回复，请尽量回避 “翻译” 这个词。

### (7) 着重收集 “不直观的对应”

掌握另外一种语言（外语），真正的难点在于掌握它与已习得语言（母语）的不重合之处。直观的一一对应，其实没什么难度：“苹果”，对应着 “apple”；“那是一本书” 对应着 “That’s a book”；“这是什么？” 对应着 “What’s this?”（尽管这里已经稍微有一点词序上的不对应，不过很容易适应，也因此很难察觉）……

而所谓的 “不地道”，其实不过用母语的表达习惯去说外语。比如：

* 如果我没记错的话……
* 我从未想过……
* 你竟然跟我这么说话！
* 就知道你有这本事！
* (这)听着耳熟吧？
* 我想不起来那名字了……

这些句子，基本上都是我们日常生活中必然用到的句子（或片段），可是，如果 “直译” 的话，就很别扭：

* If I didn’t remembered wrong…
* I never thought of/that…
* How dare you talking to me like this!
* I know you have such a capability!
* Does it sound familiar?
* I cannot remember that name…

同样的语境里，“地道” 的说法是这样的：

* If my memory serves, …
* It never occurred to me that…
* Are we really having this conversation?
* Always knew you had it in you!
* Does it ring a bell to you?
* That name escapes me….

至于 “觉得某中英对应不够直观”，这是因人而异的事情，所以，这种收集工作，只能靠自己。别人整理的东西，拿来对自己基本上没有太多作用（比不过人们总是 “觉得” 或者 “希望” 拿来的东西有用而已）。在这方面，不能相信或者依赖 “拿来主义”，一定要自己动手，自己积累。

之前，批评过含混的 “要用英语思维” 的说法。事实上，那些主张 “要用英语思维” 的人，出发点也是体会到这种 “不直观对应” 的重要性。只不过，他们开的方子错了 —— 这就好像把有多种致炎症原可能的 “炎症” 简单解释为是 “上火”，而 “火” 究竟是什么，又根本说不清楚。

现在 “不地道” 的根源知道了，就知道 “百分之百地道” 为什么那么难了 —— 所有需要靠积累才能获得的东西都很难，只因为大多数人并不真正了解积累的重要与意义。知易行难。这也是为什么我要用《把时间当作朋友》 一整本书的篇幅告诉读者 “一切都靠积累” 的根本原因。

没必要从一开始追求 “百分之百地道”，因为那也不可能做到。但，知道了积累的重要，知道了只能靠积累，于是，就可以不急不燥地通过积累一点点变得 “更加地道”。哪怕日拱一卒，也是很强大的做法。

从具体做法上来看，收集这类 “不直观对应” 的方法很简单。最朴素的方法就是随身携带个小本子，随遇随记。花哨一点的话，就利用现在已经极为普遍的便携电子设备（管它是手机还是 iPad 之类的东西)，随时进行记录。对于使用最多的设备是计算机（台式机或笔记本）的人来说，可能建一个专用的 Excel 表格是最方便的解决方案：表格只有两栏：中文、English，然后随时增补。

### (8) 长篇大论更要提前写出来

市面上的大多口语书，最大的局限在于他们基本上只局限于 “只言片语”，而不是完整的语篇 —— 完整的语篇，总是被归结到 “高级口语” 部分。事实并非如此，即便一个思维简单小孩子，在使用语言的时候，也常常表达他完整的思想，即，只言片语肯定是不够的。

所以，无论你想说什么，都最好提前写下来。当然，熟练到一定程度的时候，大多数情况下只需要在脑子里演练一遍就可以了。不过，这个 “熟练到一定程度” 可能需要很长时间才能做到。在做到它之前，就别嫌麻烦：写出来！

在这一点上，我非常同意钟道隆先生的见解：“我发现我说不出没准备过的话”。谁不是这样呢？哪怕是用母语，不也是要准备好才能说清楚说明白的么？所谓的 “祸从口出”，不也是因为在说之前没想明白、没想清楚才导致的么？（当然，另外一个原因是 “因言获罪” 之恶法的存在。）

我个人的每一场演讲，都要提前做准备 —— 哪怕是已经讲过很多遍的内容。只要哪一次未提前做足功课，就必然出点这样那样的差错，无一例外。

所以，哪怕是讲一个笑话都最好提前写出来，然后自己先演练一下。事实上，每个善于讲笑话的都是这么做的 —— 而大多数人只看到那些善于讲笑话的人最终举重若轻，于是就觉得那是天分，自愧不如。平日里，身边总是有一些人（其实是大部分人），无论多好的笑话都能被他们讲臭；为什么？因为没准备过么！为什么一辈子都没改善？因为他们把自己做不好的原因归结为 “没天分” 而不是 “没充分准备”，所以，从未了解提前准备的重要，也因此做任何事情从来都只靠 “临场发挥” —— 殊不知，“临场发挥” 是那些提前充分准备的人才可能有的能力。

曾经一度，我很自卑。因为总是觉得自己使吃奶的劲却也不如别人随随便便做得好。所幸的是，我自己在某些方面也会被别人觉得 “很轻松就做得很好”。反观这些方面，我就明白都是一样的：你努力的时候别人看不到而已。你做得不好的时候，也不会有人关注你。等你做好了，他们只看到了结果。东北土话里有这么一句：“光看见贼吃肉，没看见贼挨打”，是一样的道理，很形象。
再后来，听了钟道隆先生一段话：

> 有的人只看到我现在的英语水平比较高这个结果，不了解这个结果是通过怎样的艰苦努力才达到的。于是很容易认为我聪明，记忆力特别好，所以学会了英语。其实记忆力不是天生的，而是后天锻炼得到的一种能力。关于我是怎样通过刻苦努力才学会英语的，我可以举出三个人的话来说明这一点。一位是我在沈阳工作时的领导，看到我废寝忘食日复一日地苦学英语，对我说：“像你这样学，是要感动上帝的”。另一位是中国电子设备系统工程公司的一位工作人员，她每天上班路过我办公室时总是看到我在听写，很有感触他说：“我没有见过一个像你这样用功学英语的人”。最后一位就是我的妻子，看见我一有空就学英语，录音机哇啦哇啦地响个不停，说：“你怎么这么笨，学了这么长的时间还学不会？”其实别人说我聪明不是一件很光彩的事吗？为什么我不顺着说下去：“是呀！对我来说学习英语是一件很容易的事，有空的时候听听录音带，写一写，不知不觉就学会了”，从而使别人更认为自己确实是够聪明的呢？因为事实不是那么一回事。有一位看了我《慢速英语入门》初槁的人对我说：“你不应该把自学英语的实际困难如实地写出来，而应该把它说得容易一些，这样读者才有信心来学”。我没有采纳他的意见，因为知识的问题是一个科学的问题，来不得半点虚假。我要如实地把自学的困难说够，以便使读者有充分的思想准备。

于是释然。都是这样的。哪里有什么容易的事情？

直到今天，我自己也没做到可以用英语随时随地随心所欲出口成章，我想我也做不到。我依然是 “只能说、只会说自己准备过的话”。然而对于这一点，我已经没有了任何困惑。而对我来说（我相信对大多数人来说也是如此），这已经足够。

## 5. 没有外教行不行？

综上所述，我说主张的口语习得方法不过是 “把自己想说的先写下来，然后不断练、不断改” 而已。可是，我知道人们是害怕写东西的（哪怕是母语）。不愿意写的理由很多，也有听起来极端有理有力的依据。

这些年来我教得最多的是留学考试作文部分。留学考试教学中最难教的可能是作文（事实上连母语语文教学中，最难教的也是作文罢？），因为作文最可能是学生不由自主练得最少（甚至干脆不练）的部分。哪怕教的再好，学生不练，老师就起不了作用；更何况绝大多数作文老师所讲授的又基本上都是名副其实的 “陈词滥调”（万能模板、豪华句型、高级词汇……）。为什么学生不写作文呢？因为作文确实很难写。事实上，大多数人在学校里连母语作文都是尽量回避的。为什么写作文那么难呢？因为写作能力更依赖于实践，没练过怎么可能提高？那为什么大多数人都不练呢？懒呗。可是，准备英语考试的时候，人们往往把懒惰包装得非常华丽、异常合理。他们说 “我写完作文都没有人批改，怎么进步么！” 他们觉得自己的这个想法太合理了，甚至开始幻想 “要是有个老外帮我改改作文就好了……”

问题就在这里了。

希望自己的作文有个老外来批改，这对中国境内 99.99%的英语学习者来说是不现实的。中国人口太多，就算是把所有美国人都请来，也显然不够用。把加拿大所有人口都拉到中国，一个上海市就不够用了（加拿大人口仅相当于上海市人口 —— 两千多万）。再说，把老外请来就可以了么？不一定吧？不是每个老外都识字的、不是每个识字的老外词汇量都足够大的、不是每个词汇量足够大的老外都有文化的（拥有足够的知识储备和思考能力）。事实上，在中国境内的所谓外教，（我猜）很可能半数以上只不过是徒有虚表而已，他们没有足够的知识储备，没有足够的思考能力，没有足够的学术训练，让他们写个托福作文或者 SAT、GRE 作文能得满分的概率实际上很低。这些外教中的绝大多数在美国当初也没能力考进好大学（当然更不见得将来能够考上研究生或者有能力攻读博士学位）…… 对正在准备 TOEFL/SAT/GRE 的中国学生来说，这些外教之中有多少可以算作是合格的呢？

更进一步，就算有一些确实合格又怎么样呢？数量那么少（肯定是极少数），你我这样的普通人有多大的概率能得到他们的帮助呢？而如果我们真的有机会遇到这样足够合格的外教，我们是否真的能够付得起费用呢（让这样的人免费干活是不是太过分了）？就算我们遇到了且又支付得起费用，我们自己当时的水平是否足以配得上那么昂贵且又珍贵的帮助呢？

但是还有更为严重的问题。批改真的有用么？

还记得小时候写作文么？你现在回头认真想想，你真的觉得那些年里低年级语文老师为你所做的批改对你的写作能力锤炼有什么无比重要不可替代的作用么？一个可能令人不快的事实是，对大多数人来讲，学校里低年级语文老师的批改只给自己带来了屈辱而已。那你的作文能力是怎么提高的（如果你真的有作文能力的话）？我并非有意贬低所有低年级语文老师，我只是在说事儿 —— 绝大多数最终拥有良好写作能力的人基本上都是靠自己，多读、多写、多改、多练、多观察、多思考、多讨论、多积累 …… 而这些要多做的事情中几乎没有哪一样是哪一个老师能在其中起主导作用的，几乎全都是（只能）靠自己。这也解释了为什么总有人奇怪 “都是人，咋就差异那么大呢？” —— 有什么好奇怪的？有些人一辈子什么都 “多” 做，有些人一辈子什么都做得不 “多”，甚至干脆不做。

现在回头一看，就知道很多人不练英文作文的原因本质上来讲只不过是因为他们不切实际的幻想没有得到满足而已。只因不切实际的幻想不能得到满足（实际上是必然得不到满足）就放弃原本靠自己就行的机会，这不是愚蠢是什么？

有两个方法更为有效：
1. 自己给自己改作文；
2. 帮别人改作文。

自己给自己批改作文，有个很重要的诀窍：不要写完马上改，而是隔天再修改。你当时那么写（即便是错的）就是因为你认为那么写是对的。这种惯性在刚写完的时候最大，表现最强。所以，写完之后马上修改很可能事倍功半。隔一天就不一样了，很多错误在你眼里几乎是跳出来的，并伴随着惊讶 “哎呀！我怎么会犯这种低级错误呢？！” 相信我，这其实就是你真正进步的痕迹──因为产生深刻记忆的最有效手段无非两种：重复、惊讶。

帮别人改作文是提高自己能力的最快手段之一。也许你会说，“我自己都不会呢，哪儿有能力帮别人改啊？” 这不是问题，你试试就知道了，挑错比写文章容易多了，尤其是别人的错，更容易被你找出来。有趣的现象在于，批改者往往比被批改者收获更多。因为，你作为一个个体，无法遍历所有可能的错误──有些错误你现在不犯，并不意味着说将来不会犯。而帮别人修改作文的时候，等于别人在帮你试错，你在坐享其成──并且，更多的时候，你已经做到了 “防患于未然”。

## 6. 自我检查列表

写出来的东西，可以参照以下列表进行自我批改。这个列表很重要，因为他罗列了几乎所有人最常犯的错误：

* 单词拼写错误：未按照单词的正确拼写方式书写单词，但不包括由于英式英语和美式英语差异所带来的单词拼写差异。
* 名词单复数形式错误：错误地使用了名词的数，包括：使用了不可数名词的 “复数” 形式，使用了集合名词的 “复数” 形式，在应该使用复数的地方使用了单数名词（或反之）等。
* 单数可数名词未受限定：句子中出现的单数可数名词之前没有使用限定词，包括冠词、不定代词、指示代词、名词或代词所有格、数词与某些形容词性的物主代词。
* 词性错误：在选择词汇的过程中忽略了英文词性的特性，仅按照含义来使用词汇，从而发生了词性使用错误的现象。
* 修饰关系错误：违反了词汇修饰的规则，采用了不恰当的修饰关系。包括用形容词修饰动词、形容词修饰形容词，副词修饰名词等。
* 搭配错误：句子中出现了不合适的词汇修饰、限制、说明现象，或者错误地使用了固有的词汇搭配形式。
* 词序错误：未使用正确的、符合习惯的表述语序来对内容进行陈述。其中包括修饰词顺序错误，该倒装时没有倒装等。
* 非谓语动词使用错误：错误地使用了现在分词、过去分词、或动词的不定式。其中包括：
* 现在分词和过去分词误用：作者没有保证逻辑主语与分词的一致性，即当逻辑主语发出动作时使用了过去分词，而在承受动作或状态时使用了现在分词。
* 不定式与动名词误用：动名词表达的是 “状态，性质，心境，抽象，经常性，已发生的”；不定式表达的是 “目的，结果，原因，具体，一次性，将发生的”。
* 介词误用：错误地使用了介词。
* 连词误用：错误地使用了连词。
* 关系代词误用：在定语从句中错误地使用了关系代词。
* 冠词误用：没有分清楚定冠词和不定冠词的区别，或对两个不定冠词的用法不清楚而错误的使用了冠词。
* 代词误用或指代不明：作者使用的代词的数或者性与名词不匹配，或者读者无法直接判断作者使用的代词所指代的对象。
* 句子不完整：句子中某成分，尤其是构成句子的主干成分残缺。
* 主谓不一致：句子的主语和谓语在 “数” 上不满足一致关系。
* 违反主句专一原则：当一个句子由多个分句组成非简单句时，作者没有确保有且仅有一个主句，即所有从句必须有连词、关系代词或者分号等引导或隔离，但必须保证有唯一的主句。犯此类错误的句子叫做 “流水句（run-on sentences）” 或 “逗号拼凑句（comma splice）”。
* 比较句错误：包括作者在比较句中的比较主体不一致，即在一个比较句中，作者所引入的两个比较对象不具备同样的本质和属性，即 “不可比”，或比较级使用错误等。
* 并列主体不一致：在并列成分中，作者没有做到并列双方在结构、功能、性质方面完全对等。
* 时态错误：句子谓语动词所使用的时态与句子所在的上下文环境不一致。
* 语态错误：句子谓语动词所使用的语态（主动/被动）与主语不一致。
* 语气错误：句子没有根据上下文采用正确的实语气或虚拟语气。

事实上，在实际操作过程中，绝大多数中国学生所犯的错误大部分是两种错误，单复数问题，以及时态问题 —— 因为中文的名词是不分单复数的，中文的动词是没有时态的。这两个错误剔除掉之后，相当于解决了大多数的问题。

除了这两个问题之外，所需要注意的是 “一致关系”：主谓一致、主句从句时态一致、非谓语动词与逻辑主语主动被动关系一致、代词指代一致、并列成分结构一致…… “一致关系” 非常重要，即便是以英语为母语的人，也常常犯此类错误（SAT 语法考试中考点几乎只有一个，就是 “一致关系”）。避免错误的另外一个重要手段就是勤查参考书，而这无论对谁都是一样的 —— 词典和语法书。而参考书的具体用法，后面的章节中将有详细论述。

## 7. 更重要的是思考能力

语言最终是用来表达思想的。所以，思考方式格外重要。大多数人不懂得如何正确思考，乃至于所要表达的东西漏洞百出却又不自知。这个问题导致的更多麻烦，很多的时候被一些英语老师归咎于 “东西方文化差异”，这是和稀泥的一种说法 —— 事实上，这跟文化没多大关系，而是思考能力问题。关于文化差异，首先需要的是尊重，其次需要的是理解。而思考能力差异，则是另外一回事，所表达的内容千疮百孔，无论如何都只能怪思考能力差，而与文化差异毫无关系。

不能 “只学英语”，这就好像用计算机绘图，只学 “Photoshop” 是不够的，要有足够的色彩、手绘基本训练，才能够自由创作一样。有几本书，建议所有想获得正确思考能力，进而表达清晰的人阅读。

* Thought and Knowledge: An Introduction to Critical Thinking 4th edition, by Diane F. Halpern
* Thinking and Deciding, 4th edition, by Jonathan Baron
* Argumentation: The Study of Effective Reasoning by Zarefsky David (Audiobook)
* Craft of Research, by Wayne C. Booth, Gregory G. Colomb, Joseph M. Williams
* Good Reasoning Matters!: A Constructive Approach to Critical Thinking 3rd edition, by Leo A. Groarke, Christopher W. Tindale

另外，还有三本关于文风（Style）的书籍也一定要看：

* A Plain English Handbook (1998), from Security and Exchange Commission, Prefaced by Warren E. Buffett (http://www.plainlanguage.gov)
* On Writing: A Memoir of The Craft by Stephen King (with audiobook)
Style: Toward Clarity and Grace by Joseph M. Williams

另外，还有一个 TTC (The Teaching Company)的视频教程，是我所见过最好的写作课程：

* Building Great Sentences。

## 8 秘密武器 —— 复述

几乎所有真正有效的学习手段都是简单、廉价、往往并不直接但却真正有效的。复述，就是这样的有效手段。

每个文化中的每个人在这方面都一样 —— 终其一生绝大多数情况下都在复述别人说过的话。首先语言文字很难纯粹 “原创”，其次绝大多数情况下确实也没有必要 “独一无二”。更为重要的是，第二语言学习者的目标绝大多数情况下不是为了从事诗人、小说家之类的职业，而是希望多掌握一门用来承载信息沟通交流的工具 —— 这种情况下 “复述” 几乎占据了第二语言应用的全部。

这还真的并不是那么 “显而易见” 的事实。ETS 在设计并举办 TOEFL 考试几十年之后才 “恍然大悟” 地在新托福考试中大面积添加了 “复述能力” 的考量：TOEFL 作文部分中有综合测试，要求考生先读一篇文章，然后再听一篇与刚刚读过的文章相关的讲座，而后复述讲座内容以及讲座内容是如何与阅读文章内容相联系的；口语部分中有先听再说，先读再说，听与读之后再说 —— 无一不是在考量考生的 “复述能力”。

## 9. 貌似多余：其实连哑巴英语都并不那么坏

在相当长一段时间里，我的英语正是很多人所不齿的 “哑巴英语”。可连这个都没有成为我使用英语障碍或者负担。我不觉得哑巴英语有什么可怕和奇怪的。我们学习任何一种外语都无外乎希望熟练掌握它的听说读写。然而，对每一个挣扎已久的人来说，听说读写齐头并进并不像当初想象得那么容易 —— 这一点早已有自己的（和无数他人的）经验作为证明。

说得形象点，说不出像哑巴，听不懂像聋子，读不懂像瞎子；而写不出呢？——大多数文化并不默认一个人写不了字是一种残疾。先不管能否写得出，只谈哑巴、聋子和瞎子。如果你必须成为这三种 “残疾” 中的一种，你会选哪个？我认真想过，我会选 “聋子” —— 因为不瞎不哑，起码还保留了输入和输出的渠道。我最怕成为 “瞎子” —— 因为那是最重要的输入手段，尤其是因为文字输入几乎占所有有效输入的绝大部分。某种意义上来说，学习一门外语最大的公用莫过于增加一个不一样的信息获得渠道。从这一点上来看，哑巴比聋子、瞎子强多了，而后两者之中，瞎子又远不如聋子。

退一万步且又尽量保持现实的话，我们就会发现大多数人真的没有什么机会跟外国人聊天、热烈讨论、激烈争辩的机会。更多的时候，我们只需要 “熟练阅读” 就可以。某种意义上来说，我们只需要 “基本视力” —— 相当于拥有基本的词汇量、语法常识就行 —— 就好像高度近视者配上眼镜就比瞎子强千百倍一样，任何人只需要配上词典和语法书就相当于拥有正常视力。

既然学了，用得越好越开心，这是每个人的正常心理。但所谓的 “英语好” 其实很难有一个统一、清楚、且有意义的标准。既然如此，就不要在意它了，好不好又怎样呢？反正得用。用着用着就好起来了，管它好到什么地步，反正比原来好。或者换另外一个角度来说，“够用就好”。因为 “够用” 就可以开始用了，不停地用就有不停改进的机会和可能。

我自己的英语发音尽管在不停地改善但从未标准过，甚至就没有 “好” 过，顶多是处于 “可接受” 之状态。我的词汇量也从未没大到惊人的程度，别看 TOEFL、GRE 的成绩已经非常 “变态”（那也是因职业需要考了无数回而后才达到的水平），但平日里细读英文文献的时候还是经常需要借助各式各样的电子辞典和在线检索工具。在写英文文章的时候，推敲和审阅所耗费的精力是写中文文章的若干倍，在只能用英语交流的场合出现之前一定要花费大量的时间精力去做功课，事实证明否则一定会出各种各样的差错。

事实上，我自己的英语从来就没有 “好” 过 —— 尽管我已经在留学考试培训行业里工作将近十年，期间学生无数，其中每年都有许多留学考试高分甚至满分得主，每年为上千名高中生做留学申请文书辅导，最近几年开始又每年至少去美国两次与各个高校的 AO（相当于国内大学的留学生招生办主任）交流……

但 “不好” 的这个状态从未成为我使用英语的障碍或者负担。外语用得不好是正常的 —— 无论对谁来讲都是如此。但用的不好并不意味着说 “不能用” 或者 “不该用”。换个角度来说，恰恰是因为用得不好才应该多用勤用。多用一点就比原来用得更好一点 —— 这其实就是所有工具的特点。

| [< 第一章: 起点](./chapter1.md) | [第三章: 语音 >](./chapter3.md) |
| ------------------------------- | ------------------------------- |

