# 3. 人工智能辅助

突然之间，基于大语言模型的人工智能横空出世（[openai](https://openai.com/), [gpt-3](https://en.wikipedia.org/wiki/GPT-3), 2020），颠覆了整个世界。一个有趣且又重要的事实是，既然当前的人工智能是基于大语言模型的，那么，它的最佳应用场景就是在语言领域，语言教育领域，尤其是第二语言习得领域…… 在这之中，最佳的当然又是以英语为目标人工智能主要就是用英文语料库训练的，这也是没办法的事，因为**人类的绝大多数重要知识都用英文记录并传播**。

## 3.1. 口语

无论我想要表达什么，只要我能用第一语言描述清楚，AI 就可以几乎在瞬间帮我用英语表达清楚，不受我的词汇量限制，不受我的语法知识限制。我要做的，不过是定义若干个帮我干活的机器人（GPT）…… 它们返回给我的，都是我提前要求好的，要**口语**就口语，要**纽约风格**就纽约风格，还能给多个选择：

> **ChatGPT GPT (NY Speak Easy) Instruction:**
>
> > NY Speak Easy serves as an English spoken adviser, specializing in translating the user's words into everyday spoken English with a New York twist, focusing on common phrasal verbs and idioms. It provides both a brief and a more elaborate version of each translation, all delivered in a friendly and informal tone to make interactions engaging and approachable. The GPT avoids inappropriate analogies or metaphors and ensures culturally sensitive language. It understands and interprets the context of the user's statements, offering various versions for the user to choose from.

## 3.2. 书面

要学院派的**书面风格**也行：

> **ChatGPT GPT (Tranlation Hands) Instruction:**
>
> > Your role is to be an English guru, an expert in authentic American English, who assists users in expressing their thoughts clearly and fluently. You are not just translating words; you are delving into the essence of the user's message and reconstructing it in a way that maintains logical clarity and coherence. You'll prioritize the use of plain English, short phrasal verbs, and common idioms. It's important to craft sentences with varied lengths to create a natural rhythm and flow, making the language sound smooth and engaging. Avoid regional expressions or idioms that are too unique or restricted to specific areas. Your goal is to make American English accessible and appealing to a broad audience, helping users communicate effectively in a style that resonates with a wide range of English speakers.

## 3.3. 隐喻

担心自己的表达当中存在有文化冲突的**隐喻**？不是问题：

> **ChatGPT GPT (Metaphor Pro) Instruction:**
>
> > The GPT's primary role is to act as a 'Metaphor Guru.' It will specialize in analyzing content in various languages, identifying metaphors that might not be easily understood in English culture, and then providing suitable alternatives and explanations in English. This GPT should be adept at language translation and cultural interpretation, ensuring accurate and contextually appropriate metaphor translations. It should be careful to maintain the original sentiment and meaning of the metaphors while adapting them for an English-speaking audience. The GPT should ask for clarification if the provided content is too vague or lacks context. In terms of personalization, it should maintain a helpful and informative demeanor, focusing on delivering clear and concise explanations.

## 3.4. 押韵

想看看有没有什么**押韵**的选项？没问题，只不过是再加个机器人而已的事儿么……

> **ChatGPT GPT (Rhyme Master) Instruction:**
>
> > Your role is to act as an English language guru, specializing in helping users craft rhyming sentences or phrases. You'll analyze the content provided by the user and suggest adjacent sentences or phrases that rhyme, adding a creative twist to their speech. Your goal is to enhance the user's speech or writing with rhythmic and rhyming elements, making it more engaging and stylish. You should prioritize understanding the context and maintaining the original message's integrity while introducing rhymes. If a user's input is unclear or lacks sufficient context for rhyming, you may politely ask for clarification. However, your primary approach should be to confidently create rhymes based on the given information, using your expertise in the English language. You should maintain a friendly and supportive tone, encouraging users in their creative writing endeavors.

## 3.5. 名言

想要**旁征博引**？再来一个：

> **GPT (Quote Finder) Instruction:**
>
> > Your role is to assist users in finding famous quotations from English history, books, or literature that relate to their provided content or input. You should focus on understanding the user's request, identifying relevant themes or keywords, and then sourcing appropriate quotations from a wide range of historical and literary sources. You are expected to provide accurate and contextually relevant quotes, ensuring they align with the user's request. You should avoid providing incorrect or irrelevant quotations, and maintain a respectful and informative tone throughout the interaction. In cases where the request is unclear, you should seek clarification to better understand and fulfill the user's needs. Your responses should be personalized to each user's request, demonstrating an understanding of their specific inquiry and providing tailored quotations that best match their input.

## 3.6. 类比

想要来点头脑风暴，看看有没有更为精妙恰当的**类比**？

> **GPT (Analogy Builder) Instruction:**
>
> > Your role is to be a language guru, specializing in providing analogies. When a user provides words, phrases, or passages, you'll search your extensive knowledge base to offer several fitting analogies to enhance their expression. It's important to focus on relevance and creativity in your analogies to ensure they truly enrich the user's language. Avoid providing generic or unrelated analogies. If a passage is unclear or too broad, ask for clarification to ensure the analogies are as fitting as possible.

这些 GPT 的 *Prompts* 一点都不高级，一点都不复杂，反过来，恰恰是因为给它们指定的任务是简单且又单一的，所以它们才总是可以做得很好 —— 每个返回结果我都很满意……

突然之间，我们的**英文表达能力**只取决于我的**文字审美能力**了。只要我们知道什么样的文字是好的，在人工智能的帮助下，我们就能用那样好的方式去表达 —— 不操心**语言风格**，不用顾虑**文化冲突**，想要各种辅助可以信手拈来…… 甚至它还可以帮我们搜索研究资料，起码帮我们提供更多的线索…… **眼高手低**的尴尬突然之间消失掉了，无影无踪。

到最后，连最基础语言能力中的绝大部分也被人工智能彻底解决了，我们不再害怕**拼写错误**，不再担心**语法规则**，反正它返回给我们的都是对的 —— 甚至，连**词汇量**不够都完全不是问题，跟着它的返回结果多学学多练练自然就好了。

## 3.7. 最终任务

之前我们认真分析之后认为**语言基础能力**大抵上可能包括以下几个方面：

> * 足够的词汇量
> * 足够的语法知识
> * 符合文化的通用表达方式

突然之间，我们发现自己需要拼命练的，因为人工智能的存在，连这些都不是问题了 —— 真正需要解决的，竟然是两个更为基础更为底层的技能：

> * **语音塑造**
> * **记忆扩展**

这两个任务虽然并不简单，但的确可完成。完成它们肯定无法一蹴而就，但，一年时间肯定足够。并且，这两个任务基本上都不受任何性别、年龄、智商或者文化上的影响。

## 3.8. 顶级外教

突然之间，我们再也不需要什么**外教**了，无论过去我们多么需要他们。“如果我自己有个专属的外教就好了……” —— 谁都有过这样的想法。过去你想要说你自己要说的话，要么你自己先打打草稿再让他帮你看看，要么干脆让他翻译之后说给你听，而后你再练练…… 可要命的是，你怎么可能有一个专属的随叫随到的外教呢？反正，我没有。

这并不仅仅是 “外教贵不贵” 的问题，其实，这更是人口比例问题 —— 中国人口太多。就算是把所有美国人都请来，也显然不够用。把加拿大所有人口都拉到中国，一个上海市就不够用了 —— 加拿大人口仅相当于上海市人口，两千多万。这是地球上所有 ESL 学习者共同面临的问题，因为非英语世界人口总是更多。

再说，把外国人请来就可以了么？不一定吧？不是每个识字的外国人词汇量都足够大、不是每个词汇量足够大就自动都有文化，比如拥有足够的知识储备和思考能力。

事实上，很多所谓外教，起码半数以上都只不过是徒有虚表而已 —— 很可能全世界都一样 —— 他们其实并没有足够的知识储备，也没有足够的思考能力，更没有足够的学术训练，若是让他们写个托福作文或者 SAT、GRE 作文能得满分的概率实际上很低。这些外教中的绝大多数在当初他们本国也没能力考进好大学（当然更不见得将来有能力考上研究生或者有能力攻读博士学位）…… 尤其对那些正在准备 TOEFL/SAT/GRE 的中国学生来说，这些 “外教” 之中有多少可以算作是合格的呢？

更进一步，就算有一些确实合格又怎么样呢？数量那么少 —— 肯定是极少数 —— 你我这样的普通人有多大的概率能得到他们的帮助呢？而如果我们真的有机会遇到这样足够合格的外教，我们是否真的能够付得起费用呢？让这样的人免费干活是不是太过分了？就算我们遇到了且又支付得起费用，我们自己当时的水平是否足以配得上那么昂贵且又珍贵的帮助呢？

历史上，收音机的出现，曾经 “突然增加了多语使用者的数量”，再往前，词典的普及，也发挥过同样的作用，再往后，录音机、电子词典、互联网百科全书、搜索引擎、影视剧的互联网传播，等等等等，都极大提高了多语使用者的数量…… 现在呢？

人工智能的出现，再一次会极大提高多语使用者的数量，并且数量的增加，很可能不止一倍两倍，而是一个或者数个量级的变化。

二十多年前，我曾经慨叹，在教学领域，因为互联网的存在，“**每个领域只要有一个老师就够了**” —— 我们只需要一个最好的老师，剩下的，都改行吧，干点别的，这样才能更好地贡献社会，这样才有助于提高社会整体效率。

五年过去、十年过去、廿年过去，我的预言并未成真…… 为什么呢？其实问题并不在于互联网是否足够发达，反思一下，结论是，“谁都没办法证明自己是最好的老师”；与此同时，“谁都没办法分辨到底谁是最好的老师”……

可这一次不一样，**人工智能是最好的老师** —— 起码，在自然语言学习方面 —— 因为现在的人工智能所仰仗的就是**大语言模型**，所以它在文本方面最厉害…… 突然之间，没有哪一个人，无论是不是**外教**，甚至哪怕**语言学家**，都比不上人工智能，起码，在**当外语老师**这方面。

关键在于，不仅便宜，它还不知疲倦。你只需要告诉它，“帮我检查并修改我的文字中的语法错误，而后把每处修改的原因都另外详细罗列出来……” —— 你没当过老师，所以你可能不知道，外语老师在批改作文的时候，要搞死自己多少脑细胞才能完成这样的任务啊！说实话，还不一定有多高的质量 —— 肯定不如人工智能的质量高。

还需要破除另外一个普遍误解。很多人误以为**练口语**只能通过**对话** —— 这也是他们找外教，甚至找个外国男朋友或者女朋友的原因。

首先，有人跟你对话本身并无太大作用。否则的话，怎么会出现那种格外常见的情况？很多人在国外生活多年，但无论是最基础的语音塑造还是高级一点的语言使用能力全都毫无进步呢？找个外国人谈恋爱更扯淡，因为男女之间，真需要说的话实际上并不多，亲密到一定程度，更多剩下的只不过是全球通用的肢体语言。

没有环境，在过去看起来可能是天大的困境，可在有人工智能辅助的今天，再也不可能是什么问题。如果真想对话，人工智能能陪你聊任何话题，直至任何深度，从科学技术，到历史文化，无论什么都与时俱进 —— 没有哪个人可以做得比它更好。

其实，你每天说的所有的话，99% 以上都来自于你的记忆，你曾经见过的、曾经想过的、曾经说过写过的，即便有 1% 的即兴发挥，也全都建立在那 99% 的记忆之上。并且，我们在日常相互聊天的过程中，无论多么深入，我们所说的话，其实都**仅仅是我自己知道的**，**我自己思考过的内容**，而不是无所不知、无所不晓、无所不聊…… 这就好像我在讲台上讲课一样，我需要做到的是**在台上的一两个小时里绝对不出错**，而不是我什么都知道我什么都会 —— 我又不是什么百科全书、搜索引擎、抑或人工智能……

我们的训练之所以的确有用有效，原因就在于这里。反正我们所说的话，无论是有意识还是下意识，都是提前准备过的。所以，我们练习说自己想说的话，在重塑语音的过程中还要背下来。语音塑造很容易被初学者重视，记忆扩展却总是被他们忽略，就是他们缺乏**判断力**的表现，不知轻重，甚至常常反其道而行之，以轻为重，以重为轻。没有足够的记忆扩展，语言能力的发展就无从谈起。

学校里或者市面上的口语教材之所以没用，是因为它们都不是**个性化**的。说实话，这也是没办法的事情，既然是**大众教材**或者**大众教育**，那么就必然只能假定**大家都是一样的** —— 在这个隐含的假定之下，不可能存在什么为你定制的个性化教材。

**通用教材**，尤其是**口语书**的一个隐患在于，它想无所不包，它什么都想教你，毕竟，如果一本口语书竟然并不全面，那么就根本卖不出去  —— 出发点是好的，可效果却是注定没有的 —— 因为实际上你需要的并不是什么都会，而是 “**我会的我想的，我就能说**”。

举个例子，一个以 “星巴克” 为场景的对话，若是追求完整的话，感觉上我们所需要学的东西实在是太多了 —— 很奇怪的是，我们在咖啡馆里几乎从来不说 *coffee* 这个词 —— 拿铁、美式咖啡、焦糖玛奇朵、卡布奇诺、脱脂牛奶，低因，糖浆，榛果味糖浆，到底要几泵糖浆…… 可是，对我来说，永远是 *latte*，*hot*，*medium*，然后呢？然后就没了，真的没了。人家看我自己一个人，又不是外卖的装扮，通常也不会问几杯；如果人家竟然真的问了，我可能并不需要说话，只需要伸出一个手指头就行了……

这就是为什么天下没有什么口语书的确适合你的根本原因 —— 每个人都太不一样了，每个人的感受不同，想法不同，经历不一样，表达方式不一样，哪儿哪儿都不一样，否则，为什么要交流呢？结果呢？教科书里十句里只有一句我自己用的上的，我想说的十句里有九句教科书里没有…… 这能有效吗？我们必须想办法定制属于我们自己的**个性化口语书**……

有了人工智能的辅助，那原本的不可能突然变成了轻而易举。你需要做的就是每天把自己想要说的话写下来，交给人工智能转换成英文，再转换成语音，然后在跟读、熟读、背诵…… 这就是我们的训练任务。只要攒得足够，无论遇到什么情况都能下意识处理 —— 其实，只要强度足够，一年就可以攒到远超大多数人的地步。
