# 2. 训练方法

请后续反复认真阅读《[语音塑造](/sounds-of-american-english/0-intro)》中的每一个章节。

## 2.1. 搞清每个单词的读音

在挣扎着**读准**之前，**首先要避免读错**。这只是一个习惯，遇到任何不确定的词汇都要查词典 —— 当然，在有各种辅助工具的情况下（[GPT: Phonetic Transcriber](https://chat.openai.com/g/g-nWwuxUVqO-phonetic-transcriber)），甚至可以整句查询音标。

望文生音非常可怕。我曾经在很多年里把 *facade* 读成 <span class="pho alt">ˈfækeɪd</span> —— 其实是 <span class="pho alt">fəˈsɑːd</span><span class="speak-word-inline" data-audio-us-male="/audios/facade-us-male.mp3" data-audio-us-femail="/audios/facade-us-female.mp3"></span>）；我也曾把 *specific* 读成 <span class="pho alt">ˈspesɪfɪk</span> —— 其实是 <span class="pho alt">spəˈsɪfɪk</span><span class="speak-word-inline" data-audio-us-male="/audios/specific-us-male.mp3" data-audio-us-female="/audios/specific-us-female.mp3"></span>）…… 不妨再猜猜 *plaid* 这个词怎么读？我在很长一段时间里误以为是 <span class="pho alt">pleɪd</span> …… 后来才发现并非如此 —— 其实是 <span class="pho alt">plæd</span> <span class="speak-word-inline" data-audio-us-male="/audios/plaid-us-male.mp3" data-audio-us-female="/audios/plaid-us-female.mp3"></span>。

如果不养成这个习惯，那么读错的单词会越来越多，等于时时刻刻在为自己的牢墙添砖加瓦，到最后再也无法逃脱 —— Github 上有个[常见中国程序员发音错误的单词列表](https://github.com/shimohq/chinese-programmer-wrong-pronunciation)，不妨去看看，当作自己的警钟。

遇到自己不熟悉发音的词汇，要单独反复大声朗读，直至自己的舌头和嘴唇都协调得非常轻松自然。每个人遇到的困难不一样。比如，Instagram 上就有个人[演示](https://www.instagram.com/reel/C1VmSpuIvTO/?igsh=czY3cDAzcGIxMGN4)过自己 *literally* 这个单词死活读不明白的尴尬<span class="speak-word-inline" data-audio-uk="/audios/literally-instagram.mp3"></span> —— 不过，这恰恰就是在自己的大脑里**新建连接新建网络**所要面临的困难，要通过练习克服的就是这个困难，并且还要通过短时间内足量重复把**新连接新网络**强化到**原有近似连接近似网络**无法竞争的地步……

## 2.2. 放慢播放速度仔细听

要慢速听**很多遍**。从 2 大层面总计 7 个方面分别去分析，详情参见《[语音塑造](/sounds-of-american-english/0-intro)》：

> * 韵律节奏
>   * 停顿（[4.2](/sounds-of-american-english/4.3-grouping#_4-2-1-意群)）
>   * 高低（[4.5.4](/sounds-of-american-english/4.5-sentences#_4-5-4-音高变化)）
>   * 起伏（[4.5.5](/sounds-of-american-english/4.5-sentences#_4-5-5-声调变化)）
>   * 轻重（[4.5.3](/sounds-of-american-english/4.5-sentences#_4-5-3-强读式与弱读式的区别)）
>   * 缓急（[4.5.6](/sounds-of-american-english/4.5-sentences#_4-5-6-语速)）
> * 音素变化
>   * 元音（[3.1](/sounds-of-american-english/3.1-vowels)）
>   * 辅音（[3.2](/sounds-of-american-english/3.2-consonants)）

**仔细听**的意思是说，按照以上的顺序，逐条分析，直至每个**音素**都认真分析过、认真体会过、认真尝试过。这一步最需要**注意力集中**，也是整个训练中最关键的部分 —— 这场训练，从另外一个角度来看，实际上都是**注意力训练**。

如果这一点没做到、没做好的话，就会出现 “**明明听到的是一回事，脑子里反应的却是另外一回事**”。

比如，假设过去你一直习惯于把 *recent* <span class="pho alt">ˈrisənt</span> 里的 <span class="pho alt">s</span> 读成了 <span class="pho alt">z</span>，而后在这一步中你并没有做到**仔细听并分析到音素级别**的话…… 那么接下来弄不好无论听多少遍，无论跟读多少遍，你都有可能依然**无法发现**你有一个音竟然读错了 —— 你的大脑会固执地用原有的连接和网络，乃至于自己毫无察觉。如果有人提醒，你会感觉特别奇怪，感觉上那么**明显**的差异，自己怎么就**竟然**一直没注意到？这里有个示例，<span class="speak-word-inline" data-audio-other="/audios/recent-z.mp3"></span>（*recent health tips*）—— 这是某位同学被发现之前完全没有意识到的错误。

在这一步，每个单词都可以跟读一下，通过试验感觉自己的声音，认真找自己需要调整的地方。

在最初尚不熟悉的时候，可以把文本和音标打印出来，在纸上用笔做各种标记。

> * 用 <span class="pho">|</span> 标注**可换气停顿**，用 <span class="pho">·</span> 标注**非换气停顿**；
> * 在**音高**（*pitch*）被拔高的音节上标注一个 <span class="pho">^</span>；
> * 在**重读**的单词可用加重字体作为标注；
> * 需要读长的**元音**在下面或者上面画一段直线；
> * 在必要的重读音节的元音上标注**声调**，<span class="pho">◌̅, ◌́, ◌̀</span>
> * **连读**用 <span class="pho">◌‿◌</span> 符号做出标记
> * 在**读得很快的几个词汇**下画波浪线；
> * 格外需要注意并调整的**音素**，引出一个箭头之后写上各种必要的笔记……

这一步的仔细分析很重要，是后面所有练习步骤的必要前提。请注意，这一步分析，弄上半小时甚至一小时都不过分…… 因为**你不知道的你就注意不到**。

## 2.3. 分段跟读

这和我们练琴特别像。刚开始的时候，人家弹得轻松听着优美，我们自己的手指干脆不听话，笨得跟脚趾似的……

<video controls><source src="/videos/hc-gt-normal.mp4"></source></video>

于是，只能放慢听，放慢速度练……

<video controls><source src="/videos/hc-gt-slow.mp4"></source></video>

 可即便放慢速度了也不行…… 于是，只能一小节一小节地练，练熟了一小节再去练下一小节，两个小节都练熟了之后吧，还得拼起来重复很多遍才能做到两个小节之间衔接自然…… 如此这般，一小节一小节地终于 “**爬**” 完之后，才算有资格可以进行**正式练习**了……

自然语音中有**暂停**（*pause*）的地方，就相当于是乐谱里的小节分界线。分段练习，实在难的小节，还可以继续拆分……

在跟读的时候，有必要**夸张**一点。声音也要正常地**大** —— 确实不用喊，嗓子的确需要保护。实际上，我们主要需要练的是嘴唇、舌头、气流振动的配合，主要练的还真不是声带。

跟读的时候，可以戴着耳机。一个比较好的方法是戴单只耳机 —— 这样，一方面录音听得更清楚，另外一方面也不妨碍听清自己的声音，还可以换着耳朵戴。

上一步中的**音素级分析**，在这一步中开始发挥作用，因为你可以注意到每一个细节。而后的过程，漫长且又难过 —— **短时间内足量重复** —— 要在大脑里创建新连接强化新连接，创建新网络强化新网络，防止旧连接旧网络被启用，防止近似连接近似网络劫持操作…… 时时刻刻感觉到自己的笨拙，苦恼于做不到、做不好 —— **非常难过，但必需忍受**。

不要害怕自己的笨拙。

大家都一样，刚开始的时候就是很吃力，就是很生硬 —— 并且，这种笨拙必然要持续相当长一段时间…… 哪怕感觉上已经熟练，还是需要继续练习的 —— 做什么都一样。

TED 上有一个讲座，Benjamin Zander 讲 [The transformative power of classical music](https://www.ted.com/talks/benjamin_zander_the_transformative_power_of_classical_music/transcript?language=en)，提到说 “没有人是音盲（*tune deaf*）” 所以每个人都可以练习演奏 —— 这很重要…… 不过，值得你在这里听听的是他模仿了不同时期孩子弹钢琴的情况，从生硬到熟练……

<audio controls><source src="/audios/benjamin-zander-on-kids-playing-piano.mp3"></source></audio>

其实，无论干什么，每个人都得经历那其中的各个阶段。

## 2.4. 完整跟读

终于，可以尝试**完整跟读**了。

在这个阶段里，千万不能误以为自己现在已经很熟练了就彻底过关了。

完整跟读几遍之后，要录音。这时候，之前做的详细的标记就更起作用了。你会发现自己总是会在一些想象不到的地方一不小心就变成了过往自己说话的样子 —— 这就是近似连接近似网络和新建连接新建网络竞争胜出的结果。也许你需要换个颜色的笔再做一些**重点标记**。

重复三五遍之后，就要再录一次音，再对比再调整。

**录音非常重要**。因为不录音的话，很多自己没弄明白的细节就被掩盖了。只要录音，没做好没做对的地方就无可遁形。倒不见得每一次跟读都要录音，但，一定要时不时录一次。

## 2.5. 背诵

**这一步格外重要，绝不能糊弄！**—— 这是两个核心任务之一。随着时间的推移，**记忆扩展**的重要性会逐步超过**语音塑造** —— 毕竟，**语音塑造**练一段时间之后就可以用一辈子；但，**记忆扩展**却是可以且最好长期持续进行的。

切记：**记忆是一切语言能力的基础**。

这时候，你已经把整个文本读过不知道多少遍了 —— 背诵不应该有太多困难。

然而，由于它并不是用你目前高度熟悉的语言书写的，所以你还真不一定能够一下子记住。要集中注意力短时间内重复多次才可以。

刚开始的时候可能会感觉死活记不住…… 放心，**你的记忆力会越来越好的，只要你肯练**。

每隔一段时间要专门腾出一天复习之前的内容。比如，周日的时候，专门复习这一整周的所有内容。同样，到了月末，要腾出两三天专门复习这一整个月的内容。

## 2.6. 放松

在此之前，你的所有努力都是要尽量用录音里的方式说出所有的文字。在这个过程中，为了保证练习效果，你可能一直相当夸张，这也非常必要。

在练习的过程中，绝大多数人都会不由自主受到的影响有一部分来自于示范录音中的**音质**。

无论是人工智能生成的所谓真人语音，还是有声书里的录音，抑或是影视剧里的台词 —— 这些录音中的朗读者**音质**也好**声线**也罢，都是训练有素的**表演**。绝大多数人在日常生活里并未受到过这方面的专业训练，肯定不影响日常交流，但，的确很难做到在音质上或者声线上模仿。

当你熟悉到一定程度之后，你可以尝试着放松自己的声音。这样多少可以摆脱音质或声线造成的影响。但，依然需要重点关注的是那两大方面：**韵律节奏**和**音素变化** —— 这些都与音质或声线无关。

放松自己的嘴唇、舌头、呼吸，用尽量自然的方式反复朗读文本。重复几遍之后就录一次音…… 对比一下…… 也需要做调整…… 尝试背诵…… —— 重复以上步骤。

## 2.7. 复盘

一天至少三个小时，每周最多可以中止一天。

每天结束之前，要花 5～10 分钟做一下**复盘**，回忆并记录一下自己今天遇到的困难、已经克服的困难、尚未克服的困难、以及面对那些困难时所采用的方法…… 想一想还有什么方法可以试试？这些都要写下来。相信我，记录这个东西 ，总是会以想象不到的方式起想象不到的作用。
