# 8.1. 输入音标与特殊符号

在电子文档中输入音标符号（及其其它特殊符号）从来都很麻烦。

macOS 上有一个收费软件，[Alfred](https://www.alfredapp.com/)，可以用来定义很多快捷流程（workflow）去完成相对复杂的任务。

> Alfred 的使用方法，参见：
> https://github.com/xiaolai/apple-computer-literacy/blob/main/alfred.md

我用 Alfred 作为辅助在电脑上输入各种特殊符号。以下是 Alfred workflow 文件：

> [IPA-Phonetic-Symbols.alfredworkflow](https://1000h.org/alfred-workflows/IPA-Phonetic-Symbols.alfredworkflow)

以启动关键字 `ipae` 为例 —— 呼出 Alfred：

![ipae](/images/ipae.png)

这时，就可以用 `CMD + 数字` 的方式，将对应的符号插入当前文本。比如，`CMD + 4` 就是将 <span class="pho">ɝː</span> 插入当前文本编辑器。

以下罗列的是各个符号对应的 Alfred 关键字（Keywords）：

| 关键字（Keyword） | 符号（Symbol） |
| ----- | ----- |
| `ipaa`  |  <span class="pho">ʌ</span>  |
| `ipaaa`  |  <span class="pho">ɑ</span>  |
| `ipaae`  |  <span class="pho">æ</span>  |
| `ipae`  |  <span class="pho">ə</span>  |
| `ipaeeer`  |  <span class="pho">ɝː</span>  |
| `ipaer`  |  <span class="pho">ɚ</span>  |
| `ipaes`  |  <span class="pho">ᵊ</span>  |
| `ipai`  |  <span class="pho">ɪ</span>  |
| `ipau`  |  <span class="pho">ʊ</span>  |
| `ipao`  |  <span class="pho">ɒ</span>  |
| `ipaoo`  |  <span class="pho">ɔ</span>  |
| `ipal`  |  <span class="pho">ɤ</span>  |
| `ipatd`  |  <span class="pho">t̠</span>  |
| `ipatg`  |  <span class="pho">ʔ</span>  |
| `ipats`  |  <span class="pho">ᵗ</span>  |
| `ipan`  |  <span class="pho">ŋ</span>  |
| `ipath`  |  <span class="pho">θ</span>  |
| `ipad`  |  <span class="pho">ð</span>  |
| `ipas`  |  <span class="pho">ʃ</span>  |
| `ipaz`  |  <span class="pho">ʒ</span>  |
| `ipaj`  |  <span class="pho">ʲ</span>  |
| `ipaw`  |  <span class="pho">ʷ</span>  |
| `ipa1`  |  <span class="pho">◌̅</span> flat  |
| `ipa2`  |  <span class="pho">◌́</span> rise  |
| `ipa3`  |  <span class="pho">◌̌</span> fall-rise  |
| `ipa4`  |  <span class="pho">◌̀</span> fall  |
| `ipa5`  |  <span class="pho">◌̂</span> pitch raise  |
| `ipa6`  |  <span class="pho">◌̲</span> long vowel  |
| `ipa7`  |  <span class="pho">◌̩</span> syllabic consonant  |
| `ipa8`  |  <span class="pho">◌̥</span> voiceless  |
| `ipa9`  |  <span class="pho">◌̚</span> stop  |
| `ipa0`  |  <span class="pho">◌</span>  |
| `ipa:`  |  <span class="pho">ː</span> long vowel symbol  |
| `ipa"`  |  <span class="pho">ˈ</span> prime stress  |
| `ipa'`  |  <span class="pho">ˌ</span> secondary stress  |
| `ipa-`  |  <span class="pho">◌‿◌</span> linking  |
| `ipa\|` |  <span class="pho">‖</span> grouping boundary  |
| `-->`  |  <span class="pho">⭢</span>  |
| `<--`  |  <span class="pho">⭠</span>  |
| `<->`  |  <span class="pho">⭤</span>  |
| `irise`  |  <span class="pho">⤴</span> senetence intonation rise  |
| `idown`  |  <span class="pho">⤵</span> senetence intonation fall  |
