# 4.4. 连接

一个**意群**内可能有若干个**单词**，而每个单词都由至少一个音节构成 —— 于是，一连串的音节之间，可能会构成单独朗读时不存在的连接。

相邻的两个词之间，可能产生的连接通常有以下三种：

> 1. 辅音 + 元音
> 2. 辅音 + 辅音
> 3. 元音 + 元音

## 4.4.1 辅音 + 元音（Consonant + Vowel）

在词汇内部，“辅音 + 元音” 当然可以构成一个音节；在同一个**意群**（thought group）中，如果**以辅音结尾的词汇**遇到**以元音开头的词汇**的话，那么前一个词末尾的**辅音**和后一个词开头的**元音**很可能会连起来读，听起来构成一个**音节**，这种方式叫做**连读**。

比如在 *People's opinions vary from individual to individual.*<span class="speak-word-inline" data-audio-us-male="/audios/sentence-opinions-vary-alloy.mp3" data-audio-us-female="/audios/sentence-opinions-vary-nova.mp3"></span> 在这句话中，*People's* 末尾的 <span class="pho">z</span> 和 *opinions* 开头的 <span class="pho">ə</span> 会连在一起，<span class="pho alt">piː·pəl·zə·ˈpɪ·njənz</span> —— 感觉上是在读一整个由 *5* 个音节构成的词汇一样……

这类连读，其实无需刻意，只要做到前面一个词末尾的辅音发声器官动作完整，而后能够熟练且又清楚地说出下一个元音开头的词汇，语音就会自然而然连接起来。

这类**连读**中有相当难度乃至于必须刻意练习的其实只有两种，<span class="pho">t</span> 和 <span class="pho">l</span> 构成的连读。

之前提到过，在美式英语里，<span class="pho">t</span> 有个特殊的现象，它夹在两个元音之间的时候会被浊化，被读成弹舌音，用 <span class="pho">t̬</span> 表示，听起来接近 <span class="pho">d</span>…… 比如，在 city <span class="pho alt">ˈsɪt̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/city-us-male.mp3" data-audio-us-female="/audios/city-us-female.mp3"></span> 这个词汇里， <span class="pho">t</span> 就夹在两个元音之间，所以读成 <span class="pho">t̬</span>。

在自然语流里，同一个意群中，经常会出现以 <span class="pho">t</span> 结尾的词汇后面跟着一个以元音开头的词汇，并且，<span class="pho">t</span> 的前面是元音的概率也很高，所以，词汇之间出现 <span class="pho">t</span> 的浊化弹舌音 <span class="pho">t̬</span> 的情况非常普遍。比如，*Get it done.* <span class="pho alt">ɡet̬ ɪt dʌn</span><span class="speak-word-inline" data-audio-us-male="/audios/sentence-it-done-alloy.mp3" data-audio-us-female="/audios/sentence-it-done-nova.mp3"></span>

<span class="pho">l</span> 构成的连读，对绝大多数人来说，难点在于，如果前一个单词末尾的 <span class="pho">l</span> **舌尖动作不够完整**的话（即，结束的时候舌尖没有贴到龈脊）那么，<span class="pho">l</span> 这个弹舌音就发不出来，无法与后面的元音连上…… 尤其是在没有纠正掉用嘴唇动作替代舌尖动作的错误（乃至于有 <span class="pho">ʊ</span> 的音色）的情况下。

请仔细听一遍以下的录音，注意所有以 <span class="pho">l</span> 作为末尾的音节：

> Whether the *goal of* an insurgency has been to establish the Christian religion in the days of the Roman Empire, to create an interstate commerce commission in nineteenth-century America, or to promote civil rights for minorities in the twentieth century, what a *successful insurgency* does in *institutional or* process terms is to change the incentives and constraints facing others, *as well as* the incentives and constraints facing themselves and their successors.<span class="speak-word-inline" data-audio-us-male="/audios/goal-of.mp3"></span>[^1]

在以上这段录音中，*goal‿of*<span class="speak-word-inline" data-audio-us-male="/audios/goal-of-1.mp3"></span>, *successful‿insurgency*<span class="speak-word-inline" data-audio-us-male="/audios/goal-of-2.mp3"></span>, *as well‿as*<span class="speak-word-inline" data-audio-us-male="/audios/goal-of-3.mp3"></span>, 都有前一个单词末尾的 <span class="pho">l</span> 与后一个单词开头的元音之间轻微的连读。但，*institutional or*<span class="speak-word-inline" data-audio-us-male="/audios/goal-of-4.mp3"></span> 之间却没有 —— 因为这两个词汇实际上分别属于前后不同的意群。

初学者容易矫枉过正，想把一切自己遇到的词汇间 “辅音 + 元音” 的组合连起来读…… 请注意，是**很可能**连起来读，但**并不一定**。首先，这多少与个人讲话的习惯有关。更为重要的是，讲话的时候要划分**意群**，意群之间要有**暂停**（*pause*）—— 前一个意群末尾的辅音和下一个意群开头的元音，不应该连读。

并且，即便是在同一个意群里，也不能时时刻刻连读，有时盲目连读会出现歧义。

> 比如在这句话之中：
>
> * She will cherish those memories and ever hold them close to her heart.<span class="speak-word-inline" data-audio-us-male="/audios/She-will-cherish-those-memories-and-ever-hold-them-close-to-her-heart.-alloy.mp3" data-audio-us-female="/audios/She-will-cherish-those-memories-and-ever-hold-them-close-to-her-heart.-nova.mp3"></span>
>
> 如果 and ever，非要连起来读，前面的 and 可能被弱读作 <span class="pho alt">æn, ən</span>，而后要是非要与后面的 <span class="pho alt">ˈev.ɚ</span> 连起来，就可能被听成 <span class="pho alt">ə.nˈev.ɚ</span>（and never）—— 那岂不是可能会被理解成相反的意思？

> [!Note]
>
> 目前（2024.03） OpenAI 的 TTS 引擎生成的语音中，*<span class="pho">l</span> + vowels* 的组合总是没有连读效果 —— 也许将来的版本会改进？

## 4.4.2. 辅音 + 辅音（Consonant + Consonant）

“**辅音 + 辅音**” 的组合需要注意的地方相对较多。

## 4.4.2.1 省音（elision）

“**辅音 + 辅音**” 的组合，常常会造成前一个辅音虽然发声器官（*articulator*）动作完整但并不发声的情况，于是会出现一个既 “听不到” 也 “看不见” 的**停顿**（*stop*），之前举过单词内存在这种情况的例子，*hotdog* <span class="pho alt">ˈhɑːtdɑːɡ</span><span class="speak-word-inline" data-audio-us-male="/audios/hotdog-us-male.mp3" data-audio-us-female="/audios/hotdog-us-female.mp3"></span> 和 *network* <span class="pho alt">ˈnetwɝːk</span><span class="speak-word-inline" data-audio-us-male="/audios/network-us-male.mp3" data-audio-us-female="/audios/network-us-female.mp3"></span>，再比如，*hard-nosed* <span class="pho alt">hɑːrd-noʊzd</span><span class="speak-word-inline" data-audio-us-male="/audios/hard-nosed-us-male.mp3" data-audio-us-female="/audios/hard-nosed-us-female.mp3"></span>, *partner* <span class="pho alt">ˈpɑːrtnɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/partner-us-male.mp3" data-audio-us-female="/audios/partner-us-female.mp3"></span>……

有人把这种现象叫做 **省音**（*elision*）；但，这种说法容易产生误导，因为音的确是省了，但，动作却没省，不仅没有省，**动作还很完整**。

在意群中，更是经常出现前一个词汇末尾是辅音，后一个词汇开头也是辅音的情况 —— 同样会出现**省音**。

## 4.4.2.2. 叠音（geminates）

上一个音节末尾的辅音和下一个音节开头的辅音相同的时候，这一对相同的辅音被称作**叠音**（*geminates*）。在连贯的自然语音中，这两个辅音就只发声一次 —— 但听起来的时候，有可能感受到前一个辅音存在造成细微停顿。它从机制上来看，其实和**省音**一样。其实哪怕相邻的两个辅音相似的时候，也会发生同样的现象。

比如，*at that time*, 不是 <span class="pho alt">æt ðæt taɪm</span>，而是 <span class="pho alt">æ·ðæ·t̬aɪm</span><span class="speak-word-inline" data-audio-us-male="/audios/at-that-time-us-male.mp3" data-audio-us-female="/audios/at-that-time-us-female.mp3"></span> —— 第一个 <span class="pho">t</span> 由于后面跟着一个辅音，于是产生了**省音**，听不到了，但，该有的停顿却依然在，在这里我们用 <span class="pho">·</span> 代表那个停顿 ；而后，第二个 <span class="pho">t</span> 与第三个 <span class="pho">t</span> 是**叠音**，这两个 <span class="pho">t</span> 只发声一次。

上下居中的圆点 <span class="pho">·</span> 是我们用来标记这种因为停顿（stop）的符号。（注意，不是英文句号 <span class="pho">.</span> —— 那是用来标记音节边界的符号。）

又比如，*a bad day*, 不是 <span class="pho alt">ə bæd deɪ</span>，而是 <span class="pho alt">ə bæ·deɪ</span><span class="speak-word-inline" data-audio-us-male="/audios/a-bad-day-us-male.mp3" data-audio-us-female="/audios/a-bad-day-us-female.mp3"></span>。 再比如，*with this*, 不是 <span class="pho alt">wɪθ ðɪs</span>，而是 <span class="pho alt">wɪ·ðɪs</span><span class="speak-word-inline" data-audio-us-male="/audios/with-this-us-male.mp3" data-audio-us-female="/audios/with-this-us-female.mp3"></span>。

## 4.4.2.3. 同化（assimilation）

同化（*assimilation*）主要有两种情况：

> * <span class="pho">t</span> + <span class="pho">j</span> = <span class="pho">tʃ</span>
> * <span class="pho">d</span> + <span class="pho">j</span> = <span class="pho">dʒ</span>

最常见的比如，*Don't you?* <span class="pho alt">doʊn tʃju?</span><span class="speak-word-inline" data-audio-us-male="/audios/Dont-you-us-male.mp3"></span> *Would you?* <span class="pho alt">wʊ dʒju?</span><span class="speak-word-inline" data-audio-us-female="/audios/Would-you-us-female.mp3"></span> 这里的关键在于，<span class="pho">t, d</span> 发声时起始的舌尖位置如果放对了（[3.2.2](3.2.2-td#_3-2-2-2-舌尖起始位置)），它与后面的 <span class="pho alt">ju</span> 连起来的发声就只能如此。

同化主要发生在 <span class="pho">j</span> 这个音上。除了已经讲过的 <span class="pho">j</span> 前面遇到 <span class="pho">t</span> 和 <span class="pho">d</span> 时会产生同化之外，

> * <span class="pho">s</span> + <span class="pho">j</span> = <span class="pho">ʃ</span>
> * <span class="pho">z</span> + <span class="pho">j</span> = <span class="pho">ʒ</span>

比如，<span class="pho">s+j</span> 可能会被读成 <span class="pho">ʃ</span>，<span class="pho">z+j</span> 可能会被读成 <span class="pho">ʒ</span>。再比如，*Miss you so much.* <span class="pho alt">mɪ ʃu səʊ mʌʧ.</span><span class="speak-word-inline" data-audio-us-male="/audios/Miss-you-so-much-us-male.mp3" data-audio-us-female="/audios/Miss-you-so-much-us-female.mp3"></span>*It was your job.* <span class="pho alt">ɪt wɒ ʒʊr ʤɒb.</span><span class="speak-word-inline" data-audio-us-male="/audios/It-was-your-job-us-male.mp3" data-audio-us-female="/audios/It-was-your-job-us-female.mp3"></span>

另外一个细节是，<span class="pho">k/g</span> 之前的 <span class="pho">n</span>，**可能**会被同化为 <span class="pho">ŋ</span>:

> * *ten cups*, <span class="pho alt">ten kʌps</span> → <span class="pho alt">teŋ kʌps</span><span class="speak-word-inline" data-audio-us-male="/audios/ten-cups-us-male.mp3" data-audio-us-female="/audios/ten-cups-us-female.mp3"></span>
> * *increase*, <span class="pho alt">ˌɪnˈkris</span> → <span class="pho alt">ˌɪŋˈkris</span><span class="speak-word-inline" data-audio-us-male="/audios/increase-us-male.mp3" data-audio-us-female="/audios/increase-us-female.mp3"></span>
> * *brown gate*, <span class="pho alt">braʊn geɪt</span> → <span class="pho alt">braʊŋ geɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/brown-gate-us-male.mp3" data-audio-us-female="/audios/brown-gate-us-female.mp3"></span>

> [!Note]
>
> 请注意，**同化**都是**可能**，并非一定，并非所有英文母语使用者都如此发音。并非所有人都会使用这种**同化**的发音。比如，*Don't you?* <span class="pho alt">doʊnt̥ ju?</span><span class="speak-word-inline" data-audio-us-female="/audios/Dont-you-us-female.mp3"></span> *Would you?* <span class="pho alt">wʊd̥ ju?</span><span class="speak-word-inline" data-audio-us-male="/audios/Would-you-us-male.mp3"></span>

## 4.4.2.4. 击穿（dropping）

“辅音 + 辅音” 的组合中，如果第二个辅音是 <span class="pho">h</span> 的话，它常常被击穿（*dropping*），因为 <span class="pho">h</span> 原本就是很轻的音，发音时声带并不震动，所以总是自然而然地被前后发音相对更为响亮的声音所掩盖。

比如，*Was he hurt?* 三个单词分开读，应该是 <span class="pho alt">wɒz hi həːt</span> 在连贯的语音中，会被读成 <span class="pho alt">wɒzi həːt</span><span class="speak-word-inline" data-audio-us-male="/audios/Was-he-hurt-us-male.mp3" data-audio-us-female="/audios/Was-he-hurt-us-female.mp3"></span> —— 听不到 <span class="pho">h</span>，它被击穿了。

很多美国人在 <span class="pho">t</span> 这个音上还有另外一个特殊的习惯，<span class="pho">t</span> 跟在 <span class="pho">n</span> 之后的时候，美国人说话的方式会让我们听不到那个 <span class="pho">t</span>，也就是说，<span class="pho">t</span> 也可能被击穿。比如，他们说 *interview* 的时候你听到的可能是 <span class="pho alt">ˈɪnəˌvju</span><span class="speak-word-inline" data-audio-us-male="/audios/interview-us-male.mp3" data-audio-us-female="/audios/interview-us-female.mp3"></span>，没有 <span class="pho">t</span> —— 也就是说，那其实是一个可选音 <span class="pho">ᵗ</span>（[3.2.2.3.3](3.2.2-td#_3-2-2-3-3-省略音-可选音-t)）。

另外，<span class="pho">ð</span> 也可能被击穿，基本只发生在 *them* 这个常用词上。比如，*let them* <span class="pho alt">let ðəm</span>, 变成了 <span class="pho alt">let-əm</span>，又由于 <span class="pho">ð</span> 被击穿了之后，<span class="pho">t</span> 等于被夹在了两个元音之间，于是会变成浊化的弹舌音 <span class="pho">t̬</span>，于是，说出来的或者听到的是 <span class="pho alt">let̬əm</span><span class="speak-word-inline" data-audio-us-male="/audios/let-them-us-male.mp3" data-audio-us-female="/audios/let-them-us-female.mp3"></span>…… 所以，在快速的自然语流中 *let him* 和 *let them* 实际上几乎没有区别，需要通过上下文确定究竟是 *him* 还是 *them*。

## 4.4.2.5 其它（others）

值得一提的是，<span class="pho">m/n</span> + <span class="pho">f/v</span> 的情况。词汇之内我们看过 *comfort* <span class="pho alt">ˈkʌmfɚt</span><span class="speak-word-inline" data-audio-us-male="/audios/comfort-us-male.mp3" data-audio-us-female="/audios/comfort-us-female.mp3"></span> 和 *conversation* <span class="pho alt">ˌkɑːnvɚˈseɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/conversation-us-male.mp3" data-audio-us-female="/audios/conversation-us-female.mp3"></span> 的例子（[3.2.11.3](3.2.11-mnŋ#_3-2-11-3-音变)）。这种情况在意群之内也经常会遇到，比如，*stem from*, 只能读成 <span class="pho alt">sten frəm</span><span class="speak-word-inline" data-audio-us-male="/audios/stem-from-us-male.mp3" data-audio-us-female="/audios/stem-from-us-female.mp3"></span>……

## 4.4.3. 元音 + 元音（Vowel + Vowel）

“元音 + 元音” 的组合之中，会出现**加音**（*intrusion*）。

前一个元音以 <span class="pho">ɪ/i/iː</span> 结尾，会出现加音 <span class="pho">ʲ</span>：

> - *I am* - <span class="pho alt">ˈaɪ ˈæm</span> ⭢ <span class="pho alt">ˈaɪʲæm</span><span class="speak-word-inline" data-audio-us-male="/audios/I-am-us-male.mp3" data-audio-us-female="/audios/I-am-us-female.mp3"></span>
> - *He is* - <span class="pho alt">ˈhiː ˈɪz</span> ⭢ <span class="pho alt">ˈhiːʲɪz</span><span class="speak-word-inline" data-audio-us-male="/audios/He-is-us-male.mp3" data-audio-us-female="/audios/He-is-us-female.mp3"></span>
> - *She is* - <span class="pho alt">ˈʃiː ˈɪz</span> ⭢ <span class="pho alt">ˈʃiːʲɪz</span><span class="speak-word-inline" data-audio-us-male="/audios/She-is-us-male.mp3" data-audio-us-female="/audios/She-is-us-female.mp3"></span>
> - *They are* - <span class="pho alt">ˈðeɪ ˈɑːr</span> ⭢ <span class="pho alt">ˈðeɪʲɑːr</span><span class="speak-word-inline" data-audio-us-male="/audios/They-are-us-male.mp3" data-audio-us-female="/audios/They-are-us-female.mp3"></span>

注意：一些以 <span class="pho">i</span> 结尾的动词，使用进行时态的时候，末尾会加上 *ing*，即，<span class="pho alt">ɪŋ</span>。比如，*study* <span class="pho alt">ˈstʌdi</span> 的现在分词形式是 *studying* <span class="pho alt">ˈstʌdi.ɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/studying-us-male.mp3" data-audio-us-female="/audios/studying-us-female.mp3"></span> —— 这里会出现加音 <span class="pho">ʲ</span>，即最后一个音节变成 <span class="pho alt">jɪŋ</span>，相当于 <span class="pho alt">ˈstʌdi.ʲɪŋ</span> —— 虽然，*studying* 在词典里标注的只能是 <span class="pho alt">ˈstʌdi.ɪŋ</span>。

再比如：

> * *applying* - <span class="pho alt">əˈplaɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/applying-us-male.mp3" data-audio-us-female="/audios/applying-us-female.mp3"></span>
> * *carrying* - <span class="pho alt">ˈker.i.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/carrying-us-male.mp3" data-audio-us-female="/audios/carrying-us-female.mp3"></span>
> * *crying* - <span class="pho alt">ˈkraɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/crying-us-male.mp3" data-audio-us-female="/audios/crying-us-female.mp3"></span>
> * *denying* - <span class="pho alt">dɪˈnaɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/denying-us-male.mp3" data-audio-us-female="/audios/denying-us-female.mp3"></span>
> * *qualifying* - <span class="pho alt">ˈkwɑː.lə.faɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/qualifying-us-male.mp3" data-audio-us-female="/audios/qualifying-us-female.mp3"></span>
> * *replying* - <span class="pho alt">rɪˈplaɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/replying-us-male.mp3" data-audio-us-female="/audios/replying-us-female.mp3"></span>
> * *satisfying* - <span class="pho alt">ˈsæt̬.ɪs.faɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/satisfying-us-male.mp3" data-audio-us-female="/audios/satisfying-us-female.mp3"></span>
> * *specifying* - <span class="pho alt">ˈspes.ə.faɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/specifying-us-male.mp3" data-audio-us-female="/audios/specifying-us-female.mp3"></span>
> * *spying* - <span class="pho alt">spaɪ.ʲɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/spying-us-male.mp3" data-audio-us-female="/audios/spying-us-female.mp3"></span>

前一个音节以 <span class="pho">ʊ</span> 结尾，比如 <span class="pho">ʊ/uː/aʊ/oʊ</span>，会出现加音 <span class="pho">ʷ</span>：

> - *Go away* - <span class="pho alt">ˈɡoʊ əˈweɪ</span> ⭢ <span class="pho alt">ˈɡoʊʷəˈweɪ</span><span class="speak-word-inline" data-audio-us-male="/audios/Go-away-us-male.mp3" data-audio-us-female="/audios/Go-away-us-female.mp3"></span>
> - *Do all* - <span class="pho alt">ˈduː ˈɔːl</span> ⭢ <span class="pho alt">ˈduːʷɔːl</span><span class="speak-word-inline" data-audio-us-male="/audios/Do-all-us-male.mp3" data-audio-us-female="/audios/Do-all-us-female.mp3"></span>
> - *Do it* - <span class="pho alt">ˈduː ˈɪt</span> ⭢ <span class="pho alt">ˈduːʷɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/Do-it-us-male.mp3" data-audio-us-female="/audios/Do-it-us-female.mp3"></span>
> - *Throw it* - <span class="pho alt">ˈθroʊ ˈɪt</span> ⭢ <span class="pho alt">ˈθroʊʷɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/Throw-it-us-male.mp3" data-audio-us-female="/audios/Throw-it-us-female.mp3"></span>

[^1]: This audio clip is extracted from the Audible edition of Knowledge and Decisions by Thomas Sowell.