# 4.3. 意群

在自然语流中，很多句子并不是 “一口气” 读完的…… 

## 4.3.1. 意群

**句子**，只要略微长一点，就可能会被分割为若干个**意群**。

先听听以下视频里的这段话，同时观察一下语音的 “波谱”（*waveform*）及其 “音高变化”（*pitch contour*）：

> Yet, it is a fact of life that an unlettered peasant is considered ignorant.[^1]
> <video controls width="720"> <source src="/videos/yet-it-is-a-fact-of-life.mp4" type="video/mp4"></source>Your browser does not support the video tag. </video>

从波谱可以清晰地看到，这一整句话，显然被分成了 3 个**意群**：

> * Yet,
> * it is a fact of life
> * that an unlettered peasant is considered ignorant.

> [!Note]
> 这个视频截取自 [Enjoy App](https://1000h.org/enjoy-app/)。Enjoy 是一个英语学习工具（及其社区）。我们可以用它分析任何语音文件，清楚地看到 “停顿” 或者 “声调” 之类过去我们仅用听力难以完整分别的细节……

事实上，如果你反复多听几遍，你会发现，*peasant* 这个词，<span class="pho alt">ˈpez.ənt</span> 是这样读出来的：<span class="pho alt">ˈpez.ən</span> 之后有个很细微的停顿（stop），而后 <span class="pho">t</span> 与后面的 <span class="pho">ɪz</span> 连了起来…… 本质上，这是因为这个 <span class="pho">t</span> 的舌尖动作完整，然后有个停顿，而后接着说出了后面的 <span class="pho">ɪz</span>，所以它们才听起来被连起来了。

无论是**暂停**（pause）还是**停顿**（stop），虽然它们没有声音，却都在自然语流中都起着重要的作用。

为了将来的说明清楚与方便，我们会将意群之间的语流空隙称为 “**停**”（或者 “**暂停**”，即，*pause*），而把词汇内音节之间的语流空隙称为 “**顿**”（或者 “**停顿**”，即，*stop*）。

> * **停**（**暂停**/*pause*）：发生在意群之间，语流空隙时段较长，可以用来换气，不会产生 “连读” 现象
> * **顿**（**停顿**/*stop*）：发生在音节之间，语流空隙时段很短（但的确存在），不会用来换气，前后可能产生 “连读现象

## 4.3.2. 停/暂停（pause）

暂停的作用就是 “断句” —— 英文和中文一样的，其实任何语言也都是如此，不同的断句，有可能造成意义或者逻辑的变化。

> * Let's eat, kids. <span class="speak-word-inline" data-audio-us-male="/audios/Let's-eat...-kids.-alloy.mp3"></span>
> * Let's eat kids. <span class="speak-word-inline" data-audio-us-male="/audios/Let's-eat-kids.-alloy.mp3"></span>

或者

> * A woman without her man is nothing. <span class="speak-word-inline" data-audio-us-male="/audios/A-woman-without-her-man-is-nothing.-alloy.mp3"></span>
> * A woman: without her, man is nothing. <span class="speak-word-inline" data-audio-us-female="/audios/A-woman,-without-her,-man-is-nothing.-nova.mp3"></span>

而同一意群中细微的**停顿**（*stop*）影响自然语流的节奏，不符合惯常节奏的声音，总是需要 “多一层的处理” 才能够理解。

## 4.3.3. 顿/停顿（stop）

**暂停/停**（*pause*）往往很容易分辨，但，**停顿**（*stop*）就是几乎被所有初学者完全忽视的重要细节。

一个常见的停顿来自于**重读音节**。当我们想要强调某个音节的时候，为了能把它读得相对较重，在此之前往往需要**停顿**一下 —— 做个准备。

比如，你可以试着读一下 *absolutely* <span class="pho alt">ˌæbsəˈluːtli</span><span class="speak-word-inline" data-audio-us-male="/audios/absolutely-us-male.mp3" data-audio-us-female="/audios/absolutely-us-female.mp3"></span>…… 为了把 <span class="pho alt">luː</span> 这个音节读成**重音**（顺带说，这是个长元音），你可能就会不由自主地在发出 <span class="pho">sə</span> 之后略微**停顿**一下…… 拿之前的例子 *individual* <span class="pho alt">ˌɪndəˈvɪdʒuəl</span><span class="speak-word-inline" data-audio-us-male="/audios/individual-us-male.mp3" data-audio-us-female="/audios/individual-us-female.mp3"></span> 再试一下，若是在 <span class="pho alt">vɪ</span> 之前略微**停顿**一下，就能相对更为轻松地将它读成**重音**。

另外一个更为常见的**停顿**相对比较微妙，它就在那里，可不仅听不到，就算说话的人就在眼前，也看不到他们停顿时的发声器官的具体动作。

比如，在 *hotdog* <span class="pho alt">ˈhɑːt.dɑːɡ</span><span class="speak-word-inline" data-audio-us-male="/audios/hotdog-us-male.mp3" data-audio-us-female="/audios/hotdog-us-female.mp3"></span>这个词里，<span class="pho">t</span> 的声音是听不到的，但，它的舌尖动作却是**完整**的，所以，能够听到的不是 <span class="pho alt">ˈhɑtˌdɑːg</span>，也不是 <span class="pho alt">ˈhɑˌdɑːg</span>，而是 <span class="pho alt">ˈhɑt̚ ˌdɑːg</span><span class="speak-word-inline" data-audio-us-male="/audios/hotdog-us-male.mp3" data-audio-us-female="/audios/hotdog-us-female.mp3"></span>。你可以再试试 *network* <span class="pho alt">ˈnetˌwərk</span><span class="speak-word-inline" data-audio-us-male="/audios/network-us-male.mp3" data-audio-us-female="/audios/network-us-female.mp3"></span> 这个词 —— 这里面的 <span class="pho">t</span> 也是同样的机制。（注意，也有人用喉塞音 <span class="pho">ʔ</span> 读这两个词中的 <span class="pho">t</span>。）

这类**停顿**（*stop*），也叫**塞音**，最常见的有以下几种：

> - 唇塞音（*Bilabial stop*）：<span class="pho">p</span>、<span class="pho">b</span>、<span class="pho">m</span>、<span class="pho">f</span>、<span class="pho">v</span> —— *I just cannot hel**p** myself*. <span class="speak-word-inline" data-audio-us-male="/audios/sentence-just-cannot-alloy.mp3" data-audio-us-female="/audios/sentence-just-cannot-nova.mp3"></span> 第四个单词 <span class="pho alt">help</span> 末尾的 <span class="pho">p</span> 就是一个唇塞音。
> - 齿塞音（*Dental stop*）：<span class="pho">θ</span>、<span class="pho">ð</span> —— *I wish the pa**th** to success was smoother.*<span class="speak-word-inline" data-audio-us-male="/audios/sentence-wish-the-alloy.mp3" data-audio-us-female="/audios/sentence-wish-the-nova.mp3"></span> 第四个单词 <span class="pho alt">pæθ</span> 末尾的 <span class="pho">θ</span> 就是一个齿塞音。
> - 龈塞音（*Alveolar stop*）: <span class="pho">t</span>、<span class="pho">d</span> —— *He trie**d** to discuss his idea with his boss.*<span class="speak-word-inline" data-audio-us-male="/audios/sentence-tried-to-alloy.mp3" data-audio-us-female="/audios/sentence-tried-to-nova.mp3"></span> 第二个单词 <span class="pho alt">traɪd</span> 末尾的 <span class="pho">d</span> 就是一个龈塞音。
> - 喉塞音（*Glottal stop*）：<span class="pho">k</span>, <span class="pho">g</span>, <span class="pho">t</span> —— IPA 里用 <span class="pho">ʔ</span>标注。 *I don't thin**k** that is true.*<span class="speak-word-inline" data-audio-us-male="/audios/sentence-don't-think-alloy.mp3" data-audio-us-female="/audios/sentence-don't-think-nova.mp3"></span> 第三个单词 *think* 末尾的 <span class="pho">k</span> 就是一个喉塞音，<span class="pho alt">θɪŋʔ ðæt</span>。 *uh-oh* <span class="pho alt">ɑʔoʊ</span><span class="speak-word-inline" data-audio-us-female="/audios/Uh-Oh.mp3"></span> 是另外一个例子…… <span class="pho">t</span> 也有可能用这个喉塞音，比如，*utmost* <span class="pho alt">ˈʌʔˌmoʊst</span><span class="speak-word-inline" data-audio-us-male="/audios/utmost-us-male.mp3" data-audio-us-female="/audios/utmost-us-female.mp3"></span>，或者 <span class="pho alt">ˈneʔwɝːk</span><span class="speak-word-inline" data-audio-us-male="/audios/network-us-male.mp3" data-audio-us-female="/audios/network-us-female.mp3"></span>。

不管是哪一种，都是因为那个辅音**虽然并未发出声音，但整个发声器官却动作完整**而形成的。

这是一个非常重要的建议：

> 在研究 “**连读**” 之前，可能更应该先仔细研究 “**停**与**顿**”。

[^1]: 这段语音截取自 [Thomas Sowell](https://en.wikipedia.org/wiki/Thomas_Sowell) 的 [Knowledge and Decisions](https://www.amazon.com/Knowledge-Decisions-Thomas-Sowell-ebook/dp/B09NKRSC3W/) 有声版（Audible）
