# 4.2. 单词

一个**单词**（*word*）至少由一个**音节**（*syllable*）构成。

## 4.2.1. 重音、次重音、非重音、弱音

重点在于，英文的音节有**重音**、**次重音**、**非重音**的区别，这一点和亚洲语言明显不同。

如果一个单词只有一个音节，单独读出的时候，就当作是**重音**（*stress*）音节读出。而一个多音节词汇中**有且只有一个**重音音节，但，可能还有另外一些音节是**次重音**（*secondary stress*），在音标中使用 <span class="pho">ˌ</span> 作为标记。比如，*serendipity* <span class="pho alt">ˌserənˈdɪpət̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/serendipity-us-male.mp3" data-audio-us-female="/audios/serendipity-us-female.mp3"></span>，有一个**重音**和一个**次重音**。

而 *[Pneumonoultramicroscopicsilicovolcanoconiosis](https://en.wikipedia.org/wiki/Pneumonoultramicroscopicsilicovolcanoconiosis)*<span class="speak-word-inline" data-audio-us-female="/audios/En-us-pneumonoultramicroscopicsilicovolcanoconiosis.ogg.mp3"></span> 总计有 19 个音节，其中 7 个是次重音，唯一的重音是 <span class="pho">oʊ</span>……

形象地讲，5 个不分轻重的汉字（或者日文字、韩文字）排在一起大概是这样的：

![5-chars](/images/5-chars.svg)

但，由 5 个各自轻重不同的音节构成的英文词汇 *individual* <span class="pho alt">ˌɪndəˈvɪdʒuəl</span><span class="speak-word-inline" data-audio-us-male="/audios/individual-us-male.mp3" data-audio-us-female="/audios/individual-us-female.mp3"></span> 相应是这样的：

![5-syllables](/images/5-syllables.svg)

**非重音** 音节中，还有**弱音**，即被弱化成 <span class="pho">ə</span> 的央元音（*schwa*）音节。

细细体会 *individual* <span class="pho alt">ˌɪndəˈvɪdʒuəl</span><span class="speak-word-inline" data-audio-us-male="/audios/individual-us-male.mp3" data-audio-us-female="/audios/individual-us-female.mp3"></span> 这个词，如果每个音节都清晰地用同样的强度读出来的话，应该是 <span class="pho alt">ɪn-dɪ-vɪ-dʒju-əl</span>…… 这里面，第 2 个音节 <span class="pho alt">dɪ</span>里的元音 <span class="pho">ɪ</span> 被弱化为 <span class="pho">ə</span>；另外，第 4 个音节 <span class="pho alt">dʒu</span> 里的元音 <span class="pho">ju</span> 也被弱化成了 <span class="pho">ə</span>，但保留了 <span class="pho">u</span> 的音色；而处于音节末尾的 <span class="pho">l</span>，之前自带着轻微的 <span class="pho">ə</span>，于是连成了很轻的 <span class="pho">ʷᵊl</span>……

![5-syllables-individual](/images/5-syllables-individual.svg)

有些时候，同样的词汇，因**重音位置**不同会产生**词义**或**词性**的变化。比如，*address*, <span class="pho alt">ˈædres</span><span class="speak-word-inline" data-audio-us-female="/audios/address-noun.mp3"></span> 是名词，“地址”；<span class="pho alt">əˈdres</span><span class="speak-word-inline" data-audio-us-male="/audios/address-verb.mp3"></span> 是动词，“强调”；再比如，*record*，可以读作 <span class="pho alt">ˈrekɚd</span><span class="speak-word-inline" data-audio-us-female="/audios/record-noun.mp3"></span> 或 <span class="pho alt">rɪˈkɔːrd</span><span class="speak-word-inline" data-audio-us-female="/audios/record-verb.mp3"></span>，前者是名词，后者是动词。

类似的还有很多，比如以下常见词汇[^1]：

| Noun                                                                                                              | Verb                                                                                                             |
| ----------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------- |
| 'conduct <span class="pho alt">ˈkɑːndʌkt</span>   <span class="speak-word-inline" data-audio-us-male="/audios/conduct-noun.mp3"></span> | con'duct <span class="pho alt">kənˈdʌkt</span><span class="speak-word-inline" data-audio-us-male="/audios/conduct-verb.mp3"></span>    |
| 'conflict <span class="pho alt">ˈkɑːnflɪkt</span><span class="speak-word-inline" data-audio-us-male="/audios/conflict-noun.mp3"></span> | con'flict <span class="pho alt">kənˈflɪkt</span><span class="speak-word-inline" data-audio-us-male="/audios/conflict-verb.mp3"></span> |
| 'convert <span class="pho alt">ˈkɑːnvɝːt</span><span class="speak-word-inline" data-audio-us-male="/audios/convert-noun.mp3"></span>    | con'vert <span class="pho alt">kənˈvɝːt</span><span class="speak-word-inline" data-audio-us-male="/audios/convert-verb.mp3"></span>    |
| 'digest <span class="pho alt">ˈdaɪdʒest</span><span class="speak-word-inline" data-audio-us-male="/audios/digest-noun.mp3"></span>      | di'gest <span class="pho alt">daɪˈdʒest</span><span class="speak-word-inline" data-audio-us-male="/audios/digest-verb.mp3"></span>     |
| 'permit <span class="pho alt">ˈpɝːmɪt</span><span class="speak-word-inline" data-audio-us-female="/audios/permit-noun.mp3"></span>      | per'mit <span class="pho alt">pɚˈmɪt</span><span class="speak-word-inline" data-audio-us-female="/audios/permit-verb.mp3"></span>      |
| 'rebel <span class="pho alt">ˈrebəl</span><span class="speak-word-inline" data-audio-us-female="/audios/rebel-noun.mp3"></span>         | re'bel <span class="pho alt">rɪˈbel</span><span class="speak-word-inline" data-audio-us-female="/audios/rebel-verb.mp3"></span>        |
| 'subject <span class="pho alt">ˈsʌbdʒekt</span><span class="speak-word-inline" data-audio-us-male="/audios/subject-noun.mp3"></span>    | sub'ject <span class="pho alt">səbˈdʒekt</span><span class="speak-word-inline" data-audio-us-female="/audios/subject-verb.mp3"></span> |

不妨逐个练习一下以下常用多音节词汇，注意**重音**音节、**次重音**音节，以及**非重音**音节和**弱音**音节。

> [!Note]
> 在练习跟读每个单词的之前，请先数一下该单词到底有多少个音节？然后再揣摩一下整个单词读出来的长度。

<div class="two-column">

> * *accommodate* <span class="pho alt">əˈkɑːmədeɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/accommodate-us-male.mp3" data-audio-us-female="/audios/accommodate-us-female.mp3"></span>
> * *anniversary* <span class="pho alt">ˌænəˈvɝːsɚi</span><span class="speak-word-inline" data-audio-us-male="/audios/anniversary-us-male.mp3" data-audio-us-female="/audios/anniversary-us-female.mp3"></span>
> * *anticipate* <span class="pho alt">ænˈtɪsəpeɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/anticipate-us-male.mp3" data-audio-us-female="/audios/anticipate-us-female.mp3"></span>
> * *appreciate* <span class="pho alt">əˈpriːʃieɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/appreciate-us-male.mp3" data-audio-us-female="/audios/appreciate-us-female.mp3"></span>
> * *beautiful* <span class="pho alt">ˈbjuːt̬əfəl</span><span class="speak-word-inline" data-audio-us-male="/audios/beautiful-us-male.mp3" data-audio-us-female="/audios/beautiful-us-female.mp3"></span>
> * *celebration* <span class="pho alt">ˌseləˈbreɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/celebration-us-male.mp3" data-audio-us-female="/audios/celebration-us-female.mp3"></span>
> * *characteristic* <span class="pho alt">ˌkerəktəˈrɪstɪk</span><span class="speak-word-inline" data-audio-us-male="/audios/characteristic-us-male.mp3" data-audio-us-female="/audios/characteristic-us-female.mp3"></span>
> * *communication* <span class="pho alt">kəˌmjuːnəˈkeɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/communication-us-male.mp3" data-audio-us-female="/audios/communication-us-female.mp3"></span>
> * *determination* <span class="pho alt">dɪˌtɝːmɪˈneɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/determination-us-male.mp3" data-audio-us-female="/audios/determination-us-female.mp3"></span>
> * *discovery* <span class="pho alt">dɪˈskʌvɚi</span><span class="speak-word-inline" data-audio-us-male="/audios/discovery-us-male.mp3" data-audio-us-female="/audios/discovery-us-female.mp3"></span>
> * *encouragement* <span class="pho alt">ɪnˈkɝːɪdʒmənt</span><span class="speak-word-inline" data-audio-us-male="/audios/encouragement-us-male.mp3" data-audio-us-female="/audios/encouragement-us-female.mp3"></span>
> * *entrepreneur* <span class="pho alt">ˌɑːntrəprəˈnɝː</span><span class="speak-word-inline" data-audio-us-male="/audios/entrepreneur-us-male.mp3" data-audio-us-female="/audios/entrepreneur-us-female.mp3"></span>
> * *environment* <span class="pho alt">ɪnˈvaɪrənmənt</span><span class="speak-word-inline" data-audio-us-male="/audios/environment-us-male.mp3" data-audio-us-female="/audios/environment-us-female.mp3"></span>
> * *exaggerate* <span class="pho alt">ɪɡˈzædʒəreɪt</span><span class="speak-word-inline" data-audio-us-male="/audios/exaggerate-us-male.mp3" data-audio-us-female="/audios/exaggerate-us-female.mp3"></span>
> * *examination* <span class="pho alt">ɪɡˌzæməˈneɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/examination-us-male.mp3" data-audio-us-female="/audios/examination-us-female.mp3"></span>
> * *explanation* <span class="pho alt">ˌekspləˈneɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/explanation-us-male.mp3" data-audio-us-female="/audios/explanation-us-female.mp3"></span>
> * *fascinating* <span class="pho alt">ˈfæsəneɪtɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/fascinating-us-male.mp3" data-audio-us-female="/audios/fascinating-us-female.mp3"></span>
> * *government* <span class="pho alt">ˈɡʌvɚnmənt</span><span class="speak-word-inline" data-audio-us-male="/audios/government-us-male.mp3" data-audio-us-female="/audios/government-us-female.mp3"></span>
> * *hospitality* <span class="pho alt">ˌhɑːspɪˈtælət̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/hospitality-us-male.mp3" data-audio-us-female="/audios/hospitality-us-female.mp3"></span>
> * *imagination* <span class="pho alt">ɪˌmædʒəˈneɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/imagination-us-male.mp3" data-audio-us-female="/audios/imagination-us-female.mp3"></span>
> * *impossible* <span class="pho alt">ɪmˈpɑːsəbəl</span><span class="speak-word-inline" data-audio-us-male="/audios/impossible-us-male.mp3" data-audio-us-female="/audios/impossible-us-female.mp3"></span>
> * *incredible* <span class="pho alt">ɪnˈkredəbəl</span><span class="speak-word-inline" data-audio-us-male="/audios/incredible-us-male.mp3" data-audio-us-female="/audios/incredible-us-female.mp3"></span>
> * *independent* <span class="pho alt">ˌɪndɪˈpendənt</span><span class="speak-word-inline" data-audio-us-male="/audios/independent-us-male.mp3" data-audio-us-female="/audios/independent-us-female.mp3"></span>
> * *information* <span class="pho alt">ˌɪnfɚˈmeɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/information-us-male.mp3" data-audio-us-female="/audios/information-us-female.mp3"></span>
> * *inspiration* <span class="pho alt">ˌɪnspəˈreɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/inspiration-us-male.mp3" data-audio-us-female="/audios/inspiration-us-female.mp3"></span>
> * *interesting* <span class="pho alt">ˈɪntrɪstɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/interesting-us-male.mp3" data-audio-us-female="/audios/interesting-us-female.mp3"></span>
> * *international* <span class="pho alt">ˌɪnt̬ɚˈnæʃənəl</span><span class="speak-word-inline" data-audio-us-male="/audios/international-us-male.mp3" data-audio-us-female="/audios/international-us-female.mp3"></span>
> * *knowledgeable* <span class="pho alt">ˈnɑːlɪdʒəbəl</span><span class="speak-word-inline" data-audio-us-male="/audios/knowledgeable-us-male.mp3" data-audio-us-female="/audios/knowledgeable-us-female.mp3"></span>
> * *opportunity* <span class="pho alt">ˌɑːpɚˈtuːnət̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/opportunity-us-male.mp3" data-audio-us-female="/audios/opportunity-us-female.mp3"></span>
> * *personality* <span class="pho alt">ˌpɝːsənˈælət̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/personality-us-male.mp3" data-audio-us-female="/audios/personality-us-female.mp3"></span>
> * *photography* <span class="pho alt">fəˈtɑːɡrəfi</span><span class="speak-word-inline" data-audio-us-male="/audios/photography-us-male.mp3" data-audio-us-female="/audios/photography-us-female.mp3"></span>
> * *professional* <span class="pho alt">prəˈfeʃənəl</span><span class="speak-word-inline" data-audio-us-male="/audios/professional-us-male.mp3" data-audio-us-female="/audios/professional-us-female.mp3"></span>
> * *recognition* <span class="pho alt">ˌrekəɡˈnɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/recognition-us-male.mp3" data-audio-us-female="/audios/recognition-us-female.mp3"></span>
> * *rehabilitation* <span class="pho alt">ˌriːhəˌbɪləˈteɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/rehabilitation-us-male.mp3" data-audio-us-female="/audios/rehabilitation-us-female.mp3"></span>
> * *relationship* <span class="pho alt">rɪˈleɪʃənʃɪp</span><span class="speak-word-inline" data-audio-us-male="/audios/relationship-us-male.mp3" data-audio-us-female="/audios/relationship-us-female.mp3"></span>
> * *responsibility* <span class="pho alt">rɪˌspɑːnsəˈbɪlət̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/responsibility-us-male.mp3" data-audio-us-female="/audios/responsibility-us-female.mp3"></span>
> * *revolutionary* <span class="pho alt">ˌrevəˈluːʃəneri</span><span class="speak-word-inline" data-audio-us-male="/audios/revolutionary-us-male.mp3" data-audio-us-female="/audios/revolutionary-us-female.mp3"></span>
> * *satisfaction* <span class="pho alt">ˌsæt̬ɪsˈfækʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/satisfaction-us-male.mp3" data-audio-us-female="/audios/satisfaction-us-female.mp3"></span>
> * *spectacular* <span class="pho alt">spekˈtækjəlɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/spectacular-us-male.mp3" data-audio-us-female="/audios/spectacular-us-female.mp3"></span>
> * *temperature* <span class="pho alt">ˈtempɚətʃɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/temperature-us-male.mp3" data-audio-us-female="/audios/temperature-us-female.mp3"></span>
> * *transportation* <span class="pho alt">ˌtrænspɚˈteɪʃən</span><span class="speak-word-inline" data-audio-us-male="/audios/transportation-us-male.mp3" data-audio-us-female="/audios/transportation-us-female.mp3"></span>
> * *unbelievable* <span class="pho alt">ˌʌnbɪˈliːvəbəl</span><span class="speak-word-inline" data-audio-us-male="/audios/unbelievable-us-male.mp3" data-audio-us-female="/audios/unbelievable-us-female.mp3"></span>
> * *understand* <span class="pho alt">ˌʌndɚˈstænd</span><span class="speak-word-inline" data-audio-us-male="/audios/understand-us-male.mp3" data-audio-us-female="/audios/understand-us-female.mp3"></span>
> * *understanding* <span class="pho alt">ˌʌndɚˈstændɪŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/understanding-us-male.mp3" data-audio-us-female="/audios/understanding-us-female.mp3"></span>
> * *unforgettable* <span class="pho alt">ˌʌnfɚˈɡet̬əbəl</span><span class="speak-word-inline" data-audio-us-male="/audios/unforgettable-us-male.mp3" data-audio-us-female="/audios/unforgettable-us-female.mp3"></span>
> * *university* <span class="pho alt">ˌjuːnəˈvɝːsət̬i</span><span class="speak-word-inline" data-audio-us-male="/audios/university-us-male.mp3" data-audio-us-female="/audios/university-us-female.mp3"></span>
> * *vegetarian* <span class="pho alt">ˌvedʒəˈteriən</span><span class="speak-word-inline" data-audio-us-male="/audios/vegetarian-us-male.mp3" data-audio-us-female="/audios/vegetarian-us-female.mp3"></span>
> * *vocabulary* <span class="pho alt">voʊˈkæbjəleri</span><span class="speak-word-inline" data-audio-us-male="/audios/vocabulary-us-male.mp3" data-audio-us-female="/audios/vocabulary-us-female.mp3"></span>
> * *vulnerable* <span class="pho alt">ˈvʌlnɚəbəl</span><span class="speak-word-inline" data-audio-us-male="/audios/vulnerable-us-male.mp3" data-audio-us-female="/audios/vulnerable-us-female.mp3"></span>
> * *wonderfully* <span class="pho alt">ˈwʌndɚfəli</span><span class="speak-word-inline" data-audio-us-male="/audios/wonderfully-us-male.mp3" data-audio-us-female="/audios/wonderfully-us-female.mp3"></span>

</div>

## 4.2.2. 强读与弱读

单词的读音实际上都有两种形式：

> * 强读式（***accented** form*）
> * 弱读式（***weak** form*）

字典里的音标标注或者真人朗读示范，都是**强读式**。任何单词，在单独说出的时候都是**强读式**。但，在自然语流之中，不是每个单词都是强读式，只有少数是**强读式**，更多是**弱读式**。

比如 *our* 这个单词，词典里标注的当然是 <span class="pho alt">ˈaʊ.ɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/hour-us-male.mp3" data-audio-us-female="/audios/hour-us-female.mp3"></span> —— 这是**强读式**，每一个单词的 “默认形式”。然而，在实际的自然语流中，你更多听到的并不是这个饱满的三元音 <span class="pho alt">ˈaʊ.ɚ</span> 而是它的**弱读式**，一个很轻很短的 <span class="pho alt">ɑr</span>：

> It's *our* pleasure.<span class="pho alt">ˈaʊ.ɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/Its-our-pleasure-us-male.mp3" data-audio-us-female="/audios/Its-our-pleasure-us-female.mp3"></span>

关于**强读式**与**弱读式**的区别，得等到[音节](4.1-syllables)、[单词](4.2-words)、[意群](4.3-grouping.md)、[连接](4.4-linking)全都讲清楚之后，到了[句子](4.5-sentences)那个章节再深入讲解。

## 4.2.3. 词典读音

现在，你已经知道了，所有的词典，都没有，也不可能标注单词的**弱读形式** —— 可能是因为在自然语流中，弱读形式就不存在一个所谓的 “标准”。

除此之外，你还必须了解一个可能是所有学校里的老师都没有告诉过你的一个**重要事实**：

> 词典中的**音标标注**，或者**真人发声示例**，其实都只是 “**完成度极高**” 的 “**半成品**”。

首先，人类的自然语音，就是很难使用一个符号系统去完美地标注……

英文的例子一会儿再讲，现在先举一个中文的例子。你琢磨一下自己平日里是如何说 “不知道” 这三个字的？当然，我们可以用拼音分别标注这三个字 <span class="pho">[bù zhī dào]</span> —— 可你真的是这样三个字分开一字一顿地说的吗？你说出来的声音，只能用拼音凑合着标注成 <span class="pho">[búr(i)dào]</span> —— “**不**” 你可能读的不是四声，更像是速度很快的二声；“**知**” 你说得像 “日”，但速度很快，乃至于可能感觉只有一个声母 `[r]` 没带着韵母 `[i]`；最后，三个字里，只有 “**到**” `[dào]` 这个字算是字正腔圆地说完了。****

更何况，音标本身也是个 “**无法完美**” 的符号系统。

比如，<span class="pho">ə/əː</span> 的儿化音，到底是用 <span class="pho">ər/əːr</span> 好呢？还是用 <span class="pho">ɚ/ɝː</span> 更好呢？大多数情况下看不出什么区别，但，就是有一些词会出现无论用哪种都不太合适的情况。

比如，*literally* 这个词。

> * [牛津词典的标注](https://www.oxfordlearnersdictionaries.com/definition/english/literally?q=literally)是： <span class="pho alt">ˈlɪtərəli</span>，而后，真人示例中，英音 <span class="speak-word-inline" data-audio-uk-female="https://www.oxfordlearnersdictionaries.com/media/english/uk_pron/l/lit/liter/literally__gb_1.mp3"></span> 听起来像 <span class="pho alt">ˈlɪtrəli</span>，美音像 <span class="speak-word-inline" data-audio-us-female="https://www.oxfordlearnersdictionaries.com/media/english/us_pron/l/lit/liter/literally__us_1.mp3"></span> <span class="pho alt">ˈlɪtɚəli</span>（其实还真就是这个标注才对）……
> * [剑桥词典的标注](https://dictionary.cambridge.org/pronunciation/english/literally)是：<span class="pho alt">ˈlɪt̬.ɚ.ᵊl.i</span>，而后，真人示例中，英音 <span class="speak-word-inline" data-audio-uk-female="https://dictionary.cambridge.org/media/english/uk_pron/u/ukl/uklis/uklisp_017.mp3"></span> 听起来像 <span class="pho alt">ˈlɪtrəli</span>，美音像 <span class="speak-word-inline" data-audio-us-male="https://dictionary.cambridge.org/media/english/us_pron/l/lit/liter/literally.mp3"></span> <span class="pho alt">ˈlɪt̬ərəli</span>……

如果你要是误以为所有词典里的标注或者示范都是 “权威的”、“标准的”，那么，没比较过，没深入探究倒也罢了，只要稍微认真一点，就得掉入 “无所适从” 的尴尬境地。

这个词，本身就有好几种不太一样的读法。针对其中的任何一种读法，想要用音标完美标注都感觉相当费劲，甚至勉为其难。

> [!Note]
> 说实话，这个词真的不太容易读好，Instagram 上就有个人[演示](https://www.instagram.com/reel/C1VmSpuIvTO/?igsh=czY3cDAzcGIxMGN4)过自己 *literally* 这个单词死活读不明白的尴尬<span class="speak-word-inline" data-audio-uk="/audios/literally-instagram.mp3"></span>……

> * 当然，作为 ESL 练习者，对策也很简单，反正自己选择一种固定下来就是了。比如，我就选择了剑桥英语发声词典的 <span class="pho alt">ˈlɪt̬.ɚ.ᵊl.i</span>，不仅如此，而后还选择了用舌背后缩的方式读 <span class="pho">ɚ</span> 这个音节。甚至，我还专门买了 [The Phonetics 3D](http://www.thephonetics.com/)[^2]，去仔细观看 *literally* 这个词发声时的舌头动作：
>
> <video controls width="720"> <source src="/videos/literally.mp4" type="video/mp4"></source>Your browser does not support the video tag. </video>

又比如，另外一个相当常用的单词，*temperature* —— 我曾经误以为它读作 <span class="pho alt">ˌtem.pə.ˈreɪ.tʃɚ</span> —— 它实际读音的音标标注是 <span class="pho alt">ˈtem.pɚ.ə.tʃɚ</span>，结果呢，在日常生活中，你更常听到的是 <span class="pho alt">ˈtem.pə.tʃɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/temperature-us-male.mp3"></span>，或者是 <span class="pho alt">ˈtem.pɤtʃɚ</span>，甚至干脆是 <span class="pho alt">ˈtem.ptʃɚ</span><span class="speak-word-inline" data-audio-us-female="/audios/temperature-us-female.mp3"></span>

再举一个更常用的词作为例子，*important* <span class="pho alt">ɪmˈpɔːr.tənt</span><span class="speak-word-inline" data-audio-us-male="/audios/important-us-male.mp3"></span>，你可能无论如何都想不到，这个由 3 个音节构成的单词，你可能有 3 处细节需要注意，但，竟然从来没意识到……

> * 第一个是最普遍的，很多人不分元音长短，所以会说成 <span class="pho alt">ɪmˈpɔ.tənt</span> 或者 <span class="pho alt">ɪmˈpɔr.tənt</span>；
> * 第二个细节是，这个词的第一个 <span class="pho">t</span> 经常会被说成喉塞音 `ʔ`，所以，你很多时候听到的其实是 <span class="pho alt">ɪmˈpɔːr.ʔənt</span><span class="speak-word-inline" data-audio-us-male="/audios/important-us-male.mp3"></span>；
> * 第三个细节是，这个词的最后一个 <span class="pho">t</span> 其实是 “可选 <span class="pho">ᵗ</span>”（即，非重读音节末尾 <span class="pho">n</span> 之后的 <span class="pho">t</span>）—— <span class="pho alt">ɪmˈpɔːr.ʔənᵗ</span> —— 那个 <span class="pho">ᵗ</span> 在自然语流中经常并不存在，比如，当你说 *It's a very important aspect.*<span class="speak-word-inline" data-audio-us-male="/audios/It-s-a-very-important-aspect-alloy.mp3" data-audio-us-female="/audios/It-s-a-very-important-aspect-nova.mp3"></span> 的时候，与后面的 <span class="pho">æ</span> 连起来读的（示例语音中并未连读），更可能是 <span class="pho">n</span> 而不是 <span class="pho">t</span>。

我们其实已经用了一些英文词典里的音标中并不存在的符号才能把一些细节讲清楚，比如，阻塞音符号 <span class="pho">◌̚</span>，比如，比央元音更弱的一个音， <span class="pho">ɤ</span>，再比如喉塞音 <span class="pho">ʔ</span>…… 可即便如此，英文有那么多的单词（几十万个），有至少 7,000 个左右构成独特的音节，于是，无论如何都不大可能用一个并不完美的音标系统完美地标注任何自然语音。

[^1]: Sound files in this list come from [CEPD online edition](https://dictionary.cambridge.org/pronunciation/).
[^2]: *literally* 在该软件里的音标标注为 <span class="pho alt">ˈlɪtɚːəli</span> —— 虽然和《剑桥英语发声词典》略有不同，但我们依然看得懂……
