# 3.2. 辅音（Consonants）

地球上的所有语言都一样，在自然语流中，**辅音**不会单独存在。单独的**元音**，可以构成**音节**，也可以构成或者表达意义。比如，*ah* <span class="pho alt">ɑː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_father_2023feb.mp3"></span>, *oh* <span class="pho alt">oʊ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_nose_2023feb.mp3"></span>，或者 *Uh-Oh* <span class="pho alt">ˈʌ.oʊ</span><span class="speak-word-inline" data-audio-us-female="/audios/Uh-Oh.mp3"></span>[^1]。但，绝大多数**辅音**必须依附于**元音**才能构成**音节**，并且，单独的辅音也不能构成意义。

辅音可以根据发声时**声带**是否震动被分为清辅音（voiceless consonants）与浊辅音（voiced consonants）。清辅音只有气流震动，没有声带振动，而浊辅音的气流震动却伴有声带振动。比如，<span class="pho">s</span> 是清辅音，<span class="pho">z</span> 是浊辅音。

|                     | 辅音（consonants）                                                                                                                                                                                                                                                                                                                                                                                                                    |
| ------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 清辅音（voiceless） | <span class="pho">p</span>, <span class="pho">t</span>, <span class="pho">k</span>, <span class="pho">f</span>, <span class="pho">s</span>, <span class="pho">θ</span>, <span class="pho">ʃ</span>, <span class="pho">h</span>, <span class="pho">tʃ</span>, <span class="pho">tr</span>, <span class="pho">ts</span>                                                                                                                 |
| 浊辅音（voiced）    | <span class="pho">b</span>, <span class="pho">d</span>, <span class="pho">g</span>, <span class="pho">v</span>, <span class="pho">z</span>, <span class="pho">ð</span>, <span class="pho">ʒ</span>, <span class="pho">r</span>, <span class="pho">dʒ</span>, <span class="pho">dr</span>, <span class="pho">dz</span>, <span class="pho">m</span>, <span class="pho">n</span>, <span class="pho">ŋ</span>, <span class="pho">l</span> |

注意：<span class="pho">w</span> 和 <span class="pho">j</span> 这两个辅音被称为**半元音** —— 无法用声带振动与否分类。

辅音的另外一个划分，是根据口腔内**气流**振动的方式和位置。

| 气流振动方式（Airflow） | 清浊与否（Voiced or not） | 辅音（Consonants）                                                                                                                         |
| ----------------------- | ------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
| 破擦音（Plosive）       | 清辅音                    | <span class="pho">p</span>, <span class="pho">t</span>, <span class="pho">k</span>                                                         |
|                         | 浊辅音                    | <span class="pho">b</span>, <span class="pho">d</span>, <span class="pho">g</span>                                                         |
| 摩擦音（Fricative）     | 清辅音                    | <span class="pho">f</span>, <span class="pho">s</span>, <span class="pho">θ</span>, <span class="pho">ʃ</span>, <span class="pho">h</span> |
|                         | 浊辅音                    | <span class="pho">v</span>, <span class="pho">z</span>, <span class="pho">ð</span>, <span class="pho">ʒ</span>                             |
| 塞擦音（Affricate）     | 清辅音                    | <span class="pho">tʃ</span>, <span class="pho">tr</span>, <span class="pho">ts</span>                                                      |
|                         | 浊辅音                    | <span class="pho">dʒ</span>, <span class="pho">dr</span>, <span class="pho">dz</span>                                                      |
| 鼻音（Nasal）           | 浊辅音                    | <span class="pho">m</span>, <span class="pho">n</span>, <span class="pho">ŋ</span>                                                         |
| 边擦音（Lateral）       | 浊辅音                    | <span class="pho">l</span>, <span class="pho">r</span>                                                                                     |
| 半元音（Semivowel）     |                           | <span class="pho">j</span>, <span class="pho">w</span>                                                                                     |

作为初学者，**你无需尝试记忆这些分类和术语** —— 除非将来你有多余的时间精力。这些语言学的概念，并不构成任何学习障碍。你需要了解的只不过是分类的**依据**：**声带振动与否**，以及**气流振动方式和位置**。

另外，需要注意：有 *4* 个辅音，<span class="pho">l</span>, <span class="pho">m</span>, <span class="pho">n</span>，以及之前见过很多次的 <span class="pho">r</span>，它们被称作 “**音节辅音**”，因为它们自带 <span class="pho">ə</span> 的音色。比如，*bottle* <span class="pho alt">ˈbɑːtl</span>, *bottom* <span class="pho alt">ˈbɑːtm</span>, *button* <span class="pho alt">ˈbʌtn</span>。有些词典会用 <span class="pho">ᵊ</span>，比如写成：
*bottle* <span class="pho alt">ˈbɑːtᵊl</span>, *bottom* <span class="pho alt">ˈbɑːtᵊm</span>, *button* <span class="pho alt">ˈbʌtᵊn</span>。而《剑桥英语发声词典》的标注方式是：*bottle* <span class="pho alt">ˈbɑːt̬əl</span>, *bottom* <span class="pho alt">ˈbɑːt̬əm</span>, *button* <span class="pho alt">ˈbʌtən</span>……

格外需要注意的是：辅音发声时，**舌尖起始位置**非常重要。

以下 4 个位置，我们会反复提及：

![articulator-tongue-tip-positions](/images/articulator-tongue-tip-positions.svg)

| Positions of tongue tip | Consonants                                                                                                                                                                                                                                                     |
| :---------------------: | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|            ①            | <span class="pho">θ</span>, <span class="pho">ð</span>                                                                                                                                                                                                         |
|            ②            | <span class="pho">s</span>, <span class="pho">z</span>                                                                                                                                                                                                         |
|            ③            | <span class="pho">t</span>, <span class="pho">d</span>, <span class="pho">l</span>, <span class="pho">ʃ</span>, <span class="pho">ʒ</span>, <span class="pho">tʃ</span>, <span class="pho">dʒ</span>, <span class="pho">tr</span>, <span class="pho">dr</span> |
|            ④            | <span class="pho">r</span>                                                                                                                                                                                                                                     |

[^1]: *Uh-Oh* <span class="pho alt">ˈʌ.oʊ</span> 实际上有个隐藏的辅音，喉塞音 <span class="pho">ʔ</span>，完整的音标应该是 <span class="pho alt">ˈʌʔ.oʊ</span>……
