# 发声器官

尽管说着不同的语言，人类的大脑构造和发声器官（articulators）构造却都是一样的。也正因为如此，所有的人类幼崽都具备习得地球上任何一种语言，甚至同时习得多种语言的潜能 —— 这其实还真是一个颇有些惊人却又常常被忽视甚至轻视的事实。

**说话**对大脑来说是一项异常复杂的活动，它大约总计需要协调差不多 100 块左右的肌肉配合着呼吸才能发出一个音素的声音[^1]，从而形成我们说出来的词汇和句子。

<video controls width="720"> <source src="/videos/speech-form-brain-signals.mp4" type="video/mp4"></source>Your browser does not support the video tag. </video>

> Brain signals precisely coordinate nearly 100 muscles to move the lips, jaw, tongue, and larynx, shaping our breath into sounds that form our words and sentences.

再详细一点，我们说话的时候动用的器官实际上很多，包括但不限于：下巴（*lower jaw*）、嘴唇（*lips*）、牙齿（*teeth*）、龈脊（*alveolar ridge*）、舌尖（*tongue tip*）、舌背（*tongue roof*）、软腭（*soft palate*）、咽（*pharynx*）、喉（*larynx*）、声带（*vocal cords*）等等。

![Speech Tract (zh-CN)](/images/articulators-cn.svg)

另外一个重要的方面是呼吸（*breathe*）—— 也就是说，肺也可以算作是发声器官 —— 呼吸不仅影响声音，也影响节奏；因为换气的必要，自然语流中总是存在停顿（*pause*）。

以下的 X 光视频展示了一个歌手在演唱歌曲时发声器官的活动情况[^2]：

<video controls width="720"> <source src="/videos/articulator-movement-singing.mp4" type="video/mp4"></source>Your browser does not support the video tag. </video>

某种意义上，“说话” 其实是 “**低配版唱歌**”，相对要求低一些…… 以下是朗读一些单词的时候发声器官活动情况的 3D 展示[^3]：

<video controls width="720"> <source src="/videos/3d-presentation.mp4" type="video/mp4"></source>Your browser does not support the video tag. </video>

“说外语”，本质上来看，就是 “**以另一种方式说话**” —— 也就是说，那么多的器官要协调在一起做之前可能完全不熟悉的动作，难度可想而知。

即便是让单一器官做不一样的动作也并非易事。

比如，你可以试试舌头。练一下就知道了，有意识地控制舌头是相当困难的。虽然我们的舌头事实上很灵活，几乎可以与我们的手相媲美，可问题在于，它处于一个我们用眼睛观察不到的部位 —— 如果没看过 X 光视频或者 3D 展示，我们可能都不知道自己的舌头究竟是怎样的形状 —— 学也好练也罢，相对于手多出了一整个维度的困难。

再比如，控制唇形也很难，虽然嘴唇通过照镜子是可以看到的。有两个元音，被称作 “圆元音”（*round vowels*）—— <span class="pho">ɔ</span> 和 <span class="pho">u</span>，需要把嘴唇略微缩作圆形，并且 <span class="pho">u</span> 还得嘴唇略微凸出…… 这好像并不难，可想要真正熟练，并且永远不出错，就没那么简单了。

不过，为了练好美式英语，你可能需要格外注意的发声器官其实只有两个，都是**舌头**（*tongue*）：

> * **舌尖**（适应若干个辅音发声的新的舌尖起始位置）
> * **舌背**（需要学习一个将它后缩的动作以便发出儿化音）

凡事都不容易，但，只要肯练，谁都可以掌握。

[^1]: https://www.youtube.com/watch?v=YHFx6O5x5Hw
[^2]: https://www.youtube.com/watch?v=2N5q85G3ydk
[^3]: https://www.youtube.com/watch?v=wYwk07QM4rc —— 这是 [Speech Graphics](https://www.speech-graphics.com) 为 [Saundz app](https://soundz.pro/)（[iOS](https://apps.apple.com/us/app/soundz/id6448163324)/Android 已无可用链接）开发的视频展示片段。

![vowels-mouth-ɔ-u](/images/vowels-mouth-ɔ-u.svg)
