# 1. 音素与音标

在自然语流中，不可继续分割的组成部分被称为**音素**（*phonemes*）。

英语的音素分为**元音**（*vowels*）和**辅音**（*consonants*）。**音标**（*phonetics*）是用来标记音素的符号系统 —— 每个音素都由一个独特的音标符号标记。

我们采用的是《剑桥英语发声词典》（[Cambridge English Pronouncing Dictionary](https://dictionary.cambridge.org/pronunciation/), i.e. *CEPD*）的音标标注体系。

在《剑桥英语发声词典》里，英式英语的音标采用 *D.J.* 音标，而美式英语的音标则采用国际音标（*IPA*）[^1]，并针对美式英语做了些 “优化”：

> * <span class="pho">ə</span> 的长短版本儿化音，分别是 <span class="pho">ɚ</span> 和 <span class="pho">ɝː</span>
> * <span class="pho">ə</span> 结尾的双元音和三元音，结尾的 <span class="pho">ə</span> 使用 <span class="pho">r</span> 替换，比如 <span class="pho">ɪə</span>  ⭢ <span class="pho">ɪr</span>，或者 <span class="pho">aʊə</span>  ⭢ <span class="pho">aʊr</span>
> * 短元音 <span class="pho">ɒ</span> 用 <span class="pho">ɑː</span> 标注
> * <span class="pho">t</span> 增加了一个弹舌音版本 <span class="pho">t̬</span>

以下的罗列部分基于[《剑桥英语发声词典》](https://dictionary.cambridge.org/pronunciation/)的官方音标指南，在此基础上做了一些补充并重新排序[^2]，并刻意减少了例词的数量。

> [!Note]
> 《剑桥英语发声词典》官方音标指南（Pronunciation symbols）：
> > https://dictionary.cambridge.org/help/phonetics.html

虽然我们的教程着重讲解的是 “**美式英语**” 语音，但，为了教学方便，也同时罗列了 “英式英语” 的音素和音标。

## 1.1. 元音

<table>
<tbody>
<tr>
<td colspan="2"><strong>British (24)</strong></td>
<td colspan="2"><strong>American (27)</strong></td>
</tr>
<tr>
<td>D.J.</td>
<td>例词（Example）</td>
<td>IPA</td>
<td>例词（Example）</td>
</tr>
<tr>
<td><span class="pho">ə</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_above_2023feb.mp3"></span></td>
<td><b>a</b>bout <span class="pho alt not-display">əˈbaʊt</span><span class="speak-word-inline" data-audio-uk-female="/audios/about-uk-female.mp3" data-audio-uk-male="/audios/about-uk-male.mp3"></span></td>
<td><span class="pho">ə</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_above_2023feb.mp3"></span></td>
<td><b>a</b>bout <span class="pho alt not-display">əˈbaʊt</span><span class="speak-word-inline" data-audio-us-female="/audios/about-us-female.mp3" data-audio-us-male="/audios/about-us-male.mp3"></span></td>
</tr>
<tr>
<td></td>
<td></td>
<td><span class="pho">ɚ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_mother_2023feb.mp3"></span></td>
<td>work<b>er</b> <span class="pho alt not-display">ˈwɝː.kɚ</span><span class="speak-word-inline" data-audio-us-female="/audios/worker-us-female.mp3" data-audio-us-male="/audios/worker-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɜː</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_bird_2023feb.mp3"></span></td>
<td>w<b>or</b>ker <span class="pho alt not-display">ˈwɜː.kə</span><span class="speak-word-inline" data-audio-uk-female="/audios/worker-uk-female.mp3" data-audio-uk-male="/audios/worker-uk-male.mp3"></span></td>
<td><span class="pho">ɝː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_bird_2023feb.mp3"></span></td>
<td>w<b>or</b>ker <span class="pho alt not-display">ˈwɝː.kɚ</span><span class="speak-word-inline" data-audio-us-female="/audios/worker-us-female.mp3" data-audio-us-male="/audios/worker-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ʌ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_cup_2023feb.mp3"></span></td>
<td>b<b>u</b>t <span class="pho alt not-display">bʌt</span><span class="speak-word-inline" data-audio-uk-female="/audios/but-uk-female.mp3" data-audio-uk-male="/audios/but-uk-male.mp3"></span></td>
<td><span class="pho">ʌ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_cup_2023feb.mp3"></span></td>
<td>b<b>u</b>t <span class="pho alt not-display">bʌt</span><span class="speak-word-inline" data-audio-us-female="/audios/but-us-female.mp3" data-audio-us-male="/audios/but-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɑː</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_father_2023feb.mp3"></span></td>
<td>f<b>a</b>ther <span class="pho alt not-display">ˈfɑː.ðər</span><span class="speak-word-inline" data-audio-uk-female="/audios/father-uk-female.mp3" data-audio-uk-male="/audios/father-uk-male.mp3"></span></td>
<td><span class="pho">ɑː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_father_2023feb.mp3"></span></td>
<td>f<b>a</b>ther <span class="pho alt not-display">ˈfɑː.ðɚ</span><span class="speak-word-inline" data-audio-us-female="/audios/father-us-female.mp3" data-audio-us-male="/audios/father-us-male.mp3"></span></td>
</tr>
<tr>
<td></td>
<td></td>
<td><span class="pho">ɑːr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_card_2023feb.mp3"></span></td>
<td>c<b>ar</b>d<span class="speak-word-inline" data-audio-us-female="/audios/card-us-female.mp3" data-audio-us-male="/audios/card-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɪ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_ship_2023feb.mp3"></span></td>
<td>th<b>i</b>s <span class="pho alt not-display">ðɪs</span><span class="speak-word-inline" data-audio-uk-female="/audios/this-uk-female.mp3" data-audio-uk-male="/audios/this-uk-male.mp3"></span></td>
<td><span class="pho">ɪ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_ship_2023feb.mp3"></span></td>
<td>th<b>i</b>s <span class="pho alt not-display">ðɪs</span><span class="speak-word-inline" data-audio-us-female="/audios/this-us-female.mp3" data-audio-us-male="/audios/this-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">iː</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_sheep_2023feb.mp3"></span></td>
<td>tr<b>ee</b> <span class="pho alt not-display">triː</span><span class="speak-word-inline" data-audio-uk-female="/audios/tree-uk-female.mp3" data-audio-uk-male="/audios/tree-uk-male.mp3"></span></td>
<td><span class="pho">iː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_sheep_2023feb.mp3"></span></td>
<td>tr<b>ee</b> <span class="pho alt not-display">triː</span><span class="speak-word-inline" data-audio-us-female="/audios/tree-us-female.mp3" data-audio-us-male="/audios/tree-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">i</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_happy_2023feb.mp3"></span></td>
<td>cit<b>y</b> <span class="pho alt not-display">ˈsɪt.i</span><span class="speak-word-inline" data-audio-uk-female="/audios/city-uk-female.mp3" data-audio-uk-male="/audios/city-uk-male.mp3"></span></td>
<td><span class="pho">i<span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_happy_2023feb.mp3"></span></span></td>
<td>cit<b>y</b> <span class="pho alt not-display">ˈsɪt̬.i</span><span class="speak-word-inline" data-audio-us-female="/audios/city-us-female.mp3" data-audio-us-male="/audios/city-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɪə</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_ear_2023feb.mp3"></span></td>
<td>id<b>ea</b> <span class="pho alt not-display">aɪˈdɪə</span><span class="speak-word-inline" data-audio-uk-female="/audios/idea-uk-female.mp3" data-audio-uk-male="/audios/idea-uk-male.mp3"></span></td>
<td><span class="pho">ɪr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_ear_2023feb.mp3"></span></td>
<td>g<b>ear</b> <span class="pho alt not-display">ɡɪr</span><span class="speak-word-inline" data-audio-us-female="/audios/gear-us-female.mp3" data-audio-us-male="/audios/gear-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ʊ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_foot_2023feb.mp3"></span></td>
<td>f<b>oo</b>t <span class="pho alt not-display">fʊt</span><span class="speak-word-inline" data-audio-uk-female="/audios/foot-uk-female.mp3" data-audio-uk-male="/audios/foot-uk-male.mp3"></span></td>
<td><span class="pho">ʊ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_foot_2023feb.mp3"></span></td>
<td>f<b>oo</b>t <span class="pho alt not-display">fʊt</span><span class="speak-word-inline" data-audio-us-female="/audios/foot-us-female.mp3" data-audio-us-male="/audios/foot-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">u</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_situation_2023feb.mp3"></span></td>
<td>sit<b>u</b>ation <span class="pho alt not-display">ˌsɪtʃ.uˈeɪ.ʃən</span><span class="speak-word-inline" data-audio-uk-female="/audios/situation-uk-female.mp3" data-audio-uk-male="/audios/situation-uk-male.mp3"></span></td>
<td><span class="pho">u</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_situation_2023feb.mp3"></span></td>
<td>sit<b>u</b>ation <span class="pho alt not-display">ˌsɪtʃ.uˈeɪ.ʃən</span><span class="speak-word-inline" data-audio-us-female="/audios/situation-us-female.mp3" data-audio-us-male="/audios/situation-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">uː</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_blue_2023feb.mp3"></span></td>
<td>m<b>oo</b>n <span class="pho alt not-display">muːn</span><span class="speak-word-inline" data-audio-uk-female="/audios/moon-uk-female.mp3" data-audio-uk-male="/audios/moon-uk-male.mp3"></span></td>
<td><span class="pho">uː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_blue_2023feb.mp3"></span></td>
<td>m<b>oo</b>n <span class="pho alt not-display">muːn</span><span class="speak-word-inline" data-audio-us-female="/audios/moon-us-female.mp3" data-audio-us-male="/audios/moon-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ʊə</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_pure_2023feb.mp3"></span></td>
<td>p<b>ure</b> <span class="pho alt not-display">pjʊə</span><span class="speak-word-inline" data-audio-uk-female="/audios/pure-uk-female.mp3" data-audio-uk-male="/audios/pure-uk-male.mp3"></span></td>
<td><span class="pho">ʊr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_pure_2023feb.mp3"></span></td>
<td>p<b>ure</b> <span class="pho alt not-display">pjʊr</span><span class="speak-word-inline" data-audio-us-female="/audios/pure-us-female.mp3" data-audio-us-male="/audios/pure-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">e</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_head_2023feb.mp3"></span></td>
<td>ch<b>e</b>ck <span class="pho alt not-display">tʃek</span><span class="speak-word-inline" data-audio-uk-female="/audios/check-uk-female.mp3" data-audio-uk-male="/audios/check-uk-male.mp3"></span></td>
<td><span class="pho">e</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_head_2023feb.mp3"></span></td>
<td>ch<b>e</b>ck <span class="pho alt not-display">tʃek</span><span class="speak-word-inline" data-audio-us-female="/audios/check-us-female.mp3" data-audio-us-male="/audios/check-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">æ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_hat_2023feb.mp3"></span></td>
<td>th<b>a</b>nk <span class="pho alt not-display">θæŋk</span><span class="speak-word-inline" data-audio-uk-female="/audios/thank-uk-female.mp3" data-audio-uk-male="/audios/thank-uk-male.mp3"></span></td>
<td><span class="pho">æ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_hat_2023feb.mp3"></span></td>
<td>th<b>a</b>nk <span class="pho alt not-display">θæŋk</span><span class="speak-word-inline" data-audio-us-female="/audios/thank-us-female.mp3" data-audio-us-male="/audios/thank-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">eə</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_hair_2023feb.mp3"></span></td>
<td><b>air</b> <span class="pho alt not-display">eə</span><span class="speak-word-inline" data-audio-uk-female="/audios/air-uk-female.mp3" data-audio-uk-male="/audios/air-uk-male.mp3"></span></td>
<td><span class="pho">er</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_hair_2023feb.mp3"></span></td>
<td><b>air</b> <span class="pho alt not-display">er</span><span class="speak-word-inline" data-audio-us-female="/audios/air-us-female.mp3" data-audio-us-male="/audios/air-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɒ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_sock_2023feb.mp3"></span></td>
<td>d<b>o</b>g <span class="pho alt not-display">dɒɡ</span><span class="speak-word-inline" data-audio-uk-female="/audios/dog-uk-female.mp3" data-audio-uk-male="/audios/dog-uk-male.mp3"></span></td>
<td><span class="pho">ɑː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_father_2023feb.mp3"></span></td>
<td>d<b>o</b>g <span class="pho alt not-display">dɑːɡ</span><span class="speak-word-inline" data-audio-us-female="/audios/dog-us-female.mp3" data-audio-us-male="/audios/dog-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɔː</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_horse_2023feb.mp3"></span></td>
<td>redr<b>aw</b> <span class="pho alt not-display">ˌriːˈdrɔː</span><span class="speak-word-inline" data-audio-uk-female="/audios/redraw-uk-female.mp3" data-audio-uk-male="/audios/redraw-uk-male.mp3"></span></td>
<td><span class="pho">ɔː</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_horse_2023feb.mp3"></span></td>
<td>redr<b>aw</b> <span class="pho alt not-display">ˌriːˈdrɔː</span><span class="speak-word-inline" data-audio-us-female="/audios/redraw-us-female.mp3" data-audio-us-male="/audios/redraw-us-male.mp3"></span></td>
</tr>
<tr>
<td></td>
<td></td>
<td><span class="pho">ɔːr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_ho_rse_2023feb.mp3"></span></td>
<td>sh<b>ore</b><span class="pho alt not-display">ʃɔːr</span><span class="speak-word-inline" data-audio-us-female="/audios/shore-us-female.mp3" data-audio-us-male="/audios/shore-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">aɪ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_eye_2023feb.mp3"></span></td>
<td>dr<b>y</b> <span class="pho alt not-display">draɪ</span><span class="speak-word-inline" data-audio-uk-female="/audios/dry-uk-female.mp3" data-audio-uk-male="/audios/dry-uk-male.mp3"></span></td>
<td><span class="pho">aɪ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_eye_2023feb.mp3"></span></td>
<td>dr<b>y</b> <span class="pho alt not-display">draɪ</span><span class="speak-word-inline" data-audio-us-female="/audios/dry-us-female.mp3" data-audio-us-male="/audios/dry-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">aɪə</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_fire_2023feb.mp3"></span></td>
<td>f<b>ire</b> <span class="pho alt not-display">faɪə</span><span class="speak-word-inline" data-audio-uk-female="/audios/fire-uk-female.mp3" data-audio-uk-male="/audios/fire-uk-male.mp3"></span></td>
<td><span class="pho">aɪr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_fire_2023feb.mp3"></span></td>
<td>f<b>ire</b> <span class="pho alt not-display">faɪr</span><span class="speak-word-inline" data-audio-us-female="/audios/fire-us-female.mp3" data-audio-us-male="/audios/fire-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">eɪ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_day_2023feb_002.mp3"></span></td>
<td>t<b>a</b>ke <span class="pho alt not-display">teɪk</span><span class="speak-word-inline" data-audio-uk-female="/audios/take-uk-female.mp3" data-audio-uk-male="/audios/take-uk-male.mp3"></span></td>
<td><span class="pho">eɪ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_day_2023feb_002.mp3"></span></td>
<td>t<b>a</b>ke <span class="pho alt not-display">teɪk</span><span class="speak-word-inline" data-audio-us-female="/audios/take-us-female.mp3" data-audio-us-male="/audios/take-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ɔɪ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_boy_2023feb.mp3"></span></td>
<td>v<b>oi</b>ce <span class="pho alt not-display">vɔɪs</span><span class="speak-word-inline" data-audio-uk-female="/audios/voice-uk-female.mp3" data-audio-uk-male="/audios/voice-uk-male.mp3"></span></td>
<td><span class="pho">ɔɪ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_boy_2023feb.mp3"></span></td>
<td>v<b>oi</b>ce <span class="pho alt not-display">vɔɪs</span><span class="speak-word-inline" data-audio-us-female="/audios/voice-us-female.mp3" data-audio-us-male="/audios/voice-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">aʊ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_mouth_2023feb.mp3"></span></td>
<td>h<b>ow</b> <span class="pho alt not-display">haʊ</span><span class="speak-word-inline" data-audio-uk-female="/audios/how-uk-female.mp3" data-audio-uk-male="/audios/how-uk-male.mp3"></span></td>
<td><span class="pho">aʊ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_mouth_2023feb.mp3"></span></td>
<td>h<b>ow</b> <span class="pho alt not-display">haʊ</span><span class="speak-word-inline" data-audio-us-female="/audios/how-us-female.mp3" data-audio-us-male="/audios/how-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">aʊə</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_hour_2023feb.mp3"></span></td>
<td>h<b>our</b> <span class="pho alt not-display">aʊər</span><span class="speak-word-inline" data-audio-uk-female="/audios/hour-uk-female.mp3" data-audio-uk-male="/audios/hour-uk-male.mp3"></span></td>
<td><span class="pho">aʊr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_hour_2023feb.mp3"></span></td>
<td>h<b>our</b> <span class="pho alt not-display">aʊr</span><span class="speak-word-inline" data-audio-us-female="/audios/hour-us-female.mp3" data-audio-us-male="/audios/hour-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">əʊ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_nose_2023feb.mp3"></span></td>
<td>n<b>o</b>se <span class="pho alt not-display">nəʊz</span><span class="speak-word-inline" data-audio-uk-female="/audios/nose-uk-female.mp3" data-audio-uk-male="/audios/nose-uk-male.mp3"></span></td>
<td><span class="pho">oʊ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_nose_2023feb.mp3"></span></td>
<td>n<b>o</b>se <span class="pho alt not-display">noʊz</span><span class="speak-word-inline" data-audio-us-female="/audios/nose-us-female.mp3" data-audio-us-male="/audios/nose-us-male.mp3"></span></td>
</tr>
</tbody>
</table>

> [!Note]
>
> [《剑桥英语发声词典》官方音标指南](https://dictionary.cambridge.org/help/phonetics.html)中除了 <span class="pho">ɚ</span> 和 <span class="pho">ɝː</span> 之外，其它元音的美式英语儿化音都没有罗列，比如，
<span class="pho">ɑːr</span>、<span class="pho">ɔːr</span>、<span class="pho">er</span>、<span class="pho">ɪr</span>、<span class="pho">ʊr</span>、<span class="pho">aɪr</span>、<span class="pho">aʊr</span>。

## 1.2. 辅音

<table>
<tbody>
<tr>
<td colspan="2"><strong>British (28)</strong></td>
<td colspan="2"><strong>American (29)</strong></td>
</tr>
<tr>
<td>D.J.</td>
<td>例词（Example）</td>
<td>IPA</td>
<td>例词（Example）</td>
</tr>
<tr>
<td><span class="pho">p</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_pen_2023feb.mp3"></span></td>
<td><b>p</b>oor <span class="pho alt not-display">pɔː</span><span class="speak-word-inline" data-audio-uk-female="/audios/poor-uk-female.mp3" data-audio-uk-male="/audios/poor-uk-male.mp3"></span></td>
<td><span class="pho">p</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_pen_2023feb.mp3"></span></td>
<td><b>p</b>oor <span class="pho alt not-display">pʊr</span><span class="speak-word-inline" data-audio-us-female="/audios/poor-us-female.mp3" data-audio-us-male="/audios/poor-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">b</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_book_2023feb.mp3"></span></td>
<td><b>b</b>ut <span class="pho alt not-display">bʌt</span><span class="speak-word-inline" data-audio-uk-female="/audios/but-uk-female.mp3" data-audio-uk-male="/audios/but-uk-male.mp3"></span></td>
<td><span class="pho">b</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_book_2023feb.mp3"></span></td>
<td><b>b</b>ut <span class="pho alt not-display">bʌt</span><span class="speak-word-inline" data-audio-us-female="/audios/but-us-female.mp3" data-audio-us-male="/audios/but-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">t</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_town_2023feb.mp3"></span></td>
<td><b>t</b>ake <span class="pho alt not-display">teɪk</span><span class="speak-word-inline" data-audio-uk-female="/audios/take-uk-female.mp3" data-audio-uk-male="/audios/take-uk-male.mp3"></span></td>
<td><span class="pho">t</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_town_2023feb.mp3"></span></td>
<td><b>t</b>ake <span class="pho alt not-display">teɪk</span><span class="speak-word-inline" data-audio-us-female="/audios/take-us-female.mp3" data-audio-us-male="/audios/take-us-male.mp3"></span></td>
</tr>
<tr>
<td></td>
<td></td>
<td><span class="pho">t̬</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_cutting_2023feb.mp3"></span></td>
<td>ci<b>t</b>y <span class="pho alt not-display">ˈsɪt̬.i</span><span class="speak-word-inline" data-audio-us-female="/audios/city-us-female.mp3" data-audio-us-male="/audios/city-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">d</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_day_2023feb_001.mp3"></span></td>
<td><b>d</b>og <span class="pho alt not-display">dɒɡ</span><span class="speak-word-inline" data-audio-uk-female="/audios/dog-uk-female.mp3" data-audio-uk-male="/audios/dog-uk-male.mp3"></span></td>
<td><span class="pho">d</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_day_2023feb_001.mp3"></span></td>
<td><b>d</b>og <span class="pho alt not-display">dɑːɡ</span><span class="speak-word-inline" data-audio-us-female="/audios/dog-us-female.mp3" data-audio-us-male="/audios/dog-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">k</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_cat_2023feb.mp3"></span></td>
<td><b>c</b>ard <span class="pho alt not-display">kɑːd</span><span class="speak-word-inline" data-audio-uk-female="/audios/card-uk-female.mp3" data-audio-uk-male="/audios/card-uk-male.mp3"></span></td>
<td><span class="pho">k</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_cat_2023feb.mp3"></span></td>
<td><b>c</b>ard <span class="pho alt not-display">kɑːrd</span><span class="speak-word-inline" data-audio-us-female="/audios/card-us-female.mp3" data-audio-us-male="/audios/card-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">g</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_give_2023feb.mp3"></span></td>
<td><b>g</b>ear <span class="pho alt not-display">ɡɪə</span><span class="speak-word-inline" data-audio-uk-female="/audios/gear-uk-female.mp3" data-audio-uk-male="/audios/gear-uk-male.mp3"></span></td>
<td><span class="pho">g</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_give_2023feb.mp3"></span></td>
<td><b>g</b>ear <span class="pho alt not-display">ɡɪr</span><span class="speak-word-inline" data-audio-us-female="/audios/gear-us-female.mp3" data-audio-us-male="/audios/gear-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">f</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_fish_2023feb.mp3"></span></td>
<td><b>f</b>ire <span class="pho alt not-display">faɪə</span><span class="speak-word-inline" data-audio-uk-female="/audios/fire-uk-female.mp3" data-audio-uk-male="/audios/fire-uk-male.mp3"></span></td>
<td><span class="pho">f</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_fish_2023feb.mp3"></span></td>
<td><b>f</b>ire <span class="pho alt not-display">faɪr</span><span class="speak-word-inline" data-audio-us-female="/audios/fire-us-female.mp3" data-audio-us-male="/audios/fire-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">v</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_very_2023feb.mp3"></span></td>
<td><b>v</b>oice <span class="pho alt not-display">vɔɪs</span><span class="speak-word-inline" data-audio-uk-female="/audios/voice-uk-female.mp3" data-audio-uk-male="/audios/voice-uk-male.mp3"></span></td>
<td><span class="pho">v</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_very_2023feb.mp3"></span></td>
<td><b>v</b>oice <span class="pho alt not-display">vɔɪs</span><span class="speak-word-inline" data-audio-us-female="/audios/voice-us-female.mp3" data-audio-us-male="/audios/voice-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">s</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_say_2023feb.mp3"></span></td>
<td><b>s</b>ituation <span class="pho alt not-display">ˌsɪtʃ.uˈeɪ.ʃən</span><span class="speak-word-inline" data-audio-uk-female="/audios/situation-uk-female.mp3" data-audio-uk-male="/audios/situation-uk-male.mp3"></span></td>
<td><span class="pho">s</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_say_2023feb.mp3"></span></td>
<td><b>s</b>ituation <span class="pho alt not-display">ˌsɪtʃ.uˈeɪ.ʃən</span><span class="speak-word-inline" data-audio-us-female="/audios/situation-us-female.mp3" data-audio-us-male="/audios/situation-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">z</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_zoo_2023feb.mp3"></span></td>
<td><b>z</b>oo <span class="pho alt not-display">zuː</span><span class="speak-word-inline" data-audio-uk-female="/audios/zoo-uk-female.mp3" data-audio-uk-male="/audios/zoo-uk-male.mp3"></span></td>
<td><span class="pho">z</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_zoo_2023feb.mp3"></span></td>
<td><b>z</b>oo <span class="pho alt not-display">zuː</span><span class="speak-word-inline" data-audio-us-female="/audios/zoo-us-female.mp3" data-audio-us-male="/audios/zoo-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">θ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_think_2023feb.mp3"></span></td>
<td><b>th</b>ank <span class="pho alt not-display">θæŋk</span><span class="speak-word-inline" data-audio-uk-female="/audios/thank-uk-female.mp3" data-audio-uk-male="/audios/thank-uk-male.mp3"></span></td>
<td><span class="pho">θ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_think_2023feb.mp3"></span></td>
<td><b>th</b>ank <span class="pho alt not-display">θæŋk</span><span class="speak-word-inline" data-audio-us-female="/audios/thank-us-female.mp3" data-audio-us-male="/audios/thank-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ð</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_this_2023feb.mp3"></span></td>
<td><b>th</b>is <span class="pho alt not-display">ðɪs</span><span class="speak-word-inline" data-audio-uk-female="/audios/this-uk-female.mp3" data-audio-uk-male="/audios/this-uk-male.mp3"></span></td>
<td><span class="pho">ð</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_this_2023feb.mp3"></span></td>
<td><b>th</b>is <span class="pho alt not-display">ðɪs</span><span class="speak-word-inline" data-audio-us-female="/audios/this-us-female.mp3" data-audio-us-male="/audios/this-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ʃ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_she_2023feb.mp3"></span></td>
<td><b>sh</b>ore <span class="pho alt not-display">ʃɔːr</span><span class="speak-word-inline" data-audio-uk-female="/audios/shore-uk-female.mp3" data-audio-uk-male="/audios/shore-uk-male.mp3"></span></td>
<td><span class="pho">ʃ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_she_2023feb.mp3"></span></td>
<td><b>sh</b>ore <span class="pho alt not-display">ʃɔːr</span><span class="speak-word-inline" data-audio-us-female="/audios/shore-us-female.mp3" data-audio-us-male="/audios/shore-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ʒ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_vision_2023feb.mp3"></span></td>
<td>vi<b>s</b>ion <span class="pho alt not-display">ˈvɪʒ.ən</span><span class="speak-word-inline" data-audio-uk-female="/audios/vision-uk-female.mp3" data-audio-uk-male="/audios/vision-uk-male.mp3"></span></td>
<td><span class="pho">ʒ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_vision_2023feb.mp3"></span></td>
<td>vi<b>s</b>ion <span class="pho alt not-display">ˈvɪʒ.ən</span><span class="speak-word-inline" data-audio-us-female="/audios/vision-us-female.mp3" data-audio-us-male="/audios/vision-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">tʃ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_cheese_2023feb.mp3"></span></td>
<td><b>ch</b>eck <span class="pho alt not-display">tʃek</span><span class="speak-word-inline" data-audio-uk-female="/audios/check-uk-female.mp3" data-audio-uk-male="/audios/check-uk-male.mp3"></span></td>
<td><span class="pho">tʃ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_cheese_2023feb.mp3"></span></td>
<td><b>ch</b>eck <span class="pho alt not-display">tʃek</span><span class="speak-word-inline" data-audio-us-female="/audios/check-us-female.mp3" data-audio-us-male="/audios/check-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">dʒ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_jump_2023feb.mp3"></span></td>
<td><b>j</b>et <span class="pho alt not-display">dʒet</span><span class="speak-word-inline" data-audio-uk-female="/audios/jet-uk-female.mp3" data-audio-uk-male="/audios/jet-uk-male.mp3"></span></td>
<td><span class="pho">dʒ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_jump_2023feb.mp3"></span></td>
<td><b>j</b>et <span class="pho alt not-display">dʒet</span><span class="speak-word-inline" data-audio-us-female="/audios/jet-us-female.mp3" data-audio-us-male="/audios/jet-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">tr</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_tra_2023feb.mp3"></span></td>
<td><b>tr</b>ee <span class="pho alt not-display">triː</span><span class="speak-word-inline" data-audio-uk-female="/audios/tree-uk-female.mp3" data-audio-uk-male="/audios/tree-uk-male.mp3"></span></td>
<td><span class="pho">tr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_tra_2023feb.mp3"></span></td>
<td><b>tr</b>ee <span class="pho alt not-display">triː</span><span class="speak-word-inline" data-audio-us-female="/audios/tree-us-female.mp3" data-audio-us-male="/audios/tree-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">dr</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_dra_2023feb.mp3"></span></td>
<td><b>dr</b>y <span class="pho alt not-display">draɪ</span><span class="speak-word-inline" data-audio-uk-female="/audios/dry-uk-female.mp3" data-audio-uk-male="/audios/dry-uk-male.mp3"></span></td>
<td><span class="pho">dr</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_dra_2023feb.mp3"></span></td>
<td><b>dr</b>y <span class="pho alt not-display">draɪ</span><span class="speak-word-inline" data-audio-us-female="/audios/dry-us-female.mp3" data-audio-us-male="/audios/dry-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ts</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_cats.mp3"></span></td>
<td>ca<b>ts</b> <span class="pho alt not-display">kæts</span><span class="speak-word-inline" data-audio-uk-female="/audios/cats-uk-female.mp3" data-audio-uk-male="/audios/cats-uk-male.mp3"></span></td>
<td><span class="pho">ts</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_cats.mp3"></span></td>
<td>ca<b>ts</b> <span class="pho alt not-display">kæts</span><span class="speak-word-inline" data-audio-us-female="/audios/cats-us-female.mp3" data-audio-us-male="/audios/cats-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">dz</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_kids.mp3"></span></td>
<td>ki<b>ds</b> <span class="pho alt not-display">kɪdz</span><span class="speak-word-inline" data-audio-uk-female="/audios/kids-uk-female.mp3" data-audio-uk-male="/audios/kids-uk-male.mp3"></span></td>
<td><span class="pho">dz</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_kids.mp3"></span></td>
<td>ki<b>ds</b> <span class="pho alt not-display">kɪdz</span><span class="speak-word-inline" data-audio-us-female="/audios/kids-us-female.mp3" data-audio-us-male="/audios/kids-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">m</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_moon_2023feb.mp3"></span></td>
<td><b>m</b>oon <span class="pho alt not-display">muːn</span><span class="speak-word-inline" data-audio-uk-female="/audios/moon-uk-female.mp3" data-audio-uk-male="/audios/moon-uk-male.mp3"></span></td>
<td><span class="pho">m</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_moon_2023feb.mp3"></span></td>
<td><b>m</b>oon <span class="pho alt not-display">muːn</span><span class="speak-word-inline" data-audio-us-female="/audios/moon-us-female.mp3" data-audio-us-male="/audios/moon-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">n</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_name_2023feb.mp3"></span></td>
<td><b>n</b>ose <span class="pho alt not-display">nəʊz</span><span class="speak-word-inline" data-audio-uk-female="/audios/nose-uk-female.mp3" data-audio-uk-male="/audios/nose-uk-male.mp3"></span></td>
<td><span class="pho">n</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_name_2023feb.mp3"></span></td>
<td><b>n</b>ose <span class="pho alt not-display">noʊz</span><span class="speak-word-inline" data-audio-us-female="/audios/nose-us-female.mp3" data-audio-us-male="/audios/nose-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">ŋ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_sing_2023feb.mp3"></span></td>
<td>tha<b>n</b>k <span class="pho alt not-display">θæŋk</span><span class="speak-word-inline" data-audio-uk-female="/audios/thank-uk-female.mp3" data-audio-uk-male="/audios/thank-uk-male.mp3"></span></td>
<td><span class="pho">ŋ</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_sing_2023feb.mp3"></span></td>
<td>tha<b>n</b>k <span class="pho alt not-display">θæŋk</span><span class="speak-word-inline" data-audio-us-female="/audios/thank-us-female.mp3" data-audio-us-male="/audios/thank-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">l</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_look_2023feb.mp3"></span></td>
<td><b>l</b>ure <span class="pho alt not-display">lʊə</span><span class="speak-word-inline" data-audio-uk-female="/audios/lure-uk-female.mp3" data-audio-uk-male="/audios/lure-uk-male.mp3"></span></td>
<td><span class="pho">l</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_look_2023feb.mp3"></span></td>
<td><b>l</b>ure <span class="pho alt not-display">lʊr</span><span class="speak-word-inline" data-audio-us-female="/audios/lure-us-female.mp3" data-audio-us-male="/audios/lure-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">r</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_run_2023feb.mp3"></span></td>
<td><b>r</b>edraw <span class="pho alt not-display">ˌriːˈdrɔː</span><span class="speak-word-inline" data-audio-uk-female="/audios/redraw-uk-female.mp3" data-audio-uk-male="/audios/redraw-uk-male.mp3"></span></td>
<td><span class="pho">r</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_run_2023feb.mp3"></span></td>
<td><b>r</b>edraw <span class="pho alt not-display">ˌriːˈdrɔː</span><span class="speak-word-inline" data-audio-us-female="/audios/redraw-us-female.mp3" data-audio-us-male="/audios/redraw-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">w</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_we_2023feb.mp3"></span></td>
<td><b>w</b>orker <span class="pho alt not-display">ˈwɜː.kə</span><span class="speak-word-inline" data-audio-uk-female="/audios/worker-uk-female.mp3" data-audio-uk-male="/audios/worker-uk-male.mp3"></span></td>
<td><span class="pho">w</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_we_2023feb.mp3"></span></td>
<td><b>w</b>orker <span class="pho alt not-display">ˈwɝː.kɚ</span><span class="speak-word-inline" data-audio-us-female="/audios/worker-us-female.mp3" data-audio-us-male="/audios/worker-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">j</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_yes_2023feb.mp3"></span></td>
<td><b>y</b>es <span class="pho alt not-display">jes</span><span class="speak-word-inline" data-audio-uk-female="/audios/yes-uk-female.mp3" data-audio-uk-male="/audios/yes-uk-male.mp3"></span></td>
<td><span class="pho">j</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_yes_2023feb.mp3"></span></td>
<td><b>y</b>es <span class="pho alt not-display">jes</span><span class="speak-word-inline" data-audio-us-female="/audios/yes-us-female.mp3" data-audio-us-male="/audios/yes-us-male.mp3"></span></td>
</tr>
<tr>
<td><span class="pho">h</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_hand_2023feb.mp3"></span></td>
<td><b>h</b>ow <span class="pho alt not-display">haʊ</span><span class="speak-word-inline" data-audio-uk-female="/audios/how-uk-female.mp3" data-audio-uk-male="/audios/how-uk-male.mp3"></span></td>
<td><span class="pho">h</span><span class="speak-word-inline" data-audio-us-male="/audios/us_phonetics_sound_hand_2023feb.mp3"></span></td>
<td><b>h</b>ow  <span class="pho alt not-display">haʊ</span><span class="speak-word-inline" data-audio-us-female="/audios/how-us-female.mp3" data-audio-us-male="/audios/how-us-male.mp3"></span></td>
</tr>
</tbody>
</table>

> [!Note]
>
> [《剑桥英语发声词典》官方音标指南](https://dictionary.cambridge.org/help/phonetics.html)中没有罗列 <span class="pho">tr</span> 和 <span class="pho">dr</span>。

## 1.3. 外来音素

| 音素/音标                                                                                                                                                                                                      | 例词                                                                                                                                                                                                                                 |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| <span class="pho">ɒ̃</span> <span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_croissant_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_sound_croissant_2023feb.mp3"></span> | croiss**ant** <span class="pho alt">ˈkwɑ.sɒ̃ŋ</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_word_croissant_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_word_croissant_2023feb.mp3"></span> |
| <span class="pho">x</span> <span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_sound_loch_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_sound_loch_2023feb.mp3"></span>           | lo**ch** <span class="pho alt">lɒx</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_word_loch_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_word_loch_2023feb.mp3"></span>                     |

## 1.4. 其他符号

| 符号                       | 例词                                                                                                                                                                                                                               |
| -------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| <span class="pho">.</span> | system <span class="pho alt">ˈsɪs.təm</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_word_system_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_word_system_2023feb.mp3"></span>            |
| <span class="pho">ˈ</span> | surprise <span class="pho alt">sɚˈpraɪz, sə-</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_word_surprise_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_word_surprise_2023feb.mp3"></span> |
| <span class="pho">ˌ</span> | retell <span class="pho alt">ˌriːˈtel</span><span class="speak-word-inline" data-audio-uk-male="/audios/uk_phonetics_word_retell_2023feb.mp3" data-audio-us-male="/audios/us_phonetics_word_retell_2023feb.mp3"></span>            |

## 1.5. 自定义补充符号

| 符号                                                   | 含义                                                                        |
| ------------------------------------------------------ | --------------------------------------------------------------------------- |
| <span class="pho">ɤ</span>                             | 比 *schwa* <span class="pho">ə</span> 更轻的近乎于无的元音                  |
| <span class="pho">ʔ</span>                             | <span class="pho">t</span> 的喉塞音版本                                     |
| <span class="pho">ᵗ</span>/<span class="pho">◌̥</span>  | 可选 <span class="pho">t</span> 或者 <span class="pho">t̥</span>，即，不发声 |
| <span class="pho">◌̚ </span>/<span class="pho">◌̥</span> | 清辅音的阻塞音符号（可与 /<span class="pho">◌̥</span> 通用，都不发声）         |
| <span class="pho">ᵊ</span>                             | 音节辅音  <span class="pho">l, m, n, r</span> 之前的附带元音                |
| <span class="pho">ʲ</span>                             | 音节之间的加音 <span class="pho">j</span>                                   |
| <span class="pho">ʷ</span>                             | 音节之间的加音 <span class="pho">w</span>                                   |
| <span class="pho">◌̅, ◌́, ◌̀</span>                       | 音节声调，平、升、降                                                        |
| <span class="pho">◌̂</span>                             | 音高被抬高的音节                                                            |
| <span class="pho">·</span>                             | 音节之间的停顿（*stop*）                                                    |
| <span class="pho">◌‿◌</span>                           | 连读符号                                                                    |
| <span class="pho">｜</span>                            | 单词之间分割意群的暂停（*pause*）                                           |

> [!Note]
>
> 你可能注意到了，同一个基础音素的变体，可能用了不同的写法，比如， <span class="pho">ɑ</span> 这个基础音素，短元音用的是 <span class="pho">ʌ</span>，长元音不是 <span class="pho">ʌː</span> 而是 <span class="pho">ɑː</span>，而后组合成双元音的时候用的是 <span class="pho">a</span> —— <span class="pho">aɪ，aʊ</span> 等等……
>
> 这么做的理由在于，当这些音素连在一起的时候，不可能被错误组合，不会产生混淆，所以要确保每个音素都有一个独特对应的符号[^3]。

[^1]: 教程内音标字体选用的是 *Charis SIL*，https://software.sil.org/charis/
[^2]: 音素的语音文件来自剑桥官方网站；例词的语音文件大部分使用 [Microsoft Edge TTS](https://github.com/rany2/edge-tts) 生成，声音角色选择分别是：*en-GB-ThomasNeural*，*en-GB-MaisieNeural*，*en-US-RogerNeural*，和 *en-US-JennyNeural*
[^3]: 现在几乎所有词典都声称自己采用国际音标（IPA），但它们无一例外，都是国际音标的一个 “**自定义子集**”。
