# 10. 返璞归真

原本，学习是天下最有趣，进步是最令人痴迷…… 可为什么到最后人们竟然几乎全都对学习失去了兴趣，对进步也不再抱有任何幻想了呢？这种奇怪的现象到了什么地步呢？我们可以从那些哪怕最终做得还算不错的人传授经验时所用的措辞就可以窥见一斑：

> 一定要下**苦**功夫**笨**功夫……

哪怕换成诗意一点的训诫，也还是 “书山有路勤为径，学海无涯**苦**作舟” —— 搞得好像只有**苦大仇深**才是真正的动力一样。

## 1. 曾经的天才

如果我们能够穿越回去，仔细观察刚刚出生的我们自己，我们每个人都会发出一模一样的惊叹 —— “**那时候的我真聪明，完全是个天才！**” 说实话，每一个父母当时也不止一次如此慨叹过。小孩子就是很聪明，小孩子就是很厉害，很多事情竟然可以不教就会，很多事情竟然可以那么早就能做到做好……

事实上，这真不是幻觉。每个新生大脑，都是非常完善的**贝叶斯推理机**，都是**超级学习机器**。把贝叶斯推理写出来，当然是用数学这个 “**人工语言**” 书写的公式：

> $P(H|e) = \frac{P(H) \times P(e|H)}{P(e)}$

用 “**自然语言**” 尽量简单地描述的话，就是：

> 贝叶斯推理就是 “不断使用新的证据调整预测模型参数进而提高预测准确度的过程”。

你小时候拿着弹弓打树上的鸟，就是一个**贝叶斯推理过程**。你有个**模型**，这个模型有一些**参数**，比如，你手臂举起来的高度和角度，皮筋被拉长的程度、小石块的大小等等，你的**预测**是**打中树上那只小鸟**……

当然，第一次你没有打中。

但是，那射出去的那石头的轨迹，对你来说是**新的证据**，然后，你会根据这个新的证据调整你的**预测模型**的**参数**，可能是同时调整多个参数，也可能是只调整某个特定的参数…… 然后**再来一次**，成了就成了，不成的话，你就再一次根据新的证据去做调整…… 直至预测的准确度提高到足够用的地步……

这就是贝叶斯推理过程。虽然你不知道贝叶斯定理是什么，那时候当然也不曾听说，但你小时候很早就不止一次地这么干过。

事实上，你人生第一次应用贝叶斯定理去做推理，是你甚至不会说话的时候 —— 因为**你天生就会**。婴儿在学说话的时候，采用的并不是成年人学习第二语言的方式，而是用本质上等同于贝叶斯推理过程的反复试错排除法。

他们先学会的并不是某句话或者某个词汇的真实含义，他们只是记住了声音，即，音素的组合 —— 当然，那么复杂的音素组合在他们甚至说不出来的时候就能记住，绝对是了不起的杂技。然后他们最后是如何知道那个声音究竟是什么意思的呢？通过一次又一次的尝试排除非正确选项，最终找到正确答案……

**试错排除** —— 我们所说的**生学硬练** —— 并不像看起来的那么低效，事实上，恰恰相反，它异常高效 —— 这也是每个孩子都是天才的原因 —— 注意措辞，我说的不是 “每个孩子都**像**天才”，而是，“每个孩子都**是**天才”…… 因为他们的的确确就是天才 —— 就在于每个新生大脑都是**天生且不知疲倦的贝叶斯推理机**。

天才到什么地步呢？

> 任何健康出生的婴儿都天生具备习得地球上任何语言的潜力。

请注意这句话中的措辞，两个 “**任何**”。试想，有一对双胞胎，刚出生就分别被带到两个国家的家庭收养，那么，最终这对基因上最接近的两个人类幼崽，各自会习得不同的 “母语” —— 人们过去觉得神秘且难以逾越的 “关键期” 或者 “敏感期” 在这件事儿上发挥不了任何作用。这样的案例也无需凭空杜撰，历史上很多次战争之后都有双胞胎被不同国家的人收养的诸多案例。

语言是什么来着？语言是一切知识的基础，甚至天下所有的学科到最后都是 “语文”。所以说，每个婴儿都是**天生超级学习机器**，每个婴儿的大脑具备习得天下所有科目的潜力 —— 这是事实，尽管是惊人的事实。

“超级” 的意思是说，这种学习机器不仅是天生的，并且还真的天生超级。在两岁之前，即便还不会说话的时候，他们已经习得很多元音的区别了……当他们吹灭第一根蜡烛的时候，他们已经在几个层面上为其母语的主要规则打下了基础，从基本的声音、音素到韵律、词汇和甚至一些语法规则……

不仅如此，他们还记忆力超群。两三岁孩子的家长时常会惊讶不已，因为他们发现自己的孩子吐字还不清晰的时候，竟然在他们事实上并不理解内容含义的前提下，整段流利且毫无遗漏地背诵诗词或者篇章 —— 虽然篇幅可能短了点。家长们之所以惊讶，是因为他们知道自己完全不可能在不经意之间背下一段自己并不了解含义的文字。

人们经常开玩笑，说这是 “**四年级之前的天才**”。孩子还在四年级之前的时候，家长们总是忍不住在朋友圈晒娃…… 不过，只要孩子过了这个阶段，也就是十来岁的时候，家长们开始不约而同地停止晒娃。为什么？因为到了这时候，家长们开始 “**发现**” 自己的孩子正在不可避免地走向**平庸**，再也看不出当初的聪明当初的天才，甚至再也想象不出当初那种学啥都快学啥都会的样子……

有人会说，“谁不觉得自己家孩子好呢？” —— 所以，他们认为觉得自家孩子聪明觉得自家孩子天才，完全是普遍的幻觉。实际上，这才是真正的幻觉。天下哪儿有不起作用的贝叶斯推理机？哪儿有不好的天生超级学习机器？

聪明怎么就不见了呢？天才怎么就消失了呢？令人遗憾且又颇令人心寒的一个事实是：

> 整个教育体系在长期持续且又系统化地破坏贝叶斯推理机。

这不是哪个国家的问题，全球的教育体系在这方面都一样，都是**好心办坏事** —— 这倒也是整个世界运转过程中竟然出现的现象：**好的意图并不一定保证好的结果**。

人们在上学之前，各个都是天才。

> 他们对什么都**好奇**，不管什么都**敢于尝试**，做什么都很**专注**，**不知疲倦不怕重复，不知道枯燥为何物**，更重要的是，**完全不在意他人的看法**……

所谓的 “天才” 不就是这样的吗？

## 2. 学校的问题

### 2.1. 华而不实

之前我们就讨论过教育的**华而不实**。学校里只管发书讲课 —— 这只是知识获取而已，事实上最不值钱的服务。我们早就生活在一个知识获取成本可以几近于零的时代。至于最关键最起作用的，需要倾注自己的注意力才能对自己奏效的**刻意练习**，被老师们认为并非己任 —— 巧了，这也的确是学生自己的事，也的确是只有学生自己才能做的事 —— 并不属于家长们支付高昂学费所购买的服务内容。

### 2.2. 消磨主动

大脑就是这样，严格执行 “用进废退”，它讨厌浪费能量，它更害怕能量的过度消耗。用得多，它就想尽一切办法加强那些连接和网络，只要用得不够多，它就直接暂时启用或者转作其它用途。

老师讲得再好，讲得再精彩，也只是完成了 “整个教育中的 5%” 而已，弄不好这都算多了。同时，我们也遗憾地观察到，大多数老师讲得并不精彩，甚至连及格都谈不上。孩子们被迫坐在下面听那么无聊的东西连续 45 分钟，锻炼的根本就不是集中注意力的能力，真正练出来的，只不过是保持一个动作不被看出来自己正在走神的习惯……

成年累月地把孩子关进课堂里，逼着他们认真听讲的另外一个意想不到却又更加普遍更加严重的后果是，随着时间的推移，这些孩子逐步丧失了自主阅读理解能力。他们的大脑也越来越不在乎自主阅读理解，反正，有老师讲，不懂可以问，为什么要自己消耗能量去挣扎？

很多人在离开学校的那一瞬间，带着欢喜决定此后再也不读书！事实上他们就是这么做的。一项 [2024 年的美国全国调查](https://testprepinsight.com/resources/us-book-reading-statistics/)显示，几乎有一半的受访者（48.5%）在过去一年中没有阅读过任何书籍。不要误以为那是因为他们学历低，那些去年没读过任何一本书的人，包括占总比 11% 的拥有学士或者更高学位的人。

他们甚至不知道自己的问题出在哪里，甚至开始相信自己的理解能力正在变得越来越差 —— 可这只不过好像是一种病症，的确存在，但并非不能治愈。他们反复告诉自己的大脑，岁数大了，不行了…… 可实际上，原本岁数越大学习能力越强才对。

他们也不是不上进，也不是不想学新东西，尤其是生活出现困境的时候。可是，他们能想到的唯一方法就是跳回多年前的陷阱，再一次花很多很多的钱购买最不重要的服务，不是自己主动看书，而是找个学习班听老师讲解。

然后呢？然后从来都不做必要的练习，理由也非常正当 —— 真的没时间。是啊，有时间的时候，没干过正事么……

### 2.3. 非个性化

另外，学校里的教育还有个始终无法解决的问题，**无法个性化**。同一个知识点，对每个人来说，难度可能并不相同 —— 无论是学的难度，还是练的难度。预习过的和没预习过的不一样，见识过的和没见识过的不一样，大脑里有没有近似连接或者近似网络也会造成巨大的不同。

然而，一个令人沮丧的事实是，我们一直一致以为超级贵的教育，实际上是众包之后的价格，也就是说，一个班级的配置，其实是十几个家庭或者几十个家庭齐心协力才能共同负担的价格。这就是现实。

小学里，班上只要五个人以上，语文课里实际上最重要的活动就无法进行了 —— 复述。所有老师都知道，复述是最能锻炼理解能力的活动，也是最靠谱的学习效果验收手段。可问题在于说，在多人的课堂上，它就是不可行，理由既简单又明确：时间不够 —— 更别说十几人甚至几十人的课堂上了。

别说复述了，连集体讨论或者分组讨论，都是相对罕见的。因为资源是众包的，所以，自然而然地造成人数过多，时间不够。在课堂上，即便是那些有想法的老师，到最后也只能退而求其次，能带着学生一起做的，并且老师们也自信的确有效的，只剩下了朗读和背诵。

绝大多数人离开学校之后，并不具备写作能力，更不具备讲演能力。人数越多班级越大的学生越是如此。其实，写作也好讲演也罢，99% 的时间和篇幅里，都是在复述，要么是复述别人的成果，要么是复述自己过去的想法…… 写作能力差、讲演能力无，共同的核心原因是同一个，复述能力差。

小朋友上学之前，复述能力是很强的，他们无论看到什么，回家都想跟爸爸妈妈或者兄弟姐妹绘声绘色地讲至少一遍…… 可是，这样的天性和天分，在上学之后的数年间里，逐步被消磨，直至殆尽。再一次，只不过是用进废退。

到最后，学校里的讲解也好，老师留的作业也罢，到最后都是为了应对考试而设计 —— 这是家长们求锤得锤的结果。

### 2.4. 糊弄一切

**考试被严重误解了**。考试的核心作用，根本就不是考验每个人的能力，考试的核心作用，是筛选。为什么筛选呢？很简单，一切重要的社会资源都必然是有限的，所以最终只能分配给少数人。

这是永恒不变的事实。这就解释了为什么越是重要的考试越有奇怪题目的原因，并不是那些奇怪的题目可以甄别出某项必需的能力，可以更好地分配社会资源，甚至可以提高整个社会效率…… 都不是，就是为了筛掉大部分人。所以，考试成绩差，结果就是被筛掉；而考试成绩好，结果只不过是幸存而已。

你可以说这很不公平，但从另外一个角度来看，它看起来有多不公平它就事实上有多公平 —— 既然事实如此，何必伪装？

看穿了这个实质之后，你就能理解学校里的那些老师有多么无奈，所作所为有多么徒劳。他们没办法直接创造更多更好的社会资源，他们没办法让更少的人被筛掉，他们能做得最好的，本质上来看，只不过是满足焦虑的父母们因误解而产生的幻觉。也算是一种各取所需，双向奔赴。

事实上并不知所谓的作业，其实并不能改变命运的考试，夹在这其中长达十多年的结果是，所有的学生都学会了**糊弄**。他们不仅在学校里写作业的时候想尽一切办法糊弄老师，回到家里也要想尽一切办法糊弄家长，为了考试，要在校外花钱报辅导班期待能够获得一些秘籍最终竟然可以糊弄考试……

终于有一天，离开了父母的近距离监控，到了大学校园 —— 糊弄都不掩饰了，直接喊出六十分万岁，并引以为荣，比比皆是。

**用尽废退**。糊弄多了的结果是，不知不觉开始糊弄自己。坐在课堂里就以为自己的确听讲了，打开教科书就觉得自己的确读书了，坐在课外辅导班在台下玩手机就可以告诉家长告诉自己，已经尽力了……

到最后，花了那么多钱，耗费了整个青春，毕业之后养出来的最大本事竟然就是四处糊弄…… 只可惜，命运容不得糊弄，时间容不得糊弄，最终时间不耐烦了，命运不耐烦了，反手一击的时候，都不知道应该从哪里开始后悔。

### 2.5. 脱离生产

还没完…… 最大最可怕的问题是，学校的设计目标从一开始就不太正常。花那么多钱，浪费那么多的青春，如此挣扎，到最后，图什么呢？一切都是为了考试，为了升学，为了求职 —— 弄明白了，原来到最后是为了成为一个出类拔萃的打工人啊！

打工并不是不好。问题在于，有必要只是为了打工就如此费尽周折吗？为了避免名词之争，让我们从另外一个角度看这个问题。

天下一切的财富，最正当且持续的来源是**生产**，**唯有生产**。坑蒙拐骗偷虽然也是某种方法，它们的问题在于，无法长期持续。只要你会你能做出很多人肯买的商品或者服务，不仅你的生活有了保证，连生活地位都可能顺其自然地出现。获得了足够的物质财富，就有机会追求精神财富。

可我们的教育在干什么？它的核心目标不是培养生产者，而是为社会上已有的合格生产者、有效生产者输送合格劳动力 —— 对，合格生产者，有效生产者，就是整个社会的稀缺资源，必需筛掉很多人，才够分配。（更多关于时间、自学、知识、追求精神财富和物质财富的讨论，请参考《财富的真相》）

那为什么不从一开始就以 “**成为生产者**” 为目标呢？不用参加任何人为设计的考试，唯一的考试就是投放市场之后看销量 —— 这不好吗？

在学校那么多年，最初的时候也不是没问过 “学这个有什么用啊？” 长期以来能得到的只有一致的回答，“等你长大就知道了……” 后来的确长大了，但早就忘了应该索要当初这个问题的正确答案。等到自己的孩子问出一模一样的问题，还是不知道应该怎么回答，于是，拿出标准答案，对自己的孩子说，“等你长大就知道了……”

这并非社会普遍共识，这是我心甘情愿作为极少数人愿意为自己和自家孩子捍卫的看法：

> **一切学习的目标都很清楚，只能是为了生产……**

家长每天都要提醒的，小孩每天都要思考的，兄弟姐妹朋友之间每天都要讨论的，都要**从生产出发**。这个东西很好，怎么做出来的？那个服务很畅销，怎么做出来的？生活里的这个问题要是能被解决就好了，那么，针对它，人们需要什么样的商品和服务？在资讯如此发达的今天，哪儿哪儿都有答案，哪儿哪儿都有线索。

还有个丑陋的事实必需提醒：**生产者**和消费者之间的关系，从某个角度望过去，其实是生物界赤裸裸的捕食者和被捕食者之间的关系。在大自然里，你到底是捕食者还是被捕食者，几乎是不可更改的天命，在人生里，做个生产者还是做个消费者，在最初是个非常轻松且又明显的选择。只不过是等到绝大多数人清醒的时候竟然发现已经来不及了而已。

### 2.6. 英语问题

关于**英语教育**，不得不单独拿出来说一说。毫无疑问，英语教育是学校里最大的灾区。那么多年的 “学习” 和 “教育”，**最终的效果几近于零** —— 全无夸张。

核心来自两个方面：

> * 不以语音为核心；
> * 只用 “系统二” 学，不用 “系统一” 练。

语言本身，只能**以语音为核心**，没有语音作为基础，文字很难发挥实际作用。然而，也许是基于过去的现实局限，语音几乎从未成为课堂的核心内容。说实话，过去的条件也的确有限 —— 比如，外教稀缺，而本地教师发音也不一定过关…… 更为重要的是，班级里总是人数太多，乃至于语音训练仅从课堂时间分配上来看就很不现实……

更为关键的是，学校里的学习都是以考试为导向的，于是，会被考试形式本身误导 —— 考试的内容，总是考核输入更多，考核输出更少，因为输入可以使用客观题测试，输出却只能通过主观题测试；而主观题比例总是最少…… 也许是它很难被统一评判的缘故。

试卷里的客观题，都是只需要动用系统二就可以完成的任务。但，语言的实际应用，却几乎截然相反，99% 都是由系统一处理的…… 所以才出现那么普遍的现象，很多人，英语四六级都过了，甚至 TOEFL、IELTS 都高分了，却依然说不了写不出。

## 3. 名校无用

如果你是名校毕业，你也许可以理直气壮的说，“名校也没什么用” —— 甚至无需加上额外的语气或者情绪，完全可以轻描淡写。如果你不是，你说同样的话，不仅自己可能气短，别人听到之后也会不服。

如果平日里你即便自己不是名校出身也能理直气壮地说 “名校就是没什么用！”，那我们可以佩服你的倔强，但，面对 “自家孩子要不要上名校？” 这个问题的时候，你还是会想尽一切办法送他们读名校的话，我们不仅不会感到意外，甚至还是可以表示理解 —— 面对整个社会的共识，无论对错，我们不都总是在关键的时候基于这样那样的原因倾向于妥协吗？

哈佛大学的教授们也经常问这个问题，他们不仅怀疑他们正在执教的学校有没有用，更担心的是自己的教学到底有没有用…… 对他们来说，事实很清楚，那些学生该翘课翘课，该不做功课就不做功课，该熬夜就熬夜，该吸大麻吸大麻，该开趴踢就开趴踢 —— 但，到最后，大多都能混到毕业，毕业之后，职场薪水就是比普通院校毕业的人高出至少 30%。

而名校毕业的人赚得更多这个事实，其实很容易解释。比起名校和名师的作用，有另外一个更起作用且更为明显的因素 —— 这些学校通过考试招进来的都是最顶级的学生，他们本来就相对更有能力，到了社会上多赚 30% 以上其实是四年前甚至更早就注定的结果。另外，整个社会的共识决定了说，品牌效应无所不在 —— 这个因素也明显比名校名师本身起的作用更大。

反正，事实摆在那里，没必要继续争论。

但，我们也的确不应该彻底抹煞环境的力量。

所谓水涨船高。在更优秀的群体里生存，本身就抬高了生存线。烂校里学生开趴踢吸大麻然后昏昏沉沉弄不好还得再来一个二场甚至三场；名校里的学生同样参加趴踢玩得够疯，但他们不一定吸大麻，并且，其中有相当数量的人已经习惯了玩得筋疲力尽之后回到宿舌把该做的功课做完再睡觉，两小时之后冲进教室，听完课之后再抓紧抽空补觉……

所以，如果把学校理解成孩子锻炼社交能力的场所，那每个学校都挺有用的。烂校起码做到了把那些精力旺盛无处宣泄的年轻人大部分时间都关起来省得他们危害社会，名校起码让优秀的年轻人有机会接触到更多更优秀的年轻人 —— 仅仅涨了见识本身，比多看几本书多上几门课可有用太多了。

人就是社交动物，从始至终都是。然而，社交的前提往往被忽略，这世界不存在什么向上社交，或者向下社交，社交的前提就是匹配。交朋友相对来看是弱关系社交，结婚相对来看就是强关系社交，到最后，所有的社交都一样，不匹配就不稳定。

[查理芒格的说法](https://www.youtube.com/watch?v=GYCQNSWA9uA)极为朴素：

> 想要获得你想要的东西，最安全的方法是努力配得上它。
>
> The safest way to try to get what you want is to try to deserve what you want.

所以，“名校到底有没有用？” 很可能干脆问错了，更应该问的其实是，“我自己行不行？” 自己到底行不行，要看自己过往的学习与积累，行就是行，不行就是不行，但，行不行肯定不是收没收到名校录取通知书那一瞬间决定的，它总是一个发展出来的结果。

也许，在高中毕业的那一瞬间可能还不行，又或者，在大学毕业的那一瞬间依然不行，但，这并不意味着说以后就永远不行，因为学习或积累事实上从任何时候都可以开始，怕只怕时间再次过去，你自己并没有发生任何变化。

从父母角度来看，“名校到底有没有用？” 同样是错误的提问。真正的问题，或者更有效的问题，可能应该是 “我们家庭的影响是否足够强？” 完全依赖外面的学校和老师教育自家孩子，本身就是家庭影响几近于零的表现。教育这个东西，如果真的存在，最关键的部分都是无法外包的，只能亲力亲为。家庭教育做好了，外面的学校和老师都只不过是辅助工具，但，全靠外面的学校和老师的话，也只能焦虑 “名校有没有用” 了 —— 可这个问题到底是什么样的答案，在这种情况下，跟自己又有什么真正的关系呢？

很多家长苦恼于孩子的所谓 “**叛逆**”。其实，孩子从来就没有是否叛逆这一说。根本就不是什么孩子长大了，到了所谓的 “叛逆期”…… 别说这个 “叛逆期” 莫名其妙的名词了， 孩子所谓的**叛逆**，只不过是**外界影响**彻底打败了**家庭影响**这个隐含事实的表面展现而已。如果，家庭影响更强更大，外面影响发挥不了太大的作用，孩子为什么要叛逆呢？有什么好处呢？动机又何在？

换个更简单的说法，如果你作为父母能够赢得孩子的尊重，你就没机会看到自家孩子叛逆，就这么简单，还是同样的话。如何赢得尊重？—— 全都是一样的啊！想要获得你想要的东西，最安全的方法是努力配得上它。

## 4. 找回自我

一旦我们经历了整个自我训练过程，每个人都能在这个过程中一致体会的事实是：

> **一切良好自我训练所必需的特征，其实都是我们小时候曾经具备的**：
>
> > * 把一切都当做生存**必需对待** —— 这事关大脑设定的**安全阈值**，不只是**好奇心**那么简单；
> > * 无论什么都肯**生学硬练**，无限重复，不怕枯燥；
> > * 无论什么都敢于**尝试**，从来没有想过自己竟然学不会竟然做不好；
> > * 特别容易**专注**；主要原因来自于压根就不在乎别人的看法；
> > * 痴迷于**进步**而不是痴迷于某个具象的事物或者与他人比较；
> > * 对自己格外**诚实**，不可能糊弄自己；
> > * 一切的学习都既**主动**又**不可阻挡**；
> >
> > ……

反思对比之后，我们只能慨叹，**人傻竟然都是被教出来的**…… 长达十数年的教育，虽然并非出自故意，整体上来看却一直在**毁人不倦**，多少令人无奈。

我们无意反复批评学校的各种问题，也知道学校对孩子来说是一种必要的存在 —— 起码，要为他们找到一个可以安全成长的场所…… 但，与此同时，作为家长，应该了解那些问题，进而想办法发展出一套属于自己的方法论去应对那些问题。

更为重要的是，千万不能忘了自己曾经是天生的超级学习机器，天生拥有贝叶斯推理能力，大脑里的神经元之间有无限的连接可能…… 成长的关键，说一千道一万，只不过是找回当初的自己，找回学龄前的自己，毫无畏惧，勇往直前，保持天真。


