#include "common.h"
#include "memory.h"
#include <string.h>

PDE updir[NR_PDE] align_to_page;
CR3 ucr3;

PDE *get_updir() { return updir; }
uint32_t get_ucr3() { return ucr3.val; }

PDE *get_kpdir();

uint32_t brk = 0;

/* The brk() system call handler. */
void mm_brk(uint32_t new_brk)
{
	if (new_brk > brk)
	{
		mm_malloc(brk, new_brk - brk);
	}
	brk = new_brk;
}

void init_mm()
{
	PDE *kpdir = get_kpdir();

	/* make all PDE invalid */
	memset(updir, 0, NR_PDE * sizeof(PDE));

	/* create the same mapping above 0xc0000000 as the kernel mapping does */
	memcpy(&updir[KOFFSET / PT_SIZE], &kpdir[KOFFSET / PT_SIZE],
		   (PHY_MEM / PT_SIZE) * sizeof(PDE));

	ucr3.val = (uint32_t)va_to_pa((uint32_t)updir) & ~0x3ff;
}
