@echo off
setlocal enabledelayedexpansion

rem Change default helpers
set "quiet=1>nul 2>nul"
set "fquiet=/f /q 1>nul 2>nul"

rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
echo; Project settings...
echo;

set "PROJ=cake"
set "VERS=20250815"

rem Where TCC is (ie. ./win32)
rem set "COMP=tinycc"
set "COMP=."

rem What is TCC name (ie. i386-win32-tcc)
rem set "CC=tcc"
set "CC=tcc"

rem Where are include files
rem set "LOC_INC=..\..\..\cake"
set "LOC_INC=."

pushd "%LOC_INC%"
	set "LOC_INC=%cd%"
	set "LOC_EXE=%LOC_INC%\%COMP%\%CC%.exe"

rem	echo LOC_INC=%LOC_INC%
rem	echo LOC_EXE=%LOC_EXE%
popd

	"%LOC_EXE%" -v

echo;  ::done
echo;
rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
echo; Deleting binaries...

rem Go into the source folder
pushd "%LOC_INC%"
cd ".\%PROJ%\src"

	del *.bin /s %quiet%
	del *.def /s %quiet%
	del *.exe /s %quiet%
	del *.obj /s %quiet%
	del *.o /s %quiet%

rem goto :eof

echo;  ::done
echo;
rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
echo; Some flags...
echo;

rem Display constants (#define ...)
rem "%LOC_EXE%" -E -dM - < nul

	set "CFLAGS=-c"
rem	set "CFLAGS=%CFLAGS% -g"
rem	set "CFLAGS=%CFLAGS% -O2"
rem	set "CFLAGS=%CFLAGS% -Wall"
	set "CFLAGS=%CFLAGS% -std=c99"

rem	set "CFLAGS=%CFLAGS% -L%LOC_INC%\mingw64\x86_64-w64-mingw32\lib"
rem	set "CFLAGS=%CFLAGS% -I%LOC_INC%\mingw64\x86_64-w64-mingw32\include"

	set "CFLAGS=%CFLAGS% -I%LOC_INC%\%COMP%\include"
rem	set "CFLAGS=%CFLAGS% -I%LOC_INC%\%COMP%\include\sys"
rem	set "CFLAGS=%CFLAGS% -I%LOC_INC%\%COMP%\include\winapi"
	set "CFLAGS=%CFLAGS% -I%LOC_INC%\%COMP%\include_extn"

echo;  ::done
echo;
rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
echo; Compiling '%PROJ%'...
echo;

	set "ACC_OBJ="

	set "AFLAGS="
rem	set "AFLAGS=%AFLAGS% -v"

	set "AFLAGS=%AFLAGS% %CFLAGS%"

	set "AFLAGS=%AFLAGS% -I.\include"

rem	set "AFLAGS=%AFLAGS% -include windows.h"
rem	set "AFLAGS=%AFLAGS% -Wl,-subsystem=console"
rem	set "AFLAGS=%AFLAGS% -Wl,-subsystem=gui"

	echo AFLAGS=%AFLAGS%

rem	call :compile build.c
	call :compile console.c
	call :compile error.c
	call :compile expressions.c
rem	call :compile f.c
rem	call :compile file.c
	call :compile flow.c
rem	call :compile flow1.c
rem	call :compile flow2.c
	call :compile fs.c
	call :compile hashmap.c
rem	call :compile lib.c
rem	call :compile lib2.c
	call :compile main.c
	call :compile object.c
	call :compile options.c
	call :compile osstream.c
	call :compile parser.c
	call :compile pre_expressions.c
	call :compile token.c
	call :compile tokenizer.c
	call :compile type.c
rem	call :compile unit_test.c
	call :compile visit_defer.c
	call :compile visit_il.c

echo;  ::done
echo;
rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
echo; Linking '%PROJ%'...
echo;

	set "AFLAGS="
rem	set "AFLAGS=%AFLAGS% -v"

rem Static linking to .a or .lib

	set "AFLAGS=%AFLAGS% -L%LOC_INC%\%COMP%\lib"
rem	set "AFLAGS=%AFLAGS% -lgdi32"
rem	set "AFLAGS=%AFLAGS% -lgl"
rem	set "AFLAGS=%AFLAGS% -lglu"
rem	set "AFLAGS=%AFLAGS% -lglu32"
rem	set "AFLAGS=%AFLAGS% -lkernel32"
rem	set "AFLAGS=%AFLAGS% -lmingw32"
rem	set "AFLAGS=%AFLAGS% -lmsvcrt"
rem	set "AFLAGS=%AFLAGS% -lopengl32"
rem	set "AFLAGS=%AFLAGS% -lpthread"
rem	set "AFLAGS=%AFLAGS% -ltcc1-32"
rem	set "AFLAGS=%AFLAGS% -ltcc1-64"
rem	set "AFLAGS=%AFLAGS% -luser32"

rem Other parameters

rem	set "AFLAGS=%AFLAGS% --cflags"
rem	set "AFLAGS=%AFLAGS% -fomit-frame-pointer"
rem	set "AFLAGS=%AFLAGS% -mwindows"
rem	set "AFLAGS=%AFLAGS% -nostdlib"
rem	set "AFLAGS=%AFLAGS% -std=c99"
rem	set "AFLAGS=%AFLAGS% -Wall"
rem	set "AFLAGS=%AFLAGS% -Wno-unused"

rem Trying to convert COFF32 to ELF32...

"%LOC_EXE%" %AFLAGS% !ACC_OBJ! -o "%LOC_INC%\%COMP%\%PROJ%.exe"

rem Return from the source folder
popd

echo;  ::done
echo;
rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

goto :eof

rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:compile
rem	echo TCC=%AFLAGS% "%~1"
	"%LOC_EXE%" %AFLAGS% "%~1"

	set "ACC_OBJ=!ACC_OBJ! %~n1.o"
rem	echo "ACC_OBJ=!ACC_OBJ!"
exit /b
