/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import stegsolve.DPanel;
import stegsolve.StereoTransform;

public class Stereo
extends JFrame {
    private JLabel nowShowing;
    private JPanel buttonPanel;
    private JButton forwardButton;
    private JButton backwardButton;
    private JButton saveButton;
    private DPanel dp;
    private JScrollPane scrollPane;
    private BufferedImage bi = null;
    private StereoTransform transform = null;
    private int inum = 0;
    private Action backButtonPress = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Stereo.this.backwardButtonActionPerformed(e);
        }
    };
    private Action forwardButtonPress = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Stereo.this.forwardButtonActionPerformed(e);
        }
    };

    public Stereo(BufferedImage b) {
        this.bi = b;
        this.initComponents();
        this.transform = new StereoTransform(this.bi);
        this.newImage();
    }

    private void initComponents() {
        this.nowShowing = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.nowShowing, "North");
        this.buttonPanel = new JPanel();
        this.backwardButton = new JButton("<");
        this.backwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Stereo.this.backwardButtonActionPerformed(evt);
            }
        });
        this.forwardButton = new JButton(">");
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Stereo.this.forwardButtonActionPerformed(evt);
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Stereo.this.saveButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.backwardButton);
        this.buttonPanel.add(this.forwardButton);
        this.buttonPanel.add(this.saveButton);
        this.add((Component)this.buttonPanel, "South");
        this.backwardButton.getInputMap(2).put(KeyStroke.getKeyStroke(37, 0), "back");
        this.backwardButton.getActionMap().put("back", this.backButtonPress);
        this.forwardButton.getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "forward");
        this.forwardButton.getActionMap().put("forward", this.forwardButtonPress);
        this.dp = new DPanel();
        this.scrollPane = new JScrollPane(this.dp);
        this.add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void backwardButtonActionPerformed(ActionEvent evt) {
        if (this.transform == null) {
            return;
        }
        this.transform.back();
        this.updateImage();
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        if (this.bi == null) {
            return;
        }
        this.transform.forward();
        this.updateImage();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        File sfile = null;
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "gif", "png", "bmp");
        fileChooser.setFileFilter(filter);
        fileChooser.setSelectedFile(new File("solved.bmp"));
        int rVal = fileChooser.showSaveDialog(this);
        System.setProperty("user.dir", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (rVal == 0) {
            sfile = fileChooser.getSelectedFile();
            try {
                BufferedImage bbx = this.transform.getImage();
                int rns = sfile.getName().lastIndexOf(".") + 1;
                if (rns == 0) {
                    ImageIO.write((RenderedImage)bbx, "bmp", sfile);
                } else {
                    ImageIO.write((RenderedImage)bbx, sfile.getName().substring(rns), sfile);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to write file: " + e.toString());
            }
        }
    }

    private void updateImage() {
        this.nowShowing.setText(this.transform.getText());
        this.dp.setImage(this.transform.getImage());
        this.repaint();
    }

    private void newImage() {
        this.nowShowing.setText(this.transform.getText());
        this.dp.setImage(this.transform.getImage());
        this.dp.setSize(this.transform.getImage().getWidth(), this.transform.getImage().getHeight());
        this.dp.setPreferredSize(new Dimension(this.transform.getImage().getWidth(), this.transform.getImage().getHeight()));
        this.setMaximumSize(this.getToolkit().getScreenSize());
        this.pack();
        this.scrollPane.revalidate();
        this.repaint();
    }
}

