/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import stegsolve.StegSolve;

public class DPanel
extends JPanel {
    private Dimension preferredSize = new Dimension(200, 200);
    private Dimension defaultSize = new Dimension();
    private Dimension currentSize = new Dimension();
    private DropTarget dropTarget;
    private DropTargetHandler dropTargetHandler;
    private Point dragPoint;
    private boolean dragOver = false;
    private BufferedImage bi = null;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bi != null) {
            g.drawImage(this.bi, 0, 0, this.currentSize.width, this.currentSize.height, this);
        }
    }

    public void setImage(BufferedImage bix) {
        this.bi = bix;
        this.defaultSize.width = this.bi.getWidth();
        this.defaultSize.height = this.bi.getHeight();
        this.setSize(this.bi.getWidth(), this.bi.getHeight());
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void apply(int percent) {
        this.currentSize.width = (int)((float)this.defaultSize.width * ((float)percent / 100.0f));
        this.currentSize.height = (int)((float)this.defaultSize.height * ((float)percent / 100.0f));
        this.preferredSize = this.currentSize;
        this.revalidate();
        this.repaint();
    }

    protected DropTarget getMyDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this, 3, null);
        }
        return this.dropTarget;
    }

    protected DropTargetHandler getDropTargetHandler() {
        if (this.dropTargetHandler == null) {
            this.dropTargetHandler = new DropTargetHandler();
        }
        return this.dropTargetHandler;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            this.getMyDropTarget().addDropTargetListener(this.getDropTargetHandler());
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getMyDropTarget().removeDropTargetListener(this.getDropTargetHandler());
    }

    public class DragUpdate
    implements Runnable {
        private boolean dragOver;
        private Point dragPoint;

        public DragUpdate(boolean dragOver, Point dragPoint) {
            this.dragOver = dragOver;
            this.dragPoint = dragPoint;
        }

        @Override
        public void run() {
            DPanel.this.dragOver = this.dragOver;
            DPanel.this.dragPoint = this.dragPoint;
            DPanel.this.repaint();
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        protected DropTargetHandler() {
        }

        protected void processDrag(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
            SwingUtilities.invokeLater(new DragUpdate(true, dtde.getLocation()));
            DPanel.this.repaint();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
            SwingUtilities.invokeLater(new DragUpdate(true, dtde.getLocation()));
            DPanel.this.repaint();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            SwingUtilities.invokeLater(new DragUpdate(false, null));
            DPanel.this.repaint();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            SwingUtilities.invokeLater(new DragUpdate(false, null));
            Transferable transferable = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(dtde.getDropAction());
                try {
                    List transferData = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (transferData.size() == 1) {
                        StegSolve.that.loadImage((File)transferData.get(0));
                        dtde.dropComplete(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }
}

