/*
 * Decompiled with CFR 0.152.
 */
package me.leon.misc.zhconvert;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.leon.misc.zhconvert.TrieNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lme/leon/misc/zhconvert/Trie;", "", "root", "Lme/leon/misc/zhconvert/TrieNode;", "<init>", "(Lme/leon/misc/zhconvert/TrieNode;)V", "getRoot", "()Lme/leon/misc/zhconvert/TrieNode;", "insert", "", "word", "", "search", "", "char", "", "searchPrefix", "prefix", "component1", "copy", "equals", "other", "hashCode", "", "toString", "app"})
public final class Trie {
    @NotNull
    private final TrieNode root;

    public Trie(@NotNull TrieNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    public /* synthetic */ Trie(TrieNode trieNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            trieNode = new TrieNode(null, 1, null);
        }
        this(trieNode);
    }

    @NotNull
    public final TrieNode getRoot() {
        return this.root;
    }

    public final void insert(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        TrieNode node = this.root;
        int n = word.length();
        for (int i = 0; i < n; ++i) {
            char ch = word.charAt(i);
            TrieNode trieNode = node;
            Intrinsics.checkNotNull((Object)trieNode);
            if (!trieNode.containsKey(ch)) {
                node.set(ch, new TrieNode(null, 1, null));
            }
            node = node.get(ch);
        }
    }

    public final boolean search(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        TrieNode node = this.searchPrefix(word);
        return node != null;
    }

    public final boolean search(char c) {
        return this.root.get(c) != null;
    }

    private final TrieNode searchPrefix(String prefix) {
        TrieNode node = this.root;
        int n = prefix.length();
        for (int i = 0; i < n; ++i) {
            char ch = prefix.charAt(i);
            TrieNode trieNode = node;
            Intrinsics.checkNotNull((Object)trieNode);
            if (!trieNode.containsKey(ch)) {
                return null;
            }
            node = node.get(ch);
        }
        return node;
    }

    @NotNull
    public final TrieNode component1() {
        return this.root;
    }

    @NotNull
    public final Trie copy(@NotNull TrieNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return new Trie(root);
    }

    public static /* synthetic */ Trie copy$default(Trie trie, TrieNode trieNode, int n, Object object) {
        if ((n & 1) != 0) {
            trieNode = trie.root;
        }
        return trie.copy(trieNode);
    }

    @NotNull
    public String toString() {
        return "Trie(root=" + this.root + ')';
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Trie)) {
            return false;
        }
        Trie trie = (Trie)other;
        return Intrinsics.areEqual((Object)this.root, (Object)trie.root);
    }

    public Trie() {
        this(null, 1, null);
    }
}

