/*
 * Decompiled with CFR 0.152.
 */
package me.leon.misc;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.config.ConfigKt;
import me.leon.ext.FileKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J>\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010\u0014\u001a\u00020\b2\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00160\u00112\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a*\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/leon/misc/Spliter;", "", "<init>", "()V", "splitRegex", "Lkotlin/text/Regex;", "wordCost", "", "", "", "maxWordLength", "", "initDict", "", "file", "Ljava/io/File;", "splitContiguousWords", "", "sentence", "split", "partSentence", "bestMatch", "Lkotlin/Pair;", "cost", "index", "parts", "", "app"})
@SourceDebugExtension(value={"SMAP\nSpliter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spliter.kt\nme/leon/misc/Spliter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,148:1\n1969#2,14:149\n1803#2,3:163\n1118#3,3:166\n*S KotlinDebug\n*F\n+ 1 Spliter.kt\nme/leon/misc/Spliter\n*L\n37#1:149,14\n42#1:163,3\n123#1:166,3\n*E\n"})
public final class Spliter {
    @NotNull
    public static final Spliter INSTANCE = new Spliter();
    @NotNull
    private static final Regex splitRegex = new Regex("[^a-zA-Z0-9']+");
    @NotNull
    private static final Map<String, Number> wordCost = new LinkedHashMap();
    private static int maxWordLength;

    private Spliter() {
    }

    public final void initDict(@NotNull File file) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List dictionaryWords = file.exists() ? FilesKt.readLines$default((File)file, null, (int)1, null) : StringsKt.lines((CharSequence)FileKt.readResourceText('/' + ConfigKt.getWORDNINJA_DICT_FILE().getName()));
        wordCost.clear();
        double lgDictSize = Math.log(dictionaryWords.size());
        int wordIdx = 0;
        for (String word : dictionaryWords) {
            wordCost.put(word, Math.log((double)(++wordIdx) * lgDictSize));
        }
        Iterable $this$maxBy$iv = dictionaryWords;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = maxElem$iv;
        } else {
            String it = (String)maxElem$iv;
            boolean bl = false;
            int maxValue$iv = it.length();
            do {
                Object e$iv = iterator$iv.next();
                String it2 = (String)e$iv;
                $i$a$-maxByOrThrow-Spliter$initDict$1 = false;
                int v$iv = it2.length();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = maxElem$iv;
        }
        maxWordLength = ((String)t).length();
    }

    public static /* synthetic */ void initDict$default(Spliter spliter, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = ConfigKt.getWORDNINJA_DICT_FILE();
        }
        spliter.initDict(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> splitContiguousWords(@NotNull String sentence) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Iterable iterable = this.parts(sentence);
        List list = new ArrayList();
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            void var12_11;
            String string = (String)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            void $this$splitContiguousWords_u24lambda_u240_u240 = var12_11 = acc;
            boolean bl2 = false;
            boolean bl3 = splitRegex.matches((CharSequence)s) ? $this$splitContiguousWords_u24lambda_u240_u240.add(s) : $this$splitContiguousWords_u24lambda_u240_u240.add(INSTANCE.split((String)s));
            accumulator$iv = var12_11;
        }
        void splitWords = accumulator$iv;
        return splitWords;
    }

    private final String split(String partSentence) {
        Number candidateIndexValue;
        List cost = new ArrayList();
        cost.add(TuplesKt.to((Object)0, (Object)0));
        int n = partSentence.length() + 1;
        for (int index = 1; index < n; ++index) {
            cost.add(this.bestMatch(partSentence, cost, index));
        }
        List output = new ArrayList();
        for (int idx = partSentence.length(); idx > 0; idx -= candidateIndexValue.intValue()) {
            String lastWord;
            String token;
            Pair<Number, Number> candidate = this.bestMatch(partSentence, cost, idx);
            Number candidateCost = (Number)candidate.getFirst();
            candidateIndexValue = (Number)candidate.getSecond();
            if (!(candidateCost.doubleValue() == ((Number)((Pair)cost.get(idx)).getFirst()).doubleValue())) {
                throw new IllegalStateException("Candidate cost unmatched; This should not be the case!".toString());
            }
            boolean newToken = true;
            Intrinsics.checkNotNullExpressionValue((Object)partSentence.substring(idx - candidateIndexValue.intValue(), idx), (String)"substring(...)");
            if (token != "'" && output.size() > 0 && (StringsKt.equals((String)(lastWord = (String)output.get(output.size() - 1)), (String)"'s", (boolean)true) || Character.isDigit(partSentence.charAt(idx - 1)) && Character.isDigit(lastWord.charAt(0)))) {
                output.set(output.size() - 1, token + lastWord);
                newToken = false;
            }
            if (!newToken) continue;
            output.add(token);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)output), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final Pair<Number, Number> bestMatch(String partSentence, List<? extends Pair<? extends Number, ? extends Number>> cost, int index) {
        List candidates = CollectionsKt.reversed((Iterable)cost.subList((int)Math.max(0.0, (double)(index - maxWordLength)), index));
        int enumerateIdx = 0;
        Pair minPair = TuplesKt.to((Object)Integer.MAX_VALUE, (Object)enumerateIdx);
        for (Pair pair : candidates) {
            String subsequence;
            String string = partSentence.substring(index - ++enumerateIdx, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            Number minCost = Integer.MAX_VALUE;
            if (wordCost.containsKey(subsequence)) {
                double d = ((Number)pair.getFirst()).doubleValue();
                Number number = wordCost.get(subsequence);
                Intrinsics.checkNotNull((Object)number);
                minCost = d + number.doubleValue();
            }
            if (!(minCost.doubleValue() < ((Number)minPair.getFirst()).doubleValue())) continue;
            minPair = TuplesKt.to((Object)minCost.doubleValue(), (Object)enumerateIdx);
        }
        return minPair;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> parts(@NotNull String $this$parts) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$parts, (String)"<this>");
        CharSequence charSequence = $this$parts;
        Triple initial$iv = new Triple((Object)new ArrayList(), (Object)new StringBuilder(), (Object)new AtomicBoolean(false));
        boolean $i$f$fold = false;
        Triple accumulator$iv = initial$iv;
        for (int i = 0; i < $this$fold$iv.length(); ++i) {
            void char_;
            char element$iv;
            char c = element$iv = $this$fold$iv.charAt(i);
            Triple acc = accumulator$iv;
            boolean bl = false;
            if (Character.isLetter((char)char_)) {
                if (((AtomicBoolean)acc.getThird()).get()) {
                    List list = (List)acc.getFirst();
                    String string = ((StringBuilder)acc.getSecond()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    list.add(string);
                    StringsKt.clear((StringBuilder)((StringBuilder)acc.getSecond()));
                }
                ((AtomicBoolean)acc.getThird()).set(false);
                ((StringBuilder)acc.getSecond()).append((char)char_);
            } else {
                if (((CharSequence)acc.getSecond()).length() > 0) {
                    List list = (List)acc.getFirst();
                    String string = ((StringBuilder)acc.getSecond()).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    list.add(string);
                    StringsKt.clear((StringBuilder)((StringBuilder)acc.getSecond()));
                }
                ((StringBuilder)acc.getSecond()).append((char)char_);
                ((AtomicBoolean)acc.getThird()).set(true);
            }
            accumulator$iv = acc;
        }
        CharSequence it = charSequence = accumulator$iv;
        boolean bl = false;
        if (((CharSequence)it.getSecond()).length() > 0) {
            List list = (List)it.getFirst();
            String string = ((StringBuilder)it.getSecond()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            list.add(string);
        }
        return (List)charSequence.getFirst();
    }

    static {
        Spliter.initDict$default(INSTANCE, null, 1, null);
    }
}

