/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.password;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.hash.keygen.Base64StringKeyGenerator;
import me.leon.hash.keygen.StringKeyGenerator;
import me.leon.hash.password.Digester;
import me.leon.hash.password.PasswordEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lme/leon/hash/password/MessageDigestPasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "algorithm", "", "<init>", "(Ljava/lang/String;)V", "saltGenerator", "Lme/leon/hash/keygen/StringKeyGenerator;", "encodeHashAsBase64", "", "getEncodeHashAsBase64", "()Z", "setEncodeHashAsBase64", "(Z)V", "digester", "Lme/leon/hash/password/Digester;", "encode", "password", "", "digest", "salt", "rawPassword", "", "matches", "encodedPassword", "setIterations", "", "iterations", "", "extractSalt", "prefixEncodedPassword", "Companion", "app"})
public final class MessageDigestPasswordEncoder
implements PasswordEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringKeyGenerator saltGenerator;
    private boolean encodeHashAsBase64;
    @NotNull
    private final Digester digester;
    @NotNull
    private static final String PREFIX = "{";
    @NotNull
    private static final String SUFFIX = "}";

    public MessageDigestPasswordEncoder(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.saltGenerator = new Base64StringKeyGenerator(null, 0, 3, null);
        this.digester = new Digester(algorithm, 1);
    }

    public final boolean getEncodeHashAsBase64() {
        return this.encodeHashAsBase64;
    }

    public final void setEncodeHashAsBase64(boolean bl) {
        this.encodeHashAsBase64 = bl;
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String salt = '{' + this.saltGenerator.generateKey() + '}';
        return this.digest(salt, password);
    }

    @NotNull
    public final String digest(@NotNull String salt, @NotNull CharSequence rawPassword) {
        String saltedPassword;
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        String string = saltedPassword = rawPassword + salt;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] digest = this.digester.digest(byArray);
        String encoded = this.encode(digest);
        return salt + encoded;
    }

    @NotNull
    public final byte[] digest(@NotNull byte[] salt, @NotNull byte[] rawPassword) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        return ArraysKt.plus((byte[])salt, (byte[])this.digester.digest(ArraysKt.plus((byte[])salt, (byte[])rawPassword)));
    }

    private final String encode(byte[] digest) {
        return this.encodeHashAsBase64 ? Base64Kt.base64$default(digest, null, false, 3, null) : ConverterKt.toHex(digest);
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        String salt = this.extractSalt(encodedPassword);
        return Intrinsics.areEqual((Object)encodedPassword, (Object)this.digest(salt, password));
    }

    public final void setIterations(int iterations) {
        this.digester.setIterations(iterations);
    }

    private final String extractSalt(String prefixEncodedPassword) {
        String string;
        int start = StringsKt.indexOf$default((CharSequence)prefixEncodedPassword, (String)PREFIX, (int)0, (boolean)false, (int)6, null);
        if (start != 0) {
            return "";
        }
        int end = StringsKt.indexOf$default((CharSequence)prefixEncodedPassword, (String)SUFFIX, (int)start, (boolean)false, (int)4, null);
        if (end < 0) {
            string = "";
        } else {
            String string2 = prefixEncodedPassword.substring(start, end + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/leon/hash/password/MessageDigestPasswordEncoder$Companion;", "", "<init>", "()V", "PREFIX", "", "SUFFIX", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

