/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.keygen;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import me.leon.hash.keygen.BytesKeyGenerator;
import me.leon.hash.keygen.HexEncodingStringKeyGenerator;
import me.leon.hash.keygen.SecureRandomBytesKeyGenerator;
import me.leon.hash.keygen.SharedKeyGenerator;
import me.leon.hash.keygen.StringKeyGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lme/leon/hash/keygen/KeyGenerators;", "", "<init>", "()V", "secureRandom", "Lme/leon/hash/keygen/BytesKeyGenerator;", "keyLength", "", "shared", "string", "Lme/leon/hash/keygen/StringKeyGenerator;", "app"})
public final class KeyGenerators {
    @NotNull
    public static final KeyGenerators INSTANCE = new KeyGenerators();

    private KeyGenerators() {
    }

    @JvmStatic
    @NotNull
    public static final BytesKeyGenerator secureRandom() {
        return new SecureRandomBytesKeyGenerator(0, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final BytesKeyGenerator secureRandom(int keyLength) {
        return new SecureRandomBytesKeyGenerator(keyLength);
    }

    @NotNull
    public final BytesKeyGenerator shared(int keyLength) {
        return new SharedKeyGenerator(KeyGenerators.secureRandom(keyLength).generateKey());
    }

    @NotNull
    public final StringKeyGenerator string() {
        return new HexEncodingStringKeyGenerator(KeyGenerators.secureRandom());
    }
}

