/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.keygen;

import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.leon.hash.keygen.BytesKeyGenerator;
import me.leon.hash.keygen.KeyGenerators;
import me.leon.hash.keygen.StringKeyGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/leon/hash/keygen/Base64StringKeyGenerator;", "Lme/leon/hash/keygen/StringKeyGenerator;", "encoder", "Ljava/util/Base64$Encoder;", "keyLength", "", "<init>", "(Ljava/util/Base64$Encoder;I)V", "keyGenerator", "Lme/leon/hash/keygen/BytesKeyGenerator;", "generateKey", "", "Companion", "app"})
public final class Base64StringKeyGenerator
implements StringKeyGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Base64.Encoder encoder;
    @NotNull
    private final BytesKeyGenerator keyGenerator;
    private static final int DEFAULT_KEY_LENGTH = 32;

    @JvmOverloads
    public Base64StringKeyGenerator(@NotNull Base64.Encoder encoder, int keyLength) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        this.encoder = encoder;
        if (!(keyLength >= 32)) {
            boolean bl = false;
            String string = "keyLength must be greater than or equal to32";
            throw new IllegalArgumentException(string.toString());
        }
        this.keyGenerator = KeyGenerators.secureRandom(keyLength);
    }

    public /* synthetic */ Base64StringKeyGenerator(Base64.Encoder encoder, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            Base64.Encoder encoder2 = Base64.getEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)encoder2, (String)"getEncoder(...)");
            encoder = encoder2;
        }
        if ((n2 & 2) != 0) {
            n = 32;
        }
        this(encoder, n);
    }

    @Override
    @NotNull
    public String generateKey() {
        byte[] key = this.keyGenerator.generateKey();
        byte[] base64EncodedKey = this.encoder.encode(key);
        Intrinsics.checkNotNull((Object)base64EncodedKey);
        return new String(base64EncodedKey, Charsets.UTF_8);
    }

    @JvmOverloads
    public Base64StringKeyGenerator(@NotNull Base64.Encoder encoder) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        this(encoder, 0, 2, null);
    }

    @JvmOverloads
    public Base64StringKeyGenerator() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/leon/hash/keygen/Base64StringKeyGenerator$Companion;", "", "<init>", "()V", "DEFAULT_KEY_LENGTH", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

