/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.bcrypt;

import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import me.leon.hash.bcrypt.BCrypt;
import me.leon.hash.password.PasswordEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0002\u001f B)\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lme/leon/hash/bcrypt/BCryptPasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "version", "Lme/leon/hash/bcrypt/BCryptPasswordEncoder$BCryptVersion;", "strength", "", "random", "Ljava/security/SecureRandom;", "<init>", "(Lme/leon/hash/bcrypt/BCryptPasswordEncoder$BCryptVersion;ILjava/security/SecureRandom;)V", "getVersion", "()Lme/leon/hash/bcrypt/BCryptPasswordEncoder$BCryptVersion;", "setVersion", "(Lme/leon/hash/bcrypt/BCryptPasswordEncoder$BCryptVersion;)V", "getStrength", "()I", "setStrength", "(I)V", "salt", "", "getSalt", "()Ljava/lang/String;", "encode", "password", "", "rawPassword", "", "matches", "", "encodedPassword", "upgradeEncoding", "BCryptVersion", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nBCryptPasswordEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BCryptPasswordEncoder.kt\nme/leon/hash/bcrypt/BCryptPasswordEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class BCryptPasswordEncoder
implements PasswordEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BCryptVersion version;
    private int strength;
    @Nullable
    private SecureRandom random;
    @NotNull
    private static final Regex REG_BCRYPT = new Regex("\\$2([ayb])?\\$(\\d\\d)\\$[./0-9A-Za-z]{53}");

    @JvmOverloads
    public BCryptPasswordEncoder(@NotNull BCryptVersion version, int strength, @Nullable SecureRandom random) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.version = version;
        this.strength = strength;
        this.random = random;
        if (!(this.strength == -1 || this.strength >= 4 && this.strength <= 31)) {
            boolean bl = false;
            String string = "Bad strength";
            throw new IllegalArgumentException(string.toString());
        }
        this.strength = this.strength == -1 ? 10 : this.strength;
    }

    public /* synthetic */ BCryptPasswordEncoder(BCryptVersion bCryptVersion, int n, SecureRandom secureRandom, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bCryptVersion = BCryptVersion.$2A;
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            secureRandom = null;
        }
        this(bCryptVersion, n, secureRandom);
    }

    @NotNull
    public final BCryptVersion getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull BCryptVersion bCryptVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)bCryptVersion), (String)"<set-?>");
        this.version = bCryptVersion;
    }

    public final int getStrength() {
        return this.strength;
    }

    public final void setStrength(int n) {
        this.strength = n;
    }

    private final String getSalt() {
        String string = this.version.getVersion();
        SecureRandom secureRandom = this.random;
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        return BCrypt.Companion.genSalt(string, this.strength, secureRandom);
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return BCrypt.Companion.hashpw(((Object)password).toString(), this.getSalt());
    }

    @NotNull
    public final String encode(@NotNull CharSequence rawPassword, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        return BCrypt.Companion.hashpw(((Object)rawPassword).toString(), BCrypt.Companion.genSalt(salt, this.version.getVersion(), this.strength));
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        if (((CharSequence)encodedPassword).length() == 0) {
            System.out.println((Object)"Empty encoded password");
            return false;
        }
        CharSequence charSequence = encodedPassword;
        if (!REG_BCRYPT.matches(charSequence)) {
            System.out.println((Object)"Encoded password does not look like BCrypt");
            return false;
        }
        return BCrypt.Companion.checkPw(((Object)password).toString(), encodedPassword);
    }

    @Override
    public boolean upgradeEncoding(@NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        if (((CharSequence)encodedPassword).length() == 0) {
            System.out.println((Object)"Empty encoded password");
            return false;
        }
        MatchResult matcher = Regex.find$default((Regex)REG_BCRYPT, (CharSequence)encodedPassword, (int)0, (int)2, null);
        if (matcher == null) {
            boolean $i$a$-requireNotNull-BCryptPasswordEncoder$upgradeEncoding$22 = false;
            String $i$a$-requireNotNull-BCryptPasswordEncoder$upgradeEncoding$22 = "Encoded password does not look like BCrypt: " + encodedPassword;
            throw new IllegalArgumentException($i$a$-requireNotNull-BCryptPasswordEncoder$upgradeEncoding$22.toString());
        }
        int strength = Integer.parseInt((String)matcher.getGroupValues().get(2));
        return strength < this.strength;
    }

    @JvmOverloads
    public BCryptPasswordEncoder(@NotNull BCryptVersion version, int strength) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this(version, strength, null, 4, null);
    }

    @JvmOverloads
    public BCryptPasswordEncoder(@NotNull BCryptVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this(version, 0, null, 6, null);
    }

    @JvmOverloads
    public BCryptPasswordEncoder() {
        this(null, 0, null, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lme/leon/hash/bcrypt/BCryptPasswordEncoder$BCryptVersion;", "", "version", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "$2A", "$2Y", "$2B", "app"})
    public static final class BCryptVersion
    extends Enum<BCryptVersion> {
        @NotNull
        private final String version;
        public static final /* enum */ BCryptVersion $2A = new BCryptVersion("$2a");
        public static final /* enum */ BCryptVersion $2Y = new BCryptVersion("$2y");
        public static final /* enum */ BCryptVersion $2B = new BCryptVersion("$2b");
        private static final /* synthetic */ BCryptVersion[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BCryptVersion(String version) {
            this.version = version;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        public static BCryptVersion[] values() {
            return (BCryptVersion[])$VALUES.clone();
        }

        public static BCryptVersion valueOf(String value) {
            return Enum.valueOf(BCryptVersion.class, value);
        }

        @NotNull
        public static EnumEntries<BCryptVersion> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = bCryptVersionArray = new BCryptVersion[]{BCryptVersion.$2A, BCryptVersion.$2Y, BCryptVersion.$2B};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/leon/hash/bcrypt/BCryptPasswordEncoder$Companion;", "", "<init>", "()V", "REG_BCRYPT", "Lkotlin/text/Regex;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

