/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.argon2;

import java.util.Base64;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/leon/hash/argon2/Argon2EncodingUtils;", "", "<init>", "()V", "b64encoder", "Ljava/util/Base64$Encoder;", "kotlin.jvm.PlatformType", "b64decoder", "Ljava/util/Base64$Decoder;", "encode", "", "hash", "", "parameters", "Lorg/bouncycastle/crypto/params/Argon2Parameters;", "decode", "Lme/leon/hash/argon2/Argon2EncodingUtils$Argon2Hash;", "encodedHash", "Argon2Hash", "app"})
@SourceDebugExtension(value={"SMAP\nArgon2EncodingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Argon2EncodingUtils.kt\nme/leon/hash/argon2/Argon2EncodingUtils\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n37#2,2:130\n37#2,2:133\n1#3:132\n*S KotlinDebug\n*F\n+ 1 Argon2EncodingUtils.kt\nme/leon/hash/argon2/Argon2EncodingUtils\n*L\n100#1:130,2\n115#1:133,2\n*E\n"})
public final class Argon2EncodingUtils {
    @NotNull
    public static final Argon2EncodingUtils INSTANCE = new Argon2EncodingUtils();
    private static final Base64.Encoder b64encoder = Base64.getEncoder().withoutPadding();
    private static final Base64.Decoder b64decoder = Base64.getDecoder();

    private Argon2EncodingUtils() {
    }

    @NotNull
    public final String encode(@Nullable byte[] hash, @NotNull Argon2Parameters parameters) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        StringBuilder stringBuilder = new StringBuilder();
        switch (parameters.getType()) {
            case 0: {
                StringBuilder stringBuilder2 = stringBuilder.append("$argon2d");
                break;
            }
            case 1: {
                StringBuilder stringBuilder2 = stringBuilder.append("$argon2i");
                break;
            }
            case 2: {
                StringBuilder stringBuilder2 = stringBuilder.append("$argon2id");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm type: " + parameters.getType());
            }
        }
        stringBuilder.append("$v=").append(parameters.getVersion()).append("$m=").append(parameters.getMemory()).append(",t=").append(parameters.getIterations()).append(",p=").append(parameters.getLanes());
        if (parameters.getSalt() != null) {
            stringBuilder.append("$").append(b64encoder.encodeToString(parameters.getSalt()));
        }
        stringBuilder.append("$").append(b64encoder.encodeToString(hash));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Argon2Hash decode(@NotNull String encodedHash) throws IllegalArgumentException {
        Argon2Parameters.Builder builder;
        Intrinsics.checkNotNullParameter((Object)encodedHash, (String)"encodedHash");
        Argon2Parameters.Builder paramsBuilder = null;
        String[] stringArray = new String[]{"$"};
        String[] $this$toTypedArray$iv = (String[])StringsKt.split$default((CharSequence)encodedHash, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (!(parts.length >= 4)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$62 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$62 = "Invalid encoded Argon2-hash";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$62.toString());
        }
        int currentPart = 1;
        switch (parts[currentPart++]) {
            case "argon2d": {
                builder = new Argon2Parameters.Builder(0);
                break;
            }
            case "argon2i": {
                builder = new Argon2Parameters.Builder(1);
                break;
            }
            case "argon2id": {
                builder = new Argon2Parameters.Builder(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm type: " + parts[0]);
            }
        }
        paramsBuilder = builder;
        if (StringsKt.startsWith$default((String)parts[currentPart], (String)"v=", (boolean)false, (int)2, null)) {
            String string = parts[currentPart].substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            paramsBuilder.withVersion(Integer.parseInt(string));
        }
        int n = ++currentPart;
        ++currentPart;
        thisCollection$iv = new String[]{","};
        Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)parts[n], (String[])thisCollection$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] performanceParams = thisCollection$iv2.toArray(new String[0]);
        if (!(performanceParams.length == 3)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$72 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$72 = "Amount of performance parameters invalid";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$72.toString());
        }
        if (!StringsKt.startsWith$default((String)performanceParams[0], (String)"m=", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$82 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$82 = "Invalid memory parameter";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$82.toString());
        }
        String string = performanceParams[0].substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        paramsBuilder.withMemoryAsKB(Integer.parseInt(string));
        if (!StringsKt.startsWith$default((String)performanceParams[1], (String)"t=", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-Argon2EncodingUtils$decode$92 = false;
            String $i$a$-require-Argon2EncodingUtils$decode$92 = "Invalid iterations parameter";
            throw new IllegalArgumentException($i$a$-require-Argon2EncodingUtils$decode$92.toString());
        }
        String string2 = performanceParams[1].substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        paramsBuilder.withIterations(Integer.parseInt(string2));
        if (!StringsKt.startsWith$default((String)performanceParams[2], (String)"p=", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string3 = "Invalid parallelity parameter";
            throw new IllegalArgumentException(string3.toString());
        }
        String string4 = performanceParams[2].substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        paramsBuilder.withParallelism(Integer.parseInt(string4));
        paramsBuilder.withSalt(b64decoder.decode(parts[currentPart++]));
        byte[] byArray = b64decoder.decode(parts[currentPart]);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        Argon2Parameters argon2Parameters = paramsBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)argon2Parameters, (String)"build(...)");
        return new Argon2Hash(byArray, argon2Parameters);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/leon/hash/argon2/Argon2EncodingUtils$Argon2Hash;", "", "hash", "", "parameters", "Lorg/bouncycastle/crypto/params/Argon2Parameters;", "<init>", "([BLorg/bouncycastle/crypto/params/Argon2Parameters;)V", "getHash", "()[B", "setHash", "([B)V", "getParameters", "()Lorg/bouncycastle/crypto/params/Argon2Parameters;", "app"})
    public static final class Argon2Hash {
        @NotNull
        private byte[] hash;
        @NotNull
        private final Argon2Parameters parameters;

        public Argon2Hash(@NotNull byte[] hash, @NotNull Argon2Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.hash = hash;
            this.parameters = parameters;
        }

        @NotNull
        public final byte[] getHash() {
            return this.hash;
        }

        public final void setHash(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.hash = byArray;
        }

        @NotNull
        public final Argon2Parameters getParameters() {
            return this.parameters;
        }
    }
}

