/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.ext.CharsetKt;
import me.leon.ext.ConverterKt;
import me.leon.ext.crypto.SymmetricCryptoKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"LM_DATA", "", "DES_ALG", "lmHash", "", "ntlmHash", "charset", "app"})
public final class WindowsHashKt {
    @NotNull
    private static final String LM_DATA = "KGS!@#$%";
    @NotNull
    private static final String DES_ALG = "DES/ECB/PKCS5Padding";

    @NotNull
    public static final String lmHash(@NotNull String $this$lmHash) {
        Intrinsics.checkNotNullParameter((Object)$this$lmHash, (String)"<this>");
        if ($this$lmHash.length() > 14) {
            return "";
        }
        String string = $this$lmHash.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.chunked((CharSequence)StringsKt.padEnd((String)ConverterKt.toHex(string), (int)28, (char)'0'), (int)14), (CharSequence)"", null, null, (int)0, null, WindowsHashKt::lmHash$lambda$0, (int)30, null);
    }

    @NotNull
    public static final String lmHash(@NotNull byte[] $this$lmHash) {
        Intrinsics.checkNotNullParameter((Object)$this$lmHash, (String)"<this>");
        return WindowsHashKt.lmHash(StringsKt.decodeToString((byte[])$this$lmHash));
    }

    @NotNull
    public static final String ntlmHash(@NotNull String $this$ntlmHash) {
        Intrinsics.checkNotNullParameter((Object)$this$ntlmHash, (String)"<this>");
        byte[] byArray = $this$ntlmHash.getBytes(Charsets.UTF_16LE);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ConverterKt.toHex(DigestsKt.hash(byArray, "MD4"));
    }

    @NotNull
    public static final String ntlmHash(@NotNull byte[] $this$ntlmHash, @NotNull String charset) {
        Intrinsics.checkNotNullParameter((Object)$this$ntlmHash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] byArray = new String($this$ntlmHash, CharsetKt.toCharset(charset)).getBytes(Charsets.UTF_16LE);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return ConverterKt.toHex(DigestsKt.hash(byArray, "MD4"));
    }

    public static /* synthetic */ String ntlmHash$default(byte[] byArray, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        return WindowsHashKt.ntlmHash(byArray, string);
    }

    private static final CharSequence lmHash$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String key = CollectionsKt.joinToString$default((Iterable)StringsKt.chunked((CharSequence)ConverterKt.toBinaryString$default(ConverterKt.hex2ByteArray(it), false, 1, null), (int)7), (CharSequence)"", null, null, (int)0, null, WindowsHashKt::lmHash$lambda$0$0, (int)30, null);
        String string = LM_DATA;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string = ConverterKt.toHex(SymmetricCryptoKt.encrypt$default(byArray, ConverterKt.hex2ByteArray(key), new byte[0], DES_ALG, null, 8, null));
        int n = 0;
        int n2 = 16;
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    private static final CharSequence lmHash$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConverterKt.toHex(ConverterKt.binary2ByteArray$default(it + '0', false, 1, null));
    }
}

