/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005\u001a#\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002*\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\t\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a%\u0010\f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000e\u001a\u0015\u0010\u000f\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0010*\u00020\u0003\u001a%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0014\u001a%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002*\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0014\u001a;\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002*\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"determinant", "", "", "", "n", "([[II)I", "reshape", "", "dimension", "(Ljava/util/List;I)[[I", "modInverse", "modular", "multMod", "col", "([[I[II)[I", "showMatrix", "", "([[I)V", "showColum", "invert2", "([[II)[[I", "invertModMatrix", "trans", "key", "r", "([[I[[III)[[I", "app"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nme/leon/ext/math/MatrixKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,147:1\n1#2:148\n1563#3:149\n1634#3,3:150\n37#4,2:153\n13343#5,3:155\n13391#5,4:158\n13346#5:162\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nme/leon/ext/math/MatrixKt\n*L\n32#1:149\n32#1:150,3\n32#1:153,2\n49#1:155,3\n50#1:158,4\n49#1:162\n*E\n"})
public final class MatrixKt {
    public static final int determinant(@NotNull int[][] $this$determinant, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$determinant, (String)"<this>");
        int res = 0;
        switch (n) {
            case 1: {
                res = $this$determinant[0][0];
                break;
            }
            case 2: {
                res = $this$determinant[0][0] * $this$determinant[1][1] - $this$determinant[1][0] * $this$determinant[0][1];
                break;
            }
            default: {
                res = 0;
                for (int j1 = 0; j1 < n; ++j1) {
                    int n2 = 0;
                    int n3 = n - 1;
                    int[][] nArrayArray = new int[n3][];
                    while (n2 < n3) {
                        int n4 = n2++;
                        nArrayArray[n4] = new int[n - 1];
                    }
                    int[][] m = nArrayArray;
                    for (int i = 1; i < n; ++i) {
                        int j2 = 0;
                        for (int j = 0; j < n; ++j) {
                            if (j == j1) continue;
                            m[i - 1][j2] = $this$determinant[i][j];
                            ++j2;
                        }
                    }
                    res += (int)(Math.pow(-1.0, 1.0 + (double)j1 + 1.0) * (double)$this$determinant[0][j1] * (double)MatrixKt.determinant(m, n - 1));
                }
            }
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[][] reshape(@NotNull List<Integer> $this$reshape, int dimension) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$reshape, (String)"<this>");
        if (!(Math.sqrt($this$reshape.size()) == (double)dimension)) {
            boolean $i$a$-require-MatrixKt$reshape$22 = false;
            String $i$a$-require-MatrixKt$reshape$22 = "wrong dimension or list";
            throw new IllegalArgumentException($i$a$-require-MatrixKt$reshape$22.toString());
        }
        Iterable $this$map$iv = CollectionsKt.chunked((Iterable)$this$reshape, (int)dimension);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.toIntArray((Collection)((Collection)it)));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return (int[][])thisCollection$iv.toArray((T[])new int[0][]);
    }

    public static final int modInverse(int $this$modInverse, int modular) {
        int tmp = $this$modInverse % modular;
        for (int i = 1; i < modular; ++i) {
            if (tmp * i % modular != 1) continue;
            return i;
        }
        return -1;
    }

    public static /* synthetic */ int modInverse$default(int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 26;
        }
        return MatrixKt.modInverse(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final int[] multMod(@NotNull int[][] $this$multMod, @NotNull int[] col, int modular) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$this$multMod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        if (!($this$multMod[0].length == col.length)) {
            boolean $i$a$-require-MatrixKt$multMod$22 = false;
            String $i$a$-require-MatrixKt$multMod$22 = "col size must be matrix's row";
            throw new IllegalArgumentException($i$a$-require-MatrixKt$multMod$22.toString());
        }
        Object[] objectArray = (Object[])$this$multMod;
        int[] initial$iv = new int[col.length];
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int[] accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void $this$foldIndexed$iv2;
            void initial$iv2;
            void ints;
            void acc;
            void var15_17;
            int n = index$iv++;
            int[] nArray = (int[])element$iv;
            int[] nArray2 = accumulator$iv;
            int i = n;
            boolean bl = false;
            void $this$multMod_u24lambda_u241_u240 = var15_17 = acc;
            boolean bl2 = false;
            void var18_20 = ints;
            boolean bl3 = false;
            int n2 = i;
            void var21_23 = acc;
            boolean $i$f$foldIndexed2 = false;
            int index$iv2 = 0;
            void accumulator$iv2 = initial$iv2;
            for (void element$iv2 : $this$foldIndexed$iv2) {
                void intVal;
                void acc2;
                int n3 = index$iv2++;
                void var28_30 = element$iv2;
                void var29_31 = accumulator$iv2;
                int j = n3;
                boolean bl4 = false;
                accumulator$iv2 = acc2 + intVal * col[j];
            }
            void var32_34 = accumulator$iv2;
            var21_23[n2] = var32_34 % modular;
            accumulator$iv = var15_17;
        }
        return accumulator$iv;
    }

    public static final void showMatrix(@NotNull int[][] $this$showMatrix) {
        Intrinsics.checkNotNullParameter((Object)$this$showMatrix, (String)"<this>");
        String string = ">>>>>\tmatrix row " + ((Object[])$this$showMatrix).length + "  col " + $this$showMatrix[0].length + '\n' + ArraysKt.joinToString$default((Object[])((Object[])$this$showMatrix), (CharSequence)"\n", null, null, (int)0, null, MatrixKt::showMatrix$lambda$0, (int)30, null) + "\n<<<<<<";
        System.out.println((Object)string);
    }

    public static final void showColum(@NotNull int[] $this$showColum) {
        Intrinsics.checkNotNullParameter((Object)$this$showColum, (String)"<this>");
        System.out.println((Object)(">>>>>\tcolum " + $this$showColum.length + '\n' + ArraysKt.joinToString$default((int[])$this$showColum, (CharSequence)"\t\n", null, null, (int)0, null, null, (int)62, null) + "\n<<<<<<"));
    }

    @NotNull
    public static final int[][] invert2(@NotNull int[][] $this$invert2, int modular) {
        Intrinsics.checkNotNullParameter((Object)$this$invert2, (String)"<this>");
        int a = MatrixKt.modInverse(MatrixKt.determinant($this$invert2, ((Object[])$this$invert2).length), modular);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[]{$this$invert2[1][1] * a, -$this$invert2[0][1] * a};
        nArrayArray[0] = nArray;
        nArray = new int[]{-$this$invert2[1][0] * a, $this$invert2[0][0] * a};
        nArrayArray[1] = nArray;
        return nArrayArray;
    }

    public static /* synthetic */ int[][] invert2$default(int[][] nArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 26;
        }
        return MatrixKt.invert2(nArray, n);
    }

    @NotNull
    public static final int[][] invertModMatrix(@NotNull int[][] $this$invertModMatrix, int modular) {
        Intrinsics.checkNotNullParameter((Object)$this$invertModMatrix, (String)"<this>");
        if (((Object[])$this$invertModMatrix).length == 2) {
            return MatrixKt.invert2($this$invertModMatrix, modular);
        }
        int n = 0;
        int n2 = ((Object[])$this$invertModMatrix).length;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[((Object[])$this$invertModMatrix).length];
        }
        int[][] b = nArrayArray;
        n2 = 0;
        int n4 = ((Object[])$this$invertModMatrix).length;
        int[][] nArrayArray2 = new int[n4][];
        while (n2 < n4) {
            int n5 = n2++;
            nArrayArray2[n5] = new int[((Object[])$this$invertModMatrix).length];
        }
        int[][] fac = nArrayArray2;
        int p = 0;
        int m = 0;
        int n6 = 0;
        int i = 0;
        int j = 0;
        for (int q = 0; q < ((Object[])$this$invertModMatrix).length; ++q) {
            for (p = 0; p < ((Object[])$this$invertModMatrix).length; ++p) {
                m = 0;
                n6 = 0;
                for (i = 0; i < ((Object[])$this$invertModMatrix).length; ++i) {
                    for (j = 0; j < ((Object[])$this$invertModMatrix).length; ++j) {
                        b[i][j] = 0;
                        if (i == q || j == p) continue;
                        b[m][n6] = $this$invertModMatrix[i][j];
                        if (n6 < ((Object[])$this$invertModMatrix).length - 2) {
                            ++n6;
                            continue;
                        }
                        n6 = 0;
                        ++m;
                    }
                }
                fac[q][p] = (int)Math.pow(-1.0, q + p) * MatrixKt.determinant(b, ((Object[])$this$invertModMatrix).length - 1);
            }
        }
        return MatrixKt.trans(fac, $this$invertModMatrix, ((Object[])$this$invertModMatrix).length, modular);
    }

    public static /* synthetic */ int[][] invertModMatrix$default(int[][] nArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 26;
        }
        return MatrixKt.invertModMatrix(nArray, n);
    }

    @NotNull
    public static final int[][] trans(@NotNull int[][] $this$trans, @NotNull int[][] key, int r, int modular) {
        int i;
        Intrinsics.checkNotNullParameter((Object)$this$trans, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int j = 0;
        int n = 0;
        int[][] nArrayArray = new int[r][];
        while (n < r) {
            int n2 = n++;
            nArrayArray[n2] = new int[r];
        }
        int[][] b = nArrayArray;
        int n3 = 0;
        int[][] nArrayArray2 = new int[r][];
        while (n3 < r) {
            int n4 = n3++;
            nArrayArray2[n4] = new int[r];
        }
        int[][] inv = nArrayArray2;
        int d = MatrixKt.determinant(key, r);
        int mi = MatrixKt.modInverse(d, modular);
        for (i = 0; i < r; ++i) {
            for (j = 0; j < r; ++j) {
                b[i][j] = $this$trans[j][i];
            }
        }
        for (i = 0; i < r; ++i) {
            j = 0;
            while (j < r) {
                int n5;
                int[] nArray;
                inv[i][j] = b[i][j] % modular;
                if (inv[i][j] < 0) {
                    nArray = inv[i];
                    n5 = j;
                    nArray[n5] = nArray[n5] + modular;
                }
                nArray = inv[i];
                n5 = j;
                nArray[n5] = nArray[n5] * mi;
                nArray = inv[i];
                n5 = j++;
                nArray[n5] = nArray[n5] % modular;
            }
        }
        return inv;
    }

    public static /* synthetic */ int[][] trans$default(int[][] nArray, int[][] nArray2, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 26;
        }
        return MatrixKt.trans(nArray, nArray2, n, n2);
    }

    private static final CharSequence showMatrix$lambda$0(int[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ArraysKt.joinToString$default((int[])it, (CharSequence)"  ", null, null, (int)0, null, null, (int)62, null);
    }
}

