/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/leon/ext/crypto/XXTEA;", "", "<init>", "()V", "DELTA", "", "mx", "sum", "y", "z", "p", "e", "k", "", "encrypt", "", "data", "key", "", "decrypt", "decryptToString", "v", "fixKey", "toIntArray", "includeLength", "", "toByteArray", "app"})
public final class XXTEA {
    @NotNull
    public static final XXTEA INSTANCE = new XXTEA();
    private static final int DELTA = -1640531527;

    private XXTEA() {
    }

    private final int mx(int sum, int y, int z, int p, int e, int[] k) {
        return (z >>> 5 ^ y << 2) + (y >>> 3 ^ z << 4) ^ (sum ^ y) + (k[p & 3 ^ e] ^ z);
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return data.length == 0 ? data : this.toByteArray(this.encrypt(this.toIntArray(data, true), this.toIntArray(this.fixKey(key), false)), false);
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull String data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        byte[] byArray = data.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Charset charset2 = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
        byte[] byArray2 = key.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        return INSTANCE.encrypt(byArray, byArray2);
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return data.length == 0 ? data : this.toByteArray(this.decrypt(this.toIntArray(data, false), this.toIntArray(this.fixKey(key), false)), true);
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.decrypt(data, byArray);
    }

    @JvmStatic
    @NotNull
    public static final String decryptToString(@NotNull byte[] data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = INSTANCE.decrypt(data, key);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        return new String(byArray, charset);
    }

    private final int[] encrypt(int[] v, int[] k) {
        int n = v.length - 1;
        if (n < 1) {
            return v;
        }
        int p = 0;
        int q = 6 + 52 / (n + 1);
        int z = v[n];
        int y = 0;
        long sum = 0L;
        int e = 0;
        while (q-- > 0) {
            e = (int)((sum += (long)-1640531527) >>> 2 & 3L);
            for (p = 0; p < n; ++p) {
                y = v[p + 1];
                int n2 = p;
                v[n2] = v[n2] + this.mx((int)sum, y, z, p, e, k);
                z = v[p];
            }
            y = v[0];
            v[n] = v[n] + this.mx((int)sum, y, z, p, e, k);
            z = v[n];
        }
        return v;
    }

    private final int[] decrypt(int[] v, int[] k) {
        int n = v.length - 1;
        if (n < 1) {
            return v;
        }
        int p = 0;
        int q = 6 + 52 / (n + 1);
        int z = 0;
        int y = v[0];
        int e = 0;
        for (int sum = q * -1640531527; sum != 0; sum -= -1640531527) {
            e = sum >>> 2 & 3;
            for (p = n; p > 0; --p) {
                z = v[p - 1];
                int n2 = p;
                v[n2] = v[n2] - this.mx(sum, y, z, p, e, k);
                y = v[p];
            }
            z = v[n];
            v[0] = v[0] - this.mx(sum, y, z, p, e, k);
            y = v[0];
        }
        return v;
    }

    private final byte[] fixKey(byte[] key) {
        if (key.length == 16) {
            return key;
        }
        byte[] fixedKey = new byte[16];
        System.arraycopy(key, 0, fixedKey, 0, Math.min(key.length, 16));
        return fixedKey;
    }

    private final int[] toIntArray(byte[] data, boolean includeLength) {
        int n = (data.length & 3) == 0 ? data.length >>> 2 : (data.length >>> 2) + 1;
        int[] result = null;
        if (includeLength) {
            result = new int[n + 1];
            result[n] = data.length;
        } else {
            result = new int[n];
        }
        n = data.length;
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            result[i >>> 2] = result[i >>> 2] | (0xFF & data[i]) << ((i & 3) << 3);
        }
        return result;
    }

    private final byte[] toByteArray(int[] data, boolean includeLength) {
        int n = data.length << 2;
        if (includeLength) {
            int m = data[data.length - 1];
            if (m < (n -= 4) - 3 || m > n) {
                return new byte[0];
            }
            n = m;
        }
        byte[] result = new byte[n];
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            result[i] = (byte)(data[i >>> 2] >>> ((i & 3) << 3));
        }
        return result;
    }
}

