/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import me.leon.ctf.rsa.FactorsKt;
import me.leon.ext.crypto.CalculatorKt;
import me.leon.ext.crypto.ICalculator;
import me.leon.ext.math.BigIntegerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b'\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*\u00a8\u0006+"}, d2={"Lme/leon/ext/crypto/Calculator;", "Lme/leon/ext/crypto/ICalculator;", "", "algo", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getAlgo", "()Ljava/lang/String;", "PLUS", "MINUS", "MULTIPLY", "DIVIDE_REMAINDER", "EXPONENT", "ROOT", "MOD", "PLUS_MOD", "MINUS_MOD", "MULTIPLY_MOD", "DIVIDE_MOD", "MOD_POW", "INVERSE", "PRIME", "FACTOR", "RSA_D", "RSA_DECRYPT", "GCD", "LCM", "KGCD", "GEN_PRIME", "PRIME_NEXT", "AND", "OR", "NOT", "AND_NOT", "XOR", "SHIFT_LEFT", "SHIFT_RIGHT", "COMPLEX0", "FACTORIAL", "FACTORIAL_PRIME", "PERMUTATION", "COMBINATION", "app"})
public abstract class Calculator
extends Enum<Calculator>
implements ICalculator {
    @NotNull
    private final String algo;
    public static final /* enum */ Calculator PLUS = new PLUS("PLUS", 0);
    public static final /* enum */ Calculator MINUS = new MINUS("MINUS", 1);
    public static final /* enum */ Calculator MULTIPLY = new MULTIPLY("MULTIPLY", 2);
    public static final /* enum */ Calculator DIVIDE_REMAINDER = new DIVIDE_REMAINDER("DIVIDE_REMAINDER", 3);
    public static final /* enum */ Calculator EXPONENT = new EXPONENT("EXPONENT", 4);
    public static final /* enum */ Calculator ROOT = new ROOT("ROOT", 5);
    public static final /* enum */ Calculator MOD = new MOD("MOD", 6);
    public static final /* enum */ Calculator PLUS_MOD = new PLUS_MOD("PLUS_MOD", 7);
    public static final /* enum */ Calculator MINUS_MOD = new MINUS_MOD("MINUS_MOD", 8);
    public static final /* enum */ Calculator MULTIPLY_MOD = new MULTIPLY_MOD("MULTIPLY_MOD", 9);
    public static final /* enum */ Calculator DIVIDE_MOD = new DIVIDE_MOD("DIVIDE_MOD", 10);
    public static final /* enum */ Calculator MOD_POW = new MOD_POW("MOD_POW", 11);
    public static final /* enum */ Calculator INVERSE = new INVERSE("INVERSE", 12);
    public static final /* enum */ Calculator PRIME = new PRIME("PRIME", 13);
    public static final /* enum */ Calculator FACTOR = new FACTOR("FACTOR", 14);
    public static final /* enum */ Calculator RSA_D = new RSA_D("RSA_D", 15);
    public static final /* enum */ Calculator RSA_DECRYPT = new RSA_DECRYPT("RSA_DECRYPT", 16);
    public static final /* enum */ Calculator GCD = new GCD("GCD", 17);
    public static final /* enum */ Calculator LCM = new LCM("LCM", 18);
    public static final /* enum */ Calculator KGCD = new KGCD("KGCD", 19);
    public static final /* enum */ Calculator GEN_PRIME = new GEN_PRIME("GEN_PRIME", 20);
    public static final /* enum */ Calculator PRIME_NEXT = new PRIME_NEXT("PRIME_NEXT", 21);
    public static final /* enum */ Calculator AND = new AND("AND", 22);
    public static final /* enum */ Calculator OR = new OR("OR", 23);
    public static final /* enum */ Calculator NOT = new NOT("NOT", 24);
    public static final /* enum */ Calculator AND_NOT = new AND_NOT("AND_NOT", 25);
    public static final /* enum */ Calculator XOR = new XOR("XOR", 26);
    public static final /* enum */ Calculator SHIFT_LEFT = new SHIFT_LEFT("SHIFT_LEFT", 27);
    public static final /* enum */ Calculator SHIFT_RIGHT = new SHIFT_RIGHT("SHIFT_RIGHT", 28);
    public static final /* enum */ Calculator COMPLEX0 = new COMPLEX0("COMPLEX0", 29);
    public static final /* enum */ Calculator FACTORIAL = new FACTORIAL("FACTORIAL", 30);
    public static final /* enum */ Calculator FACTORIAL_PRIME = new FACTORIAL_PRIME("FACTORIAL_PRIME", 31);
    public static final /* enum */ Calculator PERMUTATION = new PERMUTATION("PERMUTATION", 32);
    public static final /* enum */ Calculator COMBINATION = new COMBINATION("COMBINATION", 33);
    private static final /* synthetic */ Calculator[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Calculator(String algo) {
        this.algo = algo;
    }

    @NotNull
    public final String getAlgo() {
        return this.algo;
    }

    public static Calculator[] values() {
        return (Calculator[])$VALUES.clone();
    }

    public static Calculator valueOf(String value) {
        return Enum.valueOf(Calculator.class, value);
    }

    @NotNull
    public static EnumEntries<Calculator> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ Calculator(String $enum$name, int $enum$ordinal, String algo, DefaultConstructorMarker $constructor_marker) {
        this(algo);
    }

    static {
        $VALUES = calculatorArray = new Calculator[]{Calculator.PLUS, Calculator.MINUS, Calculator.MULTIPLY, Calculator.DIVIDE_REMAINDER, Calculator.EXPONENT, Calculator.ROOT, Calculator.MOD, Calculator.PLUS_MOD, Calculator.MINUS_MOD, Calculator.MULTIPLY_MOD, Calculator.DIVIDE_MOD, Calculator.MOD_POW, Calculator.INVERSE, Calculator.PRIME, Calculator.FACTOR, Calculator.RSA_D, Calculator.RSA_DECRYPT, Calculator.GCD, Calculator.LCM, Calculator.KGCD, Calculator.GEN_PRIME, Calculator.PRIME_NEXT, Calculator.AND, Calculator.OR, Calculator.NOT, Calculator.AND_NOT, Calculator.XOR, Calculator.SHIFT_LEFT, Calculator.SHIFT_RIGHT, Calculator.COMPLEX0, Calculator.FACTORIAL, Calculator.FACTORIAL_PRIME, Calculator.PERMUTATION, Calculator.COMBINATION};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.AND", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class AND
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        AND() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).and(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.AND_NOT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class AND_NOT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        AND_NOT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).andNot(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.COMBINATION", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    @SourceDebugExtension(value={"SMAP\nCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$COMBINATION\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    static final class COMBINATION
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        COMBINATION() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            int p = ints.get(0).intValue();
            int q = ints.get(1).intValue();
            if (!(1 <= p ? p < 120001 : false)) {
                boolean $i$a$-require-Calculator$COMBINATION$calculate$32 = false;
                String $i$a$-require-Calculator$COMBINATION$calculate$32 = "range: 1<=P<=120000";
                throw new IllegalArgumentException($i$a$-require-Calculator$COMBINATION$calculate$32.toString());
            }
            if (!(q <= p)) {
                boolean bl = false;
                String string = "q must <= p";
                throw new IllegalArgumentException(string.toString());
            }
            BigInteger proper = p == q ? BigInteger.ONE : CalculatorKt.product(p - q);
            BigInteger bigInteger = CalculatorKt.product(p);
            BigInteger bigInteger2 = CalculatorKt.product(q);
            Intrinsics.checkNotNull((Object)proper);
            BigInteger bigInteger3 = bigInteger2.multiply(proper);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"multiply(...)");
            BigInteger bigInteger4 = bigInteger.divide(bigInteger3);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
            String string = bigInteger4.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.COMPLEX0", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class COMPLEX0
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        COMPLEX0() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            BigInteger bigInteger = ints.get(0).multiply(ints.get(3));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
            BigInteger bigInteger2 = ints.get(1).multiply(ints.get(4));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"multiply(...)");
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"add(...)");
            String string = bigInteger3.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.DIVIDE_MOD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    @SourceDebugExtension(value={"SMAP\nCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$DIVIDE_MOD\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    static final class DIVIDE_MOD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        DIVIDE_MOD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            boolean isMutualPrime = BigIntegerKt.mutualPrime(ints.get(1), ints.get(2));
            if (!isMutualPrime) {
                boolean bl = false;
                String string = "P and N are not mutual prime!";
                throw new IllegalArgumentException(string.toString());
            }
            BigInteger bigInteger = ints.get(0).mod(ints.get(2));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"mod(...)");
            BigInteger bigInteger2 = bigInteger;
            BigInteger bigInteger3 = ints.get(1).modInverse(ints.get(2));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"modInverse(...)");
            BigInteger bigInteger4 = bigInteger2.multiply(bigInteger3);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"multiply(...)");
            String string = bigInteger4.mod(ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.DIVIDE_REMAINDER", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class DIVIDE_REMAINDER
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        DIVIDE_REMAINDER() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            BigInteger[] bigIntegerArray = ints.get(0).divideAndRemainder(ints.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)bigIntegerArray, (String)"divideAndRemainder(...)");
            return ArraysKt.joinToString$default((Object[])bigIntegerArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.EXPONENT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class EXPONENT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        EXPONENT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).pow(ints.get(3).intValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.FACTOR", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class FACTOR
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        FACTOR() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            return CollectionsKt.joinToString$default((Iterable)FactorsKt.factor(ints.get(2)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.FACTORIAL", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    @SourceDebugExtension(value={"SMAP\nCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$FACTORIAL\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    static final class FACTORIAL
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        FACTORIAL() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            int intNum = ints.get(0).intValue();
            if (!(1 <= intNum ? intNum < 120001 : false)) {
                boolean bl = false;
                String string = "range: 1<=P<=120000";
                throw new IllegalArgumentException(string.toString());
            }
            String string = CalculatorKt.product(intNum).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.FACTORIAL_PRIME", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    @SourceDebugExtension(value={"SMAP\nCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$FACTORIAL_PRIME\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n1#2:207\n1563#3:208\n1634#3,3:209\n774#3:212\n865#3,2:213\n2783#3,7:215\n*S KotlinDebug\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$FACTORIAL_PRIME\n*L\n177#1:208\n177#1:209,3\n178#1:212\n178#1:213,2\n179#1:215,7\n*E\n"})
    static final class FACTORIAL_PRIME
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        FACTORIAL_PRIME() {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            int intNum = ints.get(0).intValue();
            if (!(1 <= intNum ? intNum < 120001 : false)) {
                boolean $i$a$-require-Calculator$FACTORIAL_PRIME$calculate$22 = false;
                String $i$a$-require-Calculator$FACTORIAL_PRIME$calculate$22 = "range: 1<=P<=120000";
                throw new IllegalArgumentException($i$a$-require-Calculator$FACTORIAL_PRIME$calculate$22.toString());
            }
            Iterable $this$map$iv = (Iterable)new IntRange(1, intNum);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                BigInteger bigInteger = BigInteger.valueOf((long)it);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
                collection.add(bigInteger);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BigInteger it = (BigInteger)element$iv$iv;
                boolean bl = false;
                if (!it.isProbablePrime(100)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                BigInteger $i$f$filterTo2 = (BigInteger)iterator$iv.next();
                BigInteger acc = (BigInteger)accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)acc.multiply((BigInteger)i), (String)"multiply(...)");
            }
            String string = ((BigInteger)accumulator$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.GCD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class GCD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        GCD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).gcd(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.GEN_PRIME", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class GEN_PRIME
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        GEN_PRIME() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = BigInteger.probablePrime(ints.get(0).intValue(), SecureRandom.getInstance("SHA1PRNG")).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.INVERSE", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class INVERSE
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        INVERSE() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).modInverse(ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.KGCD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class KGCD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        KGCD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            return ArraysKt.joinToString$default((Object[])BigIntegerKt.gcdExt(ints.get(0), ints.get(1)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.LCM", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class LCM
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        LCM() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = BigIntegerKt.lcm(ints.get(0), ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.MINUS", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class MINUS
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        MINUS() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            BigInteger bigInteger = ints.get(0).subtract(ints.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
            String string = bigInteger.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.MINUS_MOD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class MINUS_MOD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        MINUS_MOD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).subtract(ints.get(1)).mod(ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.MOD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class MOD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        MOD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).mod(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.MOD_POW", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class MOD_POW
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        MOD_POW() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).modPow(ints.get(3), ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.MULTIPLY", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class MULTIPLY
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        MULTIPLY() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            BigInteger bigInteger = ints.get(0).multiply(ints.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
            String string = bigInteger.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.MULTIPLY_MOD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class MULTIPLY_MOD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        MULTIPLY_MOD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).multiply(ints.get(1)).mod(ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.NOT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class NOT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        NOT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).not().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.OR", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class OR
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        OR() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).or(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.PERMUTATION", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    @SourceDebugExtension(value={"SMAP\nCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$PERMUTATION\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    static final class PERMUTATION
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        PERMUTATION() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            int p = ints.get(0).intValue();
            int q = ints.get(1).intValue();
            if (!(1 <= p ? p < 120001 : false)) {
                boolean $i$a$-require-Calculator$PERMUTATION$calculate$32 = false;
                String $i$a$-require-Calculator$PERMUTATION$calculate$32 = "range: 1<=P<=120000";
                throw new IllegalArgumentException($i$a$-require-Calculator$PERMUTATION$calculate$32.toString());
            }
            if (!(q <= p)) {
                boolean bl = false;
                String string = "q must <= p";
                throw new IllegalArgumentException(string.toString());
            }
            BigInteger proper = p == q ? BigInteger.ONE : CalculatorKt.product(p - q);
            BigInteger bigInteger = CalculatorKt.product(p);
            Intrinsics.checkNotNull((Object)proper);
            BigInteger bigInteger2 = bigInteger.divide(proper);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"divide(...)");
            String string = bigInteger2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.PLUS", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class PLUS
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        PLUS() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            System.out.println(ints);
            String string = ints.get(0).add(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.PLUS_MOD", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class PLUS_MOD
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        PLUS_MOD() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).add(ints.get(1)).mod(ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.PRIME", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class PRIME
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        PRIME() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            return String.valueOf(ints.get(0).isProbablePrime(100));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.PRIME_NEXT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class PRIME_NEXT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        PRIME_NEXT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).nextProbablePrime().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.ROOT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    @SourceDebugExtension(value={"SMAP\nCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Calculator.kt\nme/leon/ext/crypto/Calculator$ROOT\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    static final class ROOT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        ROOT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            BigInteger[] $this$calculate_u24lambda_u240 = BigIntegerKt.root(ints.get(0), ints.get(3).intValue());
            boolean bl = false;
            return "" + $this$calculate_u24lambda_u240[0] + '\n' + $this$calculate_u24lambda_u240[1];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.RSA_D", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class RSA_D
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        RSA_D() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = BigIntegerKt.invert(ints.get(3), BigIntegerKt.phi(ints.get(0), ints.get(1))).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.RSA_DECRYPT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class RSA_DECRYPT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        RSA_DECRYPT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(5).modPow(ints.get(4), ints.get(2)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.SHIFT_LEFT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class SHIFT_LEFT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        SHIFT_LEFT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).shiftLeft(ints.get(3).intValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.SHIFT_RIGHT", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class SHIFT_RIGHT
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        SHIFT_RIGHT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).shiftRight(ints.get(3).intValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"me/leon/ext/crypto/Calculator.XOR", "Lme/leon/ext/crypto/Calculator;", "calculate", "", "ints", "", "Ljava/math/BigInteger;", "app"})
    static final class XOR
    extends Calculator {
        /*
         * WARNING - void declaration
         */
        XOR() {
            void var1_1;
        }

        @Override
        @NotNull
        public String calculate(@NotNull List<? extends BigInteger> ints) {
            Intrinsics.checkNotNullParameter(ints, (String)"ints");
            String string = ints.get(0).xor(ints.get(1)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

