/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.ext.ParamsParserKt;
import me.leon.ext.crypto.EncodeRegexsKt;
import me.leon.ext.crypto.RsaKt;
import me.leon.ext.crypto.SMKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import org.bouncycastle.pqc.jcajce.spec.LMSKeyGenParameterSpec;
import org.bouncycastle.pqc.jcajce.spec.SPHINCSPlusParameterSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0016\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u001a\u0010\u001c\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u001c\u0010\u001c\u001a\u00020\u0013*\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0001\u001a&\u0010\u001e\u001a\u00020\u0013*\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0006\u001a\f\u0010 \u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010!\u001a\u00020\"*\u00020\u0001H\u0002\u001a$\u0010\u001e\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0006\u001a\n\u0010#\u001a\u00020\u0013*\u00020\u0001\u001a\u001c\u0010$\u001a\u00020\u0013*\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010%2\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u001a\u0010&\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001\u001a&\u0010'\u001a\u00020\u0013*\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010%2\u0006\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0006\u001a$\u0010(\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0006\u001a!\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u0006\u00a2\u0006\u0002\u0010,\u001a\f\u0010-\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a)\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010\u0019\u001a\u00020\u00012\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0005\u00a2\u0006\u0002\u00101\u001a\u001e\u00102\u001a\u0002032\u0006\u0010\u0019\u001a\u00020\u00012\u000e\b\u0002\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0005\u001a \u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0001\u001a\u000e\u00107\u001a\u00020\u00012\u0006\u00108\u001a\u00020\u0001\u001a\u000e\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001\u001a\u0014\u0010;\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u0001\u001a\n\u0010<\u001a\u00020\u0001*\u00020%\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"ELGAMAL", "", "SM2_C1C2C3", "ASYMMETRIC_ALGOS", "", "", "", "getASYMMETRIC_ALGOS", "()Ljava/util/Map;", "RSA_PADDINGS", "getRSA_PADDINGS", "()Ljava/util/List;", "OAEP_PARAM_SPEC_SHA1", "Ljavax/crypto/spec/OAEPParameterSpec;", "getOAEP_PARAM_SPEC_SHA1", "()Ljavax/crypto/spec/OAEPParameterSpec;", "removePemArmor", "propCipherAlgorithm", "getPropPublicKey", "", "key", "parsePublicKeyFromCerFile", "Ljava/io/File;", "toPublicKey", "Ljava/security/PublicKey;", "alg", "toPrivateKey", "Ljava/security/PrivateKey;", "pubDecrypt", "publicKey", "pubEncrypt", "reserved", "properOAEPAlg", "isOAEP", "", "keyAutoDecode", "asymmetricDecrypt", "Ljava/security/Key;", "privateDecrypt", "asymmetricEncrypt", "privateEncrypt", "genBase64KeyArray", "", "keySize", "(Ljava/lang/String;I)[Ljava/lang/String;", "properKeyPairAlg", "ecGenParameterSpec", "params", "", "(Ljava/lang/String;Ljava/util/List;)[Ljava/lang/String;", "genKeyPair", "Ljava/security/KeyPair;", "checkKeyPair", "pub", "pri", "pkcs8ToPkcs1", "pkcs8", "pkcs1ToPkcs8", "pkcs1", "privateKeyDerivedPublicKey", "parseRsaInfo", "app"})
@SourceDebugExtension(value={"SMAP\nAsymmetircCrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsymmetircCrypto.kt\nme/leon/ext/crypto/AsymmetircCryptoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,374:1\n1803#2,2:375\n1805#2:378\n1803#2,3:379\n1803#2,3:382\n1803#2,3:385\n1#3:377\n*S KotlinDebug\n*F\n+ 1 AsymmetircCrypto.kt\nme/leon/ext/crypto/AsymmetircCryptoKt\n*L\n135#1:375,2\n135#1:378\n160#1:379,3\n206#1:382,3\n239#1:385,3\n*E\n"})
public final class AsymmetircCryptoKt {
    @NotNull
    private static final String ELGAMAL = "ElGamal";
    @NotNull
    public static final String SM2_C1C2C3 = "SM2-C1C2C3";
    @NotNull
    private static final Map<String, List<Integer>> ASYMMETRIC_ALGOS;
    @NotNull
    private static final List<String> RSA_PADDINGS;
    @NotNull
    private static final OAEPParameterSpec OAEP_PARAM_SPEC_SHA1;
    @NotNull
    private static final Map<String, String> ecGenParameterSpec;

    @NotNull
    public static final Map<String, List<Integer>> getASYMMETRIC_ALGOS() {
        return ASYMMETRIC_ALGOS;
    }

    @NotNull
    public static final List<String> getRSA_PADDINGS() {
        return RSA_PADDINGS;
    }

    @NotNull
    public static final OAEPParameterSpec getOAEP_PARAM_SPEC_SHA1() {
        return OAEP_PARAM_SPEC_SHA1;
    }

    @NotNull
    public static final String removePemArmor(@NotNull String $this$removePemArmor) {
        Intrinsics.checkNotNullParameter((Object)$this$removePemArmor, (String)"<this>");
        CharSequence charSequence = $this$removePemArmor;
        Regex regex = new Regex("---+(?:END|BEGIN) (?:RSA |EC |DSA )?\\w+ KEY---+|\n|\r|\r\n");
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String propCipherAlgorithm(@NotNull String $this$propCipherAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$propCipherAlgorithm, (String)"<this>");
        return AsymmetircCryptoKt.properKeyPairAlg(AsymmetircCryptoKt.properOAEPAlg($this$propCipherAlgorithm));
    }

    @NotNull
    public static final byte[] getPropPublicKey(@NotNull String key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)"-----BEGIN CERTIFICATE-----", (boolean)false, (int)2, null)) {
            String string = key;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            byte[] byArray3 = CertificateFactory.getInstance("X.509", "BC").generateCertificate(byteArrayInputStream).getPublicKey().getEncoded();
            Intrinsics.checkNotNull((Object)byArray3);
            byArray = byArray3;
        } else {
            byArray = AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemArmor(key));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String parsePublicKeyFromCerFile(@NotNull File $this$parsePublicKeyFromCerFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$parsePublicKeyFromCerFile, (String)"<this>");
        Closeable closeable = new FileInputStream($this$parsePublicKeyFromCerFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            byte[] byArray = CertificateFactory.getInstance("X.509", "BC").generateCertificate(it).getPublicKey().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            string = Base64Kt.base64$default(byArray, null, false, 3, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @Nullable
    public static final PublicKey toPublicKey(@NotNull String $this$toPublicKey, @NotNull String alg) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)$this$toPublicKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(AsymmetircCryptoKt.getPropPublicKey($this$toPublicKey));
            publicKey = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePublic(keySpec);
        }
        catch (Exception ignore) {
            PublicKey publicKey2;
            if (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null)) {
                BigInteger bigInteger;
                Map<String, BigInteger> $this$toPublicKey_u24lambda_u240 = ParamsParserKt.parseRsaParams($this$toPublicKey);
                boolean bl = false;
                KeyFactory keyFactory = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg));
                BigInteger bigInteger2 = $this$toPublicKey_u24lambda_u240.get("n");
                if (bigInteger2 == null) {
                    bigInteger2 = new BigInteger($this$toPublicKey, 16);
                }
                if ((bigInteger = $this$toPublicKey_u24lambda_u240.get("e")) == null) {
                    bigInteger = new BigInteger("10001", 16);
                }
                publicKey2 = keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger));
            } else {
                publicKey2 = null;
            }
            publicKey = publicKey2;
        }
        return publicKey;
    }

    @Nullable
    public static final PrivateKey toPrivateKey(@NotNull String $this$toPrivateKey, @NotNull String alg) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter((Object)$this$toPrivateKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemArmor($this$toPrivateKey)));
            privateKey = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePrivate(keySpec);
        }
        catch (Exception ignore) {
            PrivateKey privateKey2;
            if (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null)) {
                Map<String, BigInteger> $this$toPrivateKey_u24lambda_u240 = ParamsParserKt.parseRsaParams($this$toPrivateKey);
                boolean bl = false;
                privateKey2 = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePrivate(new RSAPrivateKeySpec($this$toPrivateKey_u24lambda_u240.get("n"), $this$toPrivateKey_u24lambda_u240.get("d")));
            } else {
                privateKey2 = null;
            }
            privateKey = privateKey2;
        }
        return privateKey;
    }

    @NotNull
    public static final byte[] pubDecrypt(@NotNull byte[] $this$pubDecrypt, @NotNull String key, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$pubDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        return AsymmetircCryptoKt.pubDecrypt($this$pubDecrypt, AsymmetircCryptoKt.toPublicKey(key, alg), alg);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] pubDecrypt(@NotNull byte[] $this$pubDecrypt, @Nullable PublicKey publicKey, @NotNull String alg) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$pubDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$pubDecrypt_u24lambda_u240 = Cipher.getInstance(AsymmetircCryptoKt.propCipherAlgorithm(alg));
        boolean bl = false;
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$pubDecrypt_u24lambda_u240.init(2, (Key)publicKey, OAEP_PARAM_SPEC_SHA1);
            byte[] byArray = $this$pubDecrypt_u24lambda_u240.doFinal($this$pubDecrypt);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }
        $this$pubDecrypt_u24lambda_u240.init(2, publicKey);
        Iterable iterable = ArraysKt.asIterable((byte[])$this$pubDecrypt);
        PublicKey publicKey2 = publicKey;
        Intrinsics.checkNotNull((Object)publicKey2);
        Iterable iterable2 = CollectionsKt.chunked((Iterable)iterable, (int)(RsaKt.bitLength(publicKey2) / 8), arg_0 -> AsymmetircCryptoKt.pubDecrypt$lambda$0$0($this$pubDecrypt_u24lambda_u240, arg_0));
        ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
        boolean $i$f$fold = false;
        ByteArrayOutputStream accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bytes;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray = (byte[])element$iv;
            ByteArrayOutputStream acc = accumulator$iv;
            boolean bl2 = false;
            ByteArrayOutputStream it = byteArrayOutputStream = acc;
            boolean bl3 = false;
            acc.write((byte[])bytes);
            accumulator$iv = byteArrayOutputStream;
        }
        byte[] byArray = accumulator$iv.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] pubEncrypt(@NotNull byte[] $this$pubEncrypt, @Nullable PublicKey publicKey, @NotNull String alg, int reserved) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$pubEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$pubEncrypt_u24lambda_u240 = Cipher.getInstance(AsymmetircCryptoKt.propCipherAlgorithm(alg));
        boolean bl = false;
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$pubEncrypt_u24lambda_u240.init(1, (Key)publicKey, OAEP_PARAM_SPEC_SHA1);
            System.out.println((Object)"_______isOAEP");
        } else {
            $this$pubEncrypt_u24lambda_u240.init(1, publicKey);
        }
        StringBuilder stringBuilder = new StringBuilder().append("_______ ");
        PublicKey publicKey2 = publicKey;
        Intrinsics.checkNotNull((Object)publicKey2);
        System.out.println((Object)stringBuilder.append(RsaKt.bitLength(publicKey2)).append(' ').append(StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null) ? reserved : 0).toString());
        if (Intrinsics.areEqual((Object)alg, (Object)ELGAMAL)) {
            byArray = $this$pubEncrypt_u24lambda_u240.doFinal($this$pubEncrypt);
        } else {
            void $this$fold$iv;
            void it;
            int n;
            int n2 = n = RsaKt.bitLength(publicKey) / 8 - (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null) ? reserved : 0);
            Iterable iterable = ArraysKt.asIterable((byte[])$this$pubEncrypt);
            boolean bl2 = false;
            System.out.println((Object)("chunk size " + (int)it));
            Iterable iterable2 = CollectionsKt.chunked((Iterable)iterable, (int)n, arg_0 -> AsymmetircCryptoKt.pubEncrypt$lambda$0$1($this$pubEncrypt_u24lambda_u240, arg_0));
            ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
            boolean $i$f$fold = false;
            ByteArrayOutputStream accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void bytes;
                ByteArrayOutputStream byteArrayOutputStream;
                byte[] byArray2 = (byte[])element$iv;
                ByteArrayOutputStream acc = accumulator$iv;
                boolean bl3 = false;
                ByteArrayOutputStream it2 = byteArrayOutputStream = acc;
                boolean bl4 = false;
                acc.write((byte[])bytes);
                accumulator$iv = byteArrayOutputStream;
            }
            byArray = accumulator$iv.toByteArray();
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] pubEncrypt$default(byte[] byArray, PublicKey publicKey, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.pubEncrypt(byArray, publicKey, string, n);
    }

    private static final String properOAEPAlg(String $this$properOAEPAlg) {
        return AsymmetircCryptoKt.isOAEP($this$properOAEPAlg) ? StringsKt.replace$default((String)$this$properOAEPAlg, (String)"OAEP", (String)RSA_PADDINGS.get(4), (boolean)false, (int)4, null) : $this$properOAEPAlg;
    }

    private static final boolean isOAEP(String $this$isOAEP) {
        return StringsKt.endsWith$default((String)$this$isOAEP, (String)"OAEP", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final byte[] pubEncrypt(@NotNull byte[] $this$pubEncrypt, @NotNull String key, @NotNull String alg, int reserved) {
        Intrinsics.checkNotNullParameter((Object)$this$pubEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        String string = alg;
        return Intrinsics.areEqual((Object)string, (Object)"SM2") ? SMKt.sm2$default($this$pubEncrypt, true, (CipherParameters)SMKt.toECPublicKeyParams(AsymmetircCryptoKt.getPropPublicKey(key)), null, 4, null) : (Intrinsics.areEqual((Object)string, (Object)SM2_C1C2C3) ? SMKt.sm2($this$pubEncrypt, true, (CipherParameters)SMKt.toECPublicKeyParams(AsymmetircCryptoKt.getPropPublicKey(key)), SM2Engine.Mode.C1C2C3) : AsymmetircCryptoKt.pubEncrypt($this$pubEncrypt, AsymmetircCryptoKt.toPublicKey(key, alg), alg, reserved));
    }

    public static /* synthetic */ byte[] pubEncrypt$default(byte[] byArray, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.pubEncrypt(byArray, string, string2, n);
    }

    @NotNull
    public static final byte[] keyAutoDecode(@NotNull String $this$keyAutoDecode) {
        Intrinsics.checkNotNullParameter((Object)$this$keyAutoDecode, (String)"<this>");
        return EncodeRegexsKt.getHEX_REGEX().matches((CharSequence)$this$keyAutoDecode) ? ConverterKt.hex2ByteArray($this$keyAutoDecode) : Base64Kt.base64Decode$default(AsymmetircCryptoKt.removePemArmor($this$keyAutoDecode), null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] asymmetricDecrypt(@NotNull byte[] $this$asymmetricDecrypt, @Nullable Key key, @NotNull String alg) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$asymmetricDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$asymmetricDecrypt_u24lambda_u240 = Cipher.getInstance(AsymmetircCryptoKt.propCipherAlgorithm(alg));
        boolean bl = false;
        System.out.println((Object)("alg " + alg + ' ' + key));
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$asymmetricDecrypt_u24lambda_u240.init(2, key, OAEP_PARAM_SPEC_SHA1);
            byte[] byArray2 = $this$asymmetricDecrypt_u24lambda_u240.doFinal($this$asymmetricDecrypt);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"doFinal(...)");
            return byArray2;
        }
        $this$asymmetricDecrypt_u24lambda_u240.init(2, key);
        Object object = key;
        int bitLen = object instanceof PublicKey ? RsaKt.bitLength((PublicKey)key) : (object instanceof PrivateKey ? RsaKt.bitLength((PrivateKey)key) : 1024);
        System.out.println(bitLen);
        if (Intrinsics.areEqual((Object)alg, (Object)ELGAMAL)) {
            byArray = $this$asymmetricDecrypt_u24lambda_u240.doFinal($this$asymmetricDecrypt);
        } else {
            void $this$fold$iv;
            object = CollectionsKt.chunked((Iterable)ArraysKt.asIterable((byte[])$this$asymmetricDecrypt), (int)(bitLen / 8), arg_0 -> AsymmetircCryptoKt.asymmetricDecrypt$lambda$0$0($this$asymmetricDecrypt_u24lambda_u240, arg_0));
            ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
            boolean $i$f$fold = false;
            ByteArrayOutputStream accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void bytes;
                ByteArrayOutputStream byteArrayOutputStream;
                byte[] byArray3 = (byte[])element$iv;
                ByteArrayOutputStream acc = accumulator$iv;
                boolean bl2 = false;
                ByteArrayOutputStream it = byteArrayOutputStream = acc;
                boolean bl3 = false;
                acc.write((byte[])bytes);
                accumulator$iv = byteArrayOutputStream;
            }
            byArray = accumulator$iv.toByteArray();
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] privateDecrypt(@NotNull byte[] $this$privateDecrypt, @NotNull String key, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$privateDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        String string = alg;
        return Intrinsics.areEqual((Object)string, (Object)"SM2") ? SMKt.sm2$default($this$privateDecrypt, false, (CipherParameters)SMKt.toECPrivateKeyParams(AsymmetircCryptoKt.keyAutoDecode(key)), null, 4, null) : (Intrinsics.areEqual((Object)string, (Object)SM2_C1C2C3) ? SMKt.sm2($this$privateDecrypt, false, (CipherParameters)SMKt.toECPrivateKeyParams(AsymmetircCryptoKt.keyAutoDecode(key)), SM2Engine.Mode.C1C2C3) : AsymmetircCryptoKt.asymmetricDecrypt($this$privateDecrypt, AsymmetircCryptoKt.toPrivateKey(key, alg), alg));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] asymmetricEncrypt(@NotNull byte[] $this$asymmetricEncrypt, @Nullable Key key, @NotNull String alg, int reserved) {
        byte[] byArray;
        int bitLen;
        Intrinsics.checkNotNullParameter((Object)$this$asymmetricEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Cipher $this$asymmetricEncrypt_u24lambda_u240 = Cipher.getInstance(AsymmetircCryptoKt.propCipherAlgorithm(alg));
        boolean bl = false;
        if (AsymmetircCryptoKt.isOAEP(alg)) {
            $this$asymmetricEncrypt_u24lambda_u240.init(1, key, OAEP_PARAM_SPEC_SHA1);
        } else {
            $this$asymmetricEncrypt_u24lambda_u240.init(1, key);
        }
        Object object = key;
        int n = object instanceof PublicKey ? RsaKt.bitLength((PublicKey)key) : (bitLen = object instanceof PrivateKey ? RsaKt.bitLength((PrivateKey)key) : 1024);
        if (Intrinsics.areEqual((Object)alg, (Object)ELGAMAL)) {
            byArray = $this$asymmetricEncrypt_u24lambda_u240.doFinal($this$asymmetricEncrypt);
        } else {
            void $this$fold$iv;
            object = CollectionsKt.chunked((Iterable)ArraysKt.asIterable((byte[])$this$asymmetricEncrypt), (int)(bitLen / 8 - (StringsKt.contains$default((CharSequence)alg, (CharSequence)"RSA", (boolean)false, (int)2, null) ? reserved : 0)), arg_0 -> AsymmetircCryptoKt.asymmetricEncrypt$lambda$0$0($this$asymmetricEncrypt_u24lambda_u240, arg_0));
            ByteArrayOutputStream initial$iv = new ByteArrayOutputStream();
            boolean $i$f$fold = false;
            ByteArrayOutputStream accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void bytes;
                ByteArrayOutputStream byteArrayOutputStream;
                byte[] byArray2 = (byte[])element$iv;
                ByteArrayOutputStream acc = accumulator$iv;
                boolean bl2 = false;
                ByteArrayOutputStream it = byteArrayOutputStream = acc;
                boolean bl3 = false;
                acc.write((byte[])bytes);
                accumulator$iv = byteArrayOutputStream;
            }
            byArray = accumulator$iv.toByteArray();
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] asymmetricEncrypt$default(byte[] byArray, Key key, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.asymmetricEncrypt(byArray, key, string, n);
    }

    @NotNull
    public static final byte[] privateEncrypt(@NotNull byte[] $this$privateEncrypt, @NotNull String key, @NotNull String alg, int reserved) {
        Intrinsics.checkNotNullParameter((Object)$this$privateEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        return AsymmetircCryptoKt.asymmetricEncrypt($this$privateEncrypt, AsymmetircCryptoKt.toPrivateKey(key, alg), alg, reserved);
    }

    public static /* synthetic */ byte[] privateEncrypt$default(byte[] byArray, String string, String string2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 11;
        }
        return AsymmetircCryptoKt.privateEncrypt(byArray, string, string2, n);
    }

    @NotNull
    public static final String[] genBase64KeyArray(@NotNull String alg, int keySize) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        KeyPairGenerator $this$genBase64KeyArray_u24lambda_u240 = KeyPairGenerator.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg));
        boolean bl = false;
        $this$genBase64KeyArray_u24lambda_u240.initialize(keySize);
        KeyPair keyPair = $this$genBase64KeyArray_u24lambda_u240.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String[] stringArray = new String[2];
        byte[] byArray = publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        stringArray[0] = Base64Kt.base64$default(byArray, null, false, 3, null);
        byte[] byArray2 = privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        stringArray[1] = Base64Kt.base64$default(byArray2, null, false, 3, null);
        return stringArray;
    }

    private static final String properKeyPairAlg(String $this$properKeyPairAlg) {
        return StringsKt.startsWith$default((String)$this$properKeyPairAlg, (String)"SM2", (boolean)false, (int)2, null) ? "EC" : (StringsKt.startsWith$default((String)$this$properKeyPairAlg, (String)"RSA", (boolean)false, (int)2, null) ? "RSA" : (StringsKt.contains$default((CharSequence)$this$properKeyPairAlg, (CharSequence)"/", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)$this$properKeyPairAlg, (char)'/', null, (int)2, null) : $this$properKeyPairAlg));
    }

    @NotNull
    public static final String[] genBase64KeyArray(@NotNull String alg, @NotNull List<? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        KeyPair $this$genBase64KeyArray_u24lambda_u241 = AsymmetircCryptoKt.genKeyPair(alg, params);
        boolean bl = false;
        String[] stringArray = new String[2];
        byte[] byArray = $this$genBase64KeyArray_u24lambda_u241.getPublic().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        stringArray[0] = Base64Kt.base64$default(byArray, null, false, 3, null);
        byte[] byArray2 = $this$genBase64KeyArray_u24lambda_u241.getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        stringArray[1] = Base64Kt.base64$default(byArray2, null, false, 3, null);
        return stringArray;
    }

    public static /* synthetic */ String[] genBase64KeyArray$default(String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return AsymmetircCryptoKt.genBase64KeyArray(string, list);
    }

    @NotNull
    public static final KeyPair genKeyPair(@NotNull String alg, @NotNull List<? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        KeyPairGenerator $this$genKeyPair_u24lambda_u240 = KeyPairGenerator.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg), "BC");
        boolean bl = false;
        if (StringsKt.startsWith$default((String)alg, (String)"SM2", (boolean)false, (int)2, null)) {
            $this$genKeyPair_u24lambda_u240.initialize(new ECGenParameterSpec(ecGenParameterSpec.get("SM2")));
        } else if (StringsKt.startsWith$default((String)alg, (String)"EC", (boolean)false, (int)2, null)) {
            String string = alg.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            $this$genKeyPair_u24lambda_u240.initialize(new ECGenParameterSpec(ecGenParameterSpec.get(string)));
        } else if (Intrinsics.areEqual((Object)alg, (Object)"SPHINCSPLUS")) {
            $this$genKeyPair_u24lambda_u240.initialize((AlgorithmParameterSpec)SPHINCSPlusParameterSpec.fromName((String)CollectionsKt.first(params).toString()));
        } else if (Intrinsics.areEqual((Object)alg, (Object)"LMS")) {
            Object object = params.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.pqc.crypto.lms.LMSigParameters");
            LMSigParameters lMSigParameters = (LMSigParameters)object;
            Object object2 = params.get(1);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.bouncycastle.pqc.crypto.lms.LMOtsParameters");
            $this$genKeyPair_u24lambda_u240.initialize((AlgorithmParameterSpec)new LMSKeyGenParameterSpec(lMSigParameters, (LMOtsParameters)object2));
        } else if (Intrinsics.areEqual((Object)alg, (Object)ELGAMAL)) {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(alg);
            Intrinsics.checkNotNullExpressionValue((Object)algorithmParameterGenerator, (String)"getInstance(...)");
            AlgorithmParameterGenerator apg = algorithmParameterGenerator;
            Object object = params.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            apg.init((Integer)object);
            DHParameterSpec elParams = apg.generateParameters().getParameterSpec(DHParameterSpec.class);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(alg);
            kpg.initialize(elParams, new SecureRandom());
        } else if (Intrinsics.areEqual((Object)alg, (Object)"GOST3410")) {
            $this$genKeyPair_u24lambda_u240.initialize((AlgorithmParameterSpec)new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()));
        } else if (StringsKt.contains$default((CharSequence)alg, (CharSequence)"ECGOST3410", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = alg.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append('-');
            Object object = params.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            $this$genKeyPair_u24lambda_u240.initialize(new ECGenParameterSpec(ecGenParameterSpec.get(stringBuilder2.append((Integer)object).toString())), new SecureRandom());
        } else {
            Object[] objectArray = new String[]{"ED448", "ED25519"};
            if (!ArraysKt.contains((Object[])objectArray, (Object)alg)) {
                Object object = params.get(0);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                $this$genKeyPair_u24lambda_u240.initialize((Integer)object);
            }
        }
        KeyPair keyPair = $this$genKeyPair_u24lambda_u240.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"run(...)");
        return keyPair;
    }

    public static /* synthetic */ KeyPair genKeyPair$default(String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return AsymmetircCryptoKt.genKeyPair(string, list);
    }

    public static final boolean checkKeyPair(@NotNull String pub, @NotNull String pri, @NotNull String alg) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)pri, (String)"pri");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        String string = "123";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] testData = byArray2;
        System.out.println((Object)Base64Kt.base64$default(testData, null, false, 3, null));
        byte[] $this$checkKeyPair_u24lambda_u240 = AsymmetircCryptoKt.asymmetricEncrypt$default(testData, AsymmetircCryptoKt.toPublicKey(pub, alg), alg, 0, 4, null);
        boolean bl = false;
        byte[] it = byArray = AsymmetircCryptoKt.asymmetricDecrypt($this$checkKeyPair_u24lambda_u240, AsymmetircCryptoKt.toPrivateKey(pri, alg), alg);
        boolean bl2 = false;
        System.out.println((Object)StringsKt.decodeToString((byte[])it));
        return Arrays.equals(byArray, testData);
    }

    public static /* synthetic */ boolean checkKeyPair$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "RSA";
        }
        return AsymmetircCryptoKt.checkKeyPair(string, string2, string3);
    }

    @NotNull
    public static final String pkcs8ToPkcs1(@NotNull String pkcs8) {
        Intrinsics.checkNotNullParameter((Object)pkcs8, (String)"pkcs8");
        byte[] byArray = PrivateKeyInfo.getInstance((Object)Base64Kt.base64Decode$default(pkcs8, null, 1, null)).parsePrivateKey().toASN1Primitive().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return Base64Kt.base64$default(byArray, null, false, 3, null);
    }

    @NotNull
    public static final String pkcs1ToPkcs8(@NotNull String pkcs1) {
        Intrinsics.checkNotNullParameter((Object)pkcs1, (String)"pkcs1");
        byte[] $this$pkcs1ToPkcs8_u24lambda_u240 = new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption), (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])Base64Kt.base64Decode$default(pkcs1, null, 1, null))).getEncoded();
        boolean bl = false;
        PKCS8EncodedKeySpec $this$pkcs1ToPkcs8_u24lambda_u240_u240 = new PKCS8EncodedKeySpec($this$pkcs1ToPkcs8_u24lambda_u240);
        boolean bl2 = false;
        byte[] byArray = KeyFactory.getInstance("RSA").generatePrivate($this$pkcs1ToPkcs8_u24lambda_u240_u240).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return Base64Kt.base64$default(byArray, null, false, 3, null);
    }

    @NotNull
    public static final String privateKeyDerivedPublicKey(@NotNull String $this$privateKeyDerivedPublicKey, @NotNull String alg) {
        Intrinsics.checkNotNullParameter((Object)$this$privateKeyDerivedPublicKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        PKCS8EncodedKeySpec $this$privateKeyDerivedPublicKey_u24lambda_u240 = new PKCS8EncodedKeySpec(AsymmetircCryptoKt.keyAutoDecode(AsymmetircCryptoKt.removePemArmor($this$privateKeyDerivedPublicKey)));
        boolean bl = false;
        PrivateKey privateKey = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePrivate($this$privateKeyDerivedPublicKey_u24lambda_u240);
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateCrtKey");
        RSAPrivateCrtKey $this$privateKeyDerivedPublicKey_u24lambda_u240_u240 = (RSAPrivateCrtKey)privateKey;
        boolean bl2 = false;
        byte[] byArray = KeyFactory.getInstance(AsymmetircCryptoKt.properKeyPairAlg(alg)).generatePublic(new RSAPublicKeySpec($this$privateKeyDerivedPublicKey_u24lambda_u240_u240.getModulus(), $this$privateKeyDerivedPublicKey_u24lambda_u240_u240.getPublicExponent())).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return Base64Kt.base64$default(byArray, null, false, 3, null);
    }

    public static /* synthetic */ String privateKeyDerivedPublicKey$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "RSA";
        }
        return AsymmetircCryptoKt.privateKeyDerivedPublicKey(string, string2);
    }

    @NotNull
    public static final String parseRsaInfo(@NotNull Key $this$parseRsaInfo) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$parseRsaInfo, (String)"<this>");
        Key key = $this$parseRsaInfo;
        if (key instanceof RSAPublicKey) {
            StringBuilder stringBuilder = new StringBuilder().append("Key Length: ").append(RsaKt.bitLength((PublicKey)$this$parseRsaInfo)).append(System.lineSeparator()).append("Modulus: ");
            String string2 = ((RSAPublicKey)$this$parseRsaInfo).getModulus().toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(System.lineSeparator()).append("Public Exponent: ");
            String string4 = ((RSAPublicKey)$this$parseRsaInfo).getPublicExponent().toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            string = stringBuilder2.append(string5).toString();
        } else if (key instanceof RSAPrivateKey) {
            StringBuilder stringBuilder = new StringBuilder().append("Key Length: ").append(RsaKt.bitLength((PrivateKey)$this$parseRsaInfo)).append(System.lineSeparator()).append("Private Exponent: ");
            String string6 = ((RSAPrivateKey)$this$parseRsaInfo).getPrivateExponent().toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            String string7 = string6.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
            StringBuilder stringBuilder3 = stringBuilder.append(string7).append(System.lineSeparator()).append("Modulus: ");
            String string8 = ((RSAPrivateKey)$this$parseRsaInfo).getModulus().toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
            String string9 = string8.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toUpperCase(...)");
            string = stringBuilder3.append(string9).toString();
        } else {
            string = "Unsupported Type " + $this$parseRsaInfo.getClass().getName();
        }
        return string;
    }

    private static final byte[] pubDecrypt$lambda$0$0(Cipher $this_run, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
    }

    private static final byte[] pubEncrypt$lambda$0$1(Cipher $this_run, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        System.out.println((Object)("list size " + it.size()));
        return $this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
    }

    private static final byte[] asymmetricDecrypt$lambda$0$0(Cipher $this_run, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
    }

    private static final byte[] asymmetricEncrypt$lambda$0$0(Cipher $this_run, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $this_run.doFinal(CollectionsKt.toByteArray((Collection)it));
    }

    static {
        Object[] objectArray = new Pair[4];
        Object[] objectArray2 = new Integer[]{512, 1024, 2048, 3072, 4096};
        objectArray[0] = TuplesKt.to((Object)"RSA", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new Integer[]{512, 1024, 2048};
        objectArray[1] = TuplesKt.to((Object)ELGAMAL, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[2] = TuplesKt.to((Object)"SM2", (Object)CollectionsKt.listOf((Object)256));
        objectArray[3] = TuplesKt.to((Object)SM2_C1C2C3, (Object)CollectionsKt.listOf((Object)256));
        ASYMMETRIC_ALGOS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"PKCS1Padding", "NoPadding", "ISO9796-1Padding", "OAEP", "OAEPWithMD5AndMGF1Padding", "OAEPWithSHA1AndMGF1Padding", "OAEPWithSHA224AndMGF1Padding", "OAEPWithSHA3-224AndMGF1Padding", "OAEPWithSHA256AndMGF1Padding", "OAEPWithSHA3-256AndMGF1Padding", "OAEPWithSHA384AndMGF1Padding", "OAEPWithSHA3-384AndMGF1Padding", "OAEPWithSHA512AndMGF1Padding", "OAEPWithSHA3-512AndMGF1Padding"};
        RSA_PADDINGS = CollectionsKt.listOf((Object[])objectArray);
        OAEP_PARAM_SPEC_SHA1 = new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
        objectArray = new Pair[]{TuplesKt.to((Object)"ECGOST3410-2012", (Object)"Tc26-Gost-3410-12-512-paramSetA"), TuplesKt.to((Object)"ECGOST3410-2012-512", (Object)"Tc26-Gost-3410-12-512-paramSetA"), TuplesKt.to((Object)"ECGOST3410-2012-256", (Object)"Tc26-Gost-3410-12-256-paramSetA"), TuplesKt.to((Object)"SM2", (Object)"sm2p256v1")};
        ecGenParameterSpec = MapsKt.mapOf((Pair[])objectArray);
    }
}

