/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import me.leon.encode.OctalKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.ext.crypto.EncodeRegexsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0001\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0007\u001a\u001a\u0010\u0014\u001a\u00020\u0015*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0001\u00a8\u0006\u0018"}, d2={"charsetChange", "", "from", "", "to", "padStart", "length", "", "byte", "", "decodeToByteArray", "encoder", "charset", "autoDecodeToByteArray", "isDecode", "", "encodeTo", "unpack", "pack", "size", "setByteArray", "", "start", "bytes", "app"})
@SourceDebugExtension(value={"SMAP\nByteArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArray.kt\nme/leon/ext/ByteArrayKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n1#2:85\n13230#3,3:86\n*S KotlinDebug\n*F\n+ 1 ByteArray.kt\nme/leon/ext/ByteArrayKt\n*L\n67#1:86,3\n*E\n"})
public final class ByteArrayKt {
    @NotNull
    public static final byte[] charsetChange(@NotNull byte[] $this$charsetChange, @NotNull String from, @NotNull String to) {
        Intrinsics.checkNotNullParameter((Object)$this$charsetChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Object object = $this$charsetChange;
        Charset charset = Charset.forName(from);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        object = new String((byte[])object, charset2);
        Charset charset3 = Charset.forName(to);
        Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"forName(...)");
        byte[] byArray = ((String)object).getBytes(charset3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] padStart(@NotNull byte[] $this$padStart, int length, byte by) {
        Intrinsics.checkNotNullParameter((Object)$this$padStart, (String)"<this>");
        if ($this$padStart.length % length == 0) {
            return $this$padStart;
        }
        int padCount = length - $this$padStart.length % length;
        byte[] bytes = new byte[$this$padStart.length + padCount];
        int n = 0;
        while (n < padCount) {
            int it = n++;
            boolean bl = false;
            bytes[it] = by;
        }
        ArraysKt.copyInto$default((byte[])$this$padStart, (byte[])bytes, (int)padCount, (int)0, (int)0, (int)12, null);
        return bytes;
    }

    @NotNull
    public static final byte[] decodeToByteArray(@NotNull String $this$decodeToByteArray, @NotNull String encoder, @NotNull String charset) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$decodeToByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        switch (encoder) {
            case "raw": {
                String string = $this$decodeToByteArray;
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
                byte[] byArray2 = string.getBytes(charset2);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                break;
            }
            case "oct": {
                byArray = OctalKt.octalDecode($this$decodeToByteArray);
                break;
            }
            case "binary": {
                byArray = ConverterKt.binary2ByteArray$default($this$decodeToByteArray, false, 1, null);
                break;
            }
            case "hex": {
                byArray = ConverterKt.hex2ByteArray($this$decodeToByteArray);
                break;
            }
            case "base64": {
                byArray = Base64Kt.base64Decode$default($this$decodeToByteArray, null, 1, null);
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown encoder: " + encoder).toString());
            }
        }
        return byArray;
    }

    public static /* synthetic */ byte[] decodeToByteArray$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "raw";
        }
        if ((n & 2) != 0) {
            string3 = "UTF-8";
        }
        return ByteArrayKt.decodeToByteArray(string, string2, string3);
    }

    @NotNull
    public static final byte[] autoDecodeToByteArray(@NotNull String $this$autoDecodeToByteArray, boolean isDecode) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$autoDecodeToByteArray, (String)"<this>");
        if ($this$autoDecodeToByteArray.length() < 3) {
            String string = $this$autoDecodeToByteArray;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else if (EncodeRegexsKt.getBINARY_REGEX().matches((CharSequence)$this$autoDecodeToByteArray)) {
            byArray = ConverterKt.binary2ByteArray$default($this$autoDecodeToByteArray, false, 1, null);
        } else if (isDecode || EncodeRegexsKt.getHEX_WITH_LEAD_REGEX().matches((CharSequence)$this$autoDecodeToByteArray)) {
            byArray = ConverterKt.hex2ByteArray($this$autoDecodeToByteArray);
        } else {
            String string = $this$autoDecodeToByteArray;
            byte[] byArray3 = string.getBytes(Charsets.UTF_8);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        }
        return byArray;
    }

    public static /* synthetic */ byte[] autoDecodeToByteArray$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ByteArrayKt.autoDecodeToByteArray(string, bl);
    }

    @NotNull
    public static final String encodeTo(@NotNull byte[] $this$encodeTo, @NotNull String encoder, @NotNull String charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$encodeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        switch (encoder) {
            case "raw": {
                byte[] byArray = $this$encodeTo;
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
                Charset charset3 = charset2;
                string = new String(byArray, charset3);
                break;
            }
            case "base64": {
                string = Base64Kt.base64$default($this$encodeTo, null, false, 3, null);
                break;
            }
            case "hex": {
                string = ConverterKt.toHex($this$encodeTo);
                break;
            }
            case "oct": {
                string = OctalKt.octal$default($this$encodeTo, null, 1, null);
                break;
            }
            case "binary": {
                string = ConverterKt.toBinaryString$default($this$encodeTo, false, 1, null);
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown encoder: " + encoder).toString());
            }
        }
        return string;
    }

    public static /* synthetic */ String encodeTo$default(byte[] byArray, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UTF-8";
        }
        return ByteArrayKt.encodeTo(byArray, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    public static final int unpack(@NotNull byte[] $this$unpack) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$unpack, (String)"<this>");
        if (!($this$unpack.length == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ArraysKt.reverse((byte[])$this$unpack);
        byte[] byArray = $this$unpack;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void byteVal;
            void element$iv;
            void var8_9 = element$iv = $this$fold$iv[i];
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc << 8 | byteVal & 0xFF;
        }
        return accumulator$iv;
    }

    @NotNull
    public static final byte[] pack(int $this$pack, int size) {
        byte[] bytes = new byte[size];
        int n = bytes.length;
        for (int index = 0; index < n; ++index) {
            bytes[index] = (byte)($this$pack >> 8 * (ArraysKt.getLastIndex((byte[])bytes) - index) & 0xFF);
        }
        return bytes;
    }

    public static /* synthetic */ byte[] pack$default(int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 4;
        }
        return ByteArrayKt.pack(n, n2);
    }

    public static final void setByteArray(@NotNull byte[] $this$setByteArray, int start, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$setByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int end = RangesKt.coerceAtMost((int)(start + bytes.length), (int)$this$setByteArray.length);
        for (int i = start; i < end; ++i) {
            $this$setByteArray[i] = bytes[i - start];
        }
    }
}

