/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.leon.ctf.BrainFuckToken;
import me.leon.ctf.TrollScriptEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B+\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0002R\u001a\u0010\n\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lme/leon/ctf/OokEngine;", "Lme/leon/ctf/TrollScriptEngine;", "cells", "", "out", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "<init>", "(ILjava/io/OutputStream;Ljava/io/InputStream;)V", "defaultTokenLength", "getDefaultTokenLength", "()I", "setDefaultTokenLength", "(I)V", "interpret", "", "str", "loopAllTokens", "", "tokens", "", "Token", "app"})
public final class OokEngine
extends TrollScriptEngine {
    private int defaultTokenLength;

    @JvmOverloads
    public OokEngine(int cells, @Nullable OutputStream out, @Nullable InputStream inputStream) {
        super(cells, out, inputStream);
        this.defaultTokenLength = 9;
    }

    public /* synthetic */ OokEngine(int n, OutputStream outputStream, InputStream inputStream, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            outputStream = new ByteArrayOutputStream();
        }
        if ((n2 & 4) != 0) {
            inputStream = System.in;
        }
        this(n, outputStream, inputStream);
    }

    @Override
    public int getDefaultTokenLength() {
        return this.defaultTokenLength;
    }

    @Override
    public void setDefaultTokenLength(int n) {
        this.defaultTokenLength = n;
    }

    @Override
    @NotNull
    public String interpret(@NotNull String str) throws Exception {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        OutputStream outputStream = this.outWriter;
        Intrinsics.checkNotNull((Object)outputStream, (String)"null cannot be cast to non-null type java.io.ByteArrayOutputStream");
        ((ByteArrayOutputStream)outputStream).reset();
        List tokens = new ArrayList();
        while (this.charPointer < str.length()) {
            String string;
            if (StringsKt.isBlank((CharSequence)String.valueOf(str.charAt(this.charPointer)))) {
                int n = this.charPointer;
                this.charPointer = n + 1;
                continue;
            }
            if (this.charPointer + this.getDefaultTokenLength() <= str.length()) {
                String string2 = str.substring(this.charPointer, this.charPointer + this.getDefaultTokenLength());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                String string3 = str.substring(this.charPointer, this.charPointer + (str.length() - this.charPointer));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            String token = string;
            boolean b = false;
            if (this.isValidToken(token, Token.INSTANCE)) {
                tokens.add(token);
                this.charPointer += this.getDefaultTokenLength();
                b = true;
            }
            if (b) continue;
            if (this.charPointer + this.getDefaultTokenLength() > str.length()) {
                this.charPointer += str.length() - this.charPointer;
                continue;
            }
            int n = this.charPointer;
            this.charPointer = n + 1;
        }
        this.loopAllTokens(tokens);
        Intrinsics.checkNotNull((Object)this.data);
        this.initiate(this.data.length);
        return this.outWriter.toString();
    }

    private final void loopAllTokens(List<String> tokens) {
        for (int tokenPointer = 0; tokenPointer < tokens.size(); ++tokenPointer) {
            byte by;
            int n;
            String string = tokens.get(tokenPointer);
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getNext())) {
                Intrinsics.checkNotNull((Object)this.data);
                this.dataPointer = this.dataPointer == this.data.length - 1 ? 0 : this.dataPointer + 1;
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getPre())) {
                int n2;
                if (this.dataPointer == 0) {
                    Intrinsics.checkNotNull((Object)this.data);
                    n2 = this.data.length - 1;
                } else {
                    n2 = this.dataPointer - 1;
                }
                this.dataPointer = n2;
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getPlus())) {
                Intrinsics.checkNotNull((Object)this.data);
                byte[] byArray = this.data;
                n = this.dataPointer;
                by = byArray[n];
                byArray[n] = (byte)(by + 1);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getMinus())) {
                Intrinsics.checkNotNull((Object)this.data);
                byte[] byArray = this.data;
                n = this.dataPointer;
                by = byArray[n];
                byArray[n] = (byte)(by + -1);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getOutput())) {
                Intrinsics.checkNotNull((Object)this.data);
                this.outWriter.write(this.data[this.dataPointer]);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getInput())) {
                Intrinsics.checkNotNull((Object)this.data);
                this.data[this.dataPointer] = (byte)this.consoleReader.read();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getBracketLeft())) {
                Intrinsics.checkNotNull((Object)this.data);
                if (this.data[this.dataPointer] != 0) continue;
                int level = 1;
                while (level > 0) {
                    if (Intrinsics.areEqual((Object)tokens.get(++tokenPointer), (Object)Token.INSTANCE.getBracketLeft())) {
                        ++level;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)tokens.get(tokenPointer), (Object)Token.INSTANCE.getBracketRight())) continue;
                    --level;
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getBracketRight())) continue;
            Intrinsics.checkNotNull((Object)this.data);
            if (this.data[this.dataPointer] == 0) continue;
            int level = 1;
            while (level > 0) {
                if (Intrinsics.areEqual((Object)tokens.get(--tokenPointer), (Object)Token.INSTANCE.getBracketLeft())) {
                    --level;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)tokens.get(tokenPointer), (Object)Token.INSTANCE.getBracketRight())) continue;
                ++level;
            }
        }
    }

    @JvmOverloads
    public OokEngine(int cells, @Nullable OutputStream out) {
        this(cells, out, null, 4, null);
    }

    @JvmOverloads
    public OokEngine(int cells) {
        this(cells, null, null, 6, null);
    }

    @JvmOverloads
    public OokEngine() {
        this(0, null, null, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0014\u0010\u0018\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lme/leon/ctf/OokEngine$Token;", "Lme/leon/ctf/BrainFuckToken;", "<init>", "()V", "start", "", "getStart", "()Ljava/lang/String;", "next", "getNext", "pre", "getPre", "plus", "getPlus", "minus", "getMinus", "output", "getOutput", "input", "getInput", "bracketLeft", "getBracketLeft", "bracketRight", "getBracketRight", "end", "getEnd", "app"})
    public static final class Token
    implements BrainFuckToken {
        @NotNull
        public static final Token INSTANCE = new Token();
        @NotNull
        private static final String start = "";
        @NotNull
        private static final String next = "Ook. Ook?";
        @NotNull
        private static final String pre = "Ook? Ook.";
        @NotNull
        private static final String plus = "Ook. Ook.";
        @NotNull
        private static final String minus = "Ook! Ook!";
        @NotNull
        private static final String output = "Ook! Ook.";
        @NotNull
        private static final String input = "Ook. Ook!";
        @NotNull
        private static final String bracketLeft = "Ook! Ook?";
        @NotNull
        private static final String bracketRight = "Ook? Ook!";
        @NotNull
        private static final String end = "";

        private Token() {
        }

        @Override
        @NotNull
        public String getStart() {
            return start;
        }

        @Override
        @NotNull
        public String getNext() {
            return next;
        }

        @Override
        @NotNull
        public String getPre() {
            return pre;
        }

        @Override
        @NotNull
        public String getPlus() {
            return plus;
        }

        @Override
        @NotNull
        public String getMinus() {
            return minus;
        }

        @Override
        @NotNull
        public String getOutput() {
            return output;
        }

        @Override
        @NotNull
        public String getInput() {
            return input;
        }

        @Override
        @NotNull
        public String getBracketLeft() {
            return bracketLeft;
        }

        @Override
        @NotNull
        public String getBracketRight() {
            return bracketRight;
        }

        @Override
        @NotNull
        public String getEnd() {
            return end;
        }
    }
}

