/*
 * Decompiled with CFR 0.152.
 */
package me.leon.toolsfx.plugin.table;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import me.leon.toolsfx.plugin.table.CellGenerator;
import me.leon.toolsfx.plugin.table.EditingCell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006J,\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005H\u0002J4\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJJ\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007JJ\u0010\u0014\u001a\u00020\r\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J6\u0010\u0015\u001a\u00020\r\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J,\u0010\u0016\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005H\u0007R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/leon/toolsfx/plugin/table/CellGenerator;", "", "<init>", "()V", "defaultStringConverter", "Ljavafx/util/StringConverter;", "T", "getItemText", "", "cell", "Ljavafx/scene/control/Cell;", "converter", "updateItem", "", "textField", "Ljavafx/scene/control/TextField;", "hbox", "Ljavafx/scene/layout/HBox;", "graphic", "Ljavafx/scene/Node;", "startEdit", "cancelEdit", "createTextField", "plugin-apipost"})
public final class CellGenerator {
    @NotNull
    public static final CellGenerator INSTANCE = new CellGenerator();
    @NotNull
    private static final StringConverter<?> defaultStringConverter = (StringConverter)new StringConverter<Object>(){

        public String toString(Object t) {
            Object object = t;
            String string = object != null ? object.toString() : null;
            if (string == null) {
                string = "";
            }
            return string;
        }

        public Object fromString(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return string;
        }
    };

    private CellGenerator() {
    }

    @NotNull
    public final <T> StringConverter<T> defaultStringConverter() {
        StringConverter<?> stringConverter = defaultStringConverter;
        Intrinsics.checkNotNull(stringConverter, (String)"null cannot be cast to non-null type javafx.util.StringConverter<T of me.leon.toolsfx.plugin.table.CellGenerator.defaultStringConverter>");
        return stringConverter;
    }

    private final <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        String string;
        if (converter == null) {
            string = cell.getItem() == null ? "" : String.valueOf(cell.getItem());
        } else {
            String string2 = converter.toString(cell.getItem());
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    public final <T> void updateItem(@NotNull Cell<T> cell, @Nullable StringConverter<T> converter, @Nullable TextField textField) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        CellGenerator.updateItem(cell, converter, null, null, textField);
    }

    @JvmStatic
    public static final <T> void updateItem(@NotNull Cell<T> cell, @Nullable StringConverter<T> converter, @Nullable HBox hbox, @Nullable Node graphic, @Nullable TextField textField) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(INSTANCE.getItemText(cell, converter));
            }
            cell.setText(null);
            if (graphic != null) {
                HBox hBox = hbox;
                if (hBox != null && (hBox = hBox.getChildren()) != null) {
                    Object[] objectArray = new Node[]{graphic, textField};
                    hBox.setAll(objectArray);
                }
                cell.setGraphic((Node)hbox);
            } else {
                cell.setGraphic((Node)textField);
            }
        } else {
            cell.setText(INSTANCE.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    @JvmStatic
    public static final <T> void startEdit(@NotNull Cell<T> cell, @Nullable StringConverter<T> converter, @Nullable HBox hbox, @Nullable Node graphic, @Nullable TextField textField) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        if (textField != null) {
            textField.setText(INSTANCE.getItemText(cell, converter));
        }
        cell.setText(null);
        if (graphic != null) {
            HBox hBox = hbox;
            if (hBox != null && (hBox = hBox.getChildren()) != null) {
                Object[] objectArray = new Node[]{graphic, textField};
                hBox.setAll(objectArray);
            }
            cell.setGraphic((Node)hbox);
        } else {
            cell.setGraphic((Node)textField);
        }
        TextField textField2 = textField;
        Intrinsics.checkNotNull((Object)textField2);
        textField2.selectAll();
        textField.requestFocus();
    }

    @JvmStatic
    public static final <T> void cancelEdit(@NotNull Cell<T> cell, @Nullable StringConverter<T> converter, @Nullable Node graphic) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        cell.setText(INSTANCE.getItemText(cell, converter));
        cell.setGraphic(graphic);
    }

    @JvmStatic
    @NotNull
    public static final <T> TextField createTextField(@NotNull Cell<T> cell, @Nullable StringConverter<T> converter) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        TextField textField = new TextField(INSTANCE.getItemText(cell, converter));
        EditingCell cellEdit = (EditingCell)cell;
        textField.setOnMouseExited(arg_0 -> CellGenerator.createTextField$lambda$1(converter, cell, textField, arg_0));
        textField.addEventFilter(KeyEvent.KEY_PRESSED, new EventHandler(cell, cellEdit, converter, textField){
            final /* synthetic */ Cell<T> $cell;
            final /* synthetic */ EditingCell<?, ?> $cellEdit;
            final /* synthetic */ StringConverter<T> $converter;
            final /* synthetic */ TextField $textField;
            {
                this.$cell = $cell;
                this.$cellEdit = $cellEdit;
                this.$converter = $converter;
                this.$textField = $textField;
            }

            public final void handle(KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                KeyCode keyCode = event.getCode();
                switch (keyCode == null ? -1 : createTextField.WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                    case 1: {
                        ((EditingCell)this.$cell).cancelEdit();
                        event.consume();
                        break;
                    }
                    case 2: {
                        this.$cellEdit.getTableView().getSelectionModel().selectRightCell();
                        event.consume();
                        break;
                    }
                    case 3: {
                        this.$cellEdit.getTableView().getSelectionModel().selectLeftCell();
                        event.consume();
                        break;
                    }
                    case 4: {
                        this.$cellEdit.getTableView().getSelectionModel().selectAboveCell();
                        event.consume();
                        break;
                    }
                    case 5: {
                        this.$cellEdit.getTableView().getSelectionModel().selectBelowCell();
                        event.consume();
                        break;
                    }
                    case 6: {
                        if (this.$converter == null) {
                            boolean bl = false;
                            String string = "Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.";
                            throw new IllegalStateException(string.toString());
                        }
                        this.$cell.commitEdit(this.$converter.fromString(this.$textField.getText()));
                        event.consume();
                        break;
                    }
                    case 7: {
                        StringConverter<T> stringConverter = this.$converter;
                        Intrinsics.checkNotNull(stringConverter);
                        this.$cell.commitEdit(stringConverter.fromString(this.$textField.getText()));
                        this.$cellEdit.setNextColumn(event);
                        event.consume();
                    }
                }
            }
        });
        return textField;
    }

    private static final void createTextField$lambda$1(StringConverter $converter, Cell $cell, TextField $textField, MouseEvent it) {
        if ($converter == null) {
            boolean bl = false;
            String string = "Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.";
            throw new IllegalStateException(string.toString());
        }
        $cell.commitEdit($converter.fromString($textField.getText()));
    }
}

