package com.renyigesai.bakeries.inventory.oven;

import com.renyigesai.bakeries.BakeriesMod;
import com.renyigesai.bakeries.block.oven.OvenBlockEntity;
import com.renyigesai.bakeries.inventory.CustomButton;
import com.renyigesai.bakeries.network.Messages;
import com.renyigesai.bakeries.network.OvenButtonMessage;
import lombok.Getter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@OnlyIn(Dist.CLIENT)
public class OvenScreen extends AbstractContainerScreen<OvenMenu> {
    private final static HashMap<String, Object> guistate = OvenMenu.guistate;
    private final static HashMap<String, String> textstate = new HashMap<>();
    private final BlockEntity boundBlockEntity;
    private final int x, y, z;
    private final AtomicBoolean dragging = new AtomicBoolean(false);
    private int mousey;
    private CustomButton zhi_zheng;

    @Getter
    public static int zhen_y = 69; // 初始位置
    public OvenScreen(OvenMenu container, Inventory inventory, Component text) {
        super(container, inventory, text);
        Level world = container.world;
        Player entity = container.entity;
        this.boundBlockEntity = container.boundBlockEntity;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;

    }
    private static final ResourceLocation texture = new ResourceLocation(BakeriesMod.MODID,"textures/gui/oven_gui.png");

    @Override
    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.mousey = pMouseY;
        this.renderBackground(pGuiGraphics);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }
    @Override
    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if(boundBlockEntity instanceof OvenBlockEntity ovenBlockEntity) {
            String A = new DecimalFormat("##.##").format(this.getMenu().data.get(0));
            pGuiGraphics.drawString(font, A, 132, 37, 16777215, false);
        }
        super.renderLabels(pGuiGraphics, pMouseX, pMouseY);
    }

    @Override
    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.blit(texture, this.leftPos, this.topPos,this.imageWidth,this.imageHeight, 0,0,this.imageWidth, this.imageHeight, 256, 256);
        zhi_zheng = new CustomButton(pGuiGraphics, texture, this.leftPos + 104, this.topPos + zhen_y, 0, 178, 20, 3, 256, 256){
            @Override
            protected void updateProgress() {
                if(boundBlockEntity instanceof OvenBlockEntity ovenBlockEntity){
                    Messages.sendToServer(new OvenButtonMessage(2, x, y, z, zhen_y, textstate));
                }
                Minecraft.getInstance().getSoundManager().play(SimpleSoundInstance.forUI(SoundEvents.NOTE_BLOCK_HAT, 1.0F));
            }
        };

        pGuiGraphics.blit(texture,
                this.leftPos + 63, this.topPos + 36,
                0, 181,
                this.menu.data.get(1), 2,
                256, 256);
        pGuiGraphics.blit(texture,
                this.leftPos + 63 + 1 * 18, this.topPos + 36 + 0 * 36,
                0, 181,
                this.menu.data.get(2), 2,
                256, 256);

        pGuiGraphics.blit(texture,
                this.leftPos + 63 + 0 * 18, this.topPos + 36 + 1 * 36,
                0, 181,
                this.menu.data.get(3), 2,
                256, 256);

        pGuiGraphics.blit(texture,
                this.leftPos + 63 + 1 * 18, this.topPos + 36 + 1 * 36,
                0, 181,
                this.menu.data.get(4), 2,
                256, 256);
        pGuiGraphics.pose().popPose();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
         zhi_zheng.mouseClicked(dragging, pMouseX, pMouseY, pButton);
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        zhi_zheng.mouseDragged(dragging, pMouseX, pMouseY, pButton, pDragX, pDragY);
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }
    @Override
    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        zhi_zheng.mouseReleased(dragging, pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }
    @Override
    public void containerTick() {
        super.containerTick();
        int mouseY = this.mousey - this.topPos;
        if(zhen_y> 69){
            zhen_y = 69;
        }else if(zhen_y < 17){
            zhen_y = 17;
        }
        if (dragging.get()) {
            zhen_y = Math.min(Math.max(mouseY, 17), 69);
        } else {
            zhen_y = (int) (52 - ((this.menu.data.get(0)/500.0)*52.0)) + 17;
        }
    }
    @Override
    public void init() {
        super.init();

        ImageButton imagebutton_add = new ImageButton(this.leftPos + 125, this.topPos + 17, 5, 6, 0, 166, 6, texture, 256, 256, e -> {
            if (boundBlockEntity instanceof OvenBlockEntity ovenBlockEntity) {
                zhen_y = (int) ((500 - ovenBlockEntity.getTemperature(ovenBlockEntity)) / (500 / 52.0) + 17);
                Messages.sendToServer(new OvenButtonMessage(0, x, y, z, zhen_y, textstate));
            }
        });
        guistate.put("button:imagebutton_add", imagebutton_add);
        this.addRenderableWidget(imagebutton_add);

        ImageButton imagebutton_sub = new ImageButton(this.leftPos + 125, this.topPos + 64, 5, 6, 5, 166, 6, texture, 256, 256, e -> {
            if (boundBlockEntity instanceof OvenBlockEntity ovenBlockEntity) {
                zhen_y = (int) ((500 - ovenBlockEntity.getTemperature(ovenBlockEntity)) / (500 / 52.0) + 17);
                Messages.sendToServer(new OvenButtonMessage(1, x, y, z, zhen_y, textstate));
            }
        });
        guistate.put("button:imagebutton_sub", imagebutton_sub);
        this.addRenderableWidget(imagebutton_sub);

    }
}
