//package com.renyigesai.bakeries.block.pizza_dough;
//
//import com.renyigesai.bakeries.init.BakeriesBlocks;
//import net.minecraft.core.BlockPos;
//import net.minecraft.core.Direction;
//import net.minecraft.world.InteractionHand;
//import net.minecraft.world.InteractionResult;
//import net.minecraft.world.entity.player.Player;
//import net.minecraft.world.level.BlockGetter;
//import net.minecraft.world.level.Level;
//import net.minecraft.world.level.block.BaseEntityBlock;
//import net.minecraft.world.level.block.Block;
//import net.minecraft.world.level.block.RenderShape;
//import net.minecraft.world.level.block.entity.BlockEntity;
//import net.minecraft.world.level.block.entity.BlockEntityTicker;
//import net.minecraft.world.level.block.entity.BlockEntityType;
//import net.minecraft.world.level.block.state.BlockBehaviour;
//import net.minecraft.world.level.block.state.BlockState;
//import net.minecraft.world.level.block.state.StateDefinition;
//import net.minecraft.world.level.block.state.properties.BlockStateProperties;
//import net.minecraft.world.level.block.state.properties.DirectionProperty;
//import net.minecraft.world.phys.BlockHitResult;
//import net.minecraft.world.phys.shapes.CollisionContext;
//import net.minecraft.world.phys.shapes.VoxelShape;
//import org.jetbrains.annotations.Nullable;
//
//public class PizzaDoughBlock extends BaseEntityBlock {
//    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
//    protected static final VoxelShape BOX = Block.box(1.0D, 0.0D, 1.0D, 15.0D, 2.0D, 15.0D);
//
//    public PizzaDoughBlock(BlockBehaviour.Properties pProperties) {
//        super(pProperties);
//        this.registerDefaultState(this.stateDefinition.any().setValue(FACING, Direction.NORTH));
//    }
//
//    @Override
//    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
//        return BOX;
//    }
//
//    @Override
//    public RenderShape getRenderShape(BlockState pState) {
//        return RenderShape.MODEL;
//    }
//
//    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
//        pBuilder.add(FACING);
//    }
//
//    @Nullable
//    @Override
//    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
//        return pLevel.isClientSide ? null : createTickerHelper(pBlockEntityType, BakeriesBlocks.PIZZA_DOUGH_ENTITY.get(),
//                PizzaDoughBlockEntity::craftTick);
//    }
//
//    @Override
//    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
//        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
//        if (blockEntity instanceof PizzaDoughBlockEntity pizzaDoughBlockEntity){
//            if (!pLevel.isClientSide){
//                if (!pPlayer.getItemInHand(pHand).isEmpty()) {
//                    pizzaDoughBlockEntity.addItem(pPlayer.getItemInHand(pHand));
//                }
//                return InteractionResult.FAIL;
//            }
//
//        }
//        return InteractionResult.CONSUME;
//    }
//
//    @Nullable
//    @Override
//    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
//        return new PizzaDoughBlockEntity(pPos,pState);
//    }
//}
