package com.github.wallev.maidsoulkitchen.client.gui.item;

import com.github.wallev.maidsoulkitchen.MaidsoulKitchen;
import com.github.wallev.maidsoulkitchen.client.gui.widget.button.CookBagModeButton;
import com.github.wallev.maidsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.maidsoulkitchen.inventory.container.item.CookBagConfigContainer;
import com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.maidsoulkitchen.network.NetworkHandler;
import com.github.wallev.maidsoulkitchen.vhelper.client.chat.VComponent;
import com.github.wallev.maidsoulkitchen.vhelper.client.resources.VResourceLocation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.anti_ad.mc.ipn.api.IPNIgnore;

import java.awt.*;
import java.util.List;
import java.util.*;

import static com.github.wallev.maidsoulkitchen.item.ItemCulinaryHub.BIND_SIZE;

@IPNIgnore
@OnlyIn(Dist.CLIENT)
public class CookBagConfigGui extends CookBagAbstractContainerGui<CookBagConfigContainer> {
    private static final ResourceLocation TEXTURE = VResourceLocation.create(MaidsoulKitchen.MOD_ID, "textures/gui/cook_guide.png");

    protected String bindMode;

    public CookBagConfigGui(CookBagConfigContainer container, Inventory inv, Component titleIn) {
        super(container, inv, VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.title"));
        this.bindMode = ItemCulinaryHub.getBindMode(menu.cookBag);
    }

    @Override
    protected void init() {
        super.init();

        this.addBindModeButtons();
        this.addInfoButton();
    }

    private void addBindModeButtons() {
        int x = leftPos + 6;
        int y = topPos + 6;
        for (BagType value : BagType.DISPLAY_VALS) {
            MutableComponent title = VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey);

            Map<BagType, List<BlockPos>> bindPoses = ItemCulinaryHub.getBindPoses(this.menu.cookBag);
            int bindSize = bindPoses.getOrDefault(value, Collections.emptyList()).size();

            CookBagModeButton cookBagModeButton = new CookBagModeButton(x, y += 22, 100, 20, title, b -> {
            }, Tooltip.create(VComponent.empty().append(title.append(VComponent.literal(String.format("[%s/%s]", bindSize, BIND_SIZE)).withStyle(bindSize < BIND_SIZE ? ChatFormatting.GREEN : ChatFormatting.GRAY)))
                    .append(VComponent.NEW_LINE)
                    .append(VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey + ".tooltip")))) {
                @Override
                public void onClick(double pMouseX, double pMouseY) {
                    super.onClick(pMouseX, pMouseY);
                    bindMode = value.name;
                    NetworkHandler.C2S.setCookBagBindMode(bindMode);
                }

                @Override
                public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
                    if (Objects.equals(bindMode, value.name)) {
                        pColor = Color.GREEN.getRGB();
                    }
                    super.renderString(pGuiGraphics, pFont, pColor);
                }
            };

            this.addRenderableWidget(cookBagModeButton);
        }

        Button clearButton = Button.builder(VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.clear_bind_poses").withStyle(ChatFormatting.YELLOW), b -> {
                    NetworkHandler.C2S.clearCookBagBindPoses();
                    onClose();
                })
                .bounds(x, y += 22, 100, 20)
                .tooltip(Tooltip.create(VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.clear_bind_poses.tooltip")))
                .build();
        this.addRenderableWidget(clearButton);
    }

    private void addInfoButton() {
        int x = leftPos + imageWidth;
        int y = topPos + 5;
        ImageButton infoButton = new ImageButton(x - 15, y, 9, 9, 237 - 10, 212, 10, TEXTURE, (b) -> {
        });
        MutableComponent mutableComponent = VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage").withStyle(ChatFormatting.GREEN);
        mutableComponent.append(VComponent.NEW_LINE);
        mutableComponent.append(VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.1").withStyle(ChatFormatting.GRAY));
        mutableComponent.append(VComponent.NEW_LINE);
        mutableComponent.append(VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.2").withStyle(ChatFormatting.GRAY));
        mutableComponent.append(VComponent.NEW_LINE);
        mutableComponent.append(VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.usage.3").withStyle(ChatFormatting.GRAY));
        infoButton.setTooltip(Tooltip.create(mutableComponent));
        this.addRenderableWidget(infoButton);

        Map<BagType, List<BlockPos>> bindPoses = ItemCulinaryHub.getBindPoses(this.menu.cookBag);
        List<BagType> leftBindBagTypes = new ArrayList<>();

        for (BagType displayVal : BagType.DISPLAY_VALS) {
            if (bindPoses.getOrDefault(displayVal, Collections.emptyList()).isEmpty()) {
                leftBindBagTypes.add(displayVal);
            }
        }
        if (bindPoses.isEmpty() || leftBindBagTypes.size() == BagType.VALS.length - 2) {
            MutableComponent mutableComponent1 = VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn").withStyle(ChatFormatting.YELLOW);
            mutableComponent1.append(CommonComponents.NEW_LINE);
            mutableComponent1.append(VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn.empty").withStyle(ChatFormatting.GRAY));

            ImageButton warnButton = new ImageButton(x - 15 - 10, y, 9, 9, 237, 212, 10, TEXTURE, (b) -> {
            });
            warnButton.setTooltip(Tooltip.create(mutableComponent1));
            this.addRenderableWidget(warnButton);
        } else if (!leftBindBagTypes.isEmpty()) {
            MutableComponent leftComponent1 = Component.empty();
            boolean first = true;
            for (BagType value : leftBindBagTypes) {
                if (first) {
                    leftComponent1.append(VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey).withStyle(ChatFormatting.GRAY));
                    first = false;
                } else {
                    leftComponent1.append(Component.literal("、").append(VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode." + value.translateKey).withStyle(ChatFormatting.GRAY)));
                }
            }
            MutableComponent leftComponent = Component.literal("[").append(leftComponent1).append(Component.literal("]").withStyle(ChatFormatting.GRAY));

            MutableComponent mutableComponent1 = VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn").withStyle(ChatFormatting.YELLOW);
            mutableComponent1.append(CommonComponents.NEW_LINE);
            mutableComponent1.append(VComponent.translatable("tooltips.maidsoulkitchen.culinary_hub.desc.warn.left", leftComponent).withStyle(ChatFormatting.GRAY));

            ImageButton warnButton = new ImageButton(x - 15 - 10, y, 9, 9, 237, 212, 10, TEXTURE, (b) -> {
            });
            warnButton.setTooltip(Tooltip.create(mutableComponent1));
            this.addRenderableWidget(warnButton);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);

        int x = leftPos + 6;
        int y = topPos + 6;
        int width = 100;
        guiGraphics.renderItem(Items.RED_MUSHROOM.getDefaultInstance(), x + width + 1, y + 22);
        guiGraphics.renderItem(Items.BROWN_MUSHROOM.getDefaultInstance(), x + width + 16 + 1, y + 22);
        guiGraphics.renderItem(Items.COAL.getDefaultInstance(), x + width + 16 + 1 + 16 + 1, y + 22);
        guiGraphics.renderItem(Items.BOWL.getDefaultInstance(), x + width + 16 + 1 + 16 + 1 + 16 + 1, y + 22);
        guiGraphics.renderItem(Items.MUSHROOM_STEW.getDefaultInstance(), x + width + 1, y + 22 + 22);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, VComponent.translatable("gui.maidsoulkitchen.culinary_hub.config.bind_mode"), this.titleLabelX, this.titleLabelY + 12, 4210752, false);
        pGuiGraphics.drawString(this.font, this.titleComponent, this.titleLabelX, this.titleLabelY, 4210752, false);
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 4210752, false);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int middleX = (this.width - this.imageWidth) / 2;
        int middleY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(CONFIG_BACKGROUND, middleX, middleY, 0, 0, this.imageWidth, this.imageHeight);
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
    }
}
