package studio.fantasyit.maid_storage_manager.registry;

import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import studio.fantasyit.maid_storage_manager.MaidStorageManager;
import studio.fantasyit.maid_storage_manager.recipe.CopyConfigRecipe;
import studio.fantasyit.maid_storage_manager.recipe.ListClearRecipe;


public class RecipesRegistry {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create(ForgeRegistries.RECIPE_SERIALIZERS, MaidStorageManager.MODID);
    public static final RegistryObject<RecipeSerializer<?>> LIST_CLEAR_SERIALIZERS = RECIPE_SERIALIZERS.register("list_clear", ListClearRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> COPY_CONFIG_SERIALIZERS = RECIPE_SERIALIZERS.register("copy", CopyConfigRecipe.Serializer::new);

    public static void register(IEventBus modEventBus) {
        RECIPE_SERIALIZERS.register(modEventBus);
    }
}
