/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.util.fakeplayer;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.maidsoulkitchen.util.fakeplayer.WrappedMaidInventory;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class WrappedMaidFakePlayer
extends FakePlayer {
    private static final ConcurrentHashMap<UUID, WrappedMaidFakePlayer> CACHE = new ConcurrentHashMap();
    private final EntityMaid maid;
    private ItemStack ghostItem = ItemStack.f_41583_;
    private boolean enableGhostItem = false;
    private boolean needSync = false;

    private WrappedMaidFakePlayer(EntityMaid maid) {
        super((ServerLevel)maid.m_9236_(), new GameProfile(UUID.randomUUID(), maid.m_7755_().getString()));
        this.maid = maid;
        this.f_36093_ = new WrappedMaidInventory(maid, this);
        this.f_8941_ = new ServerPlayerGameMode((ServerPlayer)this){

            public boolean m_143473_(GameType pGameModeForPlayer) {
                return false;
            }
        };
    }

    public static WrappedMaidFakePlayer get(EntityMaid maid) {
        if (CACHE.containsKey(maid.m_20148_())) {
            WrappedMaidFakePlayer wrappedMaidFakePlayer = CACHE.get(maid.m_20148_());
            if (!wrappedMaidFakePlayer.maid.m_6084_()) {
                CACHE.remove(maid.m_20148_());
            } else {
                return wrappedMaidFakePlayer;
            }
        }
        WrappedMaidFakePlayer fakePlayer = new WrappedMaidFakePlayer(maid);
        CACHE.put(maid.m_20148_(), fakePlayer);
        return fakePlayer;
    }

    public WrappedMaidInventory getInventory() {
        return (WrappedMaidInventory)super.m_150109_();
    }

    public boolean m_36356_(ItemStack stack) {
        return this.getInventory().m_36054_(stack);
    }

    public boolean m_182294_(boolean dropStack) {
        return super.m_182294_(dropStack);
    }

    protected void m_5907_() {
        super.m_5907_();
    }

    protected void m_36345_() {
        super.m_36345_();
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        super.m_6472_(damageSource, damage);
    }

    protected void m_142642_(DamageSource damageSource, float damageAmount) {
        super.m_142642_(damageSource, damageAmount);
    }

    public void m_8061_(EquipmentSlot slot, ItemStack Stack) {
        super.m_8061_(slot, Stack);
    }

    public Iterable<ItemStack> m_6168_() {
        return super.m_6168_();
    }

    public SlotAccess m_141942_(int slot) {
        return super.m_141942_(slot);
    }

    public ItemStack m_6298_(ItemStack shoot) {
        return super.m_6298_(shoot);
    }

    public ItemStack m_21205_() {
        return super.m_21205_();
    }

    public ItemStack m_21206_() {
        return super.m_21206_();
    }

    public ItemStack m_21120_(InteractionHand pHand) {
        return this.enableGhostItem ? this.ghostItem : super.m_21120_(pHand);
    }

    public void m_21008_(InteractionHand pHand, ItemStack pStack) {
        if (this.maid == null) {
            return;
        }
        if (this.enableGhostItem) {
            if (ItemStack.m_150942_((ItemStack)this.ghostItem, (ItemStack)pStack)) {
                this.ghostItem.m_41774_(this.ghostItem.m_41613_() - pStack.m_41613_());
            } else {
                this.ghostItem.m_41774_(1);
                this.m_36356_(pStack);
            }
        } else {
            this.maid.m_21008_(pHand, pStack);
        }
    }

    public ItemStack m_6844_(EquipmentSlot equipmentSlot) {
        if (this.maid == null) {
            return ItemStack.f_41583_;
        }
        if (this.enableGhostItem) {
            return this.ghostItem;
        }
        switch (equipmentSlot) {
            case MAINHAND: {
                return this.maid.m_21205_();
            }
            case OFFHAND: {
                return this.maid.m_21206_();
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_21055_(Item pItem) {
        return super.m_21055_(pItem);
    }

    public boolean m_21093_(Predicate<ItemStack> pPredicate) {
        return super.m_21093_(pPredicate);
    }

    public void m_6674_(InteractionHand hand) {
        this.m_21011_(hand, false);
    }

    public void m_21011_(InteractionHand hand, boolean updateSelf) {
        this.maid.m_21011_(hand, updateSelf);
    }

    public void setGhostItem(ItemStack itemStack) {
        this.enableGhostItem = true;
        this.ghostItem = itemStack;
    }

    public void clearGhostItem() {
        this.enableGhostItem = false;
        this.ghostItem = ItemStack.f_41583_;
    }

    public void resetInv() {
        this.getInventory().resetInv();
    }

    public IItemHandlerModifiable getInv() {
        return this.getInventory().getInv();
    }

    public void setInv(IItemHandlerModifiable inv) {
        this.getInventory().setInvSupplier(maid -> inv);
    }

    public IItemHandlerModifiable getCombinedHandInv() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.maid.getHandsInvWrapper(), this.getInv()});
    }

    public InteractionResult clickPos(BlockPos targetPos, ItemStack itemStack) {
        return this.useOnByItem(targetPos, itemStack);
    }

    public InteractionResult clickPos(BlockPos targetPos) {
        return this.useOnByHand(targetPos);
    }

    public InteractionResult clickPos() {
        return this.useOnByHand();
    }

    public InteractionResult use() {
        return this.useByHand(InteractionHand.MAIN_HAND);
    }

    public InteractionResult useByHand(InteractionHand hand) {
        return this.useByHand(hand, this.m_21120_(hand));
    }

    public InteractionResult useByHand(InteractionHand hand, BlockPos pos) {
        return this.useByHand(hand, this.m_21120_(hand), pos);
    }

    public InteractionResult useByHand(InteractionHand hand, ItemStack itemStack) {
        InteractionResult result = this.f_8941_.m_6261_((ServerPlayer)this, this.maid.f_19853_, itemStack, hand);
        if (result.m_19080_()) {
            this.m_21011_(hand, true);
        }
        return result;
    }

    public InteractionResult useByHand(InteractionHand hand, ItemStack itemStack, BlockPos pos) {
        BlockHitResult blockHitResult = this.getBlockHitResult(pos);
        InteractionResult result = this.f_8941_.m_7179_((ServerPlayer)this, this.maid.f_19853_, itemStack, hand, blockHitResult);
        if (result.m_19080_()) {
            this.m_21011_(hand, true);
        }
        return result;
    }

    public InteractionResult useOnByItem(BlockPos pos, ItemStack itemStack, IItemHandlerModifiable inv) {
        try {
            BlockHitResult blockHitResult = this.getBlockHitResult(pos);
            this.setGhostItem(itemStack);
            this.getInventory().setInvSupplier(maid0 -> inv);
            InteractionResult result = this.f_8941_.m_7179_((ServerPlayer)this, this.maid.f_19853_, itemStack, InteractionHand.MAIN_HAND, blockHitResult);
            if (result.m_19080_()) {
                this.m_21011_(InteractionHand.MAIN_HAND, true);
            }
            this.clearGhostItem();
            this.getInventory().resetInv();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return InteractionResult.FAIL;
        }
    }

    public InteractionResult useOnByItem(BlockPos pos, ItemStack itemStack) {
        try {
            BlockHitResult blockHitResult = this.getBlockHitResult(pos);
            this.setGhostItem(itemStack);
            InteractionResult result = this.f_8941_.m_7179_((ServerPlayer)this, this.maid.f_19853_, itemStack, InteractionHand.MAIN_HAND, blockHitResult);
            if (result.m_19080_()) {
                this.m_21011_(InteractionHand.MAIN_HAND, true);
            }
            this.clearGhostItem();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return InteractionResult.FAIL;
        }
    }

    public InteractionResult useOnByItemWithSneak(BlockPos pos, ItemStack itemStack, IItemHandlerModifiable inv) {
        try {
            BlockHitResult blockHitResult = this.getBlockHitResult(pos);
            this.m_20260_(true);
            this.setGhostItem(itemStack);
            this.getInventory().setInvSupplier(maid0 -> inv);
            InteractionResult result = this.f_8941_.m_7179_((ServerPlayer)this, this.maid.f_19853_, itemStack, InteractionHand.MAIN_HAND, blockHitResult);
            if (result.m_19080_()) {
                this.m_21011_(InteractionHand.MAIN_HAND, true);
            }
            this.clearGhostItem();
            this.m_20260_(false);
            this.getInventory().resetInv();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return InteractionResult.FAIL;
        }
    }

    public InteractionResult useOnByItemWithSneak(BlockPos pos, ItemStack itemStack) {
        try {
            BlockHitResult blockHitResult = this.getBlockHitResult(pos);
            this.m_20260_(true);
            this.setGhostItem(itemStack);
            InteractionResult result = this.f_8941_.m_7179_((ServerPlayer)this, this.maid.f_19853_, itemStack, InteractionHand.MAIN_HAND, blockHitResult);
            if (result.m_19080_()) {
                this.m_21011_(InteractionHand.MAIN_HAND, true);
            }
            this.clearGhostItem();
            this.m_20260_(false);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return InteractionResult.FAIL;
        }
    }

    public InteractionResult useOnByHand(BlockPos pos) {
        try {
            BlockHitResult blockHitResult = this.getBlockHitResult(pos);
            InteractionResult result = this.f_8941_.m_7179_((ServerPlayer)this, this.maid.f_19853_, this.m_21205_(), InteractionHand.MAIN_HAND, blockHitResult);
            if (result.m_19080_()) {
                this.m_21011_(InteractionHand.MAIN_HAND, true);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return InteractionResult.FAIL;
        }
    }

    public InteractionResult useOnByHand() {
        try {
            return this.maid.m_6274_().m_21952_(MemoryModuleType.f_26371_).map(positionTracker -> {
                InteractionResult result = this.useOnByHand(positionTracker.m_6675_());
                if (result.m_19080_()) {
                    this.m_21011_(InteractionHand.MAIN_HAND, true);
                }
                return result;
            }).orElse(InteractionResult.FAIL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return InteractionResult.FAIL;
        }
    }

    protected BlockHitResult getBlockHitResult() {
        return (BlockHitResult)this.maid.m_19907_(7.0, 0.0f, false);
    }

    @ApiStatus.Experimental
    protected BlockHitResult getBlockHitResultBy(BlockPos pos) {
        float partialTicks = 0.0f;
        double hitDistance = 6.0;
        boolean hitFluids = false;
        this.maid.m_21563_().m_24964_(pos.m_252807_());
        Vec3 eyePosition = this.maid.m_20299_(0.0f);
        Vec3 vec31 = this.maid.m_20252_(0.0f);
        Vec3 vec32 = eyePosition.m_82520_(vec31.f_82479_ * 6.0, vec31.f_82480_ * 6.0, vec31.f_82481_ * 6.0);
        return this.maid.f_19853_.m_45547_(new ClipContext(eyePosition, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
    }

    @ApiStatus.Experimental
    protected BlockHitResult getBlockHitResult(BlockPos pos) {
        return new BlockHitResult(this.maid.m_20154_(), this.maid.m_6374_(), pos, false);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.maid != null && this.maid.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.getInv());
        }
        return super.getCapability(capability, facing);
    }

    @ApiStatus.Experimental
    public BlockHitResult getLivingEntityPOVHitResult(BlockPos pos, ClipContext.Fluid fluidMode) {
        this.maid.m_21563_().m_24964_(pos.m_252807_());
        float xRot = this.maid.m_146909_();
        float yRot = this.maid.m_146908_();
        Vec3 eyePosition = this.maid.m_146892_();
        float f2 = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-xRot * ((float)Math.PI / 180)));
        float yo = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
        float xo = f3 * f4;
        float zo = f2 * f4;
        double blockReach = this.getBlockReach();
        Vec3 vec31 = eyePosition.m_82520_((double)xo * blockReach, (double)yo * blockReach, (double)zo * blockReach);
        return this.f_19853_.m_45547_(new ClipContext(eyePosition, vec31, ClipContext.Block.OUTLINE, fluidMode, (Entity)this.maid));
    }

    public double getBlockReach() {
        AttributeInstance reachInstance = this.maid.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (reachInstance != null) {
            return this.maid.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        }
        return 6.0;
    }

    @Deprecated
    public double m_204036_(TagKey<Fluid> fluidTagKey) {
        if (this.maid == null) {
            return super.m_204036_(fluidTagKey);
        }
        return this.maid.m_204036_(fluidTagKey);
    }

    public double m_20204_() {
        if (this.maid == null) {
            return super.m_20204_();
        }
        return this.maid.m_20204_();
    }

    public final float m_20205_() {
        if (this.maid == null) {
            return super.m_20205_();
        }
        return this.maid.m_20205_();
    }

    public final float m_20206_() {
        if (this.maid == null) {
            return super.m_20206_();
        }
        return this.maid.m_20206_();
    }

    public float m_278726_() {
        if (this.maid == null) {
            return super.m_278726_();
        }
        return this.maid.m_278726_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        if (this.maid == null) {
            return super.m_5654_();
        }
        return this.maid.m_5654_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.maid == null) {
            return super.m_6972_(pose);
        }
        return this.maid.m_6972_(pose);
    }

    public Vec3 m_20182_() {
        if (this.maid == null) {
            return super.m_20182_();
        }
        return this.maid.m_20182_();
    }

    public Vec3 m_213870_() {
        if (this.maid == null) {
            return super.m_213870_();
        }
        return this.maid.m_213870_();
    }

    public BlockPos m_20183_() {
        if (this.maid == null) {
            return super.m_20183_();
        }
        return this.maid.m_20183_();
    }

    public BlockState m_146900_() {
        if (this.maid == null) {
            return super.m_146900_();
        }
        return this.maid.m_146900_();
    }

    public ChunkPos m_146902_() {
        if (this.maid == null) {
            return super.m_146902_();
        }
        return this.maid.m_146902_();
    }

    public Vec3 m_20184_() {
        if (this.maid == null) {
            return super.m_20184_();
        }
        return this.maid.m_20184_();
    }

    public void m_20256_(Vec3 deltaMovement) {
        if (this.maid == null) {
            return;
        }
        this.maid.m_20256_(deltaMovement);
    }

    public void m_246865_(Vec3 add) {
        if (this.maid == null) {
            return;
        }
        this.maid.m_20256_(add);
    }

    public void m_20334_(double x, double y, double z) {
        if (this.maid == null) {
            return;
        }
        this.maid.m_20334_(x, y, z);
    }

    public final int m_146903_() {
        if (this.maid == null) {
            return super.m_146903_();
        }
        return this.maid.m_146903_();
    }

    public final double m_20185_() {
        if (this.maid == null) {
            return super.m_20185_();
        }
        return this.maid.m_20185_();
    }

    public double m_20165_(double scale) {
        if (this.maid == null) {
            return super.m_20165_(scale);
        }
        return this.maid.m_20165_(scale);
    }

    public double m_20208_(double scale) {
        if (this.maid == null) {
            return super.m_20208_(scale);
        }
        return this.maid.m_20208_(scale);
    }

    public final int m_146904_() {
        if (this.maid == null) {
            return super.m_146904_();
        }
        return this.maid.m_146904_();
    }

    public final double m_20186_() {
        if (this.maid == null) {
            return super.m_20186_();
        }
        return this.maid.m_20186_();
    }

    public double m_20227_(double scale) {
        if (this.maid == null) {
            return super.m_20227_(scale);
        }
        return this.maid.m_20227_(scale);
    }

    public double m_20187_() {
        if (this.maid == null) {
            return super.m_20187_();
        }
        return this.maid.m_20187_();
    }

    public double m_20188_() {
        if (this.maid == null) {
            return super.m_20188_();
        }
        return this.maid.m_20188_();
    }

    public final int m_146907_() {
        if (this.maid == null) {
            return super.m_146907_();
        }
        return this.maid.m_146907_();
    }

    public final double m_20189_() {
        if (this.maid == null) {
            return super.m_20189_();
        }
        return this.maid.m_20189_();
    }

    public double m_20246_(double scale) {
        if (this.maid == null) {
            return super.m_20246_(scale);
        }
        return this.maid.m_20246_(scale);
    }

    public double m_20262_(double scale) {
        if (this.maid == null) {
            return super.m_20262_(scale);
        }
        return this.maid.m_20262_(scale);
    }

    public float m_146908_() {
        if (this.maid == null) {
            return super.m_146908_();
        }
        return this.maid.m_146908_();
    }

    public void m_146922_(float pYRot) {
        if (this.maid == null) {
            super.m_146922_(pYRot);
            return;
        }
        this.maid.m_146922_(pYRot);
    }

    public float m_213816_() {
        if (this.maid == null) {
            return super.m_213816_();
        }
        return this.maid.m_213816_();
    }

    public float m_146909_() {
        if (this.maid == null) {
            return super.m_146909_();
        }
        return this.maid.m_146909_();
    }

    public void m_146926_(float pXRot) {
        if (this.maid == null) {
            super.m_146926_(pXRot);
            return;
        }
        this.maid.m_146926_(pXRot);
    }
}

