/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.maidsoulkitchen.api.task.cook;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.wallev.maidsoulkitchen.compat.patchouli.entry.TaskBookEntryType;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.CookDataV1;
import com.github.wallev.maidsoulkitchen.entity.data.inner.task.cook.v1.KitchenData;
import com.github.wallev.maidsoulkitchen.init.MkEntities;
import com.github.wallev.maidsoulkitchen.init.touhoulittlemaid.DataRegister;
import com.github.wallev.maidsoulkitchen.inventory.container.maid.CookConfigContainer;
import com.github.wallev.maidsoulkitchen.task.MaidsoulKitchenTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.CollectChestIngredientsTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.CookMakePathingTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.CookMakeTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.CookMoveTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.GenerateRecsTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.ai.ResetCookMemoryTask;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBe;
import com.github.wallev.maidsoulkitchen.task.cook.common.cook.be.CookBeBase;
import com.github.wallev.maidsoulkitchen.task.cook.common.manager.MaidCookManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.AbstractCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.cook.TickCookRule;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.RecSerializerManager;
import com.github.wallev.maidsoulkitchen.task.cook.common.rule.rec.mkrec.MKRecipe;
import com.github.wallev.maidsoulkitchen.util.MemoryUtil;
import com.github.wallev.maidsoulkitchen.vhelper.server.ai.VBehaviorControl;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ICookTask<B extends BlockEntity, R extends Recipe<? extends Container>> {
    public static final float MOVE_SPEED = 0.5f;
    public static final int VERTICAL_SEARCH_RANGE = 2;
    private static final Map<ResourceLocation, ICookTask<?, ?>> TASK = new LinkedHashMap();
    public final CookBe.Builder<B> cookBeBuilder = this.createCookBeBuilder();
    public final AbstractCookRule<B, R> cookRule = this.createCookRule();
    public final RecSerializerManager<R> recSerializerManager = this.createRecSerializerManager();
    private String bindModName = "";

    public static void putTask(ResourceLocation id, ICookTask<?, ?> task) {
        TASK.put(id, task);
    }

    public static ICookTask<?, ?> getTask(ResourceLocation id) {
        return TASK.get(id);
    }

    public static ICookTask<?, ?> getTask(MaidsoulKitchenTask taskInfo) {
        return ICookTask.getTask(taskInfo.uid);
    }

    public static BlockPos getSearchPos(EntityMaid maid, @Nullable BlockPos currentWorkPos) {
        if (currentWorkPos != null && maid.m_21444_(currentWorkPos)) {
            return currentWorkPos;
        }
        return maid.m_21536_() ? maid.m_21534_() : maid.m_20183_().m_7495_();
    }

    public static BlockPos getSearchPos(EntityMaid maid) {
        return ICookTask.getSearchPos(maid, null);
    }

    public static boolean checkOwnerPos(EntityMaid maid, BlockPos mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.m_269323_() != null && mutableBlockPos.m_203195_((Position)maid.m_269323_().m_20182_(), 8.0);
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        return this.vCreateBrainTasks(maid);
    }

    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        List<Pair<Integer, BehaviorControl<? super EntityMaid>>> rideBrainTasks = this.vCreateRideBrainTasks(maid);
        if (!rideBrainTasks.isEmpty()) {
            return rideBrainTasks;
        }
        return List.of();
    }

    public List<Pair<Integer, VBehaviorControl>> vCreateRideBrainTasks(EntityMaid entityMaid) {
        return Collections.emptyList();
    }

    public List<Pair<Integer, VBehaviorControl>> vCreateBrainTasks(EntityMaid maid) {
        MemoryUtil.resetCookWorkState(maid);
        ArrayList<Pair<Integer, VBehaviorControl>> controlTasks = new ArrayList<Pair<Integer, VBehaviorControl>>();
        CookBeBase<B> cookBe = this.createCookBe(maid);
        AbstractCookRule<B, R> rule = this.cookRule.getOrCreate();
        MaidCookManager<R> cm = this.createRecipesManager(maid, cookBe);
        CollectChestIngredientsTask<R> collectChestIngredientsTask = new CollectChestIngredientsTask<R>(cm);
        GenerateRecsTask<R> generateRecsTask = new GenerateRecsTask<R>(cm);
        CookMoveTask<B, R> cookMoveTask = this.createMaidCookMoveTask(cookBe, cm, rule);
        CookMakeTask<B, R> cookMakeTask = this.createMaidCookMakeTask(cookBe, cm, rule);
        ResetCookMemoryTask<R> resetCookMemoryTask = new ResetCookMemoryTask<R>(cm);
        controlTasks.add(Pair.of((Object)0, resetCookMemoryTask));
        controlTasks.add(Pair.of((Object)5, collectChestIngredientsTask));
        controlTasks.add(Pair.of((Object)5, generateRecsTask));
        controlTasks.add(Pair.of((Object)5, cookMoveTask));
        controlTasks.add(Pair.of((Object)6, cookMakeTask));
        controlTasks.add(Pair.of((Object)5, collectChestIngredientsTask));
        if (rule instanceof TickCookRule) {
            CookMakePathingTask<B> cookMakePathingTask = new CookMakePathingTask<B>(cookBe);
            controlTasks.add((Pair<Integer, VBehaviorControl>)Pair.of((Object)7, cookMakePathingTask));
        }
        return controlTasks;
    }

    protected CookMoveTask<B, R> createMaidCookMoveTask(CookBeBase<B> cookBe, MaidCookManager<R> rm, AbstractCookRule<B, R> rule) {
        return new CookMoveTask<B, R>(this, rm, rule, cookBe);
    }

    protected CookMakeTask<B, R> createMaidCookMakeTask(CookBeBase<B> cookBe, MaidCookManager<R> rm, AbstractCookRule<B, R> rule) {
        return new CookMakeTask<B, R>(this, rm, rule, cookBe);
    }

    protected CookBe.Builder<B> createCookBeBuilder() {
        return CookBe.Builder.empty();
    }

    protected abstract AbstractCookRule<B, R> createCookRule();

    protected abstract RecSerializerManager<R> createRecSerializerManager();

    protected abstract CookBeBase<B> createCookBe(EntityMaid var1);

    protected MaidCookManager<R> createRecipesManager(EntityMaid maid, CookBeBase<B> cookBe) {
        return new MaidCookManager<R>(this.recSerializerManager, maid, this, cookBe);
    }

    public List<MKRecipe<R>> getRecipes(Level level) {
        return this.recSerializerManager.getRecipes(level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<MKRecipe<R>> getRecipes(EntityMaid maid) {
        return this.getRecipes(maid.f_19853_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getRecipeTypeId() {
        return this.recSerializerManager.getRecipeTypeId();
    }

    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound((EntityMaid)maid, (SoundEvent)((SoundEvent)InitSounds.MAID_FURNACE.get()), (float)0.5f);
    }

    public double getCloseEnoughDist() {
        return 3.2;
    }

    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_enough_favor", this::hasEnoughFavor)});
    }

    public boolean isEnable(EntityMaid maid) {
        return this.hasEnoughFavor(maid);
    }

    public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Cook Config Container2");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory playerInventory, Player player) {
                return new CookConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    protected boolean hasEnoughFavor(EntityMaid maid) {
        return maid.getFavorabilityManager().getLevel() >= 1;
    }

    public TaskBookEntryType getBookEntryType() {
        return TaskBookEntryType.COOK;
    }

    public CookDataV1 getDefaultData() {
        return new CookDataV1();
    }

    public CookDataV1 getTaskData(EntityMaid maid) {
        KitchenData data = (KitchenData)maid.getOrCreateData(DataRegister.COOK, (Object)new KitchenData());
        return data.getCookData(this.getUid());
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getWarnComponent() {
        return Collections.emptyList();
    }

    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return !maid.m_6274_().m_21874_((MemoryModuleType)MkEntities.WORK_POS.get());
    }

    public boolean enableEating(EntityMaid maid) {
        return !maid.m_6274_().m_21874_((MemoryModuleType)MkEntities.WORK_POS.get());
    }

    public List<Component> getDescription() {
        String key = String.format("task.%s.%s.desc", this.getUid().m_135827_(), this.getUid().m_135815_());
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)key)});
    }

    public boolean enablePanic(EntityMaid maid) {
        return true;
    }

    public boolean workPointTask(EntityMaid maid) {
        return false;
    }

    public boolean canSitInJoy(EntityMaid maid, String joyType) {
        return false;
    }

    public MutableComponent getName() {
        return Component.m_237115_((String)String.format("task.%s.%s", this.getUid().m_135827_(), this.getUid().m_135815_()));
    }

    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.emptyList();
    }

    public List<String> getDescription(EntityMaid maid) {
        String key = String.format("task.%s.%s.desc", this.getUid().m_135827_(), this.getUid().m_135815_());
        return Lists.newArrayList((Object[])new String[]{key});
    }

    public abstract ResourceLocation getUid();

    public abstract ItemStack getIcon();

    @OnlyIn(value=Dist.CLIENT)
    public Component getTaskName() {
        return this.getIcon().m_41786_();
    }

    public final void setBindModName(String modName) {
        this.bindModName = modName;
    }

    public String getBindModName() {
        return this.bindModName;
    }
}

