/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.yhc;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.action.IMaidAction;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.item.fluid.SakeFluid;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationDummyContainer;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationRecipe;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationTankBlock;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationTankBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.ferment.SimpleFermentationRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskFermentationTank
implements ICookTask<FermentationTankBlockEntity, FermentationRecipe<?>>,
IMaidAction {
    public static boolean interactWithFluidHandler(@NotNull EntityMaid maid, ItemStack fluidStack, @NotNull Level level, @NotNull BlockPos pos, @Nullable Direction side) {
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkNotNull((Object)pos);
        return FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)side).map(handler -> TaskFermentationTank.interactWithFluidHandler(maid, fluidStack, handler)).orElse(false);
    }

    public static boolean interactWithFluidHandler(@NotNull EntityMaid maid, ItemStack fluidStack, @NotNull IFluidHandler handler) {
        ItemStack heldItem = fluidStack;
        if (!heldItem.m_41619_()) {
            CombinedInvWrapper availableInv = maid.getAvailableInv(true);
            FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)handler, (IItemHandler)availableInv, (int)Integer.MAX_VALUE, null, (boolean)true);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)handler, (IItemHandler)availableInv, (int)Integer.MAX_VALUE, null, (boolean)true);
            }
            if (fluidActionResult.isSuccess()) {
                heldItem.m_41774_(1);
                ItemStack result = fluidActionResult.getResult();
                ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)result, (boolean)false);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.YHC_FERMENTATION_TANK;
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof FermentationTankBlockEntity;
    }

    @Override
    public RecipeType<FermentationRecipe<?>> getRecipeType() {
        return (RecipeType)YHBlocks.FERMENT_RT.get();
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, FermentationTankBlockEntity blockEntity, MaidRecipesManager<FermentationRecipe<?>> recManager) {
        boolean hasEnoughWater;
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        Fluid fluid = blockEntity.fluids.getFluidInTank(0).getFluid();
        if (fluid instanceof SakeFluid) {
            SakeFluid sakeFluid = (SakeFluid)fluid;
            Item container = sakeFluid.type.getContainer();
            int outputAdditionItemCount = recManager.getOutputAdditionItemCount(container.m_7968_());
            if (outputAdditionItemCount > 0) {
                return true;
            }
        }
        if (!blockEntity.items.m_7983_()) {
            FermentationDummyContainer cont = new FermentationDummyContainer(blockEntity.items, blockEntity.fluids);
            Optional opt = maid.f_19853_.m_7465_().m_44015_((RecipeType)YHBlocks.FERMENT_RT.get(), (Container)cont, maid.f_19853_);
            if (opt.isEmpty()) {
                return true;
            }
        }
        boolean bl = hasEnoughWater = !blockEntity.fluids.isEmpty();
        if (!hasEnoughWater) {
            for (int i = 0; i < maidInv.getSlots(); ++i) {
                LazyOptional opt;
                ItemStack stackInSlot = maidInv.getStackInSlot(i);
                if (stackInSlot.m_41619_() || stackInSlot.m_150930_(Items.f_42446_) || !(opt = stackInSlot.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM)).resolve().isPresent()) continue;
                return true;
            }
        }
        return hasEnoughWater && blockEntity.inProgress() == 0.0f && blockEntity.items.m_7983_() && !recManager.getRecipesIngredients().isEmpty();
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, FermentationTankBlockEntity blockEntity, MaidRecipesManager<FermentationRecipe<?>> recManager) {
        CombinedInvWrapper maidInv = maid.getAvailableInv(true);
        IItemHandlerModifiable outputInv = recManager.getOutputInv();
        FluidStack fluidInTank = blockEntity.fluids.getFluidInTank(0);
        Fluid fluid = fluidInTank.getFluid();
        if (fluid instanceof SakeFluid) {
            SakeFluid sakeFluid = (SakeFluid)fluid;
            Item container = sakeFluid.type.getContainer();
            int outputAdditionItemCount = recManager.getOutputAdditionItemCount(container.m_7968_());
            if (outputAdditionItemCount > 0) {
                int takeAmount = Math.min(fluidInTank.getAmount() / sakeFluid.type.amount(), outputAdditionItemCount);
                ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)sakeFluid.type.asStack(takeAmount), (boolean)false);
                recManager.shrinkOutputAdditionItem(container.m_7968_(), takeAmount - leftStack.m_41613_());
                blockEntity.fluids.drain(sakeFluid.type.amount() * takeAmount, IFluidHandler.FluidAction.EXECUTE);
                blockEntity.notifyTile();
                this.pickupAction(maid);
            }
        }
        if (blockEntity.fluids.isEmpty()) {
            for (int i = 0; i < maidInv.getSlots(); ++i) {
                ItemStack stackInSlot = maidInv.getStackInSlot(i);
                LazyOptional opt = stackInSlot.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                if (!opt.resolve().isPresent() || !TaskFermentationTank.interactWithFluidHandler(maid, stackInSlot, (Level)serverLevel, blockEntity.m_58899_(), null)) continue;
                blockEntity.notifyTile();
            }
        }
        if (!blockEntity.items.m_7983_()) {
            FermentationDummyContainer cont = new FermentationDummyContainer(blockEntity.items, blockEntity.fluids);
            Optional opt = maid.f_19853_.m_7465_().m_44015_((RecipeType)YHBlocks.FERMENT_RT.get(), (Container)cont, maid.f_19853_);
            if (opt.isEmpty()) {
                blockEntity.dumpInventory();
            }
        }
        if (!blockEntity.fluids.isEmpty() && blockEntity.inProgress() == 0.0f && !recManager.getRecipesIngredients().isEmpty()) {
            Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = recManager.getRecipeIngredient();
            if (((List)recipeIngredient.getFirst()).isEmpty()) {
                return;
            }
            for (List itemStacks : (List)recipeIngredient.getSecond()) {
                Optional<ItemStack> first = itemStacks.stream().filter(stack -> !stack.m_41619_()).findFirst();
                first.ifPresent(stack -> {
                    ItemStack remain;
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(1);
                    if (blockEntity.items.m_19183_(copy) && (remain = blockEntity.items.m_19173_(copy)).m_41619_()) {
                        stack.m_41774_(1);
                        blockEntity.notifyTile();
                    }
                });
            }
            serverLevel.m_46597_(blockEntity.m_58899_(), (BlockState)blockEntity.m_58900_().m_61124_((Property)FermentationTankBlock.OPEN, (Comparable)Boolean.valueOf(false)));
            this.pickupAction(maid);
        }
    }

    public ResourceLocation getUid() {
        return TaskInfo.YHC_FERMENTATION_TANK.uid;
    }

    public ItemStack getIcon() {
        return YHBlocks.FERMENT.asStack();
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.addAll((Collection)((SimpleFermentationRecipe)recipe).ingredients);
        return ingredients;
    }

    @Override
    public ItemStack getResultItem(Recipe<?> recipe, RegistryAccess pRegistryAccess) {
        SimpleFermentationRecipe fermentationRecipe = (SimpleFermentationRecipe)recipe;
        Fluid fluid = fermentationRecipe.outputFluid.getFluid();
        if (fluid instanceof SakeFluid) {
            SakeFluid sakeFluid = (SakeFluid)fluid;
            return sakeFluid.type.asStack(1);
        }
        return Items.f_41852_.m_7968_();
    }
}

