/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.mc;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.mixin.mc.AbstractFurnaceAccessor;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.TaskBaseContainerCook;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskFurnace
extends TaskBaseContainerCook<AbstractFurnaceBlockEntity, AbstractCookingRecipe> {
    @Override
    public boolean isEnable(EntityMaid maid) {
        return true;
    }

    @Override
    public boolean isHeated(AbstractFurnaceBlockEntity be) {
        return true;
    }

    @Override
    public boolean beInnerCanCook(Container inventory, AbstractFurnaceBlockEntity be) {
        return false;
    }

    @Override
    public int getOutputSlot() {
        return 2;
    }

    @Override
    public int getInputSize() {
        return 1;
    }

    @Override
    public Container getContainer(AbstractFurnaceBlockEntity be) {
        return be;
    }

    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof AbstractFurnaceBlockEntity;
    }

    @Override
    public RecipeType<AbstractCookingRecipe> getRecipeType() {
        return RecipeType.f_44110_;
    }

    public ResourceLocation getUid() {
        return TaskInfo.FURNACE.uid;
    }

    public ItemStack getIcon() {
        return Items.f_41962_.m_7968_();
    }

    @Override
    public boolean maidShouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, AbstractFurnaceBlockEntity blockEntity, MaidRecipesManager<AbstractCookingRecipe> maidRecipesManager) {
        boolean hasFuel;
        int[] resultSlots;
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        for (int resultSlot : resultSlots = blockEntity.m_7071_(Direction.DOWN)) {
            ItemStack resultStack = blockEntity.m_8020_(resultSlot);
            if (resultStack.m_41619_() || !blockEntity.m_7157_(resultSlot, resultStack, Direction.DOWN)) continue;
            return true;
        }
        boolean bl = hasFuel = this.hasFuel(blockEntity) || this.getFuel(availableInv).isPresent();
        if (!hasFuel) {
            return false;
        }
        RecipeType<? extends AbstractCookingRecipe> recipeType = ((AbstractFurnaceAccessor)blockEntity).getRecipeType();
        for (int slot : blockEntity.m_7071_(Direction.UP)) {
            ItemStack stack = blockEntity.m_8020_(slot);
            if (!stack.m_41619_() || !this.getAnyCookableItem(entityMaid, (IItemHandlerModifiable)availableInv, recipeType, cookable -> blockEntity.m_7155_(slot, cookable, Direction.UP)).isPresent()) continue;
            return true;
        }
        return false;
    }

    private boolean hasFuel(AbstractFurnaceBlockEntity furnace) {
        int[] fuelSlots;
        for (int fuelSlot : fuelSlots = furnace.m_7071_(Direction.NORTH)) {
            ItemStack fuelSlotStack = furnace.m_8020_(fuelSlot);
            if (fuelSlotStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private Optional<ItemStack> getAnyCookableItem(EntityMaid maid, IItemHandlerModifiable availableInv, RecipeType<? extends AbstractCookingRecipe> recipeType, Predicate<ItemStack> predicate) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (slotStack.m_41619_() || !this.getRecipe(maid, slotStack, recipeType).isPresent() || !predicate.test(slotStack)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    private Optional<? extends AbstractCookingRecipe> getRecipe(EntityMaid maid, ItemStack stack, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        return maid.f_19853_.m_7465_().m_44015_(recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), maid.m_9236_());
    }

    @Override
    public void maidCookMake(ServerLevel serverLevel, EntityMaid entityMaid, AbstractFurnaceBlockEntity blockEntity, MaidRecipesManager<AbstractCookingRecipe> maidRecipesManager) {
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        this.tryExtractItem(blockEntity, entityMaid, maidRecipesManager.getOutputInv());
        if (!this.tryInsertFuel(availableInv, blockEntity)) {
            return;
        }
        this.tryInsertCookable(entityMaid, availableInv, blockEntity);
    }

    private void tryExtractItem(AbstractFurnaceBlockEntity furnace, EntityMaid maid, IItemHandlerModifiable availableInv) {
        int[] resultSlots;
        for (int resultSlot : resultSlots = furnace.m_7071_(Direction.DOWN)) {
            ItemStack resultStack = furnace.m_8020_(resultSlot);
            if (resultStack.m_41619_() || !furnace.m_7157_(resultSlot, resultStack, Direction.DOWN)) continue;
            ItemStack copy = resultStack.m_41777_();
            furnace.m_6836_(resultSlot, ItemStack.f_41583_);
            ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)copy, (boolean)false);
        }
        this.pickupAction(maid);
    }

    private boolean tryInsertFuel(CombinedInvWrapper availableInv, AbstractFurnaceBlockEntity furnace) {
        int[] fuelSlots;
        for (int fuelSlot : fuelSlots = furnace.m_7071_(Direction.NORTH)) {
            ItemStack fuelSlotStack = furnace.m_8020_(fuelSlot);
            if (!fuelSlotStack.m_41619_()) continue;
            Optional<ItemStack> fuel = this.getFuel(availableInv);
            if (fuel.isEmpty()) {
                return false;
            }
            if (!furnace.m_7155_(fuelSlot, fuel.get(), Direction.NORTH)) continue;
            furnace.m_6836_(fuelSlot, fuel.get().m_41777_());
            fuel.get().m_41764_(0);
            furnace.m_6596_();
            break;
        }
        return true;
    }

    private void tryInsertCookable(EntityMaid maid, CombinedInvWrapper availableInv, AbstractFurnaceBlockEntity furnace) {
        int[] materialSlots;
        for (int materialSlot : materialSlots = furnace.m_7071_(Direction.UP)) {
            Optional<ItemStack> material;
            ItemStack materialSlotStack = furnace.m_8020_(materialSlot);
            if (!materialSlotStack.m_41619_() || (material = this.getCookable(maid, availableInv, ((AbstractFurnaceAccessor)furnace).getRecipeType())).isEmpty() || !furnace.m_7155_(materialSlot, material.get(), Direction.UP)) continue;
            furnace.m_6836_(materialSlot, material.get().m_41777_());
            material.get().m_41764_(0);
            furnace.m_6596_();
            break;
        }
        this.pickupAction(maid);
    }

    private Optional<ItemStack> getCookable(EntityMaid maid, CombinedInvWrapper availableInv, RecipeType<? extends AbstractCookingRecipe> recipeType) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack slotStack = availableInv.getStackInSlot(i);
            if (!this.getRecipe(maid, slotStack, recipeType).isPresent()) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    private Optional<ItemStack> getFuel(CombinedInvWrapper availableInv) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack stack = availableInv.getStackInSlot(i);
            if (stack.m_41619_() || !this.isFuel(stack)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    private boolean isFuel(ItemStack stack) {
        return AbstractFurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.MC_FURNACE;
    }
}

