/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.fd;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.ai.MaidCookMoveTask;
import com.github.wallev.farmsoulkitchen.task.ai.MaidCuttingMakeTask;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class TaskFdCuttingBoard
implements ICookTask<CuttingBoardBlockEntity, CuttingBoardRecipe> {
    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof CuttingBoardBlockEntity;
    }

    @Override
    public RecipeType<CuttingBoardRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.CUTTING.get();
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        if (maid.f_19853_.f_46443_) {
            return Collections.emptyList();
        }
        MaidRecipesManager<CuttingBoardRecipe> cookingPotRecipeMaidRecipesManager = this.getRecipesManager(maid);
        MaidCookMoveTask<CuttingBoardBlockEntity, CuttingBoardRecipe> maidCookMoveTask = new MaidCookMoveTask<CuttingBoardBlockEntity, CuttingBoardRecipe>(this, cookingPotRecipeMaidRecipesManager);
        MaidCuttingMakeTask maidCookMakeTask = new MaidCuttingMakeTask(this, cookingPotRecipeMaidRecipesManager);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, maidCookMoveTask), Pair.of((Object)6, (Object)((Object)maidCookMakeTask))});
    }

    @Override
    public boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid maid, CuttingBoardBlockEntity blockEntity, MaidRecipesManager<CuttingBoardRecipe> recManager) {
        return blockEntity.getStoredItem().m_41619_() && !recManager.getRecipesIngredients().isEmpty();
    }

    @Override
    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, CuttingBoardBlockEntity blockEntity, MaidRecipesManager<CuttingBoardRecipe> recManager) {
    }

    public void processCookMake(ServerLevel serverLevel, EntityMaid maid, CuttingBoardBlockEntity blockEntity, MaidRecipesManager<CuttingBoardRecipe> recManager, Consumer<Item> item) {
        if (blockEntity.getStoredItem().m_41619_() && !recManager.getRecipesIngredients().isEmpty()) {
            Pair<List<Integer>, List<List<ItemStack>>> recipeIngredient = recManager.getRecipeIngredient();
            if (((List)recipeIngredient.getFirst()).isEmpty()) {
                return;
            }
            ItemStackHandler availableInv = maid.getMaidInv();
            List itemStacks = (List)((List)recipeIngredient.getSecond()).get(0);
            for (ItemStack itemStack : itemStacks) {
                if (itemStack.m_41619_()) continue;
                ItemStack offhandItem = maid.m_21206_();
                if (offhandItem != itemStack && !ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)offhandItem, (boolean)false).m_41619_()) {
                    return;
                }
                item.accept(itemStack.m_41720_());
                maid.m_21008_(InteractionHand.OFF_HAND, itemStack.m_41777_());
                itemStack.m_41764_(0);
                break;
            }
            List toolStacks = (List)((List)recipeIngredient.getSecond()).get(1);
            for (ItemStack itemStack : toolStacks) {
                if (itemStack.m_41619_()) continue;
                ItemStack maidMainHandItem = maid.m_21205_();
                if (maidMainHandItem != itemStack && !ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)maidMainHandItem, (boolean)false).m_41619_()) {
                    return;
                }
                maid.m_21008_(InteractionHand.MAIN_HAND, itemStack.m_41777_());
                itemStack.m_41764_(0);
                break;
            }
        }
    }

    @Override
    public MaidRecipesManager<CuttingBoardRecipe> getRecipesManager(final EntityMaid maid) {
        return new MaidRecipesManager<CuttingBoardRecipe>(maid, (ICookTask)this, false){

            @Override
            protected List<Pair<List<Integer>, List<Item>>> createIngres(Map<Item, Integer> available, boolean setRecipeIngres) {
                ItemStackHandler availableInv = maid.getMaidInv();
                boolean hasAvi = false;
                for (int i = 0; i < availableInv.getSlots(); ++i) {
                    if (!availableInv.getStackInSlot(i).m_41619_()) continue;
                    hasAvi = true;
                    break;
                }
                if (!hasAvi) {
                    return Collections.emptyList();
                }
                return super.createIngres(available, setRecipeIngres);
            }
        };
    }

    public ResourceLocation getUid() {
        return TaskInfo.FD_CUTTING_BOARD.uid;
    }

    public ItemStack getIcon() {
        return ((Block)ModBlocks.CUTTING_BOARD.get()).m_5456_().m_7968_();
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.FD_CUTTING_BOARD;
    }

    @Override
    public NonNullList<Ingredient> getIngredients(Recipe<?> recipe) {
        CuttingBoardRecipe cuttingBoardRecipe = (CuttingBoardRecipe)recipe;
        NonNullList ingredients = cuttingBoardRecipe.m_7527_();
        ingredients.add((Object)cuttingBoardRecipe.getTool());
        return ingredients;
    }
}

