/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.drinkbeer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.v1.cook.ICookTask;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.CookData;
import com.github.wallev.farmsoulkitchen.init.registry.tlm.RegisterData;
import com.github.wallev.farmsoulkitchen.inventory.tooltip.AmountTooltip;
import com.github.wallev.farmsoulkitchen.mixin.drinkbeer.BeerBarrelBlockAccessor;
import com.github.wallev.farmsoulkitchen.task.TaskInfo;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.TaskBaseContainerCook;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lekavar.lma.drinkbeer.blockentities.BeerBarrelBlockEntity;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.registries.BlockRegistry;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskDbBeerBarrel
extends TaskBaseContainerCook<BeerBarrelBlockEntity, BrewingRecipe> {
    @Override
    public boolean isCookBE(BlockEntity blockEntity) {
        return blockEntity instanceof BeerBarrelBlockEntity;
    }

    @Override
    public RecipeType<BrewingRecipe> getRecipeType() {
        return (RecipeType)RecipeRegistry.RECIPE_TYPE_BREWING.get();
    }

    public ResourceLocation getUid() {
        return TaskInfo.DB_BEER.uid;
    }

    public ItemStack getIcon() {
        return ((Block)BlockRegistry.BEER_BARREL.get()).m_5456_().m_7968_();
    }

    @Override
    public boolean isHeated(BeerBarrelBlockEntity be) {
        return true;
    }

    @Override
    public boolean beInnerCanCook(Container inventory, BeerBarrelBlockEntity be) {
        BeerBarrelBlockAccessor be1 = (BeerBarrelBlockAccessor)be;
        return be1.statusCode$tlma() == 1;
    }

    @Override
    public int getOutputSlot() {
        return 5;
    }

    @Override
    public int getInputSize() {
        return 5;
    }

    @Override
    public Container getContainer(BeerBarrelBlockEntity be) {
        return be.getBrewingInventory();
    }

    @Override
    public MaidRecipesManager<BrewingRecipe> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager<BrewingRecipe>(maid, (ICookTask)this, false){

            @Override
            protected Pair<List<Integer>, List<Item>> getAmountIngredient(BrewingRecipe recipe, Map<Item, Integer> available) {
                NonNullList ingredients = recipe.m_7527_();
                ArrayList<Item> invIngredient = new ArrayList<Item>();
                HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
                boolean[] canMake = new boolean[]{true};
                boolean[] single = new boolean[]{false};
                for (Ingredient ingredient : ingredients) {
                    boolean hasIngredient = false;
                    for (Item item2 : available.keySet()) {
                        ItemStack stack = item2.m_7968_();
                        if (!ingredient.test(stack)) continue;
                        invIngredient.add(item2);
                        hasIngredient = true;
                        if (stack.m_41741_() == 1) {
                            single[0] = true;
                            itemTimes.put(item2, 1);
                            break;
                        }
                        itemTimes.merge(item2, 1, Integer::sum);
                        break;
                    }
                    if (hasIngredient) continue;
                    canMake[0] = false;
                    itemTimes.clear();
                    invIngredient.clear();
                    break;
                }
                ItemStack beerCup = recipe.getBeerCup();
                boolean hasIngredient = false;
                for (Item item3 : available.keySet()) {
                    ItemStack stack = item3.m_7968_();
                    if (!beerCup.m_150930_(stack.m_41720_()) || available.getOrDefault(item3, 0) < beerCup.m_41613_()) continue;
                    invIngredient.add(item3);
                    hasIngredient = true;
                    if (stack.m_41741_() == 1) {
                        single[0] = true;
                        itemTimes.put(item3, 1);
                        break;
                    }
                    itemTimes.merge(item3, beerCup.m_41613_(), Integer::sum);
                    break;
                }
                if (!hasIngredient) {
                    canMake[0] = false;
                    itemTimes.clear();
                    invIngredient.clear();
                }
                if (!canMake[0] || invIngredient.stream().anyMatch(item -> (Integer)available.get(item) <= 0)) {
                    return Pair.of(Collections.emptyList(), Collections.emptyList());
                }
                int maxCount = 64;
                if (single[0] || this.isSingle()) {
                    maxCount = 1;
                } else {
                    for (Item item3 : itemTimes.keySet()) {
                        maxCount = Math.min(maxCount, item3.m_7968_().m_41741_());
                        maxCount = Math.min(maxCount, available.get(item3) / (Integer)itemTimes.get(item3));
                    }
                }
                ArrayList<Integer> countList = new ArrayList<Integer>();
                for (int i = 0; i < invIngredient.size() - 1; ++i) {
                    Item item2;
                    countList.add(maxCount);
                    item2 = (Item)invIngredient.get(i);
                    available.put(item2, available.get(item2) - maxCount);
                }
                countList.add(beerCup.m_41613_());
                Item item4 = (Item)invIngredient.get(invIngredient.size() - 1);
                available.put(item4, available.get(item4) - maxCount);
                return Pair.of(countList, invIngredient);
            }

            @Override
            protected List<Pair<List<Integer>, List<List<ItemStack>>>> transform(List<Pair<List<Integer>, List<Item>>> oriList, Map<Item, Integer> available) {
                return super.transform(oriList, available);
            }
        };
    }

    @Override
    public boolean maidShouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, BeerBarrelBlockEntity blockEntity, MaidRecipesManager<BrewingRecipe> maidRecipesManager) {
        Container inventory = this.getContainer(blockEntity);
        if (this.canTakeOutput(inventory, blockEntity)) {
            return true;
        }
        boolean b = ((BeerBarrelBlockAccessor)blockEntity).statusCode$tlma() == 1;
        List<Pair<List<Integer>, List<List<ItemStack>>>> recipesIngredients = maidRecipesManager.getRecipesIngredients();
        if (!b && !recipesIngredients.isEmpty()) {
            return true;
        }
        return this.hasInput(inventory);
    }

    @Override
    public void maidCookMake(ServerLevel serverLevel, EntityMaid entityMaid, BeerBarrelBlockEntity blockEntity, MaidRecipesManager<BrewingRecipe> maidRecipesManager) {
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(true);
        this.extractOutputStack(this.getContainer(blockEntity), maidRecipesManager.getOutputInv(), (BlockEntity)blockEntity);
        this.extractInputStack(this.getContainer(blockEntity), maidRecipesManager.getInputInv(), (BlockEntity)blockEntity);
        this.tryInsertItem(serverLevel, entityMaid, blockEntity, maidRecipesManager);
        maidRecipesManager.getCookInv().syncInv();
    }

    @Override
    public void extractOutputStack(Container inventory, IItemHandlerModifiable availableInv, BlockEntity blockEntity) {
        ItemStack stackInSlot = inventory.m_8020_(this.getOutputSlot());
        if (!stackInSlot.m_41619_() && ((BeerBarrelBlockAccessor)blockEntity).statusCode$tlma() == 2) {
            ItemStack copy = stackInSlot.m_41777_();
            ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)copy, (boolean)false);
            inventory.m_7407_(this.getOutputSlot(), stackInSlot.m_41613_() - leftStack.m_41613_());
            ((BeerBarrelBlockEntity)blockEntity).markDirty();
        }
    }

    @Override
    public boolean canTakeOutput(Container inventory, BeerBarrelBlockEntity beerBarrelBlockEntity) {
        ItemStack outputStack = inventory.m_8020_(this.getOutputSlot());
        return !outputStack.m_41619_() && ((BeerBarrelBlockAccessor)beerBarrelBlockEntity).statusCode$tlma() == 2;
    }

    @Override
    public void tryInsertItem(ServerLevel serverLevel, EntityMaid entityMaid, BeerBarrelBlockEntity blockEntity, MaidRecipesManager<BrewingRecipe> maidRecipesManager) {
        if (((BeerBarrelBlockAccessor)blockEntity).statusCode$tlma() != 0) {
            return;
        }
        super.tryInsertItem(serverLevel, entityMaid, (BlockEntity)blockEntity, maidRecipesManager);
    }

    @Override
    public boolean inputCanTake(boolean beInnerCanCook, Container inventory) {
        return this.hasInput(inventory);
    }

    @Override
    public void extractInputStack(Container inventory, IItemHandlerModifiable availableInv, BlockEntity blockEntity) {
        for (int i = this.getInputStartSlot(); i < this.getInputSize() + this.getInputStartSlot(); ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            ItemStack copy = stackInSlot.m_41777_();
            if (stackInSlot.m_41619_()) continue;
            ItemStack leftStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)copy, (boolean)false);
            inventory.m_7407_(i, stackInSlot.m_41613_() - leftStack.m_41613_());
            blockEntity.m_6596_();
        }
    }

    @Override
    public TaskDataKey<CookData> getCookDataKey() {
        return RegisterData.DB_BEER;
    }

    @Override
    public Optional<TooltipComponent> getRecClientAmountTooltip(Recipe<?> recipe, boolean modeRandom, boolean overSize) {
        BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
        ItemStack beerCup = brewingRecipe.getBeerCup();
        NonNullList<Ingredient> ingres = this.getIngredients(recipe);
        NonNullList list = NonNullList.m_122779_();
        list.addAll(ingres);
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{beerCup}));
        return ingres.isEmpty() ? Optional.empty() : Optional.of(new AmountTooltip((List<Ingredient>)list, modeRandom, overSize));
    }
}

