/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.v1.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.common.TaskFdPot;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TaskFdCiCook<B extends BlockEntity, R extends Recipe<? extends Container>>
extends TaskFdPot<B, R> {
    @Override
    public void insertInputsStack(ItemStackHandler beInv, IItemHandlerModifiable maidInv, B be, Pair<List<Integer>, List<List<ItemStack>>> ingredientPair) {
        List ingredients;
        List amounts = (List)ingredientPair.getFirst();
        if (this.hasEnoughIngredient(amounts, ingredients = (List)ingredientPair.getSecond())) {
            int i = this.getInputStartSlot();
            int j = 0;
            while (i < ingredients.size() + this.getInputStartSlot()) {
                if (!((List)ingredients.get(j)).isEmpty()) {
                    this.insertAndShrink(beInv, (Integer)amounts.get(i), ingredients, j, i);
                }
                ++i;
                ++j;
            }
            be.m_6596_();
        }
        this.updateIngredient(ingredientPair);
    }

    @Override
    public boolean hasEnoughIngredient(List<Integer> amounts, List<List<ItemStack>> ingredients) {
        boolean canInsert = true;
        int i = 0;
        for (List<ItemStack> ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            int actualCount = amounts.get(i++);
            for (ItemStack itemStack : ingredient) {
                if ((actualCount -= itemStack.m_41613_()) <= 0) break;
            }
            if (actualCount <= 0) continue;
            canInsert = false;
            break;
        }
        return canInsert;
    }

    public List<Pair<List<Integer>, List<List<ItemStack>>>> rmTransform(Map<Item, List<ItemStack>> inventoryStack, List<Pair<List<Integer>, List<Item>>> oriList) {
        return oriList.stream().map(p -> {
            List<List> list = ((List)p.getSecond()).stream().map(item -> {
                if (item == null) {
                    return new ArrayList();
                }
                return (List)inventoryStack.get(item);
            }).toList();
            return Pair.of((Object)((List)p.getFirst()), list);
        }).toList();
    }

    public Pair<List<Integer>, List<Item>> rmGetAmountIngredient(R recipe, Map<Item, Integer> available, boolean isSingle) {
        NonNullList ingredients = recipe.m_7527_();
        boolean[] canMake = new boolean[]{true};
        boolean[] single = new boolean[]{false};
        ArrayList<Item> invIngredient = new ArrayList<Item>();
        HashMap<Item, Integer> itemTimes = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            boolean hasIngredient = false;
            for (Item item2 : available.keySet()) {
                ItemStack stack = item2.m_7968_();
                if (!ingredient.test(stack)) continue;
                invIngredient.add(item2);
                hasIngredient = true;
                if (stack.m_41741_() == 1) {
                    single[0] = true;
                    itemTimes.put(item2, 1);
                    break;
                }
                itemTimes.merge(item2, 1, Integer::sum);
                break;
            }
            if (hasIngredient) continue;
            canMake[0] = false;
            itemTimes.clear();
            invIngredient.clear();
            break;
        }
        int size = ingredients.size();
        int il = this.getInputSize() - size;
        if (canMake[0] && il > 0) {
            for (int i = 0; i < il; ++i) {
                invIngredient.add(size - 1 + i, null);
            }
        }
        if (!canMake[0] || invIngredient.stream().anyMatch(item -> {
            if (item == null) {
                return false;
            }
            return (Integer)available.get(item) <= 0;
        })) {
            return Pair.of((Object)Collections.EMPTY_LIST, (Object)Collections.EMPTY_LIST);
        }
        int maxCount = 64;
        if (single[0] || isSingle) {
            maxCount = 1;
        } else {
            for (Item item2 : itemTimes.keySet()) {
                if (item2 == null) continue;
                maxCount = Math.min(maxCount, available.get(item2) / (Integer)itemTimes.get(item2));
            }
        }
        ArrayList<Integer> countList = new ArrayList<Integer>();
        for (Item item3 : invIngredient) {
            if (item3 == null) {
                countList.add(0);
                continue;
            }
            countList.add(maxCount);
            available.put(item3, available.get(item3) - maxCount);
        }
        return Pair.of(countList, new ArrayList(invIngredient));
    }

    @Override
    public MaidRecipesManager<R> getRecipesManager(EntityMaid maid) {
        return new MaidRecipesManager<R>(maid, this, false){

            @Override
            protected List<Pair<List<Integer>, List<List<ItemStack>>>> transform(List<Pair<List<Integer>, List<Item>>> oriList, Map<Item, Integer> available) {
                return TaskFdCiCook.this.rmTransform(this.getCookInv().getInventoryStack(), oriList);
            }

            @Override
            protected Pair<List<Integer>, List<Item>> getAmountIngredient(R recipe, Map<Item, Integer> available) {
                return TaskFdCiCook.this.rmGetAmountIngredient(recipe, available, this.isSingle());
            }
        };
    }
}

