/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.cook.handler;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.inventory.container.item.BagType;
import com.github.wallev.farmsoulkitchen.item.ItemCulinaryHub;
import com.github.wallev.farmsoulkitchen.task.cook.handler.ICookInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CookBagInventory
implements ICookInventory {
    private final ItemStack stack;
    private final Map<Item, Integer> inventoryItem = new HashMap<Item, Integer>();
    private final Map<Item, List<ItemStack>> inventoryStack = new HashMap<Item, List<ItemStack>>();
    private final List<ItemStack> lastInvStack = new ArrayList<ItemStack>();
    private Map<BagType, ItemStackHandler> containers;

    public CookBagInventory(ItemStack stack) {
        this.stack = stack;
        this.refreshInv();
    }

    @Override
    public void refreshInv() {
        this.clearCacheStackInfo();
        this.containers = ItemCulinaryHub.getContainers(this.stack);
        ItemStackHandler availableInv = this.containers.getOrDefault((Object)BagType.INGREDIENT, new ItemStackHandler(BagType.INGREDIENT.size * 9));
        List<Integer> blackSlots = this.getBlackSlots();
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            ItemStack stack = availableInv.getStackInSlot(i);
            this.proseLastInvStack(i, stack);
            if (blackSlots.contains(i) || stack.m_41619_()) continue;
            this.add(stack);
        }
    }

    @Override
    public void proseLastInvStack(int index, ItemStack invStack) {
        ItemStack cacheStack;
        if (index < this.lastInvStack.size() && (cacheStack = this.lastInvStack.get(index)).m_150930_(invStack.m_41720_()) && cacheStack != invStack) {
            cacheStack.m_41764_(invStack.m_41613_());
            return;
        }
        this.lastInvStack.add(invStack.m_41777_());
    }

    @Override
    public void clearCacheStackInfo() {
        this.inventoryItem.clear();
        this.inventoryStack.clear();
        this.lastInvStack.clear();
    }

    @Override
    public List<Integer> getBlackSlots() {
        ArrayList<Integer> blockSlots = new ArrayList<Integer>();
        return blockSlots;
    }

    @Override
    public void add(ItemStack stack) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            if (this.inventoryStack.get(item) == null) {
                ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                stackList.add(stack);
                this.inventoryStack.put(item, stackList);
            } else {
                this.inventoryStack.get(item).add(stack);
            }
            this.inventoryItem.merge(item, stack.m_41613_(), (a, b) -> a + b);
        }
    }

    @Override
    public Map<Item, List<ItemStack>> getInventoryStack() {
        return this.inventoryStack;
    }

    @Override
    public Map<Item, Integer> getInventoryItem() {
        return this.inventoryItem;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public List<ItemStack> getLastInvStack() {
        return this.lastInvStack;
    }

    @Override
    public IItemHandlerModifiable getAvailableInv(EntityMaid maid, BagType bagType) {
        return (IItemHandlerModifiable)this.containers.get((Object)bagType);
    }

    @Override
    public void syncInv() {
        ItemCulinaryHub.setContainer(this.stack, this.containers);
    }
}

