/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.api.task.IDrinkTask;
import com.google.common.collect.ImmutableMap;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModCapabilities;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidFeedAndDrinkOwnerTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 20;
    private final IDrinkTask drinkTask;
    private final IFeedTask feedTask;
    private final float walkSpeed;
    private final int closeEnoughDist;

    public MaidFeedAndDrinkOwnerTask(IDrinkTask task, IFeedTask feedTask, int closeEnoughDist, float walkSpeed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.drinkTask = task;
        this.feedTask = feedTask;
        this.walkSpeed = walkSpeed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(20);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid)) {
            LivingEntity owner = maid.m_269323_();
            if (owner instanceof Player && owner.m_6084_() && maid.m_21444_(owner.m_20183_())) {
                if (owner.m_19950_((Entity)maid, (double)this.closeEnoughDist)) {
                    return true;
                }
                BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)owner, (float)this.walkSpeed, (int)1);
            }
            return false;
        }
        return false;
    }

    private void startFeed(ServerLevel worldIn, EntityMaid maid, Player player, boolean dying) {
        IntArrayList lowestFoods = new IntArrayList();
        IntArrayList lowFoods = new IntArrayList();
        IntArrayList highFoods = new IntArrayList();
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.feedTask.isFood(stack, player)) continue;
            IFeedTask.Priority priority = this.feedTask.getPriority(stack, player);
            if (priority == IFeedTask.Priority.HIGH) {
                highFoods.add(i);
                break;
            }
            if (priority == IFeedTask.Priority.LOW) {
                lowFoods.add(i);
                break;
            }
            if (!dying || priority != IFeedTask.Priority.LOWEST) continue;
            lowestFoods.add(i);
            break;
        }
        if (highFoods.isEmpty() && lowFoods.isEmpty() && lowestFoods.isEmpty()) {
            return;
        }
        IntArrayList map = !highFoods.isEmpty() ? highFoods : (!lowFoods.isEmpty() ? lowFoods : lowestFoods);
        map.stream().skip(maid.m_217043_().m_188503_(map.size())).findFirst().ifPresent(slot -> {
            inv.setStackInSlot(slot.intValue(), this.feedTask.feed(inv.getStackInSlot(slot.intValue()), player));
            maid.m_6674_(InteractionHand.MAIN_HAND);
            this.setNextCheckTickCount(5);
        });
    }

    private void startDrink(ServerLevel worldIn, EntityMaid maid, Player player, boolean dying) {
        IntArrayList lowestFoods = new IntArrayList();
        IntArrayList lowFoods = new IntArrayList();
        IntArrayList highFoods = new IntArrayList();
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!this.drinkTask.isDrink(stack, player)) continue;
            IDrinkTask.Priority priority = this.drinkTask.getDrinkPriority(stack, player);
            if (priority == IDrinkTask.Priority.HIGH) {
                highFoods.add(i);
                break;
            }
            if (priority == IDrinkTask.Priority.LOW) {
                lowFoods.add(i);
                break;
            }
            if (!dying || priority != IDrinkTask.Priority.LOWEST) continue;
            lowestFoods.add(i);
            break;
        }
        if (highFoods.isEmpty() && lowFoods.isEmpty() && lowestFoods.isEmpty()) {
            return;
        }
        IntArrayList map = !highFoods.isEmpty() ? highFoods : (!lowFoods.isEmpty() ? lowFoods : lowestFoods);
        map.stream().skip(maid.m_217043_().m_188503_(map.size())).findFirst().ifPresent(slot -> {
            inv.setStackInSlot(slot.intValue(), this.drinkTask.drink(inv.getStackInSlot(slot.intValue()), player));
            maid.m_6674_(InteractionHand.MAIN_HAND);
            this.setNextCheckTickCount(5);
        });
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.m_269323_();
        if (owner instanceof Player && owner.m_6084_()) {
            boolean feedDying;
            boolean thirstDying;
            Player player = (Player)owner;
            IThirst iThirst = (IThirst)owner.getCapability(ModCapabilities.PLAYER_THIRST).orElse(null);
            if (iThirst == null) {
                return;
            }
            boolean bl = thirstDying = iThirst.getThirst() < 20;
            if (thirstDying) {
                this.startDrink(worldIn, maid, player, thirstDying);
                return;
            }
            boolean bl2 = feedDying = player.m_21223_() / player.m_21233_() < 0.5f;
            if (feedDying) {
                this.startFeed(worldIn, maid, player, feedDying);
                return;
            }
        }
    }
}

