/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.task.ai;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.wallev.farmsoulkitchen.task.cook.handler.MaidRecipesManager;
import com.github.wallev.farmsoulkitchen.task.cook.v1.fd.TaskFdCuttingBoard;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

public class MaidCuttingMakeTask
extends Behavior<EntityMaid> {
    private final TaskFdCuttingBoard task;
    private final MaidRecipesManager<CuttingBoardRecipe> maidRecipesManager;
    private boolean maidHand = false;
    private int tick = 0;
    private Item processItem = null;

    public MaidCuttingMakeTask(TaskFdCuttingBoard task, MaidRecipesManager<CuttingBoardRecipe> maidRecipesManager) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.task = task;
        this.maidRecipesManager = maidRecipesManager;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (maid.m_20238_(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        return maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get()) && (!maid.m_21206_().m_41619_() && !maid.m_21205_().m_41619_() || this.isProcessItem(worldIn, maid));
    }

    private boolean isProcessItem(ServerLevel worldIn, EntityMaid maid) {
        BlockEntity blockEntity;
        Optional tracker = maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get());
        if (tracker.isPresent() && (blockEntity = worldIn.m_7702_(((PositionTracker)tracker.get()).m_6675_())) instanceof CuttingBoardBlockEntity) {
            CuttingBoardBlockEntity cuttingBoardBlockEntity = (CuttingBoardBlockEntity)blockEntity;
            return cuttingBoardBlockEntity.getStoredItem().m_150930_(this.processItem);
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6735_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof CuttingBoardBlockEntity) {
                CuttingBoardBlockEntity cuttingBoardBlockEntity = (CuttingBoardBlockEntity)blockEntity;
                this.task.processCookMake(worldIn, maid, cuttingBoardBlockEntity, this.maidRecipesManager, item -> {
                    this.processItem = item;
                });
                this.maidRecipesManager.getCookInv().syncInv();
            }
        });
    }

    protected void tick(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6725_(worldIn, (LivingEntity)maid, pGameTime);
        if (this.tick++ % 2 != 0) {
            return;
        }
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            BlockEntity blockEntity = worldIn.m_7702_(posWrapper.m_6675_());
            if (blockEntity instanceof CuttingBoardBlockEntity) {
                CuttingBoardBlockEntity cuttingBoardBlockEntity = (CuttingBoardBlockEntity)blockEntity;
                if (this.maidHand) {
                    ItemStack tool = maid.m_21205_();
                    cuttingBoardBlockEntity.processStoredItemUsingTool(tool, null);
                } else {
                    ItemStack split = maid.m_21206_().m_41620_(1);
                    cuttingBoardBlockEntity.getInventory().insertItem(0, split, false);
                }
                maid.m_6674_(InteractionHand.MAIN_HAND);
                this.maidHand = !this.maidHand;
            }
        });
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long pGameTime) {
        super.m_6732_(worldIn, (LivingEntity)maid, pGameTime);
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.processItem = null;
        this.maidHand = false;
        this.tick = 0;
    }
}

