/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.data.TaskDataRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.wallev.farmsoulkitchen.entity.data.inner.task.FruitData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record SetFruitFarmSearchYOffsetMessage(int entityId, ResourceLocation dataKey, int searchYOffset) {
    public static void encode(SetFruitFarmSearchYOffsetMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130085_(message.dataKey);
        buf.writeInt(message.searchYOffset);
    }

    public static SetFruitFarmSearchYOffsetMessage decode(FriendlyByteBuf buf) {
        return new SetFruitFarmSearchYOffsetMessage(buf.readInt(), buf.m_130281_(), buf.readInt());
    }

    public static void handle(SetFruitFarmSearchYOffsetMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    TaskDataKey value = TaskDataRegister.getValue((ResourceLocation)message.dataKey);
                    FruitData fruitData = (FruitData)maid.getOrCreateData(value, (Object)new FruitData());
                    fruitData.setSearchYOffset(message.searchYOffset);
                    maid.setAndSyncData(value, (Object)fruitData);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

