/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.client.tooltip;

import com.github.wallev.farmsoulkitchen.client.tooltip.ClientAmountTooltip;
import com.github.wallev.farmsoulkitchen.config.subconfig.TaskConfig;
import com.github.wallev.farmsoulkitchen.inventory.tooltip.AmountTooltip;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class NormalAmountTooltip
implements ClientAmountTooltip {
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmsoulkitchen", "textures/gui/cook_guide.png");
    private final MutableComponent titleTip = Component.m_237115_((String)"tooltips.farmsoulkitchen.amount.title");
    private final MutableComponent randomTip = Component.m_237115_((String)"gui.farmsoulkitchen.btn.cook_guide.warn.not_select").m_130940_(ChatFormatting.YELLOW);
    private final MutableComponent overSizeTip = Component.m_237110_((String)"gui.farmsoulkitchen.btn.cook_guide.warn.over_size", (Object[])new Object[]{TaskConfig.COOK_SELECTED_RECIPES.get()}).m_130940_(ChatFormatting.YELLOW);
    private final List<Ingredient> ingres;
    private final boolean isRandom;
    private final boolean isOverSize;

    public NormalAmountTooltip(AmountTooltip containerTooltip) {
        this.ingres = containerTooltip.ingredients();
        this.isRandom = containerTooltip.isRandom();
        this.isOverSize = containerTooltip.isOverSize();
    }

    public int m_142103_() {
        return 30 + (this.isRandom ? 10 : 0) + (this.isOverSize ? 10 : 0);
    }

    public int m_142069_(Font font) {
        int tipMax = font.m_92852_((FormattedText)this.titleTip);
        if (this.isRandom) {
            tipMax = Math.max(tipMax, font.m_92852_((FormattedText)this.randomTip));
        }
        if (this.isOverSize) {
            tipMax = Math.max(tipMax, font.m_92852_((FormattedText)this.overSizeTip));
        }
        return Math.max(tipMax, this.ingres.size() * 20);
    }

    public void m_183452_(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        if (this.isRandom) {
            guiGraphics.m_280430_(font, (Component)this.randomTip, pX, pY, ChatFormatting.YELLOW.m_126665_().intValue());
            pY += 10;
        }
        if (this.isOverSize) {
            guiGraphics.m_280430_(font, (Component)this.overSizeTip, pX, pY, ChatFormatting.YELLOW.m_126665_().intValue());
            pY += 10;
        }
        guiGraphics.m_280430_(font, (Component)this.titleTip, pX, pY, ChatFormatting.GRAY.m_126665_().intValue());
        int i = 0;
        pY += 10;
        for (Ingredient ingre : this.ingres) {
            ItemStack[] stackItems = ingre.m_43908_();
            if (stackItems.length == 0) continue;
            int xOffset = pX + i++ * 20;
            guiGraphics.m_280480_(stackItems[0], xOffset, pY);
            if (stackItems.length <= 1) continue;
            guiGraphics.m_280218_(TEXTURE, xOffset, pY + 13, 0, 253, 3, 3);
        }
    }
}

