/*
 * Decompiled with CFR 0.152.
 */
package com.github.wallev.farmsoulkitchen.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.MaidBannerModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.github.wallev.farmsoulkitchen.FarmsoulKitchen;
import com.github.wallev.farmsoulkitchen.config.subconfig.RenderConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.cristelknight.doapi.common.item.StandardItem;
import java.util.List;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;

public class GeckoLayerMaidLDBanner<T extends Mob>
extends GeoLayerRenderer<T, GeckoEntityMaidRenderer<T>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/maid_banner.png");
    private final MaidBannerModel bannerModel;

    public GeckoLayerMaidLDBanner(GeckoEntityMaidRenderer renderer, EntityModelSet modelSet) {
        super((IGeoRenderer)renderer);
        this.bannerModel = new MaidBannerModel(modelSet.m_171103_(MaidBannerModel.LAYER));
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }
        if (!((Boolean)RenderConfig.LD_BANNER_RENDER_ENABLED.get()).booleanValue()) {
            return;
        }
        Item item = maid.getBackpackShowItem().m_41720_();
        if (item instanceof StandardItem) {
            if (!((GeckoEntityMaidRenderer)this.entityRenderer).getAnimatableEntity(entity).getMaidInfo().isShowBackpack() || entity.m_5803_() || entity.m_20145_()) {
                return;
            }
            AnimatedGeoModel geoModel = ((GeckoEntityMaidRenderer)this.entityRenderer).getAnimatableEntity(entity).getCurrentModel();
            if (geoModel != null && !geoModel.backpackBones().isEmpty()) {
                matrixStack.m_85836_();
                RenderUtils.prepMatrixForLocator((PoseStack)matrixStack, (List)geoModel.backpackBones());
                matrixStack.m_85837_(0.0, 0.75, 0.3);
                matrixStack.m_85841_(0.65f, -0.65f, -0.65f);
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                matrixStack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
                VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE));
                this.bannerModel.m_7695_(matrixStack, buffer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                ResourceLocation location = StandardItem.getLocationOrNull((Item)item);
                if (location == null) {
                    FarmsoulKitchen.LOGGER.error("ResourceLocation for StandardBlock texture is null! At: " + item);
                } else {
                    VertexConsumer vc = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)location));
                    this.bannerModel.getBanner().m_104301_(matrixStack, vc, packedLightIn, OverlayTexture.f_118083_);
                }
                matrixStack.m_85849_();
            }
        }
    }
}

