/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import studio.fantasyit.maid_storage_manager.Config;

public class MathUtil {
    public static int biMaxStepCalc(int current) {
        int m = (int)Math.floor(MathUtil.log2(current));
        return (int)((double)((m + 1) * current) - Math.pow(2.0, m + 1) + 1.0);
    }

    public static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    public static Vec3 getFromToWithFriction(Entity entity, Vec3 to) {
        return MathUtil.getFromToWithFriction(entity.m_20183_().m_252807_(), to);
    }

    public static Vec3 getFromToWithFriction(Vec3 from, Vec3 to) {
        return MathUtil.getFromToWithFriction(from, to, 0.6, 0.98);
    }

    public static Vec3 getFromToWithFriction(Vec3 from, Vec3 to, double groundFriction, double airFriction) {
        return switch (Config.throwItemVector) {
            default -> throw new IncompatibleClassChangeError();
            case Config.ThrowMethod.FINALLY_POS -> {
                double deltaH = to.f_82480_ - from.f_82480_;
                double vY0 = deltaH <= 0.0 ? 0.0 : Math.sqrt(0.08 * deltaH);
                double t = vY0 == 0.0 ? Math.sqrt(deltaH / -0.02) : vY0 / 0.04;
                double friction = vY0 == 0.0 ? groundFriction : airFriction;
                double vX0 = (to.f_82479_ - from.f_82479_) * (1.0 - 0.98 * friction);
                double vZ0 = (to.f_82481_ - from.f_82481_) * (1.0 - 0.98 * friction);
                yield new Vec3(vX0, vY0, vZ0);
            }
            case Config.ThrowMethod.GO_THROUGH -> {
                double deltaH = to.f_82480_ - from.f_82480_;
                double vY0 = deltaH <= 0.0 ? 0.0 : Math.sqrt(0.08 * deltaH);
                double t = vY0 == 0.0 ? Math.sqrt(deltaH / -0.02) : vY0 / 0.04;
                double friction = vY0 == 0.0 ? groundFriction : airFriction;
                double vX0 = (to.f_82479_ - from.f_82479_) * (friction - 1.0) / (Math.pow(friction, (int)(t / 4.0) + 1) - 1.0);
                double vZ0 = (to.f_82481_ - from.f_82481_) * (friction - 1.0) / (Math.pow(friction, (int)(t / 4.0) + 1) - 1.0);
                yield new Vec3(vX0, vY0, vZ0);
            }
            case Config.ThrowMethod.FIXED -> to.m_82546_(from).m_82541_().m_82490_(0.6);
        };
    }

    public static float vec2RotX(Vec3 vec) {
        return Mth.m_14177_((float)((float)Math.toDegrees(Math.asin(-vec.m_82541_().f_82480_))));
    }

    public static float vec2RotY(Vec3 vec) {
        float yRot = (float)Math.toDegrees(Math.atan2(-vec.m_82541_().f_82479_, vec.m_82541_().f_82481_));
        if ((yRot = Mth.m_14177_((float)yRot)) < 0.0f) {
            yRot += 360.0f;
        }
        return yRot;
    }

    public static int gcd(int a, int b) {
        while (b > 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    public static int lcm(int a, int b) {
        return a * (b / MathUtil.gcd(a, b));
    }
}

